<?php

/**
* @Description: Shortcode Editor Button
* @Created At: 08-04-2013
* @Last Edited AT: 03-02-2017
* @Created By: Mahbub
**/

add_action('admin_init', 'bkb_tinymce_shortcode_button');

function bkb_tinymce_shortcode_button() {
    
    if (current_user_can('edit_posts') && current_user_can('edit_pages')) {
        
        // WPML FIXING IN VERSION 1.1.8
        $current_lang = 'en';
         
        if ( defined('ICL_SITEPRESS_VERSION') && isset( $_GET['lang'] ) ) {
            $current_lang = $_GET['lang'];
            set_transient('WPML_SELECTED_LANG', $current_lang);
        }
         
        add_filter('mce_external_plugins', 'add_bkb_shortcode_plugin');
        add_filter('mce_buttons', 'register_bkb_shortcode_button');
    }
    
}

function register_bkb_shortcode_button( $buttons ) {
    
    // Load TinyMCE shortcode buttons.
    // Fixed in version 1.1.2
    
    wp_enqueue_style( 'bkb-shortcode-editor-multiple-select-style' );
    wp_enqueue_style( 'bkb-shortcode-editor-style') ;
    wp_enqueue_script('bkb-admin-mutiple-select-script');
    
    array_push($buttons, "bkb");
    return $buttons;
}

function add_bkb_shortcode_plugin( $plugin_array ) {
    $plugin_array['bkb'] = BWL_KB_PLUGIN_DIR . 'tinymce/bkb_tinymce_button.js';
    return $plugin_array;
}