<?php
/*
Plugin Name: Easy Stats PRO
Plugin URI: http://www.persianscript.ir
Description: Do you want to track how many visitors you have, where they come from and what they do on your site? Than Easy Stats is the right choise for you!
Version: 1.5
Author: پرشین اسکریپت
Author URI: http://www.persianscript.ir
License: GPLv2
License URI: http://www.gnu.org/licenses/gpl-2.0.html
*/

require_once( plugin_dir_path( __FILE__ ) . 'includes/Browser.php');
require_once( plugin_dir_path( __FILE__ ) . 'includes/es-geo.class.php');
require_once( plugin_dir_path( __FILE__ ) . 'includes/es-functions.php');
require_once( plugin_dir_path( __FILE__ ) . 'includes/es-functions-top-query.php');
require_once( plugin_dir_path( __FILE__ ) . 'includes/es-shortcodes.php');



define('es_plugin_url', WP_PLUGIN_URL . '/' . plugin_basename( dirname(__FILE__) ) . '/' );
define('es_plugin_dir', plugin_dir_path( __FILE__ ) );




function es_init_scripts()
	{
		wp_enqueue_script('jquery');

		wp_enqueue_script('jquery-ui-datepicker');
		wp_enqueue_style('easy-stats-style', es_plugin_url.'css/style.css');
		wp_enqueue_style('easy-stats-flags', es_plugin_url.'css/flags.css');
		wp_enqueue_script('easy-stats-js', plugins_url( '/js/scripts.js' , __FILE__ ) , array( 'jquery' ));
		wp_localize_script( 'easy-stats-js', 'es_ajax', array( 'es_ajaxurl' => admin_url( 'admin-ajax.php')));
		wp_enqueue_style('jquery-ui', es_plugin_url.'css/jquery-ui.css');
		
		//ESAdmin
		wp_enqueue_style('ESAdmin', es_plugin_url.'ESAdmin/css/ESAdmin.css');
		wp_enqueue_style('ESIcons', es_plugin_url.'ESAdmin/css/ESIcons.css');		
		wp_enqueue_script('ESAdmin', plugins_url( 'ESAdmin/js/ESAdmin.js' , __FILE__ ) , array( 'jquery' ));
		
		
		//jquery.jqplot
		wp_enqueue_style('jquery.jqplot', es_plugin_url.'css/jquery.jqplot.css');		
		wp_enqueue_script('jquery.jqplot.min', plugins_url( 'js/jquery.jqplot.min.js' , __FILE__ ) , array( 'jquery' ));		
		
		wp_enqueue_script('jqplot.pieRenderer.min', plugins_url( 'js/jqplot.pieRenderer.min.js' , __FILE__ ) , array( 'jquery' ));		
		wp_enqueue_script('jqplot.highlighter.min', plugins_url( 'js/jqplot.highlighter.min.js' , __FILE__ ) , array( 'jquery' ));					
		wp_enqueue_script('jqplot.enhancedLegendRenderer.min', plugins_url( 'js/jqplot.enhancedLegendRenderer.min.js' , __FILE__ ) , array( 'jquery' ));			
		
		wp_enqueue_script('jqplot.dateAxisRenderer.min', plugins_url( 'js/jqplot.dateAxisRenderer.min.js' , __FILE__ ) , array( 'jquery' ));			
		
		wp_enqueue_script('jqplot.canvasTextRenderer.min', plugins_url( 'js/jqplot.canvasTextRenderer.min.js' , __FILE__ ) , array( 'jquery' ));			
				
		wp_enqueue_script('jqplot.canvasAxisTickRenderer.min', plugins_url( 'js/jqplot.canvasAxisTickRenderer.min.js' , __FILE__ ) , array( 'jquery' ));		
		
		wp_enqueue_script('jqplot.canvasAxisLabelRenderer.min', plugins_url( 'js/jqplot.canvasAxisLabelRenderer.min.js' , __FILE__ ) , array( 'jquery' ));			
				
	}
add_action("init","es_init_scripts");







register_activation_hook(__FILE__, 'es_install');
register_uninstall_hook(__FILE__, 'es_uninstall');


function es_uninstall()
	{

		$es_delete_data = get_option( 'es_delete_data' );
		
		
		if($es_delete_data=='yes')
			{	
		
				global $wpdb;
				$wpdb->query( "DROP TABLE IF EXISTS {$wpdb->prefix}es" );
				$wpdb->query( "DROP TABLE IF EXISTS {$wpdb->prefix}es_online" );
				
				delete_option( 'es_version' );
				delete_option( 'es_delete_data' );
				delete_option( 'es_customer_type' );
			}
		

		
		

		
	}
	
	
	
function es_install()
	{
		
		global $wpdb;
		
        $sql = "CREATE TABLE IF NOT EXISTS " . $wpdb->prefix . "es"
                 ."( UNIQUE KEY id (id),
					id int(100) NOT NULL AUTO_INCREMENT,
					session_id	VARCHAR( 255 )	NOT NULL,
					es_date	DATE NOT NULL,
					es_time	TIME NOT NULL,
					es_endtime	TIME NOT NULL,
					userid	VARCHAR( 50 )	NOT NULL,
					event	VARCHAR( 50 )	NOT NULL,
					browser	VARCHAR( 50 )	NOT NULL,
					platform	VARCHAR( 50 )	NOT NULL,
					ip	VARCHAR( 20 )	NOT NULL,
					city	VARCHAR( 50 )	NOT NULL,
					region	VARCHAR( 50 )	NOT NULL,
					countryName	VARCHAR( 50 )	NOT NULL,
					url_id	VARCHAR( 255 )	NOT NULL,
					url_term	VARCHAR( 255 )	NOT NULL,
					referer_doamin	VARCHAR( 255 )	NOT NULL,
					referer_url	TEXT NOT NULL,
					screensize	VARCHAR( 50 ) NOT NULL,
					isunique	VARCHAR( 50 ) NOT NULL,
					landing	VARCHAR( 10 ) NOT NULL

					)";
		$wpdb->query($sql);
		
		
		
        $sql2 = "CREATE TABLE IF NOT EXISTS " . $wpdb->prefix . "es_online"
                 ."( UNIQUE KEY id (id),
					id int(100) NOT NULL AUTO_INCREMENT,
					session_id VARCHAR( 255 ) NOT NULL,
					es_time  DATETIME NOT NULL,
					userid	VARCHAR( 50 )	NOT NULL,
					url_id	VARCHAR( 255 )	NOT NULL,
					url_term	VARCHAR( 255 )	NOT NULL,
					city	VARCHAR( 50 )	NOT NULL,
					region	VARCHAR( 50 )	NOT NULL,
					countryName	VARCHAR( 50 )	NOT NULL,
					browser	VARCHAR( 50 )	NOT NULL,
					platform	VARCHAR( 50 )	NOT NULL,
					referer_doamin	VARCHAR( 255 )	NOT NULL,
					referer_url	TEXT NOT NULL
					)";
		$wpdb->query($sql2);
		

		$es_version= "1.5";
		update_option('es_version', $es_version); 
		
		$es_customer_type= "free"; 
		update_option('es_customer_type', $es_customer_type); 



		}



function es_visit()
	{
		

	$es_date = es_get_date();
	$es_time = es_get_time();
	$es_datetime = es_get_datetime();	
	$es_endtime = $es_datetime;
	

	$browser = new Browser_es();
	$platform = $browser->getPlatform();
	$browser = $browser->getBrowser();
	$screensize = es_get_screensize();
	

	$ip = $_SERVER['REMOTE_ADDR'];
	$geoplugin = new geoPlugin();
	$geoplugin->locate();
	$city = $geoplugin->city;
	$region = $geoplugin->region;
	$countryName = $geoplugin->countryCode;


	$referer = es_get_referer();
	$referer = explode(',',$referer);
	$referer_doamin = $referer['0'];
	$referer_url = $referer['1'];



	$userid = es_getuser();
	$url_id_array = es_geturl_id();
	$url_id_array = explode(',',$url_id_array);
	$url_id = $url_id_array['0'];
	$url_term = $url_id_array['1'];
	
	$event = "visit";
	
	$isunique = es_get_unique();
	$landing = es_landing();
	$es_session_id = es_session();
	
	
	global $wpdb;
	$table = $wpdb->prefix . "es";
		
	$wpdb->query( $wpdb->prepare("INSERT INTO $table 
								( id, session_id, es_date, es_time, es_endtime, userid, event, browser, platform, ip, city, region, countryName, url_id, url_term, referer_doamin, referer_url, screensize, isunique, landing )
			VALUES	( %d, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s )",
						array	( '', $es_session_id, $es_date, $es_time, $es_endtime, $userid, $event, $browser, $platform, $ip, $city, $region, $countryName, $url_id, $url_term, $referer_doamin, $referer_url, $screensize, $isunique, $landing )
								));
		
		


$table = $wpdb->prefix . "es_online";	
$result = $wpdb->get_results("SELECT * FROM $table WHERE session_id='$es_session_id'", ARRAY_A);
$count = $wpdb->num_rows;


 

	if($count==NULL)
		{
			$wpdb->query( $wpdb->prepare("INSERT INTO $table 
								( id, session_id, es_time, userid, url_id, url_term, city, region, countryName, browser, platform, referer_doamin, referer_url) VALUES	(%d, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)",
							array( '', $es_session_id, $es_datetime, $userid, $url_id, $url_term, $city, $region, $countryName, $browser, $platform, $referer_doamin, $referer_url)
								));
		}
	else
		{
			$wpdb->query("UPDATE $table SET es_time='$es_datetime', url_id='$url_id', referer_doamin='$referer_doamin', referer_url='$referer_url' WHERE session_id='$es_session_id'");
		}


					
	}

add_action('wp_head', 'es_visit');




function login_with_email_address($username) {
        $user = get_user_by('email',$username);
        if(!empty($user->user_login))
                $username = $user->user_login;
        return $username;
}
add_action('wp_authenticate','login_with_email_address');

function change_username_wps_text($text){
       if(in_array($GLOBALS['pagenow'], array('wp-login.php'))){
         if ($text == 'Username'){$text = 'Username / Email';}
            }
                return $text;
         }
add_filter( 'gettext', 'change_username_wps_text' );

















add_action('admin_init', 'es_options_init' );
add_action('admin_menu', 'es_menu_init');


function es_options_init(){
	register_setting('es_options', 'es_version');
	register_setting('es_options', 'es_customer_type');	
	register_setting('es_options', 'es_delete_data');

    }

function es_settings(){
	include('es-settings.php');
	}
	
	
function es_dashboard(){
	include('es-dashboard.php');
	}
		
	
	
function es_admin_online(){
	include('es-admin-online.php');
	}

function es_admin_visitors(){
	include('es-admin-visitors.php');
	}

function es_admin_geo(){
	include('es-admin-geo.php');
	}

function es_admin_filter(){
	include('es-admin-filter.php');
	}




function es_menu_init() {





	add_menu_page(__('Easy Stats PRO','es'), __('Easy Stats PRO','es'), 'manage_options', 'es_settings', 'es_dashboard');

	add_submenu_page('es_settings', __('All Visitors','menu-es'), __('All Time Visitors','menu-es'), 'manage_options', 'es_admin_visitors', 'es_admin_visitors');	
	
	add_submenu_page('es_settings', __('Online Users','menu-es'), __('Online Users','menu-es'), 'manage_options', 'es_admin_online', 'es_admin_online');
	
	add_submenu_page('es_settings', __('Filter','menu-es'), __('Filter Statistics','menu-es'), 'manage_options', 'es_admin_filter', 'es_admin_filter');		

	add_submenu_page('es_settings', __('es Dashboard','menu-es'), __('Easy Stats Settings','menu-es'), 'manage_options', 'es_dashboard', 'es_settings');	

}

include_once (dirname (__FILE__)."/includes/es-seostatsClass.php");
function seostats_init() {
 load_plugin_textdomain( 'seo-stats-widget', false, dirname( plugin_basename( __FILE__ )) . '/lang/' ); 
}
add_action('init', 'seostats_init');
function seostats_dashboard_widgets()
{
add_meta_box( 'seostats_dashboard_widget', 'Easy Stats PRO - SEO Statistics', 'seostats_dashboard_widget_function', 'dashboard', 'side', 'high' );
}
add_action( 'wp_dashboard_setup', 'seostats_dashboard_widgets' );

/**
 * Create the function to output the contents of our Dashboard Widget.
 */
function seostats_dashboard_widget_function() {
if($v=get_transient( 'wpseostats' ))
{}
else
{
$o=new SEOStats(site_url());
$v=array('PR'=>$o->get_PR(),'GIP'=>$o->get_GIP(),'GBL'=>$o->get_GBL(),'ALEXA'=>$o->get_Alexa(),'SEM'=>$o->get_SEM());
set_transient('wpseostats',$v,DAY_IN_SECONDS);
}
$dmoz=$v['ALEXA']['dmoz']?'Yes':'No';
echo '<table class="wpseostats">
<tr>
    <td>'.__('Google Pagerank','seo-stats-widget').'</td>
    <td>'.$v['PR'].'</td>
  </tr>
  <tr>
    <td>'.__('Google Indexed Pages','seo-stats-widget').'</td>
    <td>'.$v['GIP'].'</td>
  </tr>
  <tr>
    <td>'.__('Google Backlinks','seo-stats-widget').'</td>
    <td>'.$v['GBL'].'</td>
  </tr>
  <tr>
    <td>'.__('Keywords in Google','seo-stats-widget').'</td>
    <td>'.$v['SEM']['keywords'].'</td>
  </tr>
  <tr>
    <td>'.__('Keywords Cost','seo-stats-widget').'</td>
    <td>'.$v['SEM']['cost'].'$</td>
  </tr>
  <tr>
    <td>'.__('Organic Traffic','seo-stats-widget').'</td>
    <td>'.$v['SEM']['traffic'].'</td>
  </tr>
  <tr>
    <td>'.__('SemRush Rank','seo-stats-widget').'</td>
    <td>'.$v['SEM']['rank'].'</td>
  </tr>
  <tr>
    <td>'.__('Alexa Rank','seo-stats-widget').'</td>
    <td>'.$v['ALEXA']['rank'].'</td>
  </tr>
  <tr>
    <td>'.__('Alexa Backlink','seo-stats-widget').'</td>
    <td>'.$v['ALEXA']['links'].'</td>
  </tr>
  <tr>
    <td>'.__('Dmoz Listing','seo-stats-widget').'</td>
    <td>'.$dmoz.'</td>
  </tr>
  <tr>
    <td>'.__('Website Load time','seo-stats-widget').'</td>
    <td>'.$v['ALEXA']['speed'].' ms</td>
  </tr>
</table>';
}
class wpseostats_Widget extends WP_Widget {

	public function __construct() {
	parent::__construct(
	 		'wpseostats_widget',
			'Easy Stats PRO Widget',
			array( 'description' => 'Show various SEO data about your website from different sources.' )
		);
		add_action('wp_enqueue_scripts', array(&$this, 'css'));
	}
function css(){

    if ( is_active_widget(false, false, $this->id_base, true) ) {
       wp_enqueue_style( 'seostats', plugins_url( '/css/esstyle.css', __FILE__ ));
    }           

  }
	public function widget( $args, $instance ) {
	extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );
		if ( ! empty( $title ) )
			echo $before_title . $title . $after_title;
	if($v=get_transient( 'wpseostats' ))
{}
else
{
$o=new SEOStats(site_url());
$v=array('PR'=>$o->get_PR(),'GIP'=>$o->get_GIP(),'GBL'=>$o->get_GBL(),'ALEXA'=>$o->get_Alexa(),'SEM'=>$o->get_SEM());
set_transient('wpseostats',$v,DAY_IN_SECONDS);
}
$dmoz=$v['ALEXA']['dmoz']?'Yes':'No';
echo '<aside class="widget wpseostats"><table>
  <tr>
    <td>'.__('Google Pagerank','seo-stats-widget').'</td>
    <td>'.$v['PR'].'</td>
  </tr>
  <tr>
    <td>'.__('Google Indexed Pages','seo-stats-widget').'</td>
    <td>'.$v['GIP'].'</td>
  </tr>
  <tr>
    <td>'.__('Google Backlinks','seo-stats-widget').'</td>
    <td>'.$v['GBL'].'</td>
  </tr>
  <tr>
    <td>'.__('Keywords in Google','seo-stats-widget').'</td>
    <td>'.$v['SEM']['keywords'].'</td>
  </tr>
  <tr>
    <td>'.__('Keywords Cost','seo-stats-widget').'</td>
    <td>'.$v['SEM']['cost'].'$</td>
  </tr>
  <tr>
    <td>'.__('Organic Traffic','seo-stats-widget').'</td>
    <td>'.$v['SEM']['traffic'].'</td>
  </tr>
  <tr>
    <td>'.__('SemRush Rank','seo-stats-widget').'</td>
    <td>'.$v['SEM']['rank'].'</td>
  </tr>
  <tr>
    <td>'.__('Alexa Rank','seo-stats-widget').'</td>
    <td>'.$v['ALEXA']['rank'].'</td>
  </tr>
  <tr>
    <td>'.__('Alexa Backlink','seo-stats-widget').'</td>
    <td>'.$v['ALEXA']['links'].'</td>
  </tr>
  <tr>
    <td>'.__('Dmoz Listing','seo-stats-widget').'</td>
    <td>'.$dmoz.'</td>
  </tr>
  <tr>
    <td>'.__('Website Load time','seo-stats-widget').'</td>
    <td>'.$v['ALEXA']['speed'].' ms</td>
  </tr>
</table>
<aside>';

	}

 	public function form( $instance ) {
		$title = isset($instance[ 'title' ])?$instance[ 'title' ]:__('SEO Statistics','seo-stats-widget');
		?>
		<p>
		<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:' ); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" /><br>
		</p>
		<?php
	}

	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['title'] = strip_tags( $new_instance['title'] );
		return $instance;
	}
}
add_action('widgets_init',
     create_function('', 'return register_widget("wpseostats_Widget");')
);
function seostats_css() {
   echo '<style type="text/css">
           .wpseostats{width:100%}
		   .wpseostats td{padding:2px}
		   .wpseostats tr:nth-child(odd){background-color:#EFEFEF}
         </style>';
}
add_action('admin_head', 'seostats_css');
?>