<?php
/**
 * General function toolkit
 *
 * Used globally as tools across the plugin.
 *
 * @since 2.01
 *
 */


if( ! function_exists( 'wpbo_get_woo_version_number' ) ){
	
	/**
	 * Get WooCommerce version
	 *
	 * Get version number of WooCommerce in plugins.
	 *
	 * @author				cxThemes
	 * @deprecated			2.0 Never used
	 *
	 * @return number|null	WooCommerce version number.
	 */
	function wpbo_get_woo_version_number() {
		
		// If get_plugins() isn't available, require it
		if ( ! function_exists( 'get_plugins' ) )
			require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
		
		// Create the plugins folder and file variables
		$plugin_folder = get_plugins( '/' . 'woocommerce' );
		$plugin_file = 'woocommerce.php';
		
		// If the plugin version number is set, return it
		if ( isset( $plugin_folder[$plugin_file]['Version'] ) ) {
			return $plugin_folder[$plugin_file]['Version'];
		} else {
		// Otherwise return null
			return NULL;
		}
		
	}
}



 /*
 * Backup mb_convert_encoding function
 *
 * backup if php module php_mbstring is not active on server.
 * Simply a backup to avoid errors. User should get module activated.
 *
 * @author				cxThemes
 *
 */
if( ! function_exists( 'mb_convert_encoding' ) ) {
	function mb_convert_encoding ( $string, $type = 'HTML-ENTITIES', $encoding = 'utf-8' ) {
		
		//$string = htmlentities( $string, ENT_COMPAT, $encoding, false);
		//return html_entity_decode( $string );
		return $string;
	}
	
	//$string = 'Test:!"$%&/()=ÖÄÜöäü<<';
	//echo mb_convert_encoding($string, 'HTML-ENTITIES', 'utf-8');
	//echo htmlspecialchars_decode( utf8_decode( htmlentities( $string, ENT_COMPAT, 'utf-8', false) ) );
}






?>