<?php
/**
 * Email Order Items
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates/Emails
 * @version     2.1.2
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

global $woocommerce;


if( version_compare($woocommerce->version, '2.1', '>=') ){
	
	// WC2.1 and above
	
	foreach ( $items as $item ) :
		$_product     = apply_filters( 'woocommerce_order_item_product', $order->get_product_from_item( $item ), $item );
		$item_meta    = new WC_Order_Item_Meta( $item['item_meta'], $_product );
		?>
		<tr>
			<td class="order_items_table_td_style order_items_table_td order_items_table_td_left order_items_table_td_product">
				<?php
				// Show title/image etc
				if ( $show_image ) {
					echo apply_filters( 'woocommerce_order_item_thumbnail', '<img src="' . ( $_product->get_image_id() ? current( wp_get_attachment_image_src( $_product->get_image_id(), 'thumbnail') ) : wc_placeholder_img_src() ) .'" alt="' . __( 'Product Image', 'email-control' ) . '" height="' . esc_attr( $image_size[1] ) . '" width="' . esc_attr( $image_size[0] ) . '" style="vertical-align:middle; margin-right: 10px;" />', $item );
				}

				// Product name
				echo apply_filters( 'woocommerce_order_item_name', $item['name'], $item );

				// SKU
				if ( $show_sku && is_object( $_product ) && $_product->get_sku() ) {
					echo ' (#' . $_product->get_sku() . ')';
				}

				// File URLs
				if ( $show_download_links && is_object( $_product ) && $_product->exists() && $_product->is_downloadable() ) {

					$download_files = $order->get_item_downloads( $item );
					$i              = 0;

					foreach ( $download_files as $download_id => $file ) {
						$i++;

						if ( count( $download_files ) > 1 ) {
							$prefix = sprintf( __( 'Download %d', 'email-control' ), $i );
						} elseif ( $i == 1 ) {
							$prefix = __( 'Download', 'email-control' );
						}

						echo '<br/><small class="order_item_download">' . $prefix . ': <a href="' . esc_url( $file['download_url'] ) . '" target="_blank">' . esc_html( $file['name'] ) . '</a></small>';
					}
				}

				// Variation
				if ( $item_meta->meta ) {
					echo '<br/><small>' . nl2br( $item_meta->display( true, true ) ) . '</small>';
				}
				?>
				
			</td>
			<td class="order_items_table_td_style order_items_table_td order_items_table_td order_items_table_td_product">
				<?php echo $item['qty'] ;?>
			</td>
			<td class="order_items_table_td_style order_items_table_td order_items_table_td_right order_items_table_td_product" style="text-align:right">
				<?php echo $order->get_formatted_line_subtotal( $item ); ?>
			</td>
		</tr>

		<?php if ( $show_purchase_note && is_object( $_product ) && $purchase_note = get_post_meta( $_product->id, '_purchase_note', true ) ) : ?>
			<tr>
				<td colspan="3" class="order_items_table_td_style order_items_table_td order_items_table_td_both order_items_table_td_product">
					<?php echo apply_filters( 'the_content', $purchase_note ); ?>
				</td>
			</tr>
		<?php endif; ?>

	<?php
	endforeach;
	
} else {
	
	// WC2.0 and below
	
	foreach ( $items as $item ) :

		// Get/prep product data
		$_product = $order->get_product_from_item( $item );
		$item_meta = new WC_Order_Item_Meta( $item['item_meta'] );
		
		// Handle products that was removed from store
		if ( ! is_object( $_product ) ) :
			?>
			<tr>
				<td class="order_items_table_td_style order_items_table_td order_items_table_td_left order_items_table_td_product">
					<?php
					
					// Show title/image etc
					echo 	apply_filters( 'woocommerce_order_product_image', '', null, $show_image);

					// Product name
					echo 	apply_filters( 'woocommerce_order_product_title', $item['name'], $_product );

					// Product not available anymore message
					echo '<br/><small>(' . __( 'This product is no longer available', 'email-control' ) . ')</small>';
					
					// Variation
					echo 	($item_meta->meta) ? '<br/><small>' . nl2br( $item_meta->display( true, true ) ) . '</small>' : '';
					
					?>
				</td>
				<td class="order_items_table_td_style order_items_table_td order_items_table_td order_items_table_td_product">
					<?php echo $item['qty'] ;?>
				</td>
				<td class="order_items_table_td_style order_items_table_td order_items_table_td_right order_items_table_td_product" style="text-align:right">
					<?php echo $order->get_formatted_line_subtotal( $item ); ?>
				</td>
			</tr>
			<?php
		else :
			$attachment_image_src = wp_get_attachment_image_src( get_post_thumbnail_id( $_product->id ), 'thumbnail' );
			$image = ( $show_image ) ? '<img src="' . current( $attachment_image_src ) . '" alt="Product Image" height="' . $image_size[1] . '" width="' . $image_size[0] . '" style="vertical-align:middle; margin-right: 10px;" />' : '';

			?>
			<tr>
				<td class="order_items_table_td_style order_items_table_td order_items_table_td_left order_items_table_td_product">
					<?php

					// Show title/image etc
					echo 	apply_filters( 'woocommerce_order_product_image', $image, $_product, $show_image);

					// Product name
					echo 	apply_filters( 'woocommerce_order_product_title', $item['name'], $_product );

					// SKU
					echo 	($show_sku && $_product->get_sku()) ? ' (#' . $_product->get_sku() . ')' : '';

					// File URLs
					if ( $show_download_links && $_product->exists() && $_product->is_downloadable() ) {

						$download_file_urls = $order->get_downloadable_file_urls( $item['product_id'], $item['variation_id'], $item );

						$i = 0;

						foreach ( $download_file_urls as $file_url => $download_file_url ) {
							echo '<br/><small class="order_item_download">';

							$filename = wc_get_filename_from_url( $file_url );

							if ( count( $download_file_urls ) > 1 ) {
								echo sprintf( __('Download %d:', 'email-control' ), $i + 1 );
							} elseif ( $i == 0 )
								echo __( 'Download:', 'email-control' );

							echo ' <a href="' . $download_file_url . '" target="_blank">' . $filename . '</a></small>';

							$i++;
						}
					}

					// Variation
					echo 	($item_meta->meta) ? '<br/><small>' . nl2br( $item_meta->display( true, true ) ) . '</small>' : '';

					?>
				</td>
				<td class="order_items_table_td_style order_items_table_td order_items_table_td order_items_table_td_product">
					<?php echo $item['qty'] ;?>
				</td>
				<td class="order_items_table_td_style order_items_table_td order_items_table_td_right order_items_table_td_product" style="text-align:right">
					<?php echo $order->get_formatted_line_subtotal( $item ); ?>
				</td>
			</tr>

			<?php if ($show_purchase_note && $purchase_note = get_post_meta( $_product->id, '_purchase_note', true)) : ?>
				<tr>
					<td colspan="3" class="order_items_table_td_style order_items_table_td order_items_table_td_both order_items_table_td_product">
						<?php echo apply_filters('the_content', $purchase_note); ?>
					</td>
				</tr>
			<?php endif; ?>
			
		<?php endif; ?>
	<?php
	endforeach;

}
?>