<?php

if ( ! class_exists( 'isupportOptions' ) ) {
	class isupportOptions {
			
		function __construct() {
			$this->create_isupport_Options();
		}
		
		public function create_isupport_Options() {
			require_once(BPC_PATH . "admin/admin-page-class.php");
			/**
			* configure your admin page
			*/
			$config = array(    
				'menu'           => 'settings',             //sub page to settings page
				'page_title'     => __('iSupport options',MC_TEXT_DOMAIN),       //The name of this page 
				'capability'     => 'edit_themes',         // The capability needed to view the page 
				'option_group'   => 'isupport_options',       //the name of the option to create in the database
				'id'             => 'admin_page',   // meta box id, unique per page
				'fields'         => array(),    // list of fields (can be added by field arrays)
				'local_images'   => false,   // Use local or hosted images (meta box images for add/remove)
				'use_with_theme' => false //change path if used with theme set to true, false for a plugin or anything else for a custom path(default false).
			);  
			
			/**
			* instantiate your admin page
			*/
			$options_panel = new BF_Admin_Page_Class($config);
			$options_panel->OpenTabs_container('');
			
			/**
			* define your admin page tabs listing
			*/
			$options_panel->TabsListing(array(
			'links' => array(
			  'options_1' =>  __('Style Options',MC_TEXT_DOMAIN),
			  'options_11' =>  __('Admin Style',MC_TEXT_DOMAIN),
			  'options_2' =>  __('Refresh Options',MC_TEXT_DOMAIN),
			  'options_3' => __('Database Options',MC_TEXT_DOMAIN),
			  'options_4' => __('Email Options',MC_TEXT_DOMAIN),
			  'options_5' =>  __('Responsive Options',MC_TEXT_DOMAIN),
			  //'options_6' =>  __('Field Validation',MC_TEXT_DOMAIN),
			  'options_7' =>  __('Import Export',MC_TEXT_DOMAIN),
			)
			));
			
			/**
			* Open admin page first tab
			*/
			$options_panel->OpenTab('options_1');
			
			/**
			* Add fields to your admin page first tab
			* 
			* Simple options:
			* input text, checbox, select, radio 
			* textarea
			*/
			//title
			$options_panel->Title(__("Style Options",MC_TEXT_DOMAIN));
			
			//Color field
			$options_panel->addColor('isp_button',array('name'=> __('Common button color',MC_TEXT_DOMAIN), 'std' => '', 'desc' => __('',MC_TEXT_DOMAIN)));
			$options_panel->addColor('isp_button_text',array('name'=> __('Common button text color',MC_TEXT_DOMAIN), 'std' => '', 'desc' => __('',MC_TEXT_DOMAIN)));
			$options_panel->addColor('isp_placeholder_text_color',array('name'=> __('Common placeholder text color',MC_TEXT_DOMAIN), 'std' => '', 'desc' => __('',MC_TEXT_DOMAIN)));
			$options_panel->addCheckbox('enable_isp_form_trans_bg',array('name'=> __('Transparent all form background?','apc'), 'std' => false, 'desc' => __('Enable if you want transparent all form background.','apc')));
			
			$options_panel->addColor('isp_title_bg_color',array('name'=> __('Chat window title background color',MC_TEXT_DOMAIN), 'std' => '', 'desc' => __('',MC_TEXT_DOMAIN)));
			$options_panel->addColor('isp_title_color',array('name'=> __('Chat window title text color ',MC_TEXT_DOMAIN), 'std' => '', 'desc' => __('',MC_TEXT_DOMAIN)));
			$options_panel->addColor('isp_body_bg_color',array('name'=> __('Chat window body background color ',MC_TEXT_DOMAIN), 'std' => '', 'desc' => __('',MC_TEXT_DOMAIN)));
			$options_panel->addImage('isp_bg_image',array('name'=> __('Chat window body background image ',MC_TEXT_DOMAIN),'preview_height' => '48px', 'preview_width' => '64px', 'desc' => __('',MC_TEXT_DOMAIN)));
			$options_panel->addRadio(
				'isp_bg_pattern',
				array(
					'bg0'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg0.png" />',
					'bg1'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg1.png" />',
					'bg2'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg2.png" />',
					'bg3'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg3.png" />',
					'bg4'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg4.png" />',
					'bg5'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg5.png" />',
					'bg6'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg6.png" />',
					'bg7'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg7.png" />',
					'bg8'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg8.png" />',
					'bg9'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg9.png" />',
					'bg10'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg10.png" />',
					'bg11'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg11.png" />',
					'bg12'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg12.png" />',
					'bg13'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg13.png" />',
					'bg14'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg14.png" />',
					'bg15'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg15.png" />',
					'bg16'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg16.png" />',
					'bg17'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg17.png" />',
					'bg18'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg18.png" />',
					'bg19'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg19.png" />',
					'bg20'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg20.png" />',
					'bg21'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg21.png" />',
					'bg22'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg22.png" />',
					'bg23'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg23.png" />',
					'bg24'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg24.png" />',
					'bg25'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg25.png" />',
					'bg26'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg26.png" />',
					'bg27'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg27.png" />',
					'bg28'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg28.png" />',
					'bg29'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg29.png" />',
					'bg30'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg30.png" />',
					'bg31'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg31.png" />',
					'bg32'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg32.png" />',
					'none'=>'none',
				),
				array(
					'name'=> __('Chat window background image',MC_TEXT_DOMAIN),
					'std'=> array('none'), 
					'desc' => __('',MC_TEXT_DOMAIN)
				)
			);
			$options_panel->addColor('isp_start_chat_bg_color',array('name'=> __('Start Chat background color',MC_TEXT_DOMAIN), 'std' => '', 'desc' => __('',MC_TEXT_DOMAIN)));
			$options_panel->addColor('isp_start_chat_bdr_color',array('name'=> __('Start Chat border color',MC_TEXT_DOMAIN), 'std' => '', 'desc' => __('',MC_TEXT_DOMAIN)));
			
			$options_panel->addColor('isp_chat_bg_color',array('name'=> __('Chat background color',MC_TEXT_DOMAIN), 'std' => '', 'desc' => __('',MC_TEXT_DOMAIN)));
			$options_panel->addColor('isp_chat_text_color',array('name'=> __('Chat Text color',MC_TEXT_DOMAIN), 'std' => '', 'desc' => __('',MC_TEXT_DOMAIN)));
			$options_panel->addColor('isp_chat_border_color',array('name'=> __('Chat border color',MC_TEXT_DOMAIN), 'std' => '', 'desc' => __('If you want complete closed border.',MC_TEXT_DOMAIN)));
			$options_panel->addCheckbox('enable_isp_chat_bg_opacity',array('name'=> __('Transparent chat background?','apc'), 'std' => false, 'desc' => __('Enable if you want transparent chat background.','apc')));
			//min numeric value
			$options_panel->addText('isp_chat_bg_opacity',
			array(
			  'name'     => __('Set background opacity ',MC_TEXT_DOMAIN),
			  'std'      => .5,
			  'desc'     => __("Value must be between 0-1 (Example: .4, .5, .6 .7). Default: .5",MC_TEXT_DOMAIN),
			  'validate' => array(
				  'minvalue' => array('param' => 0,'message' => __("Must be numeric with a min value of 0",MC_TEXT_DOMAIN))
			  ),
			  'validate' => array(
				  'maxvalue' => array('param' => 1,'message' => __("Must be numeric with a Max value of 1",MC_TEXT_DOMAIN))
			  )
			)
			);
			/*		
			$options_panel->addRadio(
				'isp_chat_bg_pattern',
				array(
					'bg0'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg0.png" />',
					'bg1'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg1.png" />',
					'bg2'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg2.png" />',
					'bg3'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg3.png" />',
					'bg4'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg4.png" />',
					'bg5'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg5.png" />',
					'bg6'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg6.png" />',
					'bg7'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg7.png" />',
					'bg8'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg8.png" />',
					'bg9'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg9.png" />',
					'bg10'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg10.png" />',
					'bg11'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg11.png" />',
					'bg12'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg12.png" />',
					'bg13'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg13.png" />',
					'bg14'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg14.png" />',
					'bg15'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg15.png" />',
					'bg16'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg16.png" />',
					'bg17'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg17.png" />',
					'bg18'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg18.png" />',
					'bg19'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg19.png" />',
					'bg20'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg20.png" />',
					'bg21'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg21.png" />',
					'bg22'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg22.png" />',
					'bg23'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg23.png" />',
					'bg24'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg24.png" />',
					'bg25'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg25.png" />',
					'bg26'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg26.png" />',
					'bg27'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg27.png" />',
					'bg28'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg28.png" />',
					'bg29'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg29.png" />',
					'bg30'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg30.png" />',
					'bg31'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg31.png" />',
					'bg32'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg32.png" />',
					'none'=>'none',
				),
				array(
					'name'=> __('Chat window background image',MC_TEXT_DOMAIN),
					'std'=> array('none'), 
					'desc' => __('Select Chat window background image',MC_TEXT_DOMAIN)
				)
			);
			$options_panel->addColor('isp_chat_text_color',array('name'=> __('Chat text color ',MC_TEXT_DOMAIN), 'std' => '', 'desc' => __('Chat text color',MC_TEXT_DOMAIN)));
			*/
			//$options_panel->addParagraph(__("This is a simple paragraph",MC_TEXT_DOMAIN));
			//text field
			//$options_panel->addText('text_field_id', array('name'=> __('My Text ',MC_TEXT_DOMAIN), 'std'=> 'text', 'desc' => __('Simple text field description',MC_TEXT_DOMAIN)));
			//textarea field
			//$options_panel->addTextarea('textarea_field_id',array('name'=> __('My Textarea ',MC_TEXT_DOMAIN), 'std'=> 'textarea', 'desc' => __('Simple textarea field description',MC_TEXT_DOMAIN)));
			//checkbox field
			
			//select field
			//$options_panel->addSelect('select_field_id',array('selectkey1'=>'Select Value1','selectkey2'=>'Select Value2'),array('name'=> __('My select ',MC_TEXT_DOMAIN), 'std'=> array('selectkey2'), 'desc' => __('Simple select field description',MC_TEXT_DOMAIN)));
			//radio field
			
			/**
			* Close first tab
			*/   
			$options_panel->CloseTab();
			

			/**
			* Open admin page first tab
			*/
			$options_panel->OpenTab('options_11');
			
			/**
			* Add fields to your admin page first tab
			* 
			* Simple options:
			* input text, checbox, select, radio 
			* textarea
			*/
			//title
			$options_panel->Title(__("Admin Style",MC_TEXT_DOMAIN));
			
			//Color field
			
			$options_panel->addColor('isp_adm_title_bg_color',array('name'=> __('Chat admin header background color',MC_TEXT_DOMAIN), 'std' => '', 'desc' => __('',MC_TEXT_DOMAIN)));
			$options_panel->addColor('isp_adm_title_color',array('name'=> __('Chat admin header text color ',MC_TEXT_DOMAIN), 'std' => '', 'desc' => __('',MC_TEXT_DOMAIN)));
			$options_panel->addColor('isp_adm_body_text_color',array('name'=> __('Admin dashboard text color ',MC_TEXT_DOMAIN), 'std' => '', 'desc' => __('',MC_TEXT_DOMAIN)));
			$options_panel->addColor('isp_adm_tab_bg_color',array('name'=> __('Admin client tab background color',MC_TEXT_DOMAIN), 'std' => '', 'desc' => __('',MC_TEXT_DOMAIN)));
			$options_panel->addColor('isp_adm_tab_row_color',array('name'=> __('Admin client tab row background color',MC_TEXT_DOMAIN), 'std' => '', 'desc' => __('',MC_TEXT_DOMAIN)));
			$options_panel->addColor('isp_adm_tab_bdr_color',array('name'=> __('Admin client tab border color',MC_TEXT_DOMAIN), 'std' => '', 'desc' => __('',MC_TEXT_DOMAIN)));
			$options_panel->addColor('isp_adm_tab_row_color_active',array('name'=> __('Admin client tab row background color on hover/active',MC_TEXT_DOMAIN), 'std' => '', 'desc' => __('',MC_TEXT_DOMAIN)));
			$options_panel->addColor('isp_adm_tab_text_color',array('name'=> __('Admin client tab text color',MC_TEXT_DOMAIN), 'std' => '', 'desc' => __('',MC_TEXT_DOMAIN)));
			$options_panel->addColor('isp_adm_tab_text_color_active',array('name'=> __('Admin client tab text color on hover/active',MC_TEXT_DOMAIN), 'std' => '', 'desc' => __('',MC_TEXT_DOMAIN)));
			$options_panel->addColor('isp_adm_body_bg_color',array('name'=> __('Chat admin body background color ',MC_TEXT_DOMAIN), 'std' => '', 'desc' => __('',MC_TEXT_DOMAIN)));
			$options_panel->addImage('isp_adm_bg_image',array('name'=> __('Chat admin body background image ',MC_TEXT_DOMAIN),'preview_height' => '48px', 'preview_width' => '64px', 'desc' => __('',MC_TEXT_DOMAIN)));
			$options_panel->addRadio(
				'isp_adm_bg_pattern',
				array(
					'bg0'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg0.png" />',
					'bg1'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg1.png" />',
					'bg2'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg2.png" />',
					'bg3'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg3.png" />',
					'bg4'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg4.png" />',
					'bg5'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg5.png" />',
					'bg6'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg6.png" />',
					'bg7'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg7.png" />',
					'bg8'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg8.png" />',
					'bg9'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg9.png" />',
					'bg10'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg10.png" />',
					'bg11'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg11.png" />',
					'bg12'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg12.png" />',
					'bg13'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg13.png" />',
					'bg14'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg14.png" />',
					'bg15'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg15.png" />',
					'bg16'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg16.png" />',
					'bg17'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg17.png" />',
					'bg18'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg18.png" />',
					'bg19'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg19.png" />',
					'bg20'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg20.png" />',
					'bg21'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg21.png" />',
					'bg22'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg22.png" />',
					'bg23'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg23.png" />',
					'bg24'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg24.png" />',
					'bg25'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg25.png" />',
					'bg26'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg26.png" />',
					'bg27'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg27.png" />',
					'bg28'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg28.png" />',
					'bg29'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg29.png" />',
					'bg30'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg30.png" />',
					'bg31'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg31.png" />',
					'bg32'=>'<img class="isp-radio-image" src="'.BPC_URL.'images/bg/bg32.png" />',
					'none'=>'none',
				),
				array(
					'name'=> __('Admin window background image',MC_TEXT_DOMAIN),
					'std'=> array('none'), 
					'desc' => __('',MC_TEXT_DOMAIN)
				)
			);
			$options_panel->addColor('isp_adm_start_chat_bg_color',array('name'=> __('Start Chat background color',MC_TEXT_DOMAIN), 'std' => '', 'desc' => __('',MC_TEXT_DOMAIN)));
			$options_panel->addColor('isp_adm_start_chat_bdr_color',array('name'=> __('Start Chat border color',MC_TEXT_DOMAIN), 'std' => '', 'desc' => __('',MC_TEXT_DOMAIN)));
			
			$options_panel->addColor('isp_adm_chat_bg_color',array('name'=> __('Chat background color',MC_TEXT_DOMAIN), 'std' => '', 'desc' => __('',MC_TEXT_DOMAIN)));
			$options_panel->addColor('isp_adm_chat_text_color',array('name'=> __('Chat Text color',MC_TEXT_DOMAIN), 'std' => '', 'desc' => __('',MC_TEXT_DOMAIN)));
			$options_panel->addColor('isp_adm_chat_border_color',array('name'=> __('Chat border color',MC_TEXT_DOMAIN), 'std' => '', 'desc' => __('If you want complete closed border.',MC_TEXT_DOMAIN)));
			$options_panel->addCheckbox('enable_isp_adm_chat_bg_opacity',array('name'=> __('Transparent char background?','apc'), 'std' => false, 'desc' => __('Enable if you want transparent chat background.','apc')));
			//min numeric value
			$options_panel->addText('isp_adm_chat_bg_opacity',
			array(
			  'name'     => __('Set background opacity ',MC_TEXT_DOMAIN),
			  'std'      => .5,
			  'desc'     => __("Value must be between 0-1 (Example: .4, .5, .6 .7). Default: .5",MC_TEXT_DOMAIN),
			  'validate' => array(
				  'minvalue' => array('param' => 0,'message' => __("Must be numeric with a min value of 0",MC_TEXT_DOMAIN))
			  ),
			  'validate' => array(
				  'maxvalue' => array('param' => 1,'message' => __("Must be numeric with a Max value of 1",MC_TEXT_DOMAIN))
			  )
			)
			);
			
			/**
			* Close first tab
			*/   
			$options_panel->CloseTab();
			
			/**
			* Open admin page Second tab
			*/
			$options_panel->OpenTab('options_2');
			/**
			* Add fields to your admin page 2nd tab
			* 
			* Fancy options:
			*  typography field
			*  image uploader
			*  Pluploader
			*  date picker
			*  time picker
			*  color picker
			*/
			//title
			$options_panel->Title(__('Refresh Options',MC_TEXT_DOMAIN));
			
			//is_numeric
			$options_panel->addText('isp_chat_refresh_rate',
			array(
			  'name'     => __('Chat message refresh rate ',MC_TEXT_DOMAIN),
			  'std'      => 5000,
			  'desc'     => __("Value is in millisecond (1000 ms = 1 sec). Default: 5000 ",MC_TEXT_DOMAIN),
			  'validate' => array(
				  'numeric' => array('param' => '','message' => __("must be numeric value",MC_TEXT_DOMAIN))
			  )
			)
			);
			//Typography field
			//$options_panel->addTypo('typography_field_id',array('name' => __("My Typography",MC_TEXT_DOMAIN),'std' => array('size' => '14px', 'color' => '#000000', 'face' => 'arial', 'style' => 'normal'), 'desc' => __('Typography field description',MC_TEXT_DOMAIN)));
			//Image field
			//$options_panel->addImage('image_field_id',array('name'=> __('My Image ',MC_TEXT_DOMAIN),'preview_height' => '120px', 'preview_width' => '440px', 'desc' => __('Simple image field description',MC_TEXT_DOMAIN)));
			//PLupload field
			//$options_panel->addPlupload('plupload_field_ID',array('name' => __('PlUpload Field',MC_TEXT_DOMAIN), 'multiple' => true, 'desc' => __('Simple multiple image field description',MC_TEXT_DOMAIN)));  
			//date field
			//$options_panel->addDate('date_field_id',array('name'=> __('My Date ',MC_TEXT_DOMAIN), 'desc' => __('Simple date picker field description',MC_TEXT_DOMAIN)));
			//Time field
			//$options_panel->addTime('time_field_id',array('name'=> __('My Time ',MC_TEXT_DOMAIN), 'desc' => __('Simple time picker field description',MC_TEXT_DOMAIN)));
			
			
			/**
			* Close second tab
			*/ 
			$options_panel->CloseTab();
			
			
			
			/**
			* Open admin page 3rd tab
			*/
			$options_panel->OpenTab('options_3');
			/**
			* Add fields to your admin page 3rd tab
			* 
			* Editor options:
			*   WYSIWYG (tinyMCE editor)
			*  Syntax code editor (css,html,js,php)
			*/
			//title
			$options_panel->Title(__("Database Options",MC_TEXT_DOMAIN));
			
			$options_panel->addCheckbox('enable_chat_cleanup',array('name'=> __('Delete database chat history? ',MC_TEXT_DOMAIN), 'std' => false, 'desc' => __('Enable this to delete chat history from database',MC_TEXT_DOMAIN)));
			
			$options_panel->addRadio(
				'chat_cleanup_interval',
				array(
					'hourly'=>'Once hourly',
					'twicedaily'=>'Twice daily',
					'daily'=>'Once daily',
					'weekly'=>'Once weekly',
					'monthly'=>'Once Monthly',
					'yearly'=>'Once Yearly',
				),
				array(
					'name'=> __('Database cleanup interval',MC_TEXT_DOMAIN),
					'std'=> array('monthly'), 
					'desc' => __('Select Chat cleanup interval from database',MC_TEXT_DOMAIN)
				)
			);
			
			//wysiwyg field
			//$options_panel->addWysiwyg('wysiwyg_field_id',array('name'=> __('My wysiwyg Editor ',MC_TEXT_DOMAIN), 'desc' => __('wysiwyg field description',MC_TEXT_DOMAIN)));
			//code editor field
			//$options_panel->addCode('code_field_id',array('name'=> __('Code Editor ',MC_TEXT_DOMAIN),'syntax' => 'php', 'desc' => __('code editor field description',MC_TEXT_DOMAIN)));
			/**
			* Close 3rd tab
			*/ 
			$options_panel->CloseTab();
			
			
			/**
			* Open admin page 4th tab
			*/
			
			$options_panel->OpenTab('options_4');
			
			/**
			* Add fields to your admin page 4th tab
			* 
			* WordPress Options:
			*   Taxonomies dropdown
			*  posts dropdown
			*  Taxonomies checkboxes list
			*  posts checkboxes list
			*  
			*/
			//title
			$options_panel->Title(__("Email Options",MC_TEXT_DOMAIN));
			//taxonomy select field
			$options_panel->addCheckbox('enable_isp_email',array('name'=> __('Enable Custom Email then admin email?','apc'), 'std' => false, 'desc' => __('Enable if you want to use below email box.','apc')));
			
			$options_panel->addText('isp_email_address', array('name'=> __('Email Address','apc'), 'std'=> '', 'desc' => __('Customm email address. This is where the offline customer query will be sent.','apc')));
			
			//$options_panel->addTaxonomy('taxonomy_field_id',array('taxonomy' => 'category'),array('name'=> __('My Taxonomy Select',MC_TEXT_DOMAIN),'class' => 'no-fancy','desc' => __('This field has a <pre>.no-fancy</pre> class which disables the fancy select2 functions',MC_TEXT_DOMAIN) ));
			//posts select field
			//$options_panel->addPosts('posts_field_id',array('args' => array('post_type' => 'post')),array('name'=> __('My Posts Select',MC_TEXT_DOMAIN), 'desc' => __('posts select field description',MC_TEXT_DOMAIN)));
			//Roles select field
			//$options_panel->addRoles('roles_field_id',array(),array('name'=> __('My Roles Select',MC_TEXT_DOMAIN), 'desc' => __('roles select field description',MC_TEXT_DOMAIN)));
			//taxonomy checkbox field
			//$options_panel->addTaxonomy('taxonomy2_field_id',array('taxonomy' => 'category','type' => 'checkbox_list'),array('name'=> __('My Taxonomy Checkboxes',MC_TEXT_DOMAIN), 'desc' => __('taxonomy checkboxes field description',MC_TEXT_DOMAIN)));
			//posts checkbox field
			//$options_panel->addPosts('posts2_field_id',array('post_type' => 'post','type' => 'checkbox_list'),array('name'=> __('My Posts Checkboxes',MC_TEXT_DOMAIN), 'class' => 'no-toggle','desc' => __('This field has a <pre>.no-toggle</pre> class which disables the fancy Iphone like toggle',MC_TEXT_DOMAIN)));
			//Roles checkbox field
			//$options_panel->addRoles('roles2_field_id',array('type' => 'checkbox_list' ),array('name'=> __('My Roles Checkboxes',MC_TEXT_DOMAIN), 'desc' => __('roles checboxes field description',MC_TEXT_DOMAIN)));
			
			
			/**
			* Close 4th tab
			*/
			
			$options_panel->CloseTab();
			
			/**
			* Open admin page 5th tab
			*/
			$options_panel->OpenTab('options_5');
			//title
			$options_panel->Title(__("Responsive Options",MC_TEXT_DOMAIN));
			
			//An optionl descrption paragraph
			$options_panel->addCheckbox('isp_mobile_full_width',array('name'=> __('Full width in mobile ',MC_TEXT_DOMAIN), 'std' => false, 'desc' => __('Enable full width chat window in mobile device',MC_TEXT_DOMAIN)));
			$options_panel->addCheckbox('isp_mobile_full_height',array('name'=> __('Full height in mobile ',MC_TEXT_DOMAIN), 'std' => false, 'desc' => __('Enable full height chat window in mobile device',MC_TEXT_DOMAIN)));
			
			$options_panel->addColor('isp_mobile_chat_bg_color',array('name'=> __('Mobile Chat icon background color',MC_TEXT_DOMAIN), 'std' => '', 'desc' => __('',MC_TEXT_DOMAIN)));
			$options_panel->addText('isp_mobile_chat_bg_opacity',
			array(
			  'name'     => __('Set mobile chat icon background opacity ',MC_TEXT_DOMAIN),
			  'std'      => .4,
			  'desc'     => __("Value must be between 0-1 (Example: .4, .5, .6 .7). Default: .4",MC_TEXT_DOMAIN),
			  'validate' => array(
				  'minvalue' => array('param' => 0,'message' => __("Must be numeric with a min value of 0",MC_TEXT_DOMAIN))
			  ),
			  'validate' => array(
				  'maxvalue' => array('param' => 1,'message' => __("Must be numeric with a Max value of 1",MC_TEXT_DOMAIN))
			  )
			)
			);
			$options_panel->addCheckbox('isp_disable_mobile_chat_icon',array('name'=> __('Disable mobile chat icon?',MC_TEXT_DOMAIN), 'std' => true, 'desc' => __('Disable it will make right bottom chat button will show up all time',MC_TEXT_DOMAIN)));
			//sortable field
			//$options_panel->addSortable('sortable_field_id',array('1' => 'One','2'=> 'Two', '3' => 'three', '4'=> 'four'),array('name' => __('My Sortable Field',MC_TEXT_DOMAIN), 'desc' => __('Sortable field description',MC_TEXT_DOMAIN)));
			
			/*
			* To Create a reapeater Block first create an array of fields
			* use the same functions as above but add true as a last param
			
			$repeater_fields[] = $options_panel->addText('re_text_field_id',array('name'=> __('My Text ',MC_TEXT_DOMAIN)),true);
			$repeater_fields[] = $options_panel->addTextarea('re_textarea_field_id',array('name'=> __('My Textarea ',MC_TEXT_DOMAIN)),true);
			$repeater_fields[] = $options_panel->addImage('image_field_id',array('name'=> __('My Image ',MC_TEXT_DOMAIN)),true);
			$repeater_fields[] = $options_panel->addCheckbox('checkbox_field_id',array('name'=> __('My Checkbox  ',MC_TEXT_DOMAIN)),true);
			*/
			/*
			* Then just add the fields to the repeater block
			*/
			//repeater block
			//$options_panel->addRepeaterBlock('re_',array('sortable' => true, 'inline' => true, 'name' => __('This is a Repeater Block',MC_TEXT_DOMAIN),'fields' => $repeater_fields, 'desc' => __('Repeater field description',MC_TEXT_DOMAIN)));
			
			/**
			* To Create a Conditional Block first create an array of fields (just like a repeater block
			* use the same functions as above but add true as a last param
			
			$Conditinal_fields[] = $options_panel->addText('con_text_field_id',array('name'=> __('My Text ',MC_TEXT_DOMAIN)),true);
			$Conditinal_fields[] = $options_panel->addTextarea('con_textarea_field_id',array('name'=> __('My Textarea ',MC_TEXT_DOMAIN)),true);
			$Conditinal_fields[] = $options_panel->addImage('con_image_field_id',array('name'=> __('My Image ',MC_TEXT_DOMAIN)),true);
			$Conditinal_fields[] = $options_panel->addCheckbox('con_checkbox_field_id',array('name'=> __('My Checkbox  ',MC_TEXT_DOMAIN)),true);
			*/
			/**
			* Then just add the fields to the repeater block
			
			//conditinal block 
			$options_panel->addCondition('conditinal_fields',
			  array(
				'name'   => __('Enable conditinal fields? ',MC_TEXT_DOMAIN),
				'desc'   => __('<small>Turn ON if you want to enable the <strong>conditinal fields</strong>.</small>',MC_TEXT_DOMAIN),
				'fields' => $Conditinal_fields,
				'std'    => false
			  ));
			*/
			/**
			* Close 5th tab
			*/
			$options_panel->CloseTab();
			
			
			/**
			* Open admin page 6th tab
			* field validation 
			* `email`            => validate email
			* `alphanumeric`     => validate alphanumeric
			* `url`              => validate url
			* `length`           => check for string length
			* `maxlength`        => check for max string length
			* `minlength`        => check for min string length
			* `maxvalue`         => check for max numeric value
			* `minvalue`         => check for min numeric value
			* `numeric`          => check for numeric value
			
			//$options_panel->OpenTab('options_6');
			//email validation
			$options_panel->addText('email_text_field_id',
			array(
			  'name'     => __('My Email validation ',MC_TEXT_DOMAIN),
			  'std'      => 'test@domain.com',
			  'desc'     => __("Field with email validation",MC_TEXT_DOMAIN),
			  'validate' => array(
				  'email' => array('param' => '','message' => __("must be a valid email address",MC_TEXT_DOMAIN))
			  )
			)
			);
			
			//alphanumeric validation
			$options_panel->addText('an_text_field_id',
			array(
			  'name'     => __('My alpha numeric validation ',MC_TEXT_DOMAIN),
			  'std'      => 'abcd1234',
			  'desc'     => __("Field with alpa numeric validation, try entring something like #$",MC_TEXT_DOMAIN),
			  'validate' => array(
				  'alphanumeric' => array('param' => '','message' => __("must be a valid alpha numeric chars only",MC_TEXT_DOMAIN))
			  )
			)
			);
			
			
			// string length exceeds maximum length validation
			$options_panel->addText('max_text_field_id',
			array(
			  'name'     => __('My Max length of string validation ',MC_TEXT_DOMAIN),
			  'std'      => 'abcdefghi',
			  'desc'     => __("Field with max string lenght validation,So try entering a longer string",MC_TEXT_DOMAIN),
			  'validate' => array(
				  'maxlength' => array('param' => 10,'message' => __("must be not exceed 10 chars long",MC_TEXT_DOMAIN))
			  )
			)
			);
			
			// string length exceeds maximum length validation
			$options_panel->addText('min_text_field_id',
			array(
			  'name'     => __('My Min length of string validation ',MC_TEXT_DOMAIN),
			  'std'      => 'abcdefghi',
			  'desc'     => __("Field with min string lenght validation, So try entering a shorter string",MC_TEXT_DOMAIN),
			  'validate' => array(
				  'minlength' => array('param' => 8,'message' => __("must be a minimum length of 8 chars long",MC_TEXT_DOMAIN))
			  )
			)
			);
			
			
			
			// check for exactly length of string validation
			$options_panel->addText('exact_text_field_id',
			array(
			  'name'     => __('My exactly length of string validation ',MC_TEXT_DOMAIN),
			  'std'      => 'abcdefghij',
			  'desc'     => __("Field with exact string lenght validation, So try entering a shorter or longer string",MC_TEXT_DOMAIN),
			  'validate' => array(
				  'length' => array('param' => 10,'message' => __("must be exactly 10 chars long",MC_TEXT_DOMAIN))
			  )
			)
			);
			
			//is_numeric
			$options_panel->addText('n_text_field_id',
			array(
			  'name'     => __('My numeric validation ',MC_TEXT_DOMAIN),
			  'std'      => 1,
			  'desc'     => __("Field with numeric value validation",MC_TEXT_DOMAIN),
			  'validate' => array(
				  'numeric' => array('param' => '','message' => __("must be numeric value",MC_TEXT_DOMAIN))
			  )
			)
			);
			
			//min numeric value
			$options_panel->addText('nmin_text_field_id',
			array(
			  'name'     => __('My Min numeric validation ',MC_TEXT_DOMAIN),
			  'std'      => 9,
			  'desc'     => __("Field with min numeric value validation",MC_TEXT_DOMAIN),
			  'validate' => array(
				  'minvalue' => array('param' => 8,'message' => __("must be numeric with a min value of 8",MC_TEXT_DOMAIN))
			  )
			)
			);
			
			//max numeric value
			$options_panel->addText('nmax_text_field_id',
			array(
			  'name'     => __('My Max numeric validation ',MC_TEXT_DOMAIN),
			  'std'      => 9,
			  'desc'     => __("Field with max numeric value validation",MC_TEXT_DOMAIN),
			  'validate' => array(
				  'maxvalue' => array('param' => 10,'message' => __("must be numeric with a Max value of 10",MC_TEXT_DOMAIN))
			  )
			)
			);
			
			//is_url validation
			$options_panel->addText('url_text_field_id',
			array(
			  'name'     => __('My URL validation ',MC_TEXT_DOMAIN),
			  'std'      => 'http://en.bainternet.info',
			  'desc'     => __("Field with url value validation",MC_TEXT_DOMAIN),
			  'validate' => array(
				  'url' => array('param' => '','message' => __("must be a valid URL",MC_TEXT_DOMAIN))
			  )
			)
			);
			*/
			/**
			* Close 6th tab
			*/
			//$options_panel->CloseTab();
			
			/**
			* Open admin page 7th tab
			*/
			$options_panel->OpenTab('options_7');
			
			//title
			$options_panel->Title(__("Import Export",MC_TEXT_DOMAIN));
			
			/**
			* add import export functionallty
			*/
			$options_panel->addImportExport();
			
			/**
			* Close 7th tab
			*/
			$options_panel->CloseTab();
			$options_panel->CloseTab();
			
			//Now Just for the fun I'll add Help tabs
			/*
			$options_panel->HelpTab(array(
			'id'      =>'tab_id',
			'title'   => __('My help tab title',MC_TEXT_DOMAIN),
			'content' =>'<p>'.__('This is my Help Tab content',MC_TEXT_DOMAIN).'</p>'
			));			
			*/
		}
	
	}
	new isupportOptions();
}

?>