<?php

class isupport_Admin_Ajax {

    public $ajax_actions;
    /*
     * Configuring and intializing ajax files and actions
     *
     * @param  -
     * @return -
     */

    public function __construct() {
		
    }

    public function initialize() {
        $this->configure_actions();
    }

    /*
     * Confire the application specific AJAX actions array and
     * load the AJAX actions bases on supplied parameters
     *
     * @param  -
     * @return -
     */

    public function configure_actions() {

        $this->ajax_actions = array(	
			"isp_load_admin_chat" => array("action" => "isp_load_admin_chat_action", "function" => "isp_load_admin_chat_function"),
			"isp_load_all_admin_chat" => array("action" => "isp_load_all_admin_chat_action", "function" => "isp_load_all_admin_chat_function"),
			"isp_admin_submit_message" => array("action" => "isp_admin_submit_message_action", "function" => "isp_admin_submit_message_function"),
			"isp_admin_chat_transfer" => array("action" => "isp_admin_chat_transfer_action", "function" => "isp_admin_chat_transfer_function"),
			"isp_fetch_transferred_client_msg" => array("action" => "isp_fetch_transferred_client_msg_action", "function" => "isp_fetch_transferred_client_msg_function"),
			"isp_set_admin_active_chat" => array("action" => "isp_set_admin_active_chat_action", "function" => "isp_set_admin_active_chat_function"),
			"isp_remove_admin_active_chat" => array("action" => "isp_remove_admin_active_chat_action", "function" => "isp_remove_admin_active_chat_function"),
			"isp_load_admin_active_chat" => array("action" => "isp_load_admin_active_chat_action", "function" => "isp_load_admin_active_chat_function"),
			"isp_search_content" => array("action" => "isp_search_content_action", "function" => "isp_search_content_function"),
			"isp_add_search_content" => array("action" => "isp_add_search_content_action", "function" => "isp_add_search_content_function"),
			"isp_edit_search_content" => array("action" => "isp_edit_search_content_action", "function" => "isp_edit_search_content_function"),
			"isp_edit_search_nav" => array("action" => "isp_edit_search_nav_action", "function" => "isp_edit_search_nav_function"),
			"isp_edit_nav_button" => array("action" => "isp_edit_nav_button_action", "function" => "isp_edit_nav_button_function"),
			"isp_delete_search_row" => array("action" => "isp_delete_search_row_action", "function" => "isp_delete_search_row_function")
        );

        /*
         * Add the AJAX actions into WordPress
         */
        foreach ($this->ajax_actions as $custom_key => $custom_action) {

            if (isset($custom_action["logged"]) && $custom_action["logged"]) {
                // Actions for users who are logged in
                add_action("wp_ajax_" . $custom_action['action'], array($this, $custom_action["function"]));
            } else if (isset($custom_action["logged"]) && !$custom_action["logged"]) {
                // Actions for users who are not logged in
                add_action("wp_ajax_nopriv_" . $custom_action['action'], array($this, $custom_action["function"]));
            } else {
                // Actions for users who are logged in and not logged in
                add_action("wp_ajax_nopriv_" . $custom_action['action'], array($this, $custom_action["function"]));
                add_action("wp_ajax_" . $custom_action['action'], array($this, $custom_action["function"]));
            }
        }
    }
	
	public function isp_delete_search_row_function() {
		header("Content-Type: application/json");
		
		$chat = array();
		$a = &$chat;		
		$rowid = $_POST["search_rowid"];
		global $wpdb;
		$wpdb->show_errors = true;
		// Using where formatting.
		$result = $wpdb->delete( 
								$wpdb->prefix.'isupport_search_document',
								array( 'DOCUMENT_ID' => $rowid ), 
								array( '%d' ) 
								);
		if($result){
			$a["is_delete"] = 1;
		}else{
			$a["is_delete"] = 0;
		}
		$a["delete_id"] = $rowid;
		echo json_encode($chat);
		exit;
		return $result;
	}
	
    /*
     * isp_load_admin_chat_function for handling AJAX request
     *
     * @param  -
     * @return -
     */

    public function isp_load_admin_chat_function() {
		header("Content-Type: application/json");
		$chat = array();
		$a = &$chat;
		$a["isp_clientinfo"] = array();		
		$a["isp_chatinfo"] = array();
		$a["isp_searchinfo"] = array();
		
        $chatAray = array();
	
		global $wpdb;
		$wpdb->show_errors = true;
		
		$UserId = get_current_user_id();
		$read = 0;
			
		$clientQuery = $wpdb->get_results($wpdb->prepare("SELECT DISTINCT u.display_name, u.user_email, u.user_login, im.user_sender 
														FROM $wpdb->users u, {$wpdb->prefix}isupport_message im 
														WHERE u.ID = im.user_sender 
														AND im.user_receiver = '%d' 
														AND im.chat_read = '%d' 
														AND DATE_ADD( u.isupport_last_activity, INTERVAL 5 MINUTE ) >= UTC_TIMESTAMP()
														ORDER BY im.id DESC 
														LIMIT 15", $UserId, $read));
		if(count($clientQuery) > 0) {
			foreach($clientQuery as $clientInfo) {
				$ClientId = $clientInfo->user_sender;
				$string = stripslashes(htmlspecialchars($clientInfo->display_name));
				$ClientName = (strlen($string) > 18) ? substr($string,0,16).'..' : $string;
				$ClientEmail = $clientInfo->user_email;
				$ClientUserName = $clientInfo->user_login;

				$getAvater = get_avatar($ClientId);
				$doc = new DOMDocument();
				$doc->loadHTML($getAvater);
				$xpath = new DOMXPath($doc);
				
				$src = str_replace('&','&amp;',$xpath->evaluate("string(//img/@src)")); # "/images/image.jpg"

				$a["isp_clientinfo"][$ClientId] = array("clientname" => $ClientName, 
														"clientemail" => $ClientEmail, 
														"clientusername"=> $ClientUserName,
														"avatar"=> $src
														);
							
				$MessageSQL = $wpdb->get_results($wpdb->prepare("SELECT * FROM {$wpdb->prefix}isupport_message WHERE user_receiver = '%d' AND user_sender = '%d' AND chat_read = '%d' ORDER BY id ASC LIMIT 15", $UserId, $ClientId, $read));
				foreach($MessageSQL as $Row) {
					$chatID = $Row->id;
					$chatAray[] = $Row->id;
					$senderID = $Row->user_sender;
					$receiverID = $Row->user_receiver;
					$chat_time = $Row->chat_time;
					$message = stripslashes($Row->message);

					$a["isp_chatinfo"][$chatID] = array("senderid" => $senderID, 
														"receiverid" => $receiverID, 
														"message"=> $message,
														"chat_time"=> $chat_time
														);
					
					$words = array();
					$words = str_word_count(strip_tags( $message ), 1);//$this->explode_items(strip_tags( $message ), ' ', false);
					
					$stop_words = array();
					$stop_word = array("a","by","I","she","us","about","could","if","so","was","also","do","in","that","we","am","for","is","the","were","an","from","it","their","what","and","had","let","them","when","any","has","me","then","where","are","ave","mine","there","which","as","he","my","these","while","at","her","of","they","why","be","him","on","this","with","been","his","or","through","you","being","hers","over","to","your","but","how","put","too");
					
					for($x = 0; $x < count($stop_word); $x++) {
						$stop_words[$stop_word[$x]] = true;
					}
				
					$words_removed = array();
					
					foreach ($words as $index => $word){
						if (isset($stop_words[strtolower($word)])){
							$words_removed[] = $word;
							unset($words[$index]); 
						}
					}
					// begin processing query
					if (count($words) > 0){
						// spell check the query words
						$spell_error = false;
						$suggest_words = array();
						$join = '';
						$where = '';
						$prefix = $wpdb->prefix;	
						$query = 'SELECT DISTINCT D.DOCUMENT_ID, D.DOCUMENT_TITLE, D.DESCRIPTION FROM '.$prefix.'isupport_search_document D ';
						foreach ($words as $index => $word){
							$cleared_word = strip_tags(strtolower($word));
							$join .= sprintf( 'JOIN '.$prefix.'isupport_search_index I%d ON D.DOCUMENT_ID = I%d.DOCUMENT_ID 
												JOIN '.$prefix.'isupport_search_term T%d ON I%d.TERM_ID = T%d.TERM_ID ', $index, $index, $index, $index, $index);
						
							$where .= sprintf('T%d.TERM_VALUE = "%s" AND ', $index, $cleared_word);
						}
						$query .= $join . 'WHERE ' . $where;
									
						// trimmed 4 characters o remove trailing ' AND'
						$query = substr($query, 0, strlen($query) - 4);
						$query .= ' LIMIT 10';
						$result = $wpdb->get_results($query);
						
						if(count($result) > 0) {
							foreach ($result as $row){
								$a["isp_searchinfo"][$senderID] = array("chatid" => $chatID, 
														"docid" => $row->DOCUMENT_ID, 
														"doctitle"=> $row->DOCUMENT_TITLE,
														"docdesc"=> $row->DESCRIPTION
														);
							}
						}
					}
				}
			}
		}else{
			//also working
			$wpdb->update( 
				$wpdb->users,
				array( 'isupport_status' => 'online'),
				array( 'ID' => $UserId )
			);
		}

		if(!empty($chatAray)) {
			foreach($chatAray as $key=>$id){
				$wpdb->update( 
					$wpdb->prefix.'isupport_message',
					array( 'chat_read' => 1),
					array( 'id' => $id ),
					array( '%d'),
					array( '%d')
				);
			}
		}

		//date_default_timezone_set('asia/dhaka');
		$date = date('Y-m-d H:i:s');
		//update_user_meta( $UserId, 'last_activity', $date );
		//update_user_meta( $user_id, $meta_key, $meta_value, $prev_value );
		
		//also working
		$wpdb->update( 
			$wpdb->users,
			array( 'isupport_last_activity' => $date),
			array( 'ID' => $UserId )
		);
		
		echo json_encode($chat);
		exit;
		
    }
	
	public function isp_fetch_transferred_client_msg_function(){
		header("Content-Type: application/json");
		$chat = array();
		$a = &$chat;
		$isp_clientid = $_POST["isp_clientid"];
		$isp_chatid = $_POST["isp_chatid"];
		
		$a["isp_msg_row"] = array();
		
        $chatAray = array();
	
		global $wpdb;
		$wpdb->show_errors = true;
		
		$UserId = get_current_user_id();
		
		$MessageSQL = $wpdb->get_results($wpdb->prepare("SELECT * FROM {$wpdb->prefix}isupport_message WHERE user_sender = '%d' AND id != '%d' ORDER BY id DESC LIMIT 5", $isp_clientid, $isp_chatid));
		
		if(!empty($MessageSQL)){
			foreach($MessageSQL as $Row) {
				$chatID = $Row->id;
				$chatAray[] = $Row->id;
				$senderID = $Row->user_sender;
				$receiverID = $Row->user_receiver;
				$chat_time = $Row->chat_time;
				$message = stripslashes($Row->message);

				$a["isp_msg_row"][$chatID] = array("senderid" => $senderID, 
													"receiverid" => $receiverID, 
													"message"=> $message,
													"chat_time"=> $chat_time
													);
			}
			$a["is_result"] = 1;
		}else{
			$a["is_result"] = 0;
		}
		$a["isp_chatid"] = $isp_chatid;
		
		echo json_encode($chat);
		exit;
		
	}
	
 	/*
     * isp_load_all_admin_chat functions for handling AJAX request
     *
     * @param  -
     * @return -
     */

    public function isp_load_all_admin_chat_function() {

        header("Content-Type: application/json");
		
		$chat = array();
		$a = &$chat;		
		$a["allmessages"] = array();
		
		global $wpdb;
		$wpdb->show_errors = true;
		
		$UserId = get_current_user_id();
		
		$senderID = $_POST["senderID"];
				
		$MessageSQL = $wpdb->get_results($wpdb->prepare("SELECT * FROM {$wpdb->prefix}isupport_message WHERE (user_receiver = '%d' AND user_sender = '%d') or (user_receiver = '%d' AND user_sender = '%d') ORDER BY id DESC LIMIT 15", $UserId, $senderID, $senderID, $UserId));
		
		$Cached = array();
		
		foreach($MessageSQL as $Row) {
			$userMessage = $Row->user_sender == $UserId;
			if($Row->user_sender == $senderID){
				$chatID = $Row->id;
			}
			
			//$getAvater = get_avatar($userMessage ? $UserId : $senderID);
			//$doc = new DOMDocument();
			//$doc->loadHTML($getAvater);
			//$xpath = new DOMXPath($doc);
			//$src = str_replace('&','&amp;',$xpath->evaluate("string(//img/@src)")); # "/images/image.jpg"
	
			if($userMessage){
				$msg = '<div class="isp_admin_message_row isp_message_row isp-clear"><div class="isupportMessage rightMessage"><div data-chatid="'.$Row->id.'" class="isupportContent isupportMessageLocation-'.$senderID.'">'.stripslashes($Row->message).'</div></div></div>';
			}else{
				$msg = '<div class="isp_client_message_row isp_message_row isp-clear"><div class="isupportMessage leftMessage"><div data-chatid="'.$Row->id.'" class="isupportContent isupportMessageLocation-'.$senderID.'"><span class="isp_msg_span">'.stripslashes($Row->message).'</span><span data-event="isp-sq-select" data-clientid="'.$senderID.'" class="isp_select_sq">&nbsp;</span></div></div></div>';
			}
			array_push($Cached, $msg);
			
			$wpdb->update( $wpdb->prefix.'isupport_message', array( 'chat_read' => 1),array( 'id' => $chatID ));
		}
		
		for($i = count($Cached); $i > -1; $i--){
			$a["allmessages"][$senderID] .= $Cached[$i];
		}
		
		echo json_encode($chat);
		exit;
    }	
	
		
	
	 /*
     * isp_admin_submit_message functions for handling AJAX request
     *
     * @param  -
     * @return -
     */

    public function isp_admin_submit_message_function() {

        header("Content-Type: application/json");
		
		$chat = array();
		$a = &$chat;
		
		global $wpdb;
		$wpdb->show_errors = true;
		
		$message = $_POST["messagecontent"];
		$clientid = $_POST["clientid"];
		$question = $_POST["question"];
		$UserId = get_current_user_id();
		$read = 0;
			
		$result = $wpdb->insert( 
			$wpdb->prefix.'isupport_message', 
			array( 
				'user_sender' => $UserId, 
				'user_receiver' => $clientid,
				'message' => $message,
				'chat_read' => $read,
			), 
			array( 
				'%d', 
				'%d',
				'%s',
				'%d',
			) 
		);
		if($result){
			$a["is_submit"] = 1;
			$wpdb->update( 
				$wpdb->users,
				array( 'isupport_status' => 'busy'),
				array( 'ID' => $UserId )
			);
			$a["is_insert"] = $this->isp_insert_search_content($question, $message);
		}else{
			$a["is_submit"] = 0;
		}
		
		echo json_encode($chat);
        exit;
    }

	 /*
     * isp_admin_chat_transfer functions for handling AJAX request
     *
     * @param  -
     * @return -
     */

    public function isp_admin_chat_transfer_function() {

        header("Content-Type: application/json");
		
		$chat = array();
		$a = &$chat;
		
		global $wpdb;
		$wpdb->show_errors = true;
		
		$message = $_POST["isp_message"];
		$clientid = $_POST["isp_clientid"];
		$operatorid = $_POST["isp_operatorid"];
		$UserId = get_current_user_id();
		$read = 0;
		$transfer = 1;
		$result = $wpdb->insert( 
			$wpdb->prefix.'isupport_message', 
			array( 
				'user_sender' => $clientid, 
				'user_receiver' => $operatorid,
				'message' => $message,
				'chat_read' => $read,
				'isp_transferred' => $transfer,
			), 
			array( 
				'%d', 
				'%d',
				'%s',
				'%d',
				'%d'
			) 
		);
		$a["isp_clientid"] = $clientid;
		if($result){
			$a["isp_submit"] = 1;
		}else{
			$a["isp_submit"] = 0;
		}
		
		echo json_encode($chat);
        exit;
    }

    /*
     * isp_set_admin_active_chat function functions for handling AJAX request
     *
     * @param  -
     * @return -
     */

    public function isp_set_admin_active_chat_function() {
        header("Content-Type: application/json");
		
		$chat = array();
		$a = &$chat;

		$ClientID = $_POST["ac_clientid"];
		$ClientName = $_POST["ac_clientname"];
		$ClientEmail = $_POST["ac_clientemail"];
		$avatar = $_POST["ac_avatar"];
		
		if(!isset($_SESSION["AdminStoredChat"])){
			$_SESSION["AdminStoredChat"] = array();
		}
		
		$_SESSION["AdminStoredChat"][$ClientID] = array("WINDOWID" => $ClientID, "USERNAME" => $ClientName, "CLIENTEMAIL" => $ClientEmail, "AVATAR" => $avatar);

		echo json_encode($chat);
        exit;
    }

    /*
     * isp_remove_admin_active_chat function functions for handling AJAX request
     *
     * @param  -
     * @return -
     */

    public function isp_remove_admin_active_chat_function() {
		header("Content-Type: application/json");
		
		$chat = array();
		$a = &$chat;
		
		$ClientID = $_POST["rm_clientid"];
		
		if(!isset($_SESSION["AdminStoredChat"]))
			$_SESSION["AdminStoredChat"] = array();
		
		if(array_key_exists($ClientID, $_SESSION["AdminStoredChat"]))
			unset($_SESSION["AdminStoredChat"][$ClientID]);
		
		$a["cacheData"] = $_SESSION["AdminStoredChat"];
		
		echo json_encode($chat);
        
        exit;
    }

    /*
     * isp_load_admin_active_chat function functions for handling AJAX request
     *
     * @param  -
     * @return -
     */

    public function isp_load_admin_active_chat_function() {
		header("Content-Type: application/json");
		
		$chat = array();
		$a = &$chat;
				
		if(!isset($_SESSION["AdminStoredChat"]))
			$_SESSION["AdminStoredChat"] = array();
		
		$a["AdminStoredChat"] = $_SESSION["AdminStoredChat"];
		
		echo json_encode($chat);
        
        exit;
    }
	
	/*
     * Generate random string for activation code
     *
     * @param  -
     * @return string
     */

    public function random_string() {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $randstr = '';
        for ($i = 0; $i < 15; $i++) {
            $randstr .= $characters[rand(0, strlen($characters))];
        }
        return $randstr;
    }
	
	// convert a list of items (separated by newlines by default) into an array
	// omitting blank lines and optionally duplicates
	public function explode_items($text, $separator = "\n", $preserve = true){
		$items = array();
		foreach (explode($separator, $text) as $value){
			$tmp = trim($value);
			if ($preserve){
				 $items[] = $tmp;
			}else{
				if (!empty($tmp)){
					$items[$tmp] = true;
				}
			}
		}
	
		if ($preserve){
			return $items;
		}else{
			return array_keys($items);
		}
	}
	// stop word generator
	public function stop_words(){
		$stop_words = array();
		$word = array("a","by","I","she","us","about","could","if","so","was","also","do","in","that","we","am","for","is","the","were","an","from","it","their","what","and","had","let","them","when","any","has","me","then","where","are","ave","mine","there","which","as","he","my","these","while","at","her","of","they","why","be","him","on","this","with","been","his","or","through","you","being","hers","over","to","your","but","how","put","too");
		
		for($x = 0; $x < count($word); $x++) {
			$stop_words[$word[$x]] = true;
		}
		return $stop_words;
	}
	
	/*
	 * isp_search_content_function
	 *
	*/
	
	public function isp_search_content_function(){
		header("Content-Type: application/json");
		$chat = array();
		$a = &$chat;
		global $wpdb;
		$wpdb->show_errors = true;
		$isp_search = $_POST["isp_search_query"];
		$client_id = $_POST["isp_search_id"];
		$words = array();
		
		if(isset($isp_search)){
			
			$words = str_word_count(strip_tags( $isp_search ), 1);//$this->explode_items(strip_tags( $isp_search ), ' ', false);
		
			$stop_words = array();

			$stop_word = array("a","by","I","she","us","about","could","if","so","was","also","do","in","that","we","am","for","is","the","were","an","from","it","their","what","and","had","let","them","when","any","has","me","then","where","are","ave","mine","there","which","as","he","my","these","while","at","her","of","they","why","be","him","on","this","with","been","his","or","through","you","being","hers","over","to","your","but","how","put","too");
			
			for($x = 0; $x < count($stop_word); $x++) {
				$stop_words[$stop_word[$x]] = true;
			}
		
			$words_removed = array();
			
			foreach ($words as $index => $word){
				if (isset($stop_words[strtolower($word)])){
					$words_removed[] = $word;
					unset($words[$index]); 
				}
			}
		}
		// begin processing query
		if (count($words) > 0){
			// spell check the query words
			$spell_error = false;
			$suggest_words = array();
			if(function_exists('pspell_new')){
				$ps = pspell_new('en');
				foreach ($words as $index => $word){
					if (!pspell_check($ps, $word)){
						if ($s = pspell_suggest($ps, $word)){
							if (strtolower($s[0]) != strtolower($word)) {
								// (ignore capitalization-related spelling errors)
								$spell_error = true;
								$suggest_words[$index] = $s[0];
							}
						}
					}
				}
			}
			// formulate the search query using provided terms and submit it
			$join = '';
			$where = '';
			$prefix = $wpdb->prefix;	
																	
			$query = 'SELECT DISTINCT D.DOCUMENT_ID, D.DOCUMENT_TITLE, D.DESCRIPTION FROM '.$prefix.'isupport_search_document D ';
			
			foreach ($words as $index => $word){
				$cleared_word = strip_tags(strtolower($word));
				$join .= sprintf( 'JOIN '.$prefix.'isupport_search_index I%d ON D.DOCUMENT_ID = I%d.DOCUMENT_ID 
									JOIN '.$prefix.'isupport_search_term T%d ON I%d.TERM_ID = T%d.TERM_ID ', $index, $index, $index, $index, $index);
			
				$where .= sprintf('T%d.TERM_VALUE = "%s" AND ', $index, $cleared_word);
			}
			$query .= $join . 'WHERE ' . $where;
						
			// trimmed 4 characters o remove trailing ' AND'
			$query = substr($query, 0, strlen($query) - 4);
			
			$query .= 'LIMIT 10';
			
			
			$result = $wpdb->get_results($query);
			
			$total = $wpdb->num_rows;
			
			$a["total_search_result"] = $total. ' match'.(($total > 1) ? 's' : '').' found.';
					
			// show suggested query if a possible misspelling was found
			$a["isp_mispelled_data"] = '';
			if ($spell_error){
				foreach ($words as $index => $word){
					if (isset($suggest_words[$index])){
						$words[$index] = $suggest_words[$index]; 
					}
				}
				$a["isp_mispelled_data"] .= '<p>Did you mean <a data-event="isp_search_mispelled" data-clientid="'.$client_id.'" href="">' . 
					htmlspecialchars(join(' ', $words)) . '</a>?</p>';
			}
						
			$a["isp_search_data"] = '<ul class="isp_auto_chat_row">';
			if(count($result) > 0) {
				foreach ($result as $row){
					$a["isp_search_data"] .= '<li id="docid_'.$row->DOCUMENT_ID.'">';
						$a["isp_search_data"] .= '<div class="isp-clear" data-titleid="'.$row->DOCUMENT_ID.'">';
						$a["isp_search_data"] .= '<b class="isp_auto_title" data-clientid="'.$client_id.'" data-titleid="'.$row->DOCUMENT_ID.'" data-event="send-to-chat-form">'.htmlspecialchars($row->DOCUMENT_TITLE).'</b>';
						$a["isp_search_data"] .= '<button class="expand-isp-edit-desc" data-event="expand-isp-edit-desc"><span>&or;</span></button>';
						$a["isp_search_data"] .= '</div>';
						$a["isp_search_data"] .= '<div class="isp_edit_desc" id="descid_'.$row->DOCUMENT_ID.'" data-desc-state="0">';
						$a["isp_search_data"] .= $row->DESCRIPTION;
						$a["isp_search_data"] .= '</div>';
					$a["isp_search_data"] .= '</li>';
				}
			}
			$a["isp_search_data"] .= '</ul>';

		}

		$a["isp_search_id"] = $client_id;
		if($result){
			$a["is_search_found"] = 1;
		}else{
			$a["is_search_found"] = 0;
		}

		echo json_encode($chat);
        exit;

	}
	
	/*
	 * isp_edit_search_nav_function
	 *
	*/
	
	public function isp_edit_search_nav_function(){
		header("Content-Type: application/json");
		$chat = array();
		$a = &$chat;
		global $wpdb;
		$wpdb->show_errors = true;
		$isp_search = $_POST["isp_edit_nav_query"];
		$words = array();
		
		if(isset($isp_search)){
			
			$words = str_word_count(strip_tags( $isp_search ), 1);//$this->explode_items(strip_tags( $isp_search ), ' ', false);
		
			$stop_words = array();

			$stop_word = array("a","by","I","she","us","about","could","if","so","was","also","do","in","that","we","am","for","is","the","were","an","from","it","their","what","and","had","let","them","when","any","has","me","then","where","are","ave","mine","there","which","as","he","my","these","while","at","her","of","they","why","be","him","on","this","with","been","his","or","through","you","being","hers","over","to","your","but","how","put","too");
			
			for($x = 0; $x < count($stop_word); $x++) {
				$stop_words[$stop_word[$x]] = true;
			}
		
			$words_removed = array();
			
			foreach ($words as $index => $word){
				if (isset($stop_words[strtolower($word)])){
					$words_removed[] = $word;
					unset($words[$index]); 
				}
			}
		}
		// begin processing query
		if (count($words) > 0){
			// spell check the query words
			$spell_error = false;
			$suggest_words = array();
			if(function_exists('pspell_new')){
				$ps = pspell_new('en');
				foreach ($words as $index => $word){
					if (!pspell_check($ps, $word)){
						if ($s = pspell_suggest($ps, $word)){
							if (strtolower($s[0]) != strtolower($word)) {
								// (ignore capitalization-related spelling errors)
								$spell_error = true;
								$suggest_words[$index] = $s[0];
							}
						}
					}
				}
			}
			// formulate the search query using provided terms and submit it
			$join = '';
			$where = '';
			$prefix = $wpdb->prefix;	
																	
			$query = 'SELECT DISTINCT D.DOCUMENT_ID, D.DOCUMENT_TITLE, D.DESCRIPTION FROM '.$prefix.'isupport_search_document D ';
			
			foreach ($words as $index => $word){
				$cleared_word = strip_tags(strtolower($word));
				$join .= sprintf( 'JOIN '.$prefix.'isupport_search_index I%d ON D.DOCUMENT_ID = I%d.DOCUMENT_ID 
									JOIN '.$prefix.'isupport_search_term T%d ON I%d.TERM_ID = T%d.TERM_ID ', $index, $index, $index, $index, $index);
			
				$where .= sprintf('T%d.TERM_VALUE = "%s" AND ', $index, $cleared_word);
			}
			$query .= $join . 'WHERE ' . $where;
						
			// trimmed 4 characters o remove trailing ' AND'
			$query = substr($query, 0, strlen($query) - 4);
			
			$query .= 'LIMIT 10';
			
			
			$result = $wpdb->get_results($query);
			
			$total = $wpdb->num_rows;
			
			$a["total_search_result"] = $total. ' match'.(($total > 1) ? 's' : '').' found.';
					
			// show suggested query if a possible misspelling was found
			$a["isp_mispelled_data"] = '';
			if ($spell_error){
				foreach ($words as $index => $word){
					if (isset($suggest_words[$index])){
						$words[$index] = $suggest_words[$index]; 
					}
				}
				$a["isp_mispelled_data"] .= '<p>Did you mean <a data-event="isp_search_mispelled" data-clientid="'.$client_id.'" href="">' . 
					htmlspecialchars(join(' ', $words)) . '</a>?</p>';
			}
						
			$a["isp_search_data"] = '<ul id="isp_edit_chat_row">';
			if(count($result) > 0) {
				foreach ($result as $row){
					$a["isp_search_data"] .= '<li id="docid_'.$row->DOCUMENT_ID.'">';
						$a["isp_search_data"] .= '<div class="isp-clear" data-titleid="'.$row->DOCUMENT_ID.'">';
						$a["isp_search_data"] .= '<b class="isp_edit_title" data-event="send-to-edit-form">'.htmlspecialchars($row->DOCUMENT_TITLE).'</b>';
						$a["isp_search_data"] .= '<button class="isp-delete-chat-row" data-event="isp-delete-chat-row"><span>&times;</span></button>';
						$a["isp_search_data"] .= '<button class="expand-isp-edit-desc" data-event="expand-isp-edit-desc"><span>&or;</span></button>';
						$a["isp_search_data"] .= '</div>';
						$a["isp_search_data"] .= '<div class="isp_edit_desc" id="descid_'.$row->DOCUMENT_ID.'" data-desc-state="0">';
						$a["isp_search_data"] .= $row->DESCRIPTION;
						$a["isp_search_data"] .= '</div>';
					$a["isp_search_data"] .= '</li>';
				}
			}
			$a["isp_search_data"] .= '</ul>';

		}

		if($result){
			$a["is_search_found"] = 1;
		}else{
			$a["is_search_found"] = 0;
		}

		echo json_encode($chat);
        exit;

	}

	/*
	 * isp_edit_search_nav_function
	 *
	*/
	
	public function isp_edit_nav_button_function(){
		header("Content-Type: application/json");
		$chat = array();
		$a = &$chat;
		global $wpdb;
		$wpdb->show_errors = true;
		$direction = $_POST["isp_edit_nav_dir"];
		$page_id = (int)$_POST["isp_edit_page_id"];
		
		// begin processing query
		if (isset($page_id)){
			// formulate the search query using provided terms and submit it
			$join = '';
			$where = '';
			$prefix = $wpdb->prefix;	
			
			$result = $wpdb->get_results('SELECT * FROM '.$prefix.'isupport_search_document ORDER BY DOCUMENT_ID ASC LIMIT '. ( ( $page_id - 1 ) * 10 ) .', 10');
														
			$a["isp_nav_data"] = '<ul id="isp_edit_chat_row">';
			if(count($result) > 0) {
				foreach ($result as $row){
					$a["isp_nav_data"] .= '<li id="docid_'.$row->DOCUMENT_ID.'">';
						$a["isp_nav_data"] .= '<div class="isp-clear" data-titleid="'.$row->DOCUMENT_ID.'">';
						$a["isp_nav_data"] .= '<b class="isp_edit_title" data-event="send-to-edit-form">'.htmlspecialchars($row->DOCUMENT_TITLE).'</b>';
						$a["isp_nav_data"] .= '<button class="isp-delete-chat-row" data-event="isp-delete-chat-row"><span>&times;</span></button>';
						$a["isp_nav_data"] .= '<button class="expand-isp-edit-desc" data-event="expand-isp-edit-desc"><span>&or;</span></button>';
						$a["isp_nav_data"] .= '</div>';
						$a["isp_nav_data"] .= '<div class="isp_edit_desc" id="descid_'.$row->DOCUMENT_ID.'" data-desc-state="0">';
						$a["isp_nav_data"] .= $row->DESCRIPTION;
						$a["isp_nav_data"] .= '</div>';
					$a["isp_nav_data"] .= '</li>';
				}
			}
			$a["isp_nav_data"] .= '</ul>';

		}

		if($result){
			$a["is_row_found"] = 1;
		}else{
			$a["is_row_found"] = 0;
		}
		$a["isp_direction"] = $direction;
		$a["isp_page_id"] = $page_id;

		echo json_encode($chat);
        exit;

	}	
	
	/*
	 * isp_add_search_content_function
	 *
	*/
	
	public function isp_add_search_content_function() {
		
		header("Content-Type: application/json");
		
		$chat = array();
		$a = &$chat;
		
		global $wpdb;
		$wpdb->show_errors = true;
				
		$question = $_POST["isp_search_question"];
		$answer = $_POST["isp_search_answer"];
		
		$UserId = get_current_user_id();
		$result ='';
		$prefix = $wpdb->prefix;
		
		//$sql = $wpdb->prepare("INSERT INTO {$wpdb->prefix}isupport_search_document (DOCUMENT_TITLE, DESCRIPTION) values (%s, %s)", $question, $answer);
		//$result = $wpdb->query($sql);
		if(isset($answer)){
			$result = $wpdb->insert( 
				$wpdb->prefix.'isupport_search_document', 
				array( 
					'DOCUMENT_TITLE' => $question, 
					'DESCRIPTION' => $answer
				), 
				array( 
					'%s', 
					'%s'
				) 
			);
			
			$doc_id = $wpdb->insert_id;			
			
			// strip HTML tags out from the content
			$title = strip_tags($question);
			
			$stop_words = array();
	
			$stop_word = array("a","by","I","she","us","about","could","if","so","was","also","do","in","that","we","am","for","is","the","were","an","from","it","their","what","and","had","let","them","when","any","has","me","then","where","are","ave","mine","there","which","as","he","my","these","while","at","her","of","they","why","be","him","on","this","with","been","his","or","through","you","being","hers","over","to","your","but","how","put","too");
			
			for($x = 0; $x < count($stop_word); $x++) {
				$stop_words[$stop_word[$x]] = true;
			}
			// break content into individual words
			foreach (str_word_count($title, 1) as $index => $word){
				// words should be stored as lowercase for comparisons 
				$use_word = strtolower($word);
		
				// skip word if it appears in the stop words list
				if (isset($stop_words[$use_word])) continue;
							
				$termQuery = $wpdb->get_results('SELECT TERM_ID FROM '.$prefix.'isupport_search_term WHERE TERM_VALUE = "'.$use_word.'"');
				$word_id = '';
				if(count($termQuery) > 0) {
					foreach($termQuery as $term_id) {
						$word_id = $term_id->TERM_ID;
					}
				}else{
					$term_result = $wpdb->insert( 
						$wpdb->prefix.'isupport_search_term', 
						array( 
							'TERM_VALUE' => $use_word, 
						), 
						array( 
							'%s', 
						) 
					);
					$word_id = $wpdb->insert_id;
					
				}
				
				//$wpdb->flush();
				
				$index_result = $wpdb->insert( 
					$wpdb->prefix.'isupport_search_index', 
					array( 
						'TERM_ID' => $word_id, 
						'DOCUMENT_ID' => $doc_id,
						'OFFSET' => $index, 
					), 
					array( 
						'%d', 
						'%d',
						'%d',
					) 
				);	
			}
		}else{
			$a["is_search_added"] = 0;
		}
		if($result){
			$a["is_search_added"] = 1;
		}else{
			$a["is_search_added"] = 0;
		}
		
		echo json_encode($chat);
        exit;

    }

	/*
	 * isp_insert_search_content
	 *
	*/
	
	public function isp_insert_search_content($question, $answer) {
				
		global $wpdb;
		$wpdb->show_errors = true;
				
		$UserId = get_current_user_id();
		$result ='';
		$prefix = $wpdb->prefix;
		
		if(!empty($question)){
			$result = $wpdb->insert( 
				$wpdb->prefix.'isupport_search_document', 
				array( 
					'DOCUMENT_TITLE' => $question, 
					'DESCRIPTION' => $answer,
				), 
				array( 
					'%s', 
					'%s',
				) 
			);
			
			$doc_id = $wpdb->insert_id;			
			
			// strip HTML tags out from the content
			$title = strip_tags($question);
			
			$stop_words = array();

			$stop_word = array("a","by","I","i","she","us","about","could","if","so","was","also","do","in","that","we","am","for","is","the","were","an","from","it","their","what","and","had","let","them","when","any","has","me","then","where","are","ave","mine","there","which","as","he","my","these","while","at","her","of","they","why","be","him","on","this","with","been","his","or","through","you","being","hers","over","to","your","but","how","put","too");
			
			for($x = 0; $x < count($stop_word); $x++) {
				$stop_words[$stop_word[$x]] = true;
			}
			// break content into individual words
			foreach (str_word_count($title, 1) as $index => $word){
				// words should be stored as lowercase for comparisons 
				$use_word = strtolower($word);
		
				// skip word if it appears in the stop words list
				if (isset($stop_words[$use_word])) continue;
							
				$termQuery = $wpdb->get_results('SELECT TERM_ID FROM '.$prefix.'isupport_search_term WHERE TERM_VALUE = "'.$use_word.'"');
				$word_id = '';
				if(count($termQuery) > 0) {
					foreach($termQuery as $term_id) {
						$word_id = $term_id->TERM_ID;
					}
				}else{
					$term_result = $wpdb->insert( 
						$wpdb->prefix.'isupport_search_term', 
						array( 
							'TERM_VALUE' => $use_word, 
						), 
						array( 
							'%s', 
						) 
					);
					$word_id = $wpdb->insert_id;
					
				}
								
				$index_result = $wpdb->insert( 
					$wpdb->prefix.'isupport_search_index', 
					array( 
						'TERM_ID' => $word_id, 
						'DOCUMENT_ID' => $doc_id,
						'OFFSET' => $index, 
					), 
					array( 
						'%d', 
						'%d',
						'%d',
					) 
				);	
			}
			return true;
		}else{
			return false;
		}
		

    }
		
	public function isp_edit_search_content_function() {
		
		header("Content-Type: application/json");
		
		$chat = array();
		$a = &$chat;
		
		global $wpdb;
		$wpdb->show_errors = true;
		
		$isp_edit_search = $_POST["isp_edit_search"];
		
		$question = $_POST["isp_edit_search_question"];
		$answer = $_POST["isp_edit_search_answer"];
		$docid = $_POST["isp_edit_doc_id"];
		$UserId = get_current_user_id();
		$result ='';
		$prefix = $wpdb->prefix;
		$doc_id = '';
		if(isset($isp_edit_search)){
			
			$delete = $wpdb->delete( 
								$wpdb->prefix.'isupport_search_document',
								array( 'DOCUMENT_ID' => $docid ), 
								array( '%d' ) 
								);
			
			$result = $wpdb->insert( 
				$wpdb->prefix.'isupport_search_document', 
				array( 
					'DOCUMENT_TITLE' => $question, 
					'DESCRIPTION' => $answer,
				), 
				array( 
					'%s', 
					'%s',
				) 
			);
			$doc_id = $wpdb->insert_id;	
			
			// strip HTML tags out from the content
			$title = strip_tags($question);
			
			$stop_words = array();

			$stop_word = array("a","by","I","she","us","about","could","if","so","was","also","do","in","that","we","am","for","is","the","were","an","from","it","their","what","and","had","let","them","when","any","has","me","then","where","are","ave","mine","there","which","as","he","my","these","while","at","her","of","they","why","be","him","on","this","with","been","his","or","through","you","being","hers","over","to","your","but","how","put","too");
			
			for($x = 0; $x < count($stop_word); $x++) {
				$stop_words[$stop_word[$x]] = true;
			}
			// break content into individual words
			foreach (str_word_count($title, 1) as $index => $word){
				// words should be stored as lowercase for comparisons 
				$use_word = strtolower($word);
		
				// skip word if it appears in the stop words list
				if (isset($stop_words[$use_word])) continue;
							
				$termQuery = $wpdb->get_results('SELECT TERM_ID FROM '.$prefix.'isupport_search_term WHERE TERM_VALUE = "'.$use_word.'"');
				$word_id = '';
				if(count($termQuery) > 0) {
					foreach($termQuery as $term_id) {
						$word_id = $term_id->TERM_ID;
					}
				}else{
					$term_result = $wpdb->insert( 
						$wpdb->prefix.'isupport_search_term', 
						array( 
							'TERM_VALUE' => $use_word, 
						), 
						array( 
							'%s', 
						) 
					);
					$word_id = $wpdb->insert_id;
					
				}
				
				//$wpdb->flush();
				
				$index_result = $wpdb->insert( 
					$wpdb->prefix.'isupport_search_index', 
					array( 
						'TERM_ID' => $word_id, 
						'DOCUMENT_ID' => $doc_id,
						'OFFSET' => $index, 
					), 
					array( 
						'%d', 
						'%d',
						'%d',
					) 
				);	
			}
		}else{
			$a["is_search_updated"] = 0;
		}
		
		if($result){
			$a["is_search_updated"] = 1;
		}else{
			$a["is_search_updated"] = 0;
		}
		$a["old_row_id"] = $docid;
		$a["new_row_id"] = $doc_id;
		
		echo json_encode($chat);
        exit;

    }
	
}

?>
