<?php

class isupport_Ajax {

    public $ajax_actions;
	public $operator_online = array();
	public $operator_busy = array();
	public $operator_offline = array();
    /*
     * Configuring and intializing ajax files and actions
     *
     * @param  -
     * @return -
     */

    public function __construct() {

    }

    public function initialize() {
        $this->configure_actions();
    }

    /*
     * Confire the application specific AJAX actions array and
     * load the AJAX actions bases on supplied parameters
     *
     * @param  -
     * @return -
     */

    public function configure_actions() {

        $this->ajax_actions = array(
			"isp_load_isp_window" => array("action" => "isp_load_isp_window_action", "function" => "isp_load_isp_window_function"),
			"isp_register_user" => array("action" => "isp_register_user_action", "function" => "isp_register_user_function"),
			"isp_offline_message" => array("action" => "isp_offline_message_action", "function" => "isp_offline_message_function"),
			
			"isp_load_client_chat" => array("action" => "isp_load_client_chat_action", "function" => "isp_load_client_chat_function"),
			"isp_load_allchat" => array("action" => "isp_load_allchat_action", "function" => "isp_load_allchat_function"),
			"isp_submit_client_message" => array("action" => "isp_submit_client_message_action", "function" => "isp_submit_client_message_function"),
			"isp_set_active_chat" => array("action" => "isp_set_active_chat_action", "function" => "isp_set_active_chat_function"),
			"isp_remove_active_chat" => array("action" => "isp_remove_active_chat_action", "function" => "isp_remove_active_chat_function"),
			"isp_load_active_chat" => array("action" => "isp_load_active_chat_action", "function" => "isp_load_active_chat_function"),
        );

        /*
         * Add the AJAX actions into WordPress
         */
        foreach ($this->ajax_actions as $custom_key => $custom_action) {

            if (isset($custom_action["logged"]) && $custom_action["logged"]) {
                // Actions for users who are logged in
                add_action("wp_ajax_" . $custom_action['action'], array($this, $custom_action["function"]));
            } else if (isset($custom_action["logged"]) && !$custom_action["logged"]) {
                // Actions for users who are not logged in
                add_action("wp_ajax_nopriv_" . $custom_action['action'], array($this, $custom_action["function"]));
            } else {
                // Actions for users who are logged in and not logged in
                add_action("wp_ajax_nopriv_" . $custom_action['action'], array($this, $custom_action["function"]));
                add_action("wp_ajax_" . $custom_action['action'], array($this, $custom_action["function"]));
            }
        }
    }
	/*
     * is_operator_online functions for checking user online or offline
     * @param  -
     * @return -
     */
	 
	public function is_operator_online(){
			global $wpdb;
			$opr = '%operator%';
			$sql = $wpdb->get_results($wpdb->prepare("SELECT u.ID, u.isupport_status
									FROM $wpdb->users u JOIN $wpdb->usermeta um 
									ON u.ID = um.user_id 
									WHERE DATE_ADD( u.isupport_last_activity, INTERVAL 3 MINUTE ) >= UTC_TIMESTAMP()
									AND um.meta_key = 'wp_capabilities' 
									AND um.meta_value LIKE %s", $opr));
			// http://stackoverflow.com/questions/28618463/sql-query-to-get-users-with-role-subscriber
			if(!empty($sql)){
				return true;
			}else {
				return false;
			}
	}				
    /*
     * isp_load_isp_window function for handling AJAX request
     *
     * @param  -
     * @return -
     */

    public function isp_load_isp_window_function() {
		header("Content-Type: application/json");
		$chat = array();
		$htm = '';
		$a = &$chat;
		$a["isp_window"] = '';
		global $wpdb;
		
		if($this->is_operator_online()){
			$iclass = 'isp_chat';
			$msg = __('Live Chat - Online',MC_TEXT_DOMAIN);
		}else{
			$iclass = 'isp_email';
			$msg = __('Message - Offline',MC_TEXT_DOMAIN);
		}
		
		if(is_user_logged_in()){
			$UserId = get_current_user_id();
			if($this->is_operator_online()){
				$htm .= '<div class="isp_chat_wrap" data-clientid="'.$UserId.'">
							<div id="isp_chat_body" data-clientid="'.$UserId.'" data-location="isupport-body-'.$UserId.'">
							</div>
							<div id="isp_chat_footer">
								<input type="text" data-event="submit-client-chat" placeholder="Start chat" data-clientid="'.$UserId.'" />
							</div>
						</div>';
			}else{
				$htm .= '<div class="isp_message_wrap">
				<b>'.__('Please send your query.',MC_TEXT_DOMAIN).'</b><br/>
				<form id="isp_message_form" action="" method="post">
				  <div>
					<input type="text" id="isp_message_subject" required name="isp_message_subject" value="" placeholder="'.__('Subject',MC_TEXT_DOMAIN).'">
				  </div>
				  <div>
					<textarea id="isp_message" value="" required name="isp_message" placeholder="'.__('Type message',MC_TEXT_DOMAIN).'"></textarea>
				  </div>
				  <div>
						<button class="isp_button" type="submit" data-event="offline-message" id="isp_message_submit">'.__('Send',MC_TEXT_DOMAIN).'</button>
				  </div>
				</form></div>';
			}			
		}else{
			$htm .= '<div class="isp_login_wrap">
				<b>'.__('Please log in for support.',MC_TEXT_DOMAIN).'</b><br/>
				<form action="'. wp_login_url(home_url()).'" id="login_form" name="login_form" method="post" class="clearfix">
				  <div>
					<input type="text" id="username" required name="log" class="inputbox" value="" placeholder="'.__('Username',MC_TEXT_DOMAIN).'">
				  </div>
				  <div>
					<input type="password" id="password" value="" required name="pwd" class="inputbox" placeholder="'.__('Password',MC_TEXT_DOMAIN).'">
				  </div>
				  <div>
				  <div class="isp_forgetmenot"><label for="rememberme"><input name="rememberme" type="checkbox" id="rememberme" value="forever"> Remember me</label></div>
				<div class="isp_login_submit"><button class="isp_button" type="submit" id="login" name="wp-submit" class="button">'.__('Log in',MC_TEXT_DOMAIN).'</button></div>
				<div class="forget_user_pass"><a href="'.wp_lostpassword_url().'" title="Password Lost and Found">Lost your password?</a></div>
				  </div>
				</form></div>
				<div class="isp_logres_wrap">
					<div>
						<b class="open-register">'.__('New to our support system?',MC_TEXT_DOMAIN).'</b><br/>
						<button class="open-register isp_button" data-event="open-register">Please register</button>
					</div>
					<div>
						<b class="open-log-in">'.__('Already registered? Please log in.',MC_TEXT_DOMAIN).'</b><br/>
						<button class="open-log-in isp_button" data-event="open-log-in">Log in</button>
					</div>
				</div>
				<div class="isp_register_wrap">
					<div class="isp_register_msg"></div>
					<b>'.__('Please sign up.',MC_TEXT_DOMAIN).'</b><br/>
					<form id="isp_register_form" action="" method="post">
					  <div>
						<input type="text" id="isp_signup_username" name="isp_signup_username" class="inputbox" required placeholder="'.__('Username',MC_TEXT_DOMAIN).'">
					  </div>
					  <div>
						<input type="text" id="isp_signup_fullname" name="isp_signup_fullname" class="inputbox" required placeholder="'.__('Full name',MC_TEXT_DOMAIN).'">
					  </div>
					  <div>
						<input type="text" id="isp_signup_email" name="isp_signup_email" class="inputbox" required placeholder="'.__('Email',MC_TEXT_DOMAIN).'">
					  </div>
					  <div>
						<input type="password" id="isp_signup_password" name="isp_signup_password" class="inputbox" required placeholder="'.__('Password',MC_TEXT_DOMAIN).'">
					  </div>
					  <div>
						<input type="password" id="isp_signup_password_confirm" name="isp_signup_password_confirm" class="inputbox" required placeholder="'.__('Confirm password',MC_TEXT_DOMAIN).'">
					  </div>
					  <div>
						<button type="submit" data-event="register-user" id="isp_signup_submit" name="isp_signup_submit" class="isp_button">'.__('Register',MC_TEXT_DOMAIN).'</button> 
					  </div>
					</form>
				</div>';
		}
	
		$a["isp_window"] .= '<div id="isupportChatWindow" data-window-state="0">
								<div class="isupportTitle" data-event="open-chat-window">
									<span class="chatIcon '.$iclass.'">&nbsp;</span><span class="chat-member">'.$msg.'</span><span class="listOpenIcon">&and;</span>
								</div>
								<div class="isupportBodyHolder" data-window-state="0" data-identifier="-1" style="display:none;">									
									<div class="isupportBody">
										'.$htm.'
									</div>
								</div>
							</div>
							<span data-event="open-mobile-chat-window" class="isp_mobile_ChatIcon '.$iclass.'">&nbsp;</span>
							';
				
		echo json_encode($chat);
		exit;
    }

    /*
     * Register new application user from frontend
     *
     * @param  -
     * @return void
     */

    public function isp_register_user_function() {
		header("Content-Type: application/json");
		$message = array();
		$a = &$message;
		$a["isp_message"] = '';
		$a["error"] = false;	
		$errors = false;
		
		$user_login = ( isset ( $_POST['isp_signup_username'] ) ? $_POST['isp_signup_username'] : '' );
		$user_email = ( isset ( $_POST['isp_signup_email'] ) ? $_POST['isp_signup_email'] : '' );
		$display_name = ( isset ( $_POST['isp_signup_fullname'] ) ? $_POST['isp_signup_fullname'] : '' );
		$user_pass = ( isset ( $_POST['isp_signup_password'] ) ? $_POST['isp_signup_password'] : '' );
		$pass_confirm = ( isset ( $_POST['isp_signup_password_confirm'] ) ? $_POST['isp_signup_password_confirm'] : '' );
		$user_type  = 'subscriber';
		$split_name = explode(" ",$display_name);
		if(count($split_name) >= 3){
			$first_name = $split_name[0].' '.$split_name[1];
			$last_name = '';
			for($i = 2; $i < count($split_name); $i++) {
				$last_name = $split_name[i];
			}
		}else if(count($split_name) == 2){
			$first_name = $split_name[0];
			$last_name =$split_name[1];
		}else{
			$first_name = $split_name[0];
			$last_name ='';
		}
		// Validating user data
		if (empty($user_login)){
			$a["isp_message"] .= '<span>'.__('Please enter a username.',MC_TEXT_DOMAIN).'</span><br/>';
			$errors = true;
			$a["error"] = true;
		}
		if (empty($user_email)){
			$a["isp_message"] .= '<span>'.__('Please enter e-mail.',MC_TEXT_DOMAIN).'</span><br/>';
			$errors = true;
			$a["error"] = true;
		}
		if (empty($display_name)){
			$a["isp_message"] .= '<span>'.__('Please enter full name.',MC_TEXT_DOMAIN).'</span><br/>';
			$errors = true;
			$a["error"] = true;
		}
		if (empty($user_pass)){
			$a["isp_message"] .= '<span>'.__('Please enter your password.',MC_TEXT_DOMAIN).'</span><br/>';
			$errors = true;
			$a["error"] = true;
		}
		 if (empty($pass_confirm)){
			$a["isp_message"] .= '<span>'.__('Please confirm your password .',MC_TEXT_DOMAIN).'</span><br/>';
			$errors = true;
			$a["error"] = true;
		}
		if(isset ( $_POST['isp_signup_password'] ) && isset ( $_POST['isp_signup_password_confirm'] ) && $_POST['isp_signup_password'] != $_POST['isp_signup_password_confirm']){
			$a["isp_message"] .= '<span>'.__('Password did not match.',MC_TEXT_DOMAIN).'</span><br/>';
			$errors = true;
			$a["error"] = true;
		}

		$sanitized_user_login = sanitize_user($user_login);

		if (!empty($user_email) && !is_email($user_email)){
			$a["isp_message"] .= '<span>'.__('Please enter valid email.',MC_TEXT_DOMAIN).'</span><br/>';
			$errors = true;
			$a["error"] = true;
		}elseif (email_exists($user_email)){
			$a["isp_message"] .= '<span>'.__('User with this email already registered.',MC_TEXT_DOMAIN).'</span><br/>';
			$errors = true;
			$a["error"] = true;
		}
		if (empty($sanitized_user_login) || !validate_username($user_login)){
			$a["isp_message"] .= '<span>'.__('Invalid username.',MC_TEXT_DOMAIN).'</span><br/>';
			$errors = true;
			$a["error"] = true;
		}elseif (username_exists($sanitized_user_login)){
			$a["isp_message"] .= '<span>'.__('Username alreay exists.',MC_TEXT_DOMAIN).'</span><br/>';
			$errors = true;
			$a["error"] = true;
		}
		if (!$errors) {
			
			$user_id = wp_insert_user(array('user_login' => $sanitized_user_login,
						'user_email' => $user_email,
						'display_name' => $display_name,
						'role' => $user_type,
						'first_name' => $first_name,
						'last_name' => $last_name,
						'user_pass' => $user_pass));


			if (!$user_id) {
				$a["isp_message"] .= '<span>'.__('Registration failed.',MC_TEXT_DOMAIN).'</span><br/>';
				$a["error"] = true;
			} else {
				$activation_code = $this->random_string();

				update_user_meta($user_id, 'activation_code', $activation_code);
				update_user_meta($user_id, 'activation_status', "inactive");
				wp_new_user_notification($user_id, $user_pass, $activation_code);
				
				$a["isp_message"] .= '<span>'.__('Registration completed successfully. Please check your email for activation link.',MC_TEXT_DOMAIN).'</span>';
				$a["error"] = false;
			}

		}
		
		echo json_encode($message);
		exit;
    }
	
	public function isp_offline_message_function(){
		header("Content-Type: application/json");
		if(isset($_POST['isp_message'])) {
			$message = array();
			$a = &$message;
			$a["isp_msg"] = '';
			$a["error"] = false;	
			$errors = false;
			
			$user = get_userdata( get_current_user_id() );
			$input_name = $user->display_name;
			$input_email = $user->user_email;
			$input_subject = $_POST['isp_message_subject'];
			$input_message = $_POST['isp_message'];
			
			if($input_subject == '') {
				$a["isp_msg"] .= '<span>'.__('Please enter a subject.',MC_TEXT_DOMAIN).'</span><br/>';
				$errors = true;
				$a["error"] = true;
			}
		
			if($input_message == '') {
				$a["isp_msg"] .= '<li>'.__('Please enter your message.',MC_TEXT_DOMAIN).'</span><br/>';
				$errors = true;
				$a["error"] = true;
			}
		
			//If there is no error, send the email
			$data = get_option('isupport_options');
			
			if($errors == false) {
				if($data['enable_isp_email']){
					$emailTo = $data['isp_email_address'];
					
				}else{
					$emailTo = get_option('admin_email');
				}
				$subject = $input_subject;
				$body = $input_message;
				$headers = 'From: '.$input_name.' <'.$input_email.'>' . "\r\n" . 'Reply-To: ' . $input_email;
				wp_mail($emailTo, $subject, $body, $headers);
				$a["isp_msg"] .= '<span>'.__('Thank you. We will get back to you soon',MC_TEXT_DOMAIN).'</span>';
				$a["error"] = false;
			}else{
				$a["isp_msg"] .= '<span>'.__('Message sending failed. Please try again.',MC_TEXT_DOMAIN).'</span>';
				$a["error"] = true;
			}
			
			echo json_encode($message);
			exit;
		
		}
	}	

    /*
     * isp_load_client_chat functions for handling AJAX request
     *
     * @param  -
     * @return -
     */

    function isp_load_client_chat_function() {
		header("Content-Type: application/json");
		
		$chat = array();
		$a = &$chat;		
		$a["isp_client_chat"] = array();
		
        $chatAray = array();
	
		global $wpdb;
		$wpdb->show_errors = true;
		
		$UserId = get_current_user_id();
		$Read = 0;
		$transfer = 1;
		$msgQuery = $wpdb->get_results($wpdb->prepare("SELECT DISTINCT u.display_name, im.id AS cid, im.user_sender, im.user_receiver, im.message, im.chat_time  
												FROM $wpdb->users u, {$wpdb->prefix}isupport_message im 
												WHERE u.ID = im.user_sender 
												AND im.user_receiver = '%d' 
												AND im.chat_read = '%d'
												AND im.isp_transferred != '%d'
												AND DATE_ADD( u.isupport_last_activity, INTERVAL 5 MINUTE ) >= UTC_TIMESTAMP()
												ORDER BY im.id ASC 
												LIMIT 15", $UserId, $Read, $transfer));
		if(!empty($msgQuery)) {
			foreach($msgQuery as $Row) {
				$chatID = $Row->cid;
				$chatAray[] = $Row->cid;
				$operatorID = $Row->user_sender;
				$operatorName = $Row->display_name;
				$clientID = $Row->user_receiver;
				$chat_time = $Row->chat_time;
				$message = stripslashes($Row->message);
				$getAvater = get_avatar($operatorID);
				$doc = new DOMDocument();
				$doc->loadHTML($getAvater);
				$xpath = new DOMXPath($doc);
				
				$src = str_replace('&','&amp;',$xpath->evaluate("string(//img/@src)")); # "/images/image.jpg"

				$a["isp_client_chat"][$chatID] = array("operatorid" => $operatorID, 
														"operatorname" => $operatorName, 
														"clientid"=> $clientID,
														"message"=> $message,
														"chat_time"=> $chat_time,
														"avatar"=> $src
														);
			}
		}
	
		if(count($chatAray) > 0) {
			foreach($chatAray as $key=>$id){
				$wpdb->update( 
					$wpdb->prefix.'isupport_message',
					array( 'chat_read' => 1),
					array( 'id' => $id ),
					array( '%d'),
					array( '%d')
				);
			}
		}
		
		//date_default_timezone_set('asia/dhaka');
		$date = date('Y-m-d H:i:s');
		//update_user_meta( $UserId, 'last_activity', $date );
		//update_user_meta( $user_id, $meta_key, $meta_value, $prev_value );
		
		//also working
		$wpdb->update( 
			$wpdb->users,
			array( 'isupport_last_activity' => $date),
			array( 'ID' => $UserId )
		);
		
		echo json_encode($chat);
		exit;
    }
	
 	/*
     * isp_load_allchat functions for handling AJAX request
     *
     * @param  -
     * @return -
     */

    function isp_load_allchat_function() {

        header("Content-Type: application/json");
		
		$chat = array();
		$a = &$chat;		
		$a["allmessages"] = array();
		
		global $wpdb;
		$wpdb->show_errors = true;
		
		$UserId = get_current_user_id();
		
		$clientID = $_POST["cc_clientid"];
		$transfer = 1;	
		
		$MessageSQL = $wpdb->get_results($wpdb->prepare("SELECT * FROM {$wpdb->prefix}isupport_message WHERE (user_receiver = '%d' or user_sender = '%d') AND isp_transferred != '%d' ORDER BY id DESC LIMIT 15", $clientID, $clientID, $transfer));
		
		$Cached = array();
		
		foreach($MessageSQL as $Row) {
			$userMessage = $Row->user_sender == $UserId;
			
			if(!$userMessage){
				$chatID = $Row->id;
			}
			$personalID = $userMessage ? $UserId : $Row->user_sender;
			$getAvater = get_avatar($userMessage ? $UserId : $Row->user_sender);
			$doc = new DOMDocument();
			$doc->loadHTML($getAvater);
			$xpath = new DOMXPath($doc);
			$src = str_replace('&','&amp;',$xpath->evaluate("string(//img/@src)")); # "/images/image.jpg"
			
			if($userMessage){
				$msg = '<div class="isp_client_message_row isp_message_row isp-clear"><div class="isupportMessage rightMessage"><div class="isupportContent">'.stripslashes($Row->message).'</div></div></div>';
			}else{
				$msg = '<div class="isp_admin_message_row isp_message_row isp-clear" data-operatorid="'.$personalID.'"><div class="isp_image leftImage"><img src="'.$src.'" /></div><div class="isupportMessage leftMessage"><div data-isp-chatid="'.$Row->id.'" class="isupportContent">'.stripslashes($Row->message).'</div></div></div>';
			}			
	
			array_push($Cached, $msg);
			
			$wpdb->update( $wpdb->prefix.'isupport_message', array( 'chat_read' => 1),array( 'id' => $chatID ));
			
			
		}
		
		for($i = count($Cached); $i > -1; $i--){
			$a["allmessages"][$clientID] .= $Cached[$i];
		}
		
		echo json_encode($chat);
		exit;
    }	
	
	/*
     * is_this_operator_online functions for checking user online or offline
     * @param  -
     * @return -
     */
	 
	public function is_this_operator_online($opid){
			global $wpdb;
			$opr = '%operator%';
			$sql = $wpdb->get_results($wpdb->prepare("SELECT u.ID, u.isupport_status
									FROM $wpdb->users u JOIN $wpdb->usermeta um 
									ON u.ID = um.user_id 
									WHERE DATE_ADD( u.isupport_last_activity, INTERVAL 1 MINUTE ) >= UTC_TIMESTAMP()
									AND um.meta_key = 'wp_capabilities' 
									AND u.ID = '%d'
									AND um.meta_value LIKE %s", $opid, $opr));
			// http://stackoverflow.com/questions/28618463/sql-query-to-get-users-with-role-subscriber
			if(!empty($sql)){
				return true;
			}else {
				return false;
			}
	}
		
	/*
     * all_operator_online functions for checking user online or offline
     * @param  -
     * @return -
     */
	 
	public function all_operator_online(){
			global $wpdb;
			$opr = '%operator%';
			$sql = $wpdb->get_results($wpdb->prepare("SELECT u.ID, u.isupport_status
									FROM $wpdb->users u JOIN $wpdb->usermeta um 
									ON u.ID = um.user_id 
									WHERE DATE_ADD( u.isupport_last_activity, INTERVAL 3 MINUTE ) >= UTC_TIMESTAMP()
									AND um.meta_key = 'wp_capabilities' 
									AND um.meta_value LIKE %s", $opr));
			// http://stackoverflow.com/questions/28618463/sql-query-to-get-users-with-role-subscriber
			if(!empty($sql)){
				foreach ( $sql as $row ) {
					if($row->isupport_status == 'online'){
						$this->operator_online[] = $row->ID;
					}else if($row->isupport_status == 'busy'){
						$this->operator_busy[] = $row->ID;
					}else if($row->isupport_status == 'offline'){
						$this->operator_offline[] = $row->ID;
					}
				}
				return true;
			}else{
				return false;
			}
	}
	
	 /*
     * isp_submit_client_message functions for handling AJAX request
     *
     * @param  -
     * @return -
     */

    function isp_submit_client_message_function() {

        header("Content-Type: application/json");
		
		$chat = array();
		$a = &$chat;
		
		global $wpdb;
		$wpdb->show_errors = true;
		
		$message = $_POST["messageContent"];
		$opid = $_POST["receiverUserId"];
		
		if($opid == 'none' && $this->all_operator_online()){
			
			if(!empty($this->operator_online)){
				$operatorID = $this->operator_online[array_rand($this->operator_online)];
			}else if(!empty($this->operator_busy)){
				$operatorID = $this->operator_busy[array_rand($this->operator_busy)];
			}
			
		}else if($opid != 'none' && !$this->is_this_operator_online($opid) && $this->all_operator_online()){
			if(!empty($this->operator_online)){
				$operatorID = $this->operator_online[array_rand($this->operator_online)];
			}else if(!empty($this->operator_busy)){
				$operatorID = $this->operator_busy[array_rand($this->operator_busy)];
			}
		}else{
			$operatorID = $_POST["receiverUserId"]; // operator is receiver
		}
		$UserId = get_current_user_id();
		$Read = 0;
			
		$affected_row = $wpdb->insert( 
			$wpdb->prefix.'isupport_message', 
			array( 
				'user_sender' => $UserId, 
				'user_receiver' => $operatorID,
				'message' => $message,
				'chat_read' => $Read,
			), 
			array( 
				'%d', 
				'%d',
				'%s',
				'%d',
			) 
		);
		
		if($affected_row){
			$a["is_submit"] = 1;
			$a["operator_id"] = $operatorID;
		}else{
			$a["is_submit"] = 0;
		}
		
		echo json_encode($chat);
        exit;
    }
	
    /*
     * isp_set_active_chat function functions for handling AJAX request
     *
     * @param  -
     * @return -
     */

    function isp_set_active_chat_function() {
		
        header("Content-Type: application/json");
		$chat = array();
		$a = &$chat;
		
		$ClientID = $_POST["cw_clientid"];
		
		if(!isset($_SESSION["ClientChatStored"]))
			$_SESSION["ClientChatStored"] = array();
		
		$_SESSION["ClientChatStored"][$ChatId] = array("WINDOWID" => $ClientID);
		
		echo json_encode($chat);
        exit;
    }

    /*
     * isp_remove_active_chat function functions for handling AJAX request
     *
     * @param  -
     * @return -
     */

    function isp_remove_active_chat_function() {
		
		header("Content-Type: application/json");
		
		$chat = array();
		$a = &$chat;
		
		$ClientID = $_POST["cw_clientid"];
		
		if(!isset($_SESSION["ClientChatStored"]))
			$_SESSION["ClientChatStored"] = array();
		
		if(array_key_exists($ChatId, $_SESSION["ClientChatStored"]))
			unset($_SESSION["ClientChatStored"][$ClientID]);
		
		$a["cacheData"] =$_SESSION["ClientChatStored"];
		
		echo json_encode($chat);
        
        exit;
    }

    /*
     * isp_load_active_chat function functions for handling AJAX request
     *
     * @param  -
     * @return -
     */

    function isp_load_active_chat_function() {
		
		header("Content-Type: application/json");
		$chat = array();
		$a = &$chat;
				
		if(!isset($_SESSION["ClientChatStored"]))
			$_SESSION["ClientChatStored"] = array();
		
		$a["ClientChatStored"] = $_SESSION["ClientChatStored"];
		
		echo json_encode($chat);
        
        exit;
    }
	
	/*
     * Generate random string for activation code
     *
     * @param  -
     * @return string
     */

    public function random_string() {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $randstr = '';
        for ($i = 0; $i < 15; $i++) {
            $randstr .= $characters[rand(0, strlen($characters))];
        }
        return $randstr;
    }
	
}



?>
