<?php

class isp_Admin_Area_Controller {
	private $plugin_name;
	private $plugin_version;
	
	function __construct(){
		add_action( 'admin_menu', array($this,'isupport_admin_menu') );
	}

	public function isupport_admin_menu(){
		$this->isupport_plugin_info();
        if ( current_user_can( 'publish_posts' ) ){
          $page = add_menu_page( 'iSupport - Live Chat', 'iSupport', 'publish_posts', 'isupport-chat-page', array( $this, 'isupport_chat_page' ), plugins_url('isupport/images/isupport.png' ), '30.26' );
		  add_submenu_page( 'isupport-chat-page', 'iSupport - Add QA', 'Add QA', 'publish_posts', 'isupport-add-qa-page', array( $this, 'isupport_add_qa_page' ) );
		  add_submenu_page( 'isupport-chat-page', 'iSupport - Update QA', 'Edit QA', 'publish_posts', 'isupport-edit-qa-page', array( $this, 'isupport_edit_qa_page' ) );
        }
		
    }
	
	public function isupport_chat_page(){
		$html = '';
		
		$getAvater = get_avatar(get_current_user_id());
		$doc = new DOMDocument();
		$doc->loadHTML($getAvater);
		$xpath = new DOMXPath($doc);
		$src = $xpath->evaluate("string(//img/@src)");
		$user_id = get_current_user_id();
		$user = get_userdata( $user_id );
		$name = $user->display_name;
		
		$user_query = new WP_User_Query( array( 'role' => 'operator' ) );
		
		// User Loop
		$alloperator = '';
		if ( ! empty( $user_query->results ) ) {
			foreach ( $user_query->results as $operator ) {
				if($user_id != $operator->ID){
					$alloperator .= '<li data-operatorid="'.$operator->ID.'" data-operatorname="' . $operator->display_name . '">&nbsp;</li>';
				}
			}
		}
		
		$html .= '<div class="isp-admin-wrap">';
			$html .= '<div class="isp-admin-head">';
				$html .= '<div class="isp-admin-head-left">';
					$html .= '<img class="isp-operator-image" src="'.$src.'">';
					$html .= '<span class="isp-operator-name">'.$name.'</span>';
				$html .= '</div>';
				$html .= '<div class="isp-admin-head-right">';
					$html .= '<span class="isp-info">'.$this->plugin_name.'</span>';
					$html .= '<span class="isp-info">v-'.$this->plugin_version.'</span>';
				$html .= '</div>';
			$html .= '</div>';
			$html .= '<div class="isp-admin-body isp-clear">';
				$html .= '<div id="isp-tabs-wrap">';
					$html .= '<ul id="isp-chat-tabs">';
						$html .= '<li data-event="dashboard-client-tabs" class="isp-current isp_dashboard">Dashboard</li>';
					$html .= '</ul>';
				$html .= '</div>';
				$html .= '<div id="isp-content-wrap">';
					$html .= '<div class="isp-chat-box isp-visible">';
						$html .= '<div class="isp-dashbord">';
							$html .= '<div class="isp-chat-items">';
							$html .= '
							<h4>How to add operator image?</h4>
							<p>If your theme do not have any option to add user image. Here <a href="https://wordpress.org/plugins/wp-user-avatar/" target="_blank">https://wordpress.org/plugins/wp-user-avatar/</a> is a great plugin to add image to any user. You can install it from your wp-admin panel plugin section. Just search for "wp-user-avatar" to install. </p>
            
            <p>The reason I did not include this feature is that most of the service based wordpress theme have image upload feature. I did not wanted to make a heavier plugin rather a light one. You can also disable "wp-user-avatar" plugin after uploading the operator images. So that you site become light and run faster.</p>
            <p>After installing this plugin just go all users and edit user. You will will find a image upload button at the bottom. You will also find this upload button when add operator. </p>
							';
							$html .= '</div>';
							$html .= '<div class="isp-search-items">';
							$html .= '
							<h4>How to add search content?</h4>
							<b>During Chat</b><br/>
            <p>If any new question comes from the client which answer do not exists in search query database and you want to add this question and answer to the search query database then click the gray ball beside the question and turn it into green and give a detail answer. All the question answer will be saved in search query database. if you choose wrong question just click the green ball again and it will be gray again.</p>
            <b>Add and Edit Question and Answer</b><br/>
            <p>Each operator can add common question and answer manually from the operator dashboard. Just click the add QA and edit QA. The rest of the things is self explanatory.</p>
							';
							$html .= '</div>';
						$html .= '</div>';
					$html .= '</div>';
				$html .= '</div>';
			$html .= '</div>';
		$html .= '</div>';
		$html .= '<ul class="isp_hide" id="isp_select_operator_id">';
		$html .= $alloperator;
		$html .= '</ul>';
    	echo $html;
    }
	
	public function isupport_add_qa_page(){
		$html = '';
		
		$getAvater = get_avatar(get_current_user_id());
		$doc = new DOMDocument();
		$doc->loadHTML($getAvater);
		$xpath = new DOMXPath($doc);
		$src = $xpath->evaluate("string(//img/@src)");
		
		$user = get_userdata( get_current_user_id() );
		$name = $user->display_name;
		
		$html .= '<div class="isp-admin-wrap">';
			$html .= '<div class="isp-admin-head">';
				$html .= '<div class="isp-admin-head-left">';
					$html .= '<img class="isp-operator-image" src="'.$src.'">';
					$html .= '<span class="isp-operator-name">'.$name.'</span>';
				$html .= '</div>';
				$html .= '<div class="isp-admin-head-right">';
					$html .= '<span class="isp-info">'.$this->plugin_name.'</span>';
					$html .= '<span class="isp-info">v-'.$this->plugin_version.'</span>';
				$html .= '</div>';
			$html .= '</div>';
			$html .= '<div class="isp-admin-body isp-clear">';
				$html .= '<div id="isp-add-content-wrap">';
					$html .= '<form id="isp_add_search_form" action="" method="post">
								<div class="isp_search_msg"></div>
							  <div>
								<input type="text" id="isp_search_question" name="isp_search_question" value="" placeholder="'.__('Type question', MC_TEXT_DOMAIN).'">
							  </div>
							  <div>
								<textarea id="isp_search_answer" name="isp_search_answer" value="" placeholder="'.__('Type answer', MC_TEXT_DOMAIN).'"></textarea>
							  </div>
							  <div>
								<button class="isp_button" type="submit" data-event="isp_add_search" id="isp_add_search" name="isp_add_search">'.__('Submit',MC_TEXT_DOMAIN).'</button>
							  </div>
							</form>';
				$html .= '</div>';
			$html .= '</div>';
		$html .= '</div>';
    	echo $html;
       	   
    }
	public function isupport_edit_qa_page(){
		global $wpdb;
		$wpdb->show_errors = true;			
		$html = '';
		$row = '';
		$getAvater = get_avatar(get_current_user_id());
		$doc = new DOMDocument();
		$doc->loadHTML($getAvater);
		$xpath = new DOMXPath($doc);
		$src = $xpath->evaluate("string(//img/@src)");
		
		$user = get_userdata( get_current_user_id() );
		$name = $user->display_name;
		
		$prefix = $wpdb->prefix;
		$result = $wpdb->get_results('SELECT * FROM '.$prefix.'isupport_search_document ORDER BY DOCUMENT_ID ASC LIMIT 10');
		
		if(!empty($result)){
			$row .= '<ul id="isp_edit_chat_row">';
			foreach ($result as $docs){
				$row .= '<li id="docid_'.$docs->DOCUMENT_ID.'">';
					$row .= '<div class="isp-clear" data-titleid="'.$docs->DOCUMENT_ID.'">';
					$row .= '<b class="isp_edit_title" data-event="send-to-edit-form">'.$docs->DOCUMENT_TITLE.'</b>';
					$row .= '<button class="isp-delete-chat-row" data-event="isp-delete-chat-row"><span>&times;</span></button>';
					$row .= '<button class="expand-isp-edit-desc" data-event="expand-isp-edit-desc"><span>&or;</span></button>';
					$row .= '</div>';
					$row .= '<div class="isp_edit_desc" id="descid_'.$docs->DOCUMENT_ID.'" data-desc-state="0">';
					$row .= $docs->DESCRIPTION;
					$row .= '</div>';
				$row .= '</li>';
			}
			$row .= '</ul>';
		}
		
		$html .= '<div class="isp-admin-wrap">';
			$html .= '<div class="isp-admin-head">';
				$html .= '<div class="isp-admin-head-left">';
					$html .= '<img class="isp-operator-image" src="'.$src.'">';
					$html .= '<span class="isp-operator-name">'.$name.'</span>';
				$html .= '</div>';
				$html .= '<div class="isp-admin-head-right">';
					$html .= '<span class="isp-info">'.$this->plugin_name.'</span>';
					$html .= '<span class="isp-info">v-'.$this->plugin_version.'</span>';
				$html .= '</div>';
			$html .= '</div>';
			$html .= '<div class="isp-admin-body isp-clear">';
				$html .= '<div class="isp-chat-items">';
					$html .= '<form id="isp_edit_form" action="" method="post">
								<div class="isp_search_msg"></div>
							  <div>
								<input type="text" id="isp_edit_search_question" required name="isp_edit_search_question" value="" placeholder="'.__('Type question',MC_TEXT_DOMAIN).'">
							  </div>
							  <div>
								<textarea id="isp_edit_search_answer" value="" required name="isp_edit_search_answer" placeholder="'.__('Type answer',MC_TEXT_DOMAIN).'"></textarea>
							  </div>
							  <div>
									<button class="isp_button" type="submit" data-event="isp_edit_form_button" id="isp_edit_form_button" data-isp-searchid="" name="isp_edit_form_button">'.__('Edit',MC_TEXT_DOMAIN).'</button>
							  </div>
							</form>';
				$html .= '</div>';
				$html .= '<div class="isp-search-items">';
					$html .= '<form id="isp_edit_search_form" method="post" action="">';
					  $html .= '<input type="text" placeholder="Search..." name="isp_edit_search_query" value=""/>';
					  $html .= '<button class="isp_button" type="submit" data-event="isp_edit_search_nav" id="isp_edit_search_button" name="isp_edit_search_nav">Search</button>';
					$html .= '</form>';
					$html .= '<div id="isp_edit_row_container">';
					$html .= $row;
					$html .= '</div>';
					$html .= '<div id="isp_edit_row_footer">';
					if(!empty($result) && count($result) >= 10){
						$html .= '<button class="isp_button" data-event="isp_edit_button_nav" id="isp_edit_nav_back" data-pageid="0" data-direction="back" title="Back">&lsaquo;</button>';
						$html .= '<button class="isp_button" data-event="isp_edit_button_nav" id="isp_edit_nav_next" data-pageid="2" data-direction="next" title="Next">&rsaquo;</button>';
					}
					$html .= '</div>';
				$html .= '</div>';
			$html .= '</div>';
		$html .= '</div>';
    	echo $html;
       	   
    }
	public function isupport_plugin_info(){	 
		$plugin_data = get_plugin_data( BPC_PATH.'isupport.php', false, false );
		$this->plugin_name = $plugin_data['Name'];
		$this->plugin_version = $plugin_data['Version'];
	}
}


?>