<?php

class Activation_Controller {

    public function initialize_activation_hooks() {
        register_activation_hook("isupport/isupport.php", array($this, 'execute_activation_hooks'));
		register_activation_hook("isupport/isupport.php", array($this, 'add_operator_roles'));
		//register_activation_hook("isupport/isupport.php", array($this, 'flush_application_rewrite_rules'));
		//register_deactivation_hook("isupport/isupport.php", array($this, 'execute_deactivation_hooks'));
    }

    public function execute_activation_hooks() {
		
        $database_manager = new isupport_Database_Manager();
		
        $database_manager->create_custom_tables();
		        
    }
	
	public function execute_deactivation_hooks() {
		flush_rewrite_rules();
		// Will be executed when the client deactivates the plugin
    }
	public function add_operator_roles() {
        add_role('operator', 'Operator', array('read' => true));
		$role = get_role('operator');

        $operator_capabilities = array(
            "edit_posts",
            "edit_private_posts",
            "edit_published_posts",
            "publish_posts",
            "read",
            "delete_posts",
        );

        foreach ($operator_capabilities as $capability) {
            $role->add_cap($capability);
        }
		
		// https://wordpress.org/plugins/members/ capability manager

    }
	public function flush_application_rewrite_rules() {
		flush_rewrite_rules();
	}

}

?>