<?php

class Script_Controller{

    public function enque_scripts(){
        add_action('wp_enqueue_scripts', array($this, 'include_scripts_styles'));
		add_action('wp_head', array($this, 'include_custom_styles'));
		add_action('admin_head', array($this, 'include_admin_custom_styles'));
        add_action('admin_enqueue_scripts', array($this, 'include_admin_scripts_styles'));
    }

    /*
     * Include AJAX plugin specific scripts and pass the neccessary data.
     *
     * @param  -
     * @return -
     */

    public function include_scripts_styles(){
        global $post;
		
		$data = get_option('isupport_options');
    	$chatRate = $data['isp_chat_refresh_rate'];
		$full_height = $data['isp_mobile_full_height'];
		//$activation_option = $data['isupport_activation_status'];
		//if($activation_option != false){$activation = 1;}else{$activation = 0;};
		wp_register_script('isupport_client_common', plugins_url('js/isupport-common.js', dirname(__FILE__)), array("jquery"));
        wp_enqueue_script('isupport_client_common');
        wp_register_script('isupport_ajax', plugins_url('js/isupport-ajax.js', dirname(__FILE__)), array("jquery"));
        wp_enqueue_script('isupport_ajax');
		wp_register_script('isupport_admin_scroll', plugins_url('js/ftscroller.js', dirname(__FILE__)), array("jquery"));
        wp_enqueue_script('isupport_admin_scroll');

        $nonce = wp_create_nonce("unique_key");

        $ajax = new isupport_AJAX();
        $ajax->initialize();
		
        $getAvater = get_avatar(get_current_user_id());
		$doc = new DOMDocument();
		$doc->loadHTML($getAvater);
		$xpath = new DOMXPath($doc);
		$src = $xpath->evaluate("string(//img/@src)");
				
        $config_array = array(
            'ajaxURL' => admin_url('admin-ajax.php'),
            'ajaxActions' => $ajax->ajax_actions,
            'ajaxNonce' => $nonce,
            'siteURL' => site_url(),
			'pluginsURL' => plugins_url(),
			'templateURL' => plugins_url('template/', dirname(__FILE__)),
			'chatRate' => $chatRate,
			'fullHeight' => $full_height,
			//'activation' => $activation,fullHeight
        );

        wp_localize_script('isupport_ajax', 'isupport_conf', $config_array);

        wp_register_style('user_styles', plugins_url('css/isupport-style.css', dirname(__FILE__)));
        wp_enqueue_style('user_styles');
		wp_register_style('client_common_styles', plugins_url('css/isupport-common.css', dirname(__FILE__)));
        wp_enqueue_style('client_common_styles');

        //wp_register_style('isupport_theme', plugins_url('css/isupport-theme.css',dirname(__FILE__)));
        //wp_enqueue_style('isupport_theme');

    }

    public function colourchanger($hex, $percent) {
		// Work out if hash given
		$hash = '';
		if (stristr($hex,'#')) {
			$hex = str_replace('#','',$hex);
			$hash = '#';
		}
		/// HEX TO RGB
		$rgb = array(hexdec(substr($hex,0,2)), hexdec(substr($hex,2,2)), hexdec(substr($hex,4,2)));
		for ($i=0; $i<3; $i++) {
			// See if brighter or darker
			if ($percent > 0) {
				// Lighter
				$rgb[$i] = round($rgb[$i] * $percent) + round(255 * (1-$percent));
			} else {
				// Darker
				$positivePercent = $percent - ($percent*2);
				$rgb[$i] = round($rgb[$i] * $positivePercent) + round(0 * (1-$positivePercent));
			}
			// In case rounding up causes us to go to 256
			if ($rgb[$i] > 255) {
				$rgb[$i] = 255;
			}
		}
		//// RBG to Hex
		$hex = '';
		for($i=0; $i < 3; $i++) {
			// Convert the decimal digit to hex
			$hexDigit = dechex($rgb[$i]);
			// Add a leading zero if necessary
			if(strlen($hexDigit) == 1) {
			$hexDigit = "0" . $hexDigit;
			}
			// Append to the hex string
			$hex .= $hexDigit;
		}
		return $hash.$hex;
	}
	//$colour = '#ae64fe';
	//$brightness = 0.5; // lighter
	//$brightness = 0.3; // more lighter
	//$brightness = 0.1; // close to white
	//$newColour = colourchanger($colour,$brightness);
	//$colour = '#ae64fe';
	//$brightness = -0.5; // 50% darker
	//$brightness = -0.3; // more darker
	//$brightness = -0.1; // more darker close to black
	//$newColour = colourchanger($colour,$brightness);
	public function hex2rgba($hex,$opc) {
	   $hex = str_replace("#", "", $hex);
	
	   if(strlen($hex) == 3) {
		  $r = hexdec(substr($hex,0,1).substr($hex,0,1));
		  $g = hexdec(substr($hex,1,1).substr($hex,1,1));
		  $b = hexdec(substr($hex,2,1).substr($hex,2,1));
	   } else {
		  $r = hexdec(substr($hex,0,2));
		  $g = hexdec(substr($hex,2,2));
		  $b = hexdec(substr($hex,4,2));
	   }
	   $rgb = 'rgba('.$r.','.$g.','.$b.','.$opc.')';
	   //return implode(",", $rgb); // returns the rgb values separated by commas
	   return $rgb; // returns an array with the rgb values
	}
	public function include_custom_styles(){
		
		$data = get_option('isupport_options');
		$isupportTitleBg = !empty($data['isp_title_bg_color']) && $data['isp_title_bg_color'] != '#'?'background-color:' .$data['isp_title_bg_color'].';':'';
		$isupportTitleBdr = $isupportTitleBg != ''?'border-bottom:1px solid '.$this->colourchanger($data['isp_title_bg_color'], -0.6).';':'';
		$isupportTitleColor = !empty($data['isp_title_color']) && $data['isp_title_color'] != '#'?'color:' .$data['isp_title_color'].';':'';
		
		$isupportBodyBgc = !empty($data['isp_body_bg_color']) && $data['isp_body_bg_color'] != '#'?'background-color:'.$data['isp_body_bg_color'].';':'';		
		
		$isupportBodyBgp = !empty($data['isp_bg_pattern']) && $data['isp_bg_pattern']!='none'? 'background: url('.BPC_URL . 'images/bg/'.$data['isp_bg_pattern'].'.png) repeat;':'';
		$isupportBodyBgi = !empty($data['isp_bg_image']['src'])? 'background: url('.$data['isp_bg_image']['src'].') no-repeat center center;':'';
		
		if($isupportBodyBgi){
			$isupportBodyBg = $isupportBodyBgi;
		}else if($isupportBodyBgp){
			$isupportBodyBg = $isupportBodyBgp; 
		}else{
			$isupportBodyBg = $isupportBodyBgc;
		}

		$isupportStartChatBg = !empty($data['isp_start_chat_bg_color']) && $data['isp_start_chat_bg_color'] != '#'?'background-color:' .$data['isp_start_chat_bg_color'].';':'';
		
		$isp_placeholder_text = !empty($data['isp_placeholder_text_color']) && $data['isp_placeholder_text_color'] != '#'?'
		#isupportChatWindow input::-webkit-input-placeholder, 
		.isp-admin-wrap input::-webkit-input-placeholder,
		#isupportChatWindow textarea::-webkit-input-placeholder, 
		.isp-admin-wrap textarea::-webkit-input-placeholder {
		   color: '.$data['isp_placeholder_text_color'].';
		}
		#isupportChatWindow input:-moz-placeholder, 
		.isp-admin-wrap input:-moz-placeholder,
		#isupportChatWindow textarea:-moz-placeholder, 
		.isp-admin-wrap textarea:-moz-placeholder{
		   color: '.$data['isp_placeholder_text_color'].';  
		}
		#isupportChatWindow input::-moz-placeholder, 
		.isp-admin-wrap input::-moz-placeholder,
		#isupportChatWindow textarea::-moz-placeholder, 
		.isp-admin-wrap textarea::-moz-placeholder{
		   color: '.$data['isp_placeholder_text_color'].';  
		}
		#isupportChatWindow input:-ms-input-placeholder, 
		.isp-admin-wrap input:-ms-input-placeholder,
		#isupportChatWindow textarea:-ms-input-placeholder, 
		.isp-admin-wrap textarea:-ms-input-placeholder{  
		   color: '.$data['isp_placeholder_text_color'].';  
		}
		':'';
		
		$isp_trans_form_bg = $data['enable_isp_form_trans_bg']?'
		.isupportBody input[type="text"], 
		.isupportBody input[type="password"],
		.isupportFooter textarea,
		.isupportBody textarea,
		#isp_add_search_form input[type="text"],
		#isp_add_search_form textarea,
		#isp_edit_form input[type="text"],
		#isp_edit_form textarea {
		   background-color:transparent;
		}
		':'';
		
		$isupportStartChatBdr = !empty($data['isp_start_chat_bdr_color']) && $data['isp_start_chat_bdr_color'] != '#'?'border-color:' .$data['isp_start_chat_bdr_color'].';':'';
		
		$isupportChatBg = !empty($data['isp_chat_bg_color']) && $data['isp_chat_bg_color'] != '#'?'background-color:' .$data['isp_chat_bg_color'].';':'';
		$isupportChatBdrBottom = $isupportChatBg != ''?'border-bottom-color:' .$this->colourchanger($data['isp_chat_bg_color'], -.6).';':'';
		$isupportChatBdr = !empty($data['isp_chat_border_color']) && $data['isp_chat_border_color'] != '#'?'border: 1px solid ' .$data['isp_chat_border_color'].';':'';
		$isupportChatText = !empty($data['isp_chat_text_color']) && $data['isp_chat_text_color'] != '#'?'color:' .$data['isp_chat_text_color'].';':'';
		
		if($data['enable_isp_chat_bg_opacity'] && !empty($data['isp_chat_bg_color']) && $data['isp_chat_bg_color'] != '#'){
			
			$isupportChatBgc = 'background-color:' .$this->hex2rgba($data['isp_chat_bg_color'], $data['isp_chat_bg_opacity']).';';
			
			$isupportChatTip ='
			.leftMessage:after{border-color:rgba(255, 255, 255,0);border-right-color:'.$this->hex2rgba($data['isp_chat_bg_color'],$data['isp_chat_bg_opacity']-.2).';}
			.leftMessage:before{border-color:rgba(218, 222, 225,0);border-right-color:'.$this->hex2rgba($data['isp_chat_bg_color'],$data['isp_chat_bg_opacity']-.2).';}
			.rightMessage:after{border-color:rgba(255, 255, 255,0);border-left-color:'.$this->hex2rgba($data['isp_chat_bg_color'],$data['isp_chat_bg_opacity']-.2).';}
			.rightMessage:before{border-color:rgba(218, 222, 225,0);border-left-color:'.$this->hex2rgba($data['isp_chat_bg_color'],$data['isp_chat_bg_opacity']-.2).';}
			';
		}else if(!empty($data['isp_chat_bg_color']) && $data['isp_chat_bg_color'] != '#'){
			$isupportChatBgc = 'background-color:' .$data['isp_chat_bg_color'].';';
			
			$isupportChatTip = '
			.leftMessage:after{border-color: rgba(255, 255, 255, 0);border-right-color: '.$data['isp_chat_bg_color'].';}
			.leftMessage:before{border-color: rgba(218, 222, 225, 0);border-right-color: '.$data['isp_chat_bg_color'].';}
			.rightMessage:after{border-color: rgba(255, 255, 255, 0);border-left-color: '.$data['isp_chat_bg_color'].';}
			.rightMessage:before{border-color: rgba(218, 222, 225, 0);border-left-color: '.$data['isp_chat_bg_color'].';}
			';
		}
		$isp_button = !empty($data['isp_button']) && $data['isp_button'] != '#'?"
		.isp_button {
			-moz-box-shadow:inset 0px 1px 0px 0px " .$this->colourchanger($data['isp_button'], .4).";
			-webkit-box-shadow:inset 0px 1px 0px 0px " .$this->colourchanger($data['isp_button'], .4).";
			box-shadow:inset 0px 1px 0px 0px " .$this->colourchanger($data['isp_button'], .4).";
			background:-webkit-gradient(linear, left top, left bottom, color-stop(0.05, " .$data['isp_button']."), color-stop(1, " .$this->colourchanger($data['isp_button'], -.7)."));
			background:-moz-linear-gradient(top, " .$data['isp_button']." 5%, " .$this->colourchanger($data['isp_button'], -.7)." 100%);
			background:-webkit-linear-gradient(top, " .$data['isp_button']." 5%, " .$this->colourchanger($data['isp_button'], -.7)." 100%);
			background:-o-linear-gradient(top, " .$data['isp_button']." 5%, " .$this->colourchanger($data['isp_button'], -.7)." 100%);
			background:-ms-linear-gradient(top, " .$data['isp_button']." 5%, " .$this->colourchanger($data['isp_button'], -.7)." 100%);
			background:linear-gradient(to bottom, " .$data['isp_button']." 5%, " .$this->colourchanger($data['isp_button'], -.7)." 100%);
			filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='" .$data['isp_button']."', endColorstr='" .$this->colourchanger($data['isp_button'], -.7)."',GradientType=0);
			background-color:" .$data['isp_button'].";
			text-shadow: 0px 1px 0px " .$this->colourchanger($data['isp_button'], -.3).";
		}
		.isp_button:hover{
			background:-webkit-gradient(linear, left top, left bottom, color-stop(0.05, " .$this->colourchanger($data['isp_button'], -.7)."), color-stop(1, " .$data['isp_button']."));
			background:-moz-linear-gradient(top, " .$this->colourchanger($data['isp_button'], -.7)." 5%, " .$data['isp_button']." 100%);
			background:-webkit-linear-gradient(top, " .$this->colourchanger($data['isp_button'], -.7)." 5%, " .$data['isp_button']." 100%);
			background:-o-linear-gradient(top, " .$this->colourchanger($data['isp_button'], -.7)." 5%, " .$data['isp_button']." 100%);
			background:-ms-linear-gradient(top, " .$this->colourchanger($data['isp_button'], -.7)." 5%, " .$data['isp_button']." 100%);
			background:linear-gradient(to bottom, " .$this->colourchanger($data['isp_button'], -.7)." 5%, " .$data['isp_button']." 100%);
			filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='" .$this->colourchanger($data['isp_button'], -.7)."', endColorstr='" .$data['isp_button']."',GradientType=0);
			background-color:" .$this->colourchanger($data['isp_button'], -.7).";
		}
		":"";
		$isp_button_text = !empty($data['isp_button_text']) && $data['isp_button_text'] != '#'?"
		button.isp_button {
			color:" .$data['isp_button_text'].";
		}
		":"";
		$isp_mobile_button = !empty($data['isp_mobile_chat_bg_color']) && $data['isp_mobile_chat_bg_color'] != '#'?"
		span.isp_mobile_ChatIcon.isp_chat {
			background: " .$this->hex2rgba($data['isp_mobile_chat_bg_color'], $data['isp_mobile_chat_bg_opacity'])." url(".BPC_URL . "images/isp_chat.png) no-repeat center center;
		}
		span.isp_mobile_ChatIcon.isp_email{
			background: " .$this->hex2rgba($data['isp_mobile_chat_bg_color'], $data['isp_mobile_chat_bg_opacity'])." url(".BPC_URL . "images/isp_email.png) no-repeat center center;
		}
		":"";
		//$isupportBodybgi = $data['isp_chat_bg_pattern']!='none'? ' url('.BPC_URL . 'images/bg/'.$data['isp_chat_bg_pattern'].'.png) repeat':'';
		$fullwidth = '
		@media only screen 
		  and (min-device-width: 320px) 
		  and (max-device-width: 480px)
		  and (-webkit-min-device-pixel-ratio: 2),
		  only screen 
		  and (min-device-width: 320px) 
		  and (max-device-width: 568px)
		  and (-webkit-min-device-pixel-ratio: 2),
		  only screen 
		  and (min-device-width: 375px) 
		  and (max-device-width: 667px) 
		  and (-webkit-min-device-pixel-ratio: 2),
		  only screen 
		  and (min-device-width: 414px) 
		  and (max-device-width: 736px) 
		  and (-webkit-min-device-pixel-ratio: 3),
		  only screen
		  and (max-width: 767px){';
			 if($data['isp_mobile_full_width']){
				$fullwidth .= '#isupportChatWindow {width: 100%;}';
			 }
			 if($data['isp_disable_mobile_chat_icon']){
				$fullwidth .= 'body span.isp_mobile_ChatIcon.isp_chat, body span.isp_mobile_ChatIcon.isp_email{display:block;} 
								#isupportChatWindow {display:none;}';
			 }
			
		$fullwidth .= '}';
		
		echo "<style type=\"text/css\">
			.isupportTitle { ".$isupportTitleBg.$isupportTitleColor.$isupportTitleBdr." } 
			.isupportBodyHolder{".$isupportBodyBg."} 
			.isupportBody #isp_chat_footer input[type=\"text\"]{".$isupportStartChatBg.$isupportStartChatBdr."} 
			.isupportMessage{".$isupportChatBgc.$isupportChatBdrBottom.$isupportChatText.$isupportChatBdr.";} 
			".$isupportChatTip.$fullwidth.$isp_placeholder_text.$isp_button.$isp_trans_form_bg.$isp_button_text.$isp_mobile_button."</style>"; 
    }
	
	public function include_admin_custom_styles(){
		
		$data = get_option('isupport_options');
		$adminTitleBg = !empty($data['isp_adm_title_bg_color']) && $data['isp_adm_title_bg_color'] != '#'?'background-color:' .$data['isp_adm_title_bg_color'].';':'';
		$adminTitleBdr = $adminTitleBg != ''?'border-bottom:1px solid '.$this->colourchanger($data['isp_adm_title_bg_color'], -0.6).';':'';
		$adminTitleText = !empty($data['isp_adm_title_color']) && $data['isp_adm_title_color'] != '#'?'color:' .$data['isp_adm_title_color'].';':'';
		
		$adminTabBg = !empty($data['isp_adm_tab_bg_color']) && $data['isp_adm_tab_bg_color'] != '#'?'background-color:' .$data['isp_adm_tab_bg_color'].';':'';
		$adminTabRowBg = !empty($data['isp_adm_tab_row_color']) && $data['isp_adm_tab_row_color'] != '#'?'background-color:' .$data['isp_adm_tab_row_color'].';':'';
		$adminTabRowActive = !empty($data['isp_adm_tab_row_color_active']) && $data['isp_adm_tab_row_color_active'] != '#'?'background-color:' .$data['isp_adm_tab_row_color_active'].';':'';
		
		$adminTabBdr = !empty($data['isp_adm_tab_bdr_color']) && $data['isp_adm_tab_bdr_color'] != '#'?'border-bottom:1px solid '.$data['isp_adm_tab_bdr_color'].';':'';
		
		$adminTabColor = !empty($data['isp_adm_tab_text_color']) && $data['isp_adm_tab_text_color'] != '#'?'color:' .$data['isp_adm_tab_text_color'].';':'';
		$adminTabColorActive = !empty($data['isp_adm_tab_text_color_active']) && $data['isp_adm_tab_text_color_active'] != '#'?'color:' .$data['isp_adm_tab_text_color_active'].';':'';
		
		$adminBodyBgc = !empty($data['isp_adm_body_bg_color']) && $data['isp_adm_body_bg_color'] != '#'?'background-color:'.$data['isp_adm_body_bg_color'].';':'';		
						
		$adminBodyBgp = !empty($data['isp_adm_bg_pattern']) && $data['isp_adm_bg_pattern']!='none'? 'background: url('.BPC_URL . 'images/bg/'.$data['isp_adm_bg_pattern'].'.png) repeat;':'';
		$adminBodyBgi = !empty($data['isp_adm_bg_image']['src'])? 'background: url('.$data['isp_adm_bg_image']['src'].') no-repeat center center;':'';
		
		if($adminBodyBgi){
			$adminBodyBg = $adminBodyBgi;
		}else if($adminBodyBgp){
			$adminBodyBg = $adminBodyBgp; 
		}else{
			$adminBodyBg = $adminBodyBgc;
		}
		
		$adminStartChatBg = !empty($data['isp_adm_start_chat_bg_color']) && $data['isp_adm_start_chat_bg_color'] != '#'?'background-color:' .$data['isp_adm_start_chat_bg_color'].';':'';
		
		$isp_placeholder_text = !empty($data['isp_placeholder_text_color']) && $data['isp_placeholder_text_color'] != '#'?'
		#isupportChatWindow input::-webkit-input-placeholder, 
		.isp-admin-wrap input::-webkit-input-placeholder,
		#isupportChatWindow textarea::-webkit-input-placeholder, 
		.isp-admin-wrap textarea::-webkit-input-placeholder {
		   color: '.$data['isp_placeholder_text_color'].';
		}
		#isupportChatWindow input:-moz-placeholder, 
		.isp-admin-wrap input:-moz-placeholder,
		#isupportChatWindow textarea:-moz-placeholder, 
		.isp-admin-wrap textarea:-moz-placeholder{
		   color: '.$data['isp_placeholder_text_color'].';  
		}
		#isupportChatWindow input::-moz-placeholder, 
		.isp-admin-wrap input::-moz-placeholder,
		#isupportChatWindow textarea::-moz-placeholder, 
		.isp-admin-wrap textarea::-moz-placeholder{
		   color: '.$data['isp_placeholder_text_color'].';  
		}
		#isupportChatWindow input:-ms-input-placeholder, 
		.isp-admin-wrap input:-ms-input-placeholder,
		#isupportChatWindow textarea:-ms-input-placeholder, 
		.isp-admin-wrap textarea:-ms-input-placeholder{  
		   color: '.$data['isp_placeholder_text_color'].';  
		}
		':'';
		
		$isp_trans_form_bg = $data['enable_isp_form_trans_bg']?'
		.isupportBody input[type="text"], 
		.isupportBody input[type="password"],
		.isupportFooter textarea,
		.isupportBody textarea,
		#isp_add_search_form input[type="text"],
		#isp_add_search_form textarea,
		#isp_edit_form input[type="text"],
		#isp_edit_form textarea {
		   background-color:transparent;
		}
		':'';
		
		$isp_button = !empty($data['isp_button']) && $data['isp_button'] != '#'?"
		.isp_button {
			-moz-box-shadow:inset 0px 1px 0px 0px " .$this->colourchanger($data['isp_button'], .4).";
			-webkit-box-shadow:inset 0px 1px 0px 0px " .$this->colourchanger($data['isp_button'], .4).";
			box-shadow:inset 0px 1px 0px 0px " .$this->colourchanger($data['isp_button'], .4).";
			background:-webkit-gradient(linear, left top, left bottom, color-stop(0.05, " .$data['isp_button']."), color-stop(1, " .$this->colourchanger($data['isp_button'], -.7)."));
			background:-moz-linear-gradient(top, " .$data['isp_button']." 5%, " .$this->colourchanger($data['isp_button'], -.7)." 100%);
			background:-webkit-linear-gradient(top, " .$data['isp_button']." 5%, " .$this->colourchanger($data['isp_button'], -.7)." 100%);
			background:-o-linear-gradient(top, " .$data['isp_button']." 5%, " .$this->colourchanger($data['isp_button'], -.7)." 100%);
			background:-ms-linear-gradient(top, " .$data['isp_button']." 5%, " .$this->colourchanger($data['isp_button'], -.7)." 100%);
			background:linear-gradient(to bottom, " .$data['isp_button']." 5%, " .$this->colourchanger($data['isp_button'], -.7)." 100%);
			filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='" .$data['isp_button']."', endColorstr='" .$this->colourchanger($data['isp_button'], -.7)."',GradientType=0);
			background-color:" .$data['isp_button'].";
			text-shadow: 0px 1px 0px " .$this->colourchanger($data['isp_button'], -.3).";
		}
		.isp_button:hover{
			background:-webkit-gradient(linear, left top, left bottom, color-stop(0.05, " .$this->colourchanger($data['isp_button'], -.7)."), color-stop(1, " .$data['isp_button']."));
			background:-moz-linear-gradient(top, " .$this->colourchanger($data['isp_button'], -.7)." 5%, " .$data['isp_button']." 100%);
			background:-webkit-linear-gradient(top, " .$this->colourchanger($data['isp_button'], -.7)." 5%, " .$data['isp_button']." 100%);
			background:-o-linear-gradient(top, " .$this->colourchanger($data['isp_button'], -.7)." 5%, " .$data['isp_button']." 100%);
			background:-ms-linear-gradient(top, " .$this->colourchanger($data['isp_button'], -.7)." 5%, " .$data['isp_button']." 100%);
			background:linear-gradient(to bottom, " .$this->colourchanger($data['isp_button'], -.7)." 5%, " .$data['isp_button']." 100%);
			filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='" .$this->colourchanger($data['isp_button'], -.7)."', endColorstr='" .$data['isp_button']."',GradientType=0);
			background-color:" .$this->colourchanger($data['isp_button'], -.7).";
		}
		":"";
		$isp_button_text = !empty($data['isp_button_text']) && $data['isp_button_text'] != '#'?"
		button.isp_button {
			color:" .$data['isp_button_text'].";
		}
		":"";
		$adminStartChatBdr = !empty($data['isp_adm_start_chat_bdr_color']) && $data['isp_adm_start_chat_bdr_color'] != '#'?'border-color:' .$data['isp_adm_start_chat_bdr_color'].';':'';
		
		$adminChatBg = !empty($data['isp_adm_chat_bg_color']) && $data['isp_adm_chat_bg_color'] != '#'?'background-color:' .$data['isp_adm_chat_bg_color'].';':'';
		$adminChatBdrBottom = $adminChatBg != ''?'border-bottom-color:' .$this->colourchanger($data['isp_adm_chat_bg_color'], -.6).';':'';
		$adminChatBdr = !empty($data['isp_adm_chat_border_color']) && $data['isp_adm_chat_border_color'] != '#'?'border: 1px solid ' .$data['isp_adm_chat_border_color'].';':'';
		$adminChatText = !empty($data['isp_adm_chat_text_color']) && $data['isp_adm_chat_text_color'] != '#'?'color:' .$data['isp_adm_chat_text_color'].';':'';
		
		if($data['enable_isp_adm_chat_bg_opacity'] && !empty($data['isp_adm_chat_bg_color']) && $data['isp_adm_chat_bg_color'] != '#'){
			
			$adminChatBgc = 'background-color:' .$this->hex2rgba($data['isp_adm_chat_bg_color'], $data['isp_adm_chat_bg_opacity']).';';
			
			$adminChatTip ='
			.leftMessage:after{border-color:rgba(255, 255, 255,0);border-right-color:'.$this->hex2rgba($data['isp_adm_chat_bg_color'],$data['isp_adm_chat_bg_opacity']-.2).';}
			.leftMessage:before{border-color:rgba(218, 222, 225,0);border-right-color:'.$this->hex2rgba($data['isp_adm_chat_bg_color'],$data['isp_adm_chat_bg_opacity']-.2).';}
			.rightMessage:after{border-color:rgba(255, 255, 255,0);border-left-color:'.$this->hex2rgba($data['isp_adm_chat_bg_color'],$data['isp_adm_chat_bg_opacity']-.2).';}
			.rightMessage:before{border-color:rgba(218, 222, 225,0);border-left-color:'.$this->hex2rgba($data['isp_adm_chat_bg_color'],$data['isp_adm_chat_bg_opacity']-.2).';}
			';
		}else if(!empty($data['isp_adm_chat_bg_color']) && $data['isp_adm_chat_bg_color'] != '#'){
			$adminChatBgc = 'background-color:' .$data['isp_adm_chat_bg_color'].';';
			
			$adminChatTip = '
			.leftMessage:after{border-color: rgba(255, 255, 255, 0);border-right-color: '.$data['isp_adm_chat_bg_color'].';}
			.leftMessage:before{border-color: rgba(218, 222, 225, 0);border-right-color: '.$data['isp_adm_chat_bg_color'].';}
			.rightMessage:after{border-color: rgba(255, 255, 255, 0);border-left-color: '.$data['isp_adm_chat_bg_color'].';}
			.rightMessage:before{border-color: rgba(218, 222, 225, 0);border-left-color: '.$data['isp_adm_chat_bg_color'].';}
			';
		}		
		$adminTabBdrFirst = !empty($data['isp_adm_tab_bdr_color']) && $data['isp_adm_tab_bdr_color'] != '#'?'border-top:1px solid '.$data['isp_adm_tab_bdr_color']:'';
		$adminBodyTextColor = !empty($data['isp_adm_body_text_color']) && $data['isp_adm_body_text_color'] != '#'?'color:'.$data['isp_adm_body_text_color']:'';
		echo "<style type=\"text/css\">
			.isp-admin-head { ".$adminTitleBg.$adminTitleText.$adminTitleBdr." } 
			#isp-tabs-wrap{".$adminTabBg."} 
			#isp-chat-tabs li{".$adminTabRowBg.$adminTabColor.$adminTabBdr."}
			#isp-chat-tabs li:first-child{".$adminTabBdrFirst."}
			#isp-chat-tabs li.isp-current, #isp-chat-tabs li:hover{".$adminTabRowActive.$adminTabColorActive."}
			##isp-content-wrap{".$adminBodyTextColor."}
			.isp-admin-body{".$adminBodyBg."} 
			.isupportFooter textarea{".$adminStartChatBg.$adminStartChatBdr."} 
			.isupportMessage{".$adminChatBgc.$adminChatBdrBottom.$adminChatText.$adminChatBdr.";} 
			".$adminChatTip.$isp_placeholder_text.$isp_button.$isp_trans_form_bg.$isp_button_text."</style>"; 
    }
	
    public function include_admin_scripts_styles(){
		wp_register_script('isupport_common', plugins_url('js/isupport-common.js', dirname(__FILE__)), array("jquery"));
        wp_enqueue_script('isupport_common');
		wp_register_script('isupport_admin', plugins_url('js/isupport-admin.js', dirname(__FILE__)), array("jquery"));
        wp_enqueue_script('isupport_admin');
		//wp_register_script('isupport_admin_scroll', plugins_url('js/ftscroller.js', dirname(__FILE__)), array("jquery"));
        //wp_enqueue_script('isupport_admin_scroll');

        $nonce = wp_create_nonce("unique_key");

        $admin = new isupport_Admin_AJAX();
        $admin->initialize();
		
		$data = get_option('isupport_options');
    	$chatRate = $data['isp_chat_refresh_rate'];
		
        $getAvater = get_avatar(get_current_user_id());
		$doc = new DOMDocument();
		$doc->loadHTML($getAvater);
		$xpath = new DOMXPath($doc);
		$src = $xpath->evaluate("string(//img/@src)");
				
        $config_array = array(
            'ajaxURL' => admin_url('admin-ajax.php'),
            'ajaxActions' => $admin->ajax_actions,
            'ajaxNonce' => $nonce,
            'siteURL' => site_url(),
			'pluginsURL' => plugins_url(),
			'templateURL' => plugins_url('template/', dirname(__FILE__)),
			'avatar' => $src,
			'chatRate' => $chatRate
        );

        wp_localize_script('isupport_admin', 'isupport_admin_conf', $config_array);
		
        wp_register_style( 'isupport_admin_css', plugins_url('css/isupport-admin.css', dirname(__FILE__)));
        wp_enqueue_style( 'isupport_admin_css' );
		wp_register_style( 'admin_common_styles', plugins_url('css/isupport-common.css', dirname(__FILE__)));
        wp_enqueue_style( 'admin_common_styles' );
    }


}

?>