<?php

	/*		
		Plugin Name: iSupport PersianScript.ir
		Plugin URI: http://isupport.mircode.com
		Description: Intelligent wordpress sales and support chat plugin. This plugin can save all the common question, answer and auto suggest the customer care manager for faster support.   
		Version: 1.0.3
		Author: PersianScript
		Author URI: http://persianScript.ir
		License: GPLv2
	*/
// min wp-version 3.4

if(session_id() == '') {
	session_start();
}
	
if( !defined('BPC_PATH') )
	define( 'BPC_PATH', plugin_dir_path(__FILE__) );
if( !defined('BPC_URL') )
	define( 'BPC_URL', plugin_dir_url(__FILE__ ) );
//with trailing slash
if( !defined('MC_TEXT_DOMAIN') )
	define( 'MC_TEXT_DOMAIN', 'isupport' );
	
function isupport_text_domain(){
	load_plugin_textdomain(MC_TEXT_DOMAIN, false, dirname(plugin_basename(__FILE__)) . '/languages/') ;
}
add_action('init', 'isupport_text_domain');
add_action( 'wp_footer', 'isp_sound_function');
add_action( 'admin_footer', 'isp_sound_function');
require_once 'ajax/class-isupport-ajax.php';
require_once 'ajax/class-isupport-admin-ajax.php';
require_once 'controllers/class-isupport-database-manager.php';
require_once 'admin/class-isupport-options.php';

class isupport_Apps {
	
	 public function __construct() {
		 add_action( 'init', array( $this, 'load_isupport_admin') );
    }
	
    public function initialize_controllers() {

        require_once 'controllers/class-isupport-activation-controller.php';
        $activation_controller = new Activation_Controller();
        $activation_controller->initialize_activation_hooks();
		
		require_once 'controllers/class-isupport-schedule-controller.php';
        $schedule_controller = new Schedule_Controller();
    }

    public function initialize_app_controllers() {

		require_once 'controllers/class-isupport-script-controller.php';
        $script_controller = new Script_Controller();
        $script_controller->enque_scripts();

        $ajax = new isupport_Ajax();
        $ajax->initialize();
		
		$admin = new isupport_Admin_Ajax();
        $admin->initialize();

    }
	
	public function load_isupport_admin(){
		require_once 'controllers/class-admin-area-controller.php';
		$admin_init = new isp_Admin_Area_Controller();
	}
	

}

$isupport_app = new isupport_Apps();
$isupport_app->initialize_controllers();

function load_isupport(){
	$isupport_init = new isupport_Apps();
	$isupport_init->initialize_app_controllers();
	
//$test = new isupport_Admin_Ajax();
//var_dump ($test->isp_add_search_content_function());
//$test1 = new Script_Controller();
//var_dump ($test1->include_custom_styles());
//$data = get_option('isupport_options');
//var_dump( $data['isp_bg_image']['src']);
//exit;
}

add_action('init', 'load_isupport');

function isp_sound_function() {
	$sound = '';
	$sound .= '<audio id="isupport_alert" controls loop="loop">';
	$sound .= '<source src="' . plugins_url() . '/isupport/images/alert.ogg" type="audio/ogg">';
	$sound .= '<source src="' . plugins_url() . '/isupport/images/alert.mp3" type="audio/mpeg">';
	$sound .= '</audio>';
	echo $sound;
}

?>