;(function ($) {
	$(document).ready(function () {
		var AdminStoredChat = [];
		var ChatIdStored = [];
		var NotifyUserID = [];
		var ChatCached = "";
		var RequestState1 = true;
		var RequestState2 = true;
		var notifyInterval, showNotifyInterval, friendListRefresh;
		var tabsNo = [], oldMsgsNo = {}, newMsgsNo = {}, newMessageInterval;
		
		Array.prototype.remove = function(value){
			if (this.indexOf(value)!== -1) {
				this.splice(this.indexOf(value), 1);
				return true;
			} else {
				return false;
			};
		}
		
		var AdminChat = {
			
			isupportInit: function () {
				var self = $(this);
				this.eventHandler();
				this.loadChatRow();
				this.submitMessage();
				this.initializeActiveChats();
				this.notificationAtTitle();	
			},
			initTabs: function () {
				$('ul#isp-chat-tabs').find('li').each(function(i) {
					$(this).on("click", function (event){
						$(this).addClass('isp-current').siblings().removeClass('isp-current');
						$('div#isp-content-wrap').find('div.isp-chat-box').eq($(this).index()).fadeIn(150).siblings('div.isp-chat-box').hide();
					});
				});
			},
			eventHandler: function () {
				$("body").on("click", "[data-event]", function (event){
					event.preventDefault();				
					var Event = $(this).attr("data-event");
					switch(Event) {						
						case "close-client-window":
							var ClientID = $(this).attr("data-clientid");
							var confirmmsg = 'Are you sure you want to close chat with this client?';
							if(confirm(confirmmsg)){
								AdminChat.closeClientWindow(ClientID);
							}
						break;
																		
						case "open-register":
							$(".isp_login_wrap").slideUp("slow");
							$(".open-register").slideUp("slow");
							$(".open-log-in").slideDown("slow");
							$(".isp_register_wrap").slideDown("slow");							
						break;
						case "open-log-in":
							$(".isp_register_wrap").slideUp("slow");
							$(".open-log-in").slideUp("slow");
							$(".open-register").slideDown("slow");
							$(".isp_login_wrap").slideDown("slow");			
						break;
						
						case "register-user":
							AdminChat.registerNewUser();
						break;
						
						case "isp_add_search":
							AdminChat.addSearchContent();
						break;
						
						case "isp_edit_form_button":
							var editrowid = $(this).attr("data-isp-searchid");
							if(editrowid){
								$(".isp_search_msg").html('');
								AdminChat.editSearchContent(editrowid);
							}else{
								$(".isp_search_msg").html('<p class="isp_error">Please select edit item only from right side list.</p>');
							}
						break;
						
						case "isp_search_query":
							AdminChat.fetchSearchContent($(this).attr("data-clientid"));
						break;
						
						case "send-to-chat-form":
							var tid = $(this).attr("data-titleid");
							var cid = $(this).attr("data-clientid");
							var content = $("#descid_"+tid).html();
							$("#isp_reply_to_client_"+cid).val(content).focus();
							
							//AdminChat.sendToChatSection();
						break;
						
						case "isp_edit_search_nav":
							AdminChat.fetchEditSearchContent();
						break;
						
						case "isp_edit_button_nav":
							if($(this).attr("data-direction") == 'next'){
								AdminChat.fetchEditNavContent($(this).attr("data-direction"), $(this).attr("data-pageid"));
							}else{
								if($(this).attr("data-direction") == 'back' && parseInt($(this).attr("data-pageid")) > 0){
									AdminChat.fetchEditNavContent($(this).attr("data-direction"), $(this).attr("data-pageid"));
								}else{
									alert("You are in the first page.");
								}
								
							}
						break;
						
						case "dashboard-client-tabs":
							$(this).addClass('isp-current').siblings().removeClass('isp-current');
							$('div#isp-content-wrap').find('div.isp-chat-box').eq($(this).index()).fadeIn(150).siblings('div.isp-chat-box').hide();
							if($(this).hasClass('isp_client_on')){
								$(this).removeClass('isp_client_on').addClass('isp_client_off');
							}
							
						break;
						
						case "expand-isp-edit-desc":
							var titleid = $(this).parent().attr('data-titleid');
							var state = $('#descid_'+titleid).attr('data-desc-state');
							
							if(state == "0"){
								$(this).html("<span>&and;</span>");
								$('#descid_'+titleid).slideDown(200);
								$('#descid_'+titleid).attr("data-desc-state", "1")
							}else{
								$(this).html("<span>&or;</span>");
								$('#descid_'+titleid).slideUp(200);
								$('#descid_'+titleid).attr("data-desc-state", "0")
							}
						break;
						case "send-to-edit-form":
							var title_id = $(this).parent().attr('data-titleid');
							var title = $(this).html();
							var desc = $("#descid_"+title_id).html();
							$("#isp_edit_search_question").val(title);
							$("#isp_edit_search_answer").html(desc);
							$("#isp_edit_form_button").attr("data-isp-searchid",title_id);
						break;
						case "isp-delete-chat-row":	
							var rowid = $(this).parent().attr('data-titleid');
							var loading = '<i class="isp_spinnerx16 isp_delete"></i>';
							var alert_msg = 'Do you really want to delete this from database?';
							if(confirm(alert_msg)){
								AdminChat.DeleteSearchRow(rowid);
							}
						break;	
						case "isp_transfer_operator":
							var c_id = $(this).attr('data-clientid');
							var c_name = $(this).attr('data-clientname');
							var o_id = $('#isp_selected_operator_'+c_id).val();
							var o_name = $('#isp_selected_operator_'+c_id+' option:selected').text();
							AdminChat.transferChatOperator(c_id, o_id, c_name, o_name);
						break;	
						
						case "transferred-help-request":
							var t_cid = $(this).attr('data-clientid');
							var t_id = $(this).parent().parent().attr('data-chatid');
							AdminChat.fetchTransferredClientMsg(t_cid, t_id);
						break;
						
						case "isp-sq-select":
							var ClientID = $(this).attr('data-clientid');
							var clicked = $(this);
							var Container = $("[data-location=\"isupport-body-" + ClientID + "\"]");
							$(Container).find('.isp_select_sq').each(function() {
								if($(this).not(clicked).hasClass('isp_selected_sq')){
									$(this).removeClass('isp_selected_sq');
								}
							});
							if($(this).hasClass('isp_selected_sq')){
								$(this).removeClass('isp_selected_sq');
							}else{
								$(this).addClass('isp_selected_sq');
							}
							
						break;		
					}
				});
			},
			
			closeClientWindow: function(clientid){
				var ClientID = clientid;
				$("#isp-chat-tabs [data-isp-tabid=\"" + ClientID + "\"]").remove();
				$("#client-window-id-" + ClientID ).remove();
				
				if($("#isp-chat-tabs li:nth-child(2)").length > 0){
					$("#isp-chat-tabs li:nth-child(2)").addClass('isp-current').siblings().removeClass('isp-current');
					$('div#isp-content-wrap').find('div.isp-chat-box').eq($("#isp-chat-tabs li:nth-child(2)").index()).fadeIn(150).siblings('div.isp-chat-box').hide();
					
				}else{
					$("#isp-chat-tabs li:nth-child(1)").addClass('isp-current').siblings().removeClass('isp-current');
					$('div#isp-content-wrap').find('div.isp-chat-box').eq($("#isp-chat-tabs li:nth-child(1)").index()).fadeIn(150).siblings('div.isp-chat-box').hide();
				}
				
				AdminStoredChat.remove(ClientID);
										
				$.ajax({
					url: isupport_admin_conf.ajaxURL,						
					type: "POST",
					dataType: "JSON",
					data: { 
						rm_clientid: ClientID, 
						action : isupport_admin_conf.ajaxActions.isp_remove_admin_active_chat.action,
						nonce : isupport_admin_conf.ajaxNonce
					 },
					success: function(data) { }
				});
			},
			
			DeleteSearchRow: function(rowid){
				var dbutton = $("#docid_"+rowid+" button.isp-delete-chat-row");
				dbutton.append('<i class="isp_spinnerx16 isp_delete"></i>');
				$(dbutton).prop('disabled', true);
				$.ajax({
					url: isupport_admin_conf.ajaxURL,						
					type: "POST",
					dataType: "JSON",
					data: { 
						search_rowid: rowid, 
						action : isupport_admin_conf.ajaxActions.isp_delete_search_row.action,
						nonce : isupport_admin_conf.ajaxNonce
					 },
					success: function(data) { 
						if(data.is_delete == "0"){
							alert("Database Error: Please try again.");
							$("#docid_"+data.delete_id+" button.isp-delete-chat-row i").remove();
							$("#docid_"+rowid+" button.isp-delete-chat-row").prop('disabled', false);
						}else{
							$("#docid_"+data.delete_id).remove();
							$("#docid_"+rowid+" button.isp-delete-chat-row").prop('disabled', false);
							if($("#isp_edit_search").attr("data-isp-searchid") == data.delete_id){
								$("#isp_edit_form input").val('');
								$("#isp_edit_form textarea").html('');
								$("#isp_edit_search").attr("data-isp-searchid", "")
							}
						}
					},
					complete: function() { 
						
					}
				});
			},
			setActiveChat: function(ClientID, ClientName, ClientEmail, avatar){
				$.ajax({
					url: isupport_admin_conf.ajaxURL,						
					type: "POST",
					dataType: "JSON",
					data: { 
						ac_clientid: ClientID, 
						ac_clientname: ClientName,
						ac_clientemail: ClientEmail, 
						ac_avatar: avatar,
						action : isupport_admin_conf.ajaxActions.isp_set_admin_active_chat.action,
						nonce : isupport_admin_conf.ajaxNonce
					 },
					success: function(data) { },
					complete: function() { }
				});
			},
			
			loadChatRow: function () {
				if(RequestState1 == true) {
					RequestState1 = false;
					
					$.ajax({
						url: isupport_admin_conf.ajaxURL,						
						type: "POST",
						dataType: "JSON",
						data: { 
							action : isupport_admin_conf.ajaxActions.isp_load_admin_chat.action,
							nonce : isupport_admin_conf.ajaxNonce
						 },
						success: function (data){
							var clientdata = data.isp_clientinfo;
							var chatdata = data.isp_chatinfo;
							var searchdata = data.isp_searchinfo;
							
							jQuery.each(clientdata, function(i, object) {
								var ClientID = i;
								var ClientName = object.clientname;
								var ClientEmail = object.clientemail;
								var ClientUserName = object.clientusername;
								var avatar = object.avatar;
								if($("#client-window-id-"+ClientID).length > 0){
									//Do nothing
								}else{
									AdminChat.createChatWindow(ClientID, ClientName, ClientEmail, avatar);
								}
							});
							jQuery.each(chatdata, function(i, object) {
								var chatID = i;								
								var senderID = object.senderid;
								var receiverID = object.receiverid;
								var message = object.message;
								var chatTime = object.chat_time;
								
								var Container = $("[data-location=\"isupport-body-" + senderID + "\"]");
																
								var ChatContent = '<div class="isp_client_message_row isp_message_row isp-clear"><div class="isupportMessage leftMessage"><div data-chatid="'+chatID+'" class="isupportContent isupportMessageLocation-'+senderID+'"><span class="isp_msg_span">'+message+'</span><span data-event="isp-sq-select" data-clientid="'+senderID+'" class="isp_select_sq">&nbsp;</span></div></div></div>';
								$(Container).append(ChatContent);
								
								$(Container).scrollTop($(Container).prop("scrollHeight"));
							});
							
							jQuery.each(searchdata, function(i, object) {
								var SearchContent = '';
								var clientID = i;
								var msgID = object.chatid;
								var docID = object.docid;
								var docTitle = object.doctitle;
								var docDesc = object.docdesc;
								
								SearchContent += '<div class="isp_auto_chat_div" id="docid_'+docID+'">';
									SearchContent += '<div class="isp-clear" data-titleid="'+docID+'">';
									SearchContent += '<b class="isp_auto_title" data-clientid="'+clientID+'" data-titleid="'+docID+'" data-event="send-to-chat-form">'+docTitle+'</b>';
									SearchContent += '<button class="expand-isp-edit-desc" data-event="expand-isp-edit-desc"><span>&or;</span></button>';
									SearchContent += '</div>';
									SearchContent += '<div class="isp_edit_desc" id="descid_'+docID+'" data-desc-state="0">';
									SearchContent += docDesc;
									SearchContent += '</div>';
								SearchContent += '</div>';
								$("#isupportSearchBody_"+clientID).prepend(SearchContent);
							});								
						},
						complete: function() {
							setTimeout(AdminChat.loadChatRow, isupport_admin_conf.chatRate);
							RequestState1 = true;
							
						}
					});
				}
			},

			createChatWindow: function (ClientID, ClientName, ClientEmail, avatar){
								
				var operator = '';
				
				$("#isp_select_operator_id li").each(function(index, element) {
                    var opid = $(this).attr('data-operatorid');
					var opname = $(this).attr('data-operatorname');
					operator +='<option value="'+opid+'">'+opname+'</option>';
                });
				
				var chatWindow = '', clientTab = '';
					chatWindow += '<div id="client-window-id-'+ClientID+'" data-clientname="'+ClientName+'" class="isupportWindow isp-chat-box">';
						chatWindow += '<div class="clientHeader isp-clear" data-parameter-window-id="'+ClientID+'">';
							chatWindow += '<div class="isupportUser">';
								chatWindow += '<div class="isupportUserName">';
									chatWindow += '<div class="isp_image clientImage"><img src="'+avatar+'" /></div>';
									chatWindow += '<span>'+ClientName+'</span>';
								chatWindow += '</div>';
								chatWindow += '<div class="isupportOperatorList" id="isupportOperatorList_'+ClientID+'">';
									chatWindow += '<form class="isp_operator_list_form" method="post" action="">';
									chatWindow += '<select name="isp_selected_operator_id" id="isp_selected_operator_'+ClientID+'">';
									chatWindow += operator;
									chatWindow += '</select>';
									chatWindow += '<button class="isp_button" id="isp_transfer_operator_'+ClientID+'" type="submit" data-event="isp_transfer_operator" data-clientid="'+ClientID+'" data-clientname="'+ClientName+'" name="isp_transfer_button">Transfer</button>';
					
									chatWindow += '</form>';
								chatWindow += '</div>';
								chatWindow += '<div class="isupportSearchHead">';
									chatWindow += '<form id="isp_search_form_'+ClientID+'" method="post" action="">';
									 chatWindow += '<div>';
									  chatWindow += '<input type="text" id="isp_search_query_'+ClientID+'" placeholder="Search..." name="isp_search_query" value=""/>';
									  chatWindow += '<button class="isp_button" id="isp_search_button_'+ClientID+'" type="submit" data-event="isp_search_query" data-clientid="'+ClientID+'" name="isp_search_button">Search</button>';
									 chatWindow += '</div>';
									chatWindow += '</form>';
								chatWindow += '</div>';
								chatWindow += '<i title="Close" data-event="close-client-window" data-clientid="'+ClientID+'" class="isp_close">&times;</i>';
							chatWindow += '</div>';
						chatWindow += '</div>';
						chatWindow += '<div class="isp-chat-items">';
							chatWindow += '<div class="isupportChatBody" data-location="isupport-body-'+ClientID+'">';
							chatWindow += '</div>';
							chatWindow += '<div class="isupportFooter">';
								chatWindow += '<textarea id="isp_reply_to_client_'+ClientID+'" data-event="reply-to-client" placeholder="Start chat" data-clientid="'+ClientID+'" ></textarea>';
							chatWindow += '</div>';
						chatWindow += '</div>';
						chatWindow += '<div class="isp-search-items">';
							chatWindow += '<div class="isupportSearchBody" id="isupportSearchBody_'+ClientID+'" data-clientid="'+ClientID+'">';
							chatWindow += '</div>';
						chatWindow += '</div>';
					chatWindow += '</div>';
					
					clientTab += '<li data-event="dashboard-client-tabs" class="isp_client_on" data-isp-tabid="'+ClientID+'">'+ClientName+'</li>';
				
				if($('#client-window-id-'+ClientID).length > 0){
					// do nothing
				}else{
					$("#isp-content-wrap").append(chatWindow);
					$("#isp-chat-tabs").append(clientTab);
					
					if($.inArray(ClientID, AdminStoredChat) == -1) {
						AdminStoredChat.push(ClientID);
						AdminChat.setActiveChat(ClientID, ClientName, ClientEmail, avatar);
					}
				}
				
			},
			
			submitMessage: function () {
				$("body").on("keyup", "[data-event=\"reply-to-client\"]", function (e) {
					if(e.keyCode == 13) {
						var d = new Date();
						var n = d.getTime();
						var Message = $.trim($(this).val());
						var ClientID = $(this).attr("data-clientid");
						
						var Container = $("[data-location=\"isupport-body-" + ClientID + "\"]");
						var msg = '<div class="isp_admin_message_row isp_message_row isp-clear"><div class="isupportMessage rightMessage"><div class="isupportContent">'+Message+'</div></div></div>';
						
						if($(Container).find('.isp_selected_sq').length > 0){
							var question = $(Container).find('.isp_selected_sq').siblings('span').html();
						}else{
							var question = '';
						}
						
						if(Message.length > 0) {
							$(Container).append(msg);
							$(Container).scrollTop($(Container).prop("scrollHeight"));
							$.ajax({
								url: isupport_admin_conf.ajaxURL,						
								type: "POST",
								dataType: "JSON",
								data: { 
									messagecontent: Message, 
									clientid: ClientID,
									question: question,
									action : isupport_admin_conf.ajaxActions.isp_admin_submit_message.action,
									nonce : isupport_admin_conf.ajaxNonce
								 },
								success: function(data) {
									//AdminChat.loadChatRow();
									
								},
								complete: function(){
									$(Container).find('.isp_select_sq').each(function() {
										if($(this).hasClass('isp_selected_sq')){
											$(this).removeClass('isp_selected_sq');
										}
									});
								}
							});
						}
						$(this).val("");
					}
				});
			},
			
			transferChatOperator: function (cid, oid, c_name, o_name) {
				var Message = '<a href="" data-clientid="'+cid+'" data-event="transferred-help-request">'+c_name+'</a> needs your help. Please help this client.';;
				$('#isp_transfer_operator_'+cid).append('<i class="isp_spinnerx16 isp_btn_spin"></i>');
				$('#isp_transfer_operator_'+cid).prop('disabled', true);
				$.ajax({
					url: isupport_admin_conf.ajaxURL,						
					type: "POST",
					dataType: "JSON",
					data: { 
						isp_message: Message, 
						isp_clientid: cid,
						isp_operatorid: oid, 
						action : isupport_admin_conf.ajaxActions.isp_admin_chat_transfer.action,
						nonce : isupport_admin_conf.ajaxNonce
					 },
					success: function(data) {
						if(data.isp_submit){
							var ClientID = data.isp_clientid;
							AdminChat.closeClientWindow(ClientID);
							ISP_BOX.box.show({html:'Operator transferred successfully!',animate:false,close:false,mask:true,boxid:'isp_box_success',autohide:4, height: 'auto'})
						}else{
							//alert("Chat transfer failed. Please try again.");
							ISP_BOX.box.show({html:'Chat transfer failed. Please try again.',animate:false,close:false,mask:true,boxid:'isp_box_error',autohide:4, height: 'auto'})
						}	
						$('#isp_transfer_operator_'+data.isp_clientid+' i').remove();
						$('#isp_transfer_operator_'+data.isp_clientid).prop('disabled', false);					
					},
					complete: function(){
						
					}
				});
			},
			
			fetchTransferredClientMsg: function (t_cid, t_id) {
				var tid = $('[data-chatid="' + t_id + '"]');
				$(tid).prepend('<i class="isp_spinnerx16 isp_left_spin"></i>');
				$.ajax({
					url: isupport_admin_conf.ajaxURL,						
					type: "POST",
					dataType: "JSON",
					data: { 
						isp_clientid: t_cid,
						isp_chatid: t_id, 
						action : isupport_admin_conf.ajaxActions.isp_fetch_transferred_client_msg.action,
						nonce : isupport_admin_conf.ajaxNonce
					 },
					success: function(data) {
						var t_id = data.isp_chatid;
						var t_mrow = data.isp_msg_row;
						if(data.is_result == "1"){
							$.each(t_mrow, function(i, object) {
								var chatID = i;								
								var senderID = object.senderid;
								var receiverID = object.receiverid;
								var message = object.message;
								var chatTime = object.chat_time;
								
								var Container = $("[data-location=\"isupport-body-" + senderID + "\"]");
																
								var ChatContent = '<div class="isp_client_message_row isp_message_row isp-clear"><div class="isupportMessage leftMessage"><div  data-chatid="'+chatID+'" class="isupportContent isupportMessageLocation-'+senderID+'"><span class="isp_msg_span">'+message+'</span><span data-event="isp-sq-select" data-clientid="'+senderID+'" class="isp_select_sq">&nbsp;</span></div></div></div>';
								
								$(Container).append(ChatContent);
								$(Container).scrollTop($(Container).prop("scrollHeight"));
							});
						}else{
							ISP_BOX.box.show({html:'No Result found.',animate:false,close:false,mask:true,boxid:'isp_box_error',autohide:4, height: 'auto'})
						}
						$('[data-chatid="' + t_id + '"]').find('i').remove();
					},
					complete: function(){
						
					}
				});
			},
			
			addSearchContent: function(){
				$('#isp_add_search').append('<i class="isp_spinnerx16 isp_btn_spin"></i>');
				$('#isp_add_search').prop('disabled', true);
				var error = false,
					isp_question = $('#isp_search_question').val(),
					isp_answer = $('#isp_search_answer').val();
				if(!isp_question){
					$('#isp_search_question').css('border-color','#ff0000');
					error = true;
				}
				if(!isp_answer){
					$('#isp_search_answer').css('border-color','#ff0000');
					error = true;
				}
				if(!error){
					$(".isp_search_msg").html('<div class="isupportBodyLoading"></div>');
					$.ajax({
						url: isupport_admin_conf.ajaxURL,
						type: "POST",
						dataType: "JSON",
						data:{
							action : isupport_admin_conf.ajaxActions.isp_add_search_content.action,
							nonce : isupport_admin_conf.ajaxNonce,
							isp_search_question : isp_question,
							isp_search_answer : isp_answer
						},
						success: function(data) {
							if(data.is_search_added == "1"){
								//ISP_BOX.box.show({html:'Content added successfully',animate:false,close:false,mask:true,boxid:'isp_box_success',autohide:4, height: 'auto'})
								$(".isp_search_msg").html('<p class="isp_success">Content added successfully</p>');
								$('#isp_search_question').val(''),
								$('#isp_search_answer').val('');
							}else{
								//ISP_BOX.box.show({html:'Database error: Please try again.',animate:false,close:false,mask:true,boxid:'isp_box_error',autohide:4, height: 'auto'})
								$(".isp_search_msg").html('<p class="isp_error">Database error: Please try again.</p>');
							}
						},
						complete: function() {
							$('#isp_add_search i').remove();
							$('#isp_add_search').prop('disabled', false);
						}
					});
				}else{
					$('#isp_add_search i').remove();
					$('#isp_add_search').prop('disabled', false);
				}
			},
			
			editSearchContent: function(editrowid){
				$('#isp_edit_form_button').append('<i class="isp_spinnerx16 isp_btn_spin"></i>');
				$('#isp_edit_form_button').prop('disabled', true);
				var error = false,
					question = $('#isp_edit_search_question').val(),
					answer = $('#isp_edit_search_answer').html();
				
				if(!question){
					$('#isp_edit_search_question').css('border-color','#ff0000');
					error = true;
				}
				if(!answer){
					$('#isp_edit_search_answer').css('border-color','#ff0000');
					error = true;
				}
				
				if(!error){
					$.ajax({
						url: isupport_admin_conf.ajaxURL,
						type: "POST",
						dataType: "JSON",
						data:{
							action : isupport_admin_conf.ajaxActions.isp_edit_search_content.action,
							nonce : isupport_admin_conf.ajaxNonce,
							isp_edit_search_question : question,
							isp_edit_search_answer : answer,
							isp_edit_doc_id : editrowid,
							isp_edit_search : true,
						},
						success: function(data) {
							if(data.is_search_updated == "1"){
								$(".isp_search_msg").html('<p class="isp_success">Content edited successfully</p>');
								var newr = '';
								newr += '<li id="docid_'+data.new_row_id+'">';
									newr += '<div class="isp-clear" data-titleid="'+data.new_row_id+'">';
									newr += '<b class="isp_edit_title" data-event="send-to-edit-form">'+$('#isp_edit_search_question').val()+'</b>';
									newr += '<button class="isp-delete-chat-row" data-event="isp-delete-chat-row"><span>&times;</span></button>';
									newr += '<button class="expand-isp-edit-desc" data-event="expand-isp-edit-desc"><span>&or;</span></button>';
									newr += '</div>';
									newr += '<div class="isp_edit_desc" id="descid_'+data.new_row_id+'" data-desc-state="0">';
									newr += $('#isp_edit_search_answer').html();
									newr += '</div>';
								newr += '</li>';
								$('#isp_edit_chat_row').prepend(newr);
								$('#docid_'+data.old_row_id).remove();
								$('#isp_edit_search_question').val('');
								$('#isp_edit_search_answer').val('');
								$('#isp_edit_form_button').attr("data-isp-searchid", '');
							}else{
								$(".isp_search_msg").html('<p class="isp_error">Database error: Please try again.</p>');
							}
						},
						complete: function() {
							$('#isp_edit_form_button i').remove();
							$('#isp_edit_form_button').prop('disabled', false);
						}
					});
				}else{
					$('#isp_edit_form_button i').remove();
					$('#isp_edit_form_button').prop('disabled', false);
				}
			},
			
			fetchSearchContent: function(cid){
				var search_value = $("#isp_search_form_"+cid+" input[type=text]").val();
				var ClientID = cid;
				
				if(search_value) {
					$('#isp_search_button_'+cid).append('<i class="isp_spinnerx16 isp_btn_spin"></i>');
					$('#isp_search_button_'+cid).prop('disabled', true);
					$.ajax({
						url: isupport_admin_conf.ajaxURL,						
						type: "POST",
						dataType: "JSON",
						data: { 
							isp_search_query: search_value, 
							isp_search_id: ClientID,
							action : isupport_admin_conf.ajaxActions.isp_search_content.action,
							nonce : isupport_admin_conf.ajaxNonce
						 },
						success: function(data) {
							//AdminChat.loadChatRow();
							var search_body = $('#isupportSearchBody_'+data.isp_search_id);
							if(data.is_search_found == "1"){
								//search_body.append(data.isp_mispelled_data);
								search_body.append(data.total_search_result);
								search_body.append(data.isp_search_data);
							}else{
								search_body.html("No match found");
							}
							$("#isp_search_form_"+cid+" input[type=text]").val('');
							$('#isp_search_button_'+data.isp_search_id).prop('disabled', false);
							$('#isp_search_button_'+data.isp_search_id+' i').remove();
						}
					});
				}
			},
			
			fetchEditSearchContent: function(){
				var search_value = $("#isp_edit_search_form input[type=text]").val();
				
				if(search_value) {
					$('#isp_edit_search_button').append('<i class="isp_spinnerx16 isp_btn_spin"></i>');
					$('#isp_edit_search_button').prop('disabled', true);
					$.ajax({
						url: isupport_admin_conf.ajaxURL,						
						type: "POST",
						dataType: "JSON",
						data: { 
							isp_edit_nav_query: search_value, 
							action : isupport_admin_conf.ajaxActions.isp_edit_search_nav.action,
							nonce : isupport_admin_conf.ajaxNonce
						 },
						success: function(data) {
							//AdminChat.loadChatRow();
							var search_body = $('#isp_edit_row_container');
							if(data.is_search_found == "1"){
								//search_body.append(data.isp_mispelled_data);
								//search_body.html(data.total_search_result);
								search_body.html(data.isp_search_data);
							}else{
								search_body.html("No match found");
							}
							$('#isp_edit_row_footer').html('');
							$("#isp_edit_search_form input[type=text]").val('');
							$('#isp_edit_search_button').prop('disabled', false);
							$('#isp_edit_search_button i').remove();
						}
					});
				}
			},
			
			fetchEditNavContent: function(direction, page_id){
				
				$('#isp_edit_nav_'+direction).append('<i class="isp_spinnerx16 isp_btn_spin"></i>');
				$('#isp_edit_nav_'+direction).prop('disabled', true);
				$.ajax({
					url: isupport_admin_conf.ajaxURL,						
					type: "POST",
					dataType: "JSON",
					data: { 
						isp_edit_nav_dir: direction, 
						isp_edit_page_id: page_id,
						action : isupport_admin_conf.ajaxActions.isp_edit_nav_button.action,
						nonce : isupport_admin_conf.ajaxNonce
					 },
					success: function(data) {
						//AdminChat.loadChatRow();
						var search_body = $('#isp_edit_row_container');
						if(data.is_row_found == "1"){
							//search_body.append(data.isp_mispelled_data);
							//search_body.html(data.total_search_result);
							search_body.html(data.isp_nav_data);
							var nid = $('#isp_edit_nav_next').attr('data-pageid');
							var bid = $('#isp_edit_nav_back').attr('data-pageid');
							
							if(data.isp_direction == 'next'){
								$('#isp_edit_nav_next').attr('data-pageid', (parseInt(nid)+1));
								$('#isp_edit_nav_back').attr('data-pageid', (parseInt(bid)+1));
							}else{
								if(parseInt(bid) > 0){
									$('#isp_edit_nav_next').attr('data-pageid', (parseInt(nid)-1));
									$('#isp_edit_nav_back').attr('data-pageid', (parseInt(bid)-1));
								}
							}
							
						}else{
							search_body.html("No match found");
							$('#isp_edit_row_footer').html('');
						}
						$('#isp_edit_nav_'+data.isp_direction).prop('disabled', false);
						$('#isp_edit_nav_'+data.isp_direction+' i').remove();
					}
				});
			},
						
			initializeActiveChats: function () {
				$.ajax({
					url: isupport_admin_conf.ajaxURL,						
					type: "POST",
					dataType: "JSON",
					data: { 
						action : isupport_admin_conf.ajaxActions.isp_load_admin_active_chat.action,
						nonce : isupport_admin_conf.ajaxNonce
					 },
					success: function(data) {
						var clientdata = data.AdminStoredChat;
						$.each(clientdata, function(i, object) {
							var ClientID = clientdata[i].WINDOWID;
							var ClientName = clientdata[i].USERNAME;
							var ClientEmail = clientdata[i].CLIENTEMAIL;
							var avatar = clientdata[i].AVATAR;
							
							AdminChat.createChatWindow(ClientID, ClientName, ClientEmail, avatar);
							
							$.ajax({
								url: isupport_admin_conf.ajaxURL,						
								type: "POST",
								dataType: "JSON",
								data: { 
									senderID: ClientID,
									action : isupport_admin_conf.ajaxActions.isp_load_all_admin_chat.action,
									nonce : isupport_admin_conf.ajaxNonce
								 },
								success: function(data) {
									var clientdata = data.allmessages;
									$.each(clientdata, function(i, object) {
										var ClientID = i;
										var chatContent = object;
										var Container = $("[data-location=\"isupport-body-" + i + "\"]");
										$(Container).prepend(chatContent);
										$(Container).scrollTop($(Container).prop("scrollHeight"));
									});
									
								}
								
							});
						});
					}
				});
			},
						
			notificationAtTitle : function(){
				var timer=0, newtitle = [], oldtitle = document.title;
				newtitle.push(oldtitle);
				var vis = (function(){
					var stateKey, eventKey, keys = {
						hidden: "visibilitychange",
						webkitHidden: "webkitvisibilitychange",
						mozHidden: "mozvisibilitychange",
						msHidden: "msvisibilitychange"
					};
					for (stateKey in keys) {
						if (stateKey in document) {
							eventKey = keys[stateKey];
							break;
						}
					}
					return function(c) {
						if (c) document.addEventListener(eventKey, c);
						return !document[stateKey];
					}
				})();
				vis(function(){
					var boxname = [], chatno = {};
					var audioplayer = document.getElementById("isupport_alert");
					$(".isupportWindow").each(function(i, element) {
						var id = $(this).attr('id');
						chatno[id] = $(this).find('.isp_message_row').length;
					});
					
					if(!vis()){
						notifyInterval = setInterval(function(){ 
							var nchatno = {}, ntitle;							
							$(".isupportWindow").each(function(i, element) {
								var nid = $(this).attr('id'),
									ntitle =  'New message from '+$(this).attr('data-clientname');
									
								nchatno[nid] = $(this).find('.isp_message_row').length;
								
								if(nchatno[nid] > chatno[nid] && $.inArray(ntitle, newtitle) == -1){
									newtitle.push(ntitle);
								}
							});
						}, 2000);
						
						showNotifyInterval = setInterval(function(){ 
							if(newtitle.length > 1){
								document.title = newtitle[timer];
								timer++
								if (timer >= newtitle.length){
									timer=0;
								}
								audioplayer.play();
							}
						}, 3000);
						
					}else{
						clearInterval(notifyInterval);
						clearInterval(showNotifyInterval);
						document.title = oldtitle;
						newtitle = [];
						newtitle.push(oldtitle);
						audioplayer.pause();
					}
					
				});
				
				newMessageInterval  = setInterval(function(){ 
					$("#isp-chat-tabs li:not(:first)").each(function(){
						var cid = $(this).attr('data-isp-tabid');
						newMsgsNo[cid] = $("[data-location=\"isupport-body-" + cid + "\"]").children().length;
						
						if(newMsgsNo[cid] > oldMsgsNo[cid] ){
							if(!$(this).hasClass('isp-current') && $(this).hasClass('isp_client_off')){
								$(this).removeClass('isp_client_off').addClass('isp_client_on');
							}
							
						}
						oldMsgsNo[cid] = $("[data-location=\"isupport-body-" + cid + "\"]").children().length;
					})
					
				}, 3500);
			}
			
		}
		
		AdminChat.isupportInit();
		
	});
}(jQuery));

