;(function ($) {
	$(document).ready(function () {
		var ClientChatStored = [];
		var ChatIdStored = [];
		var NotifyUserID = [];
		var ChatCached = "";
		var RequestState1 = true;
		var RequestState2 = true;
		var notifyInterval, showNotifyInterval, friendListRefresh;
		
		Array.prototype.remove = function(value){
			if (this.indexOf(value)!== -1) {
				this.splice(this.indexOf(value), 1);
				return true;
			} else {
				return false;
			}
		}
		
		var AjaxChat = {
			
			isupportInit: function () {
				var self = $(this);
				this.LoadChatWindow();
				this.eventHandler();
				// chat will load after client submit the first chat
				this.submitMessage();
				this.initializeActiveChats();
				this.notificationAtTitle();	
				this.resizewindow();
			},
						
			registerNewUser: function () {
				var error = false,
					userName = $('#isp_signup_username').val(),
					fullName = $('#isp_signup_fullname').val(),
					email = $('#isp_signup_email').val(),
					pass = $('#isp_signup_password').val(),
					confirmPass = $('#isp_signup_password_confirm').val();
				
				if(!userName){
					$('#isp_signup_username').css('border-color','#ff0000');
					error = true;
				}
				if(!fullName){
					$('#isp_signup_fullname').css('border-color','#ff0000');
					error = true;
				}
				if(!email){
					$('#isp_signup_email').css('border-color','#ff0000');
					error = true;
				}
				if(!pass){
					$('#isp_signup_password').css('border-color','#ff0000');
					error = true;
				}
				if(!confirmPass){
					$('#isp_signup_password_confirm').css('border-color','#ff0000');
					error = true;
				}
				if(!error){
					$('#isp_signup_submit').append('<i class="isp_spinnerx16 isp_btn_spin"></i>');
					$('#isp_signup_submit').prop('disabled', true);
					$.ajax({
						url: isupport_conf.ajaxURL,
						type: "POST",
						dataType: "JSON",
						data:{
							action : isupport_conf.ajaxActions.isp_register_user.action,
							nonce : isupport_conf.ajaxNonce,
							isp_signup_username : userName,
							isp_signup_email : email,
							isp_signup_fullname : fullName,
							isp_signup_password : pass,
							isp_signup_password_confirm : confirmPass
						},
						success: function(data) {
							var msg = data.isp_message;
							if(data.error == false){
								$("#isp_register_form").each(function(){
									$(this).find(':input').val('');
								});
								ISP_BOX.box.show({html:msg,animate:false,close:false,mask:true,boxid:'isp_box_success', autohide:10, height: 'auto'})
							}else{
								ISP_BOX.box.show({html:msg,animate:false,close:false,mask:true,boxid:'isp_box_error', autohide:10, height: 'auto'})
							}
							$('#isp_signup_submit i').remove();
							$('#isp_signup_submit').prop('disabled', false);
						},
						complete: function() {
						}
					});
				}
			},
			
			offlineMessage: function () {
				var error = false,
					subject = $('#isp_message_subject').val(),
					message = $('#isp_message').val();
				
				if(!subject){
					$('#isp_message_subject').css('border-color','#ff0000');
					error = true;
				}
				if(!message){
					$('#isp_message').css('border-color','#ff0000');
					error = true;
				}
				if(!error){
					$('#isp_message_submit').append('<i class="isp_spinnerx16 isp_btn_spin"></i>');
					$('#isp_message_submit').prop('disabled', true);
					$.ajax({
						url: isupport_conf.ajaxURL,
						type: "POST",
						dataType: "JSON",
						data:{
							action : isupport_conf.ajaxActions.isp_offline_message.action,
							nonce : isupport_conf.ajaxNonce,
							isp_message_subject : subject,
							isp_message : message
						},
						success: function(data) {
							var msg = data.isp_msg;
							if(data.error == false){
								$('#isp_message_subject').val(''),
								$('#isp_message').val('');
								ISP_BOX.box.show({html:msg,animate:false,close:false,mask:true,boxid:'isp_box_success',autohide:10, height: 'auto'})
							}else{
								ISP_BOX.box.show({html:msg,animate:false,close:false,mask:true,boxid:'isp_box_error',autohide:10, height: 'auto'})
							}	
							$('#isp_message_submit i').remove();
							$('#isp_message_submit').prop('disabled', false);
						},
						complete: function() {
							
						}
					});
				}
			},
			
			LoadChatWindow: function () {
				$.ajax({
					url: isupport_conf.ajaxURL,
					type: "POST",
					dataType: "JSON",
					data: { 
						action : isupport_conf.ajaxActions.isp_load_isp_window.action,
						nonce : isupport_conf.ajaxNonce
					 },
					success: function(data) {
						var data = data.isp_window;
						$("body").append(data);
					},
					complete: function() {
						//AjaxChat.loadFriends();
						
					}
				});
				
			},
						
			eventHandler: function () {
				$("body").on("click", "[data-event]", function (event){
					event.preventDefault();				
					var Event = $(this).attr("data-event");
					
					switch(Event) {						
						case "close-chat-window":
							var WindowId = $(this).attr("data-parameter-window-id");
							$("[data-identifier=\"" + WindowId + "\"]").fadeOut(function () {
								$(this).css("display","none");
							});	
							ClientChatStored.remove(WindowId);						
							$.ajax({
								url: isupport_conf.ajaxURL,						
								type: "POST",
								dataType: "JSON",
								data: { 
									cw_clientid: WindowId, 
									action : isupport_conf.ajaxActions.isp_remove_active_chat.action,
									nonce : isupport_conf.ajaxNonce
								 },
								success: function(data) { }
							});
						break;
												
						case "open-chat-window":
							var holder = $(".isupportBodyHolder").attr("data-window-state");
							if(holder=="0"){
								$(".isupportBodyHolder").slideDown("slow");
								$(".listOpenIcon").html("&or;");
								$(".isupportBodyHolder").attr("data-window-state", "1");
							}else{
								$(".isupportBodyHolder").slideUp("slow");
								$(".listOpenIcon").html("&and;");
								$(".isupportBodyHolder").attr("data-window-state", "0");
							}
							
						break;
						
						case "open-mobile-chat-window":
							var holder = $("#isupportChatWindow").attr("data-window-state");
							if(holder=="0"){
								$("#isupportChatWindow").slideDown("slow");
								$("#isupportChatWindow").attr("data-window-state", "1");
							}else{
								$("#isupportChatWindow").slideUp("slow");
								$("#isupportChatWindow").attr("data-window-state", "0");
							}
							
						break;
						
						case "open-register":
							$(".isp_login_wrap").slideUp("slow");
							$(".open-register").slideUp("slow");
							$(".open-log-in").slideDown("slow");
							$(".isp_register_wrap").slideDown("slow");							
						break;
						case "open-log-in":
							$(".isp_register_wrap").slideUp("slow");
							$(".open-log-in").slideUp("slow");
							$(".open-register").slideDown("slow");
							$(".isp_login_wrap").slideDown("slow");			
						break;
						
						case "register-user":
							AjaxChat.registerNewUser();
						break;
						
						case "offline-message":
							AjaxChat.offlineMessage();
						break;
						
						case "online_friends":
							AjaxChat.loadFriendsOnline();
							
						break;
						
					}
				});
			},
			
			setActiveChat: function(ClientID){
				$.ajax({
					url: isupport_conf.ajaxURL,						
					type: "POST",
					dataType: "JSON",
					data: { 
						cw_clientid: ClientID, 
						action : isupport_conf.ajaxActions.isp_set_active_chat.action,
						nonce : isupport_conf.ajaxNonce
					 },
					success: function(data) { },
					complete: function() {
						RequestState5 = true;
					}
				});
			},
			
			loadChatRow: function () {
				if(RequestState1 == true) {
					RequestState1 = false;
					$.ajax({
						url: isupport_conf.ajaxURL,						
						type: "POST",
						dataType: "JSON",
						data: { 
							action : isupport_conf.ajaxActions.isp_load_client_chat.action,
							nonce : isupport_conf.ajaxNonce
						 },
						success: function (data){
							var chatdata = data.isp_client_chat;
							jQuery.each(chatdata, function(i, object) {
								var chatID = i;																
								var operatorID = object.operatorid;
								var operatorName = object.operatorname;
								var clientID = object.clientid;
								var message = object.message;
								var chatTime = object.chat_time;
								var avatar = object.avatar;
								
								var Container = $("#isp_chat_body");
								
								var ScrollTop = $(Container).scrollTop();
								var CurrentHeight = $(Container).prop("scrollHeight");
								
								var chatContent = '<div class="isp_admin_message_row isp_message_row isp-clear" data-operatorname="'+operatorName+'" data-operatorid="'+operatorID+'"><div class="isp_image leftImage"><img src="'+avatar+'" /></div><div class="isupportMessage leftMessage"><div data-isp-chatid="'+chatID+'" class="isupportContent">'+message+'</div></div></div>';
								$(Container).append(chatContent);
								var NewHeight = $(Container).prop("scrollHeight");
								var Difference = NewHeight - CurrentHeight;
								$(Container).scrollTop($(Container).prop("scrollHeight"));
							});
						},
						complete: function() {
							setTimeout(AjaxChat.loadChatRow, isupport_conf.chatRate);
							RequestState1 = true;
						}
					});
				}
			},

			submitMessage: function () {
				$("body").on("keyup", "[data-event=\"submit-client-chat\"]", function (e) {
					if(e.keyCode == 13) {
						var userImage = isupport_conf.avatar;
						var d = new Date();
						var n = d.getTime();
						var Message = $.trim($(this).val());
						var ClientID = $(this).attr("data-clientid");
						var operatorID = 'none';
						
						var Container = $("#isp_chat_body");
						if($("#isp_chat_body div.isp_admin_message_row").length > 0){
							operatorID = $("#isp_chat_body div.isp_admin_message_row:last").attr("data-operatorid");
						}
						
						var msg = '<div class="isp_client_message_row isp_message_row isp-clear"><div class="isupportMessage rightMessage"><div class="isupportContent">'+Message+'</div></div></div>';
						
						if(Message.length > 0) {
							$(Container).append(msg);
							$(Container).scrollTop($(Container).prop("scrollHeight"));
							$.ajax({
								url: isupport_conf.ajaxURL,						
								type: "POST",
								dataType: "JSON",
								data: { 
									messageContent: Message, 
									receiverUserId: operatorID,
									action : isupport_conf.ajaxActions.isp_submit_client_message.action,
									nonce : isupport_conf.ajaxNonce
								 },
								success: function(data) {
									if(data.is_submit == 1 && $(".isp_admin_message_row").length == 0){
										$("#isp_chat_body").append('<div class="isp_admin_message_row isp_message_row isp-hide" data-operatorid="'+data.operator_id+'">&nbsp;</div>');
									}
									if(RequestState1 == true && data.is_submit == 1){
										if($.inArray(ClientID, ClientChatStored) == -1){
											ClientChatStored.push(ClientID);
											AjaxChat.setActiveChat(ClientID);
										}
										AjaxChat.loadChatRow();
									}
								}
							});
						}
						$(this).val("");
					}
				});
			},
			
			initializeActiveChats: function () {
				$.ajax({
					url: isupport_conf.ajaxURL,						
					type: "POST",
					dataType: "JSON",
					data: { 
						action : isupport_conf.ajaxActions.isp_load_active_chat.action,
						nonce : isupport_conf.ajaxNonce
					 },
					success: function(data) {
						var data = data.ClientChatStored;
						$.each(data, function(i, object) {
							var ClientID = data[i].WINDOWID;
							
							$.ajax({
								url: isupport_conf.ajaxURL,						
								type: "POST",
								dataType: "JSON",
								data: { 
									cc_clientid: ClientID,
									action : isupport_conf.ajaxActions.isp_load_allchat.action,
									nonce : isupport_conf.ajaxNonce
								 },
								success: function(data) {
									var data = data.allmessages;
									$.each(data, function(i, object) {
										var WindowId = i;
										var chatContent = object;
										var Container = $("#isp_chat_body");
																				
										$(Container).prepend(chatContent);
										$(Container).scrollTop($(Container).prop("scrollHeight"));
									});
								}
								
							});
						});
					}
				});
			},
						
			notificationAtTitle : function(){
				var timer=0, newtitle = [], oldtitle = document.title;
				newtitle.push(oldtitle);
				var vis = (function(){
					var stateKey, eventKey, keys = {
						hidden: "visibilitychange",
						webkitHidden: "webkitvisibilitychange",
						mozHidden: "mozvisibilitychange",
						msHidden: "msvisibilitychange"
					};
					for (stateKey in keys) {
						if (stateKey in document) {
							eventKey = keys[stateKey];
							break;
						}
					}
					return function(c) {
						if (c) document.addEventListener(eventKey, c);
						return !document[stateKey];
					}
				})();
				vis(function(){
					var boxname = [], chatno = {};
					var audioplayer = document.getElementById("isupport_alert");
					var id = $("#isp_chat_body").attr('data-clientid');
					chatno[id] = $("#isp_chat_body").find('.isp_message_row').length;
					
					if(!vis()){
						notifyInterval = setInterval(function(){ 
							var nchatno = {}, ntitle;							
							var nid = $("#isp_chat_body").attr('data-clientid'),
								ntitle =  'New message from '+$("#isp_chat_body").find('.isp_admin_message_row:last-child').attr('data-operatorname');
								
							nchatno[nid] = $("#isp_chat_body").find('.isp_message_row').length;
							
							if(nchatno[nid] > chatno[nid] && $.inArray(ntitle, newtitle) == -1){
								newtitle.push(ntitle);
							}
						}, 2000);
						
						showNotifyInterval = setInterval(function(){ 
							if(newtitle.length > 1){
								document.title = newtitle[timer];
								timer++
								if (timer >= newtitle.length){
									timer=0;
								}
								audioplayer.play();
							}
						}, 3000);
						
					}else{
						clearInterval(notifyInterval);
						clearInterval(showNotifyInterval);
						document.title = oldtitle;
						newtitle = [];
						newtitle.push(oldtitle);
						audioplayer.pause();
					}
					
				});
				
			},
			
			resizewindow: function(){
				if(isupport_conf.fullHeight && $(window).width() < 768){
					$(window).resize(function(e) {
                        $('#isupportChatWindow').css('height',$(window).height()+'px');
						$('#isp_chat_body').css('height',$(window).height()-68.5+'px');
                    });
				}
			}
		}
		
		AjaxChat.isupportInit();
		
	});
}(jQuery));
