<?php
function jobbin_template_job_listing($args) {
	$colors = array('fulltime' => '#999933', 'parttime' => '#3399FF', 'freelance' => '#CC6600', 'internship' => '#660033', 'apprenticeship' => '#660033', 'workingfromhome' => '#CCCCCC');
	$labels = array('fulltime' => __('Full Time', 'jobbin'), 'parttime' => __('Part Time', 'jobbin'), 'freelance' => __('Freelance', 'jobbin'), 'internship' => __('Internship', 'jobbin'), 'apprenticeship' => __('Apprenticeship', 'jobbin'), 'workingfromhome' => __('Working from home', 'jobbin'));
	extract($args);

	$jobbin_options = get_option('jobbin_options');
	?>
	<form method="get" action="<?php echo get_option('home');?>">
		<div>
			<small>Enter a keyword and search our jobs database.</small>
		</div>
		<div>
			<input type="hidden" value="<?php echo esc_attr($jobbin_options['post_id']);?>" name="page_id" />
			<input type="text" name="search" id="search" />
			<input type="submit" value="Find a job" id="jobsearchsubmit" />
		</div>
	</form>
	<?php
	foreach($jobs as $_job) :?>
		<h3><?php echo esc_attr($_job['label']);?></h3>
		<?php if(empty($_job['listing'])) : continue; endif;?>
		<table class="jobs-table" summary="jobs table">
			<?php foreach($_job['listing'] as $i => $job) :?>
				<?php if($i % 2) : // table striping ?>
					<tr>
				<?php else : // table striping ?>
					<tr>
				<?php endif;?>
					<td><div class="tag" style="background-color: <?php echo $colors[$job['type']];?>"><?php echo esc_attr($labels[$job['type']]);?></div></td>
					<td class="center"><small><?php echo esc_attr(date($date_format, strtotime($job['posted']) + $gmt_offset));?></small></td>
					<td>
						<?php echo sprintf(__('%1$s at %2$s', 'jobbin'), '<a href="'.jobbin_get_permalink('job_id='.esc_attr($job['id'])).'">'.esc_attr($job['title']).'</a>', '<a href="'.esc_attr($job['company_url']).'">'.esc_attr($job['company_name']).'</a>');?>
						<span class="gray"><small>(<?php echo esc_attr($job['location']);?>)</small></span><br />
						<small>REF ID# <?php echo $job['id'];?> | <a href="<?php echo jobbin_get_permalink('job_id='.esc_attr($job['id']));?>">View details and apply</a></small>
					</td>
				</tr>
			<?php endforeach;?>
		</table>
	<?php endforeach;?>

	<?php
	if(!isset($_GET['search'])) {
		if(strpos($_SERVER['REQUEST_URI'], '?'))
			echo '<p><small><a href="'.$_SERVER['REQUEST_URI'].'&amp;jobfeed=rss2"><img src="'.JOBBIN_PLUGIN_URL.'/images/icon-rss-mini.png" alt="RSS" title="RSS" /></a></small></p>';
		else
			echo '<p><small><a href="'.$_SERVER['REQUEST_URI'].'?jobfeed=rss2">RSS</a></small></p>';
	}

	if($enable_frontend && $enable_guests) :?>
		<?php if(isset($cat_ID)) :?>
			<p><a href="<?php echo jobbin_get_permalink('action=postjob&amp;cat_ID='.esc_attr($cat_ID));?>"><?php echo esc_attr($invite);?></a></p>
		<?php else :?>
			<p><a href="<?php echo jobbin_get_permalink('action=postjob');?>"><?php echo esc_attr($invite);?></a></p>
		<?php endif;?>
	<?php endif;?>

	<?php
	$jobbin_options = get_option('jobbin_options');

	$categories = jobbin_get_all_categories();
	$out = '<strong>More categories:</strong> ';
	foreach($categories as $cat) {
		$out .= '<a href="'.jobbin_get_permalink('cat='.esc_attr($cat['id'])).'">'.esc_attr($cat['name']).'</a>, ';
	}
	$out .= '<a href="'.jobbin_get_permalink().'">All jobs</a>';
	echo $out;
	?>

<?php
}
function jobbin_template_view_job($args) {
	$labels = array('fulltime' => __('Full Time', 'jobbin'), 'parttime' => __('Part Time', 'jobbin'), 'freelance' => __('Freelance', 'jobbin'), 'internship' => __('Internship', 'jobbin'), 'apprenticeship' => __('Apprenticeship', 'jobbin'), 'workingfromhome' => __('Working from home', 'jobbin'));
	extract($args);
	?>
	<p>&laquo; <a href="<?php echo jobbin_get_permalink();?>">Back to all jobs</a></p>
	<h2><?php echo esc_attr($job['title']);?> <small>at <a href="<?php echo esc_attr($job['company_url']);?>"><?php echo $job['company_name'];?></a></small></h2>
	<p>
		<?php echo $job['location'];?><br />
		<small><?php echo esc_attr($job['company_url']);?></small>
	</p>
	<p><strong><?php _e('Job description', 'jobbin');?>:</strong> <?php echo $job['description'];?></p>
	<p><strong><?php _e('How to apply', 'jobbin');?>:</strong> <?php echo $job['how_to_apply'];?></p>
	<h2><?php _e('Apply now!', 'jobbin');?></h2>
	<?php
	$form_action = $_SERVER['REQUEST_URI'];//get_permalink();

	if(isset($_POST['send'])) {
		$contact 		= (isset($_POST['contact'])) ? trim(strip_tags($_POST['contact'])) : null;
		$email 			= (isset($_POST['email'])) ? trim(strip_tags($_POST['email'])) : null;
		$contactnumber 	= (isset($_POST['contactnumber'])) ? trim(strip_tags($_POST['contactnumber'])) : null;
		$message 		= (isset($_POST['message'])) ? trim(strip_tags($_POST['message'])) : null;

		require_once ABSPATH.WPINC.'/class-phpmailer.php';
		$mail_to_send = new PHPMailer();

		$mail_to_send->FromName = $contact;
		$mail_to_send->From     = $email;
		$mail_to_send->Subject  = 'Jobbin | New job application!';
		$mail_to_send->Body     = '<p><strong>Application details:</strong></p><p>In reference to job ID# '.$jobid.'</p><p>Notes: '.$message.'</p><p>'.$contactnumber.' (phone: '.$contactnumber.' | email: '.$email.')</p>';

		$mail_to_send->isHTML(true);

		$mail_to_send->AddReplyTo($email);
		$mail_to_send->AddAddress($job['contact_email']); //contact form destination e-mail

		if(!$mail_to_send->Send()) wp_die('Error: unable to send e-mail - status code: ' . $mail_to_send->ErrorInfo);
		echo '<div class="jconfirm">Your job application has been successfully sent!</div>';
	}
	?>
	<div id="commentform">
		<form action="<?php echo $_SERVER['REQUEST_URI'];?>" method="post">
			<p>
				<input type="text" name="contact" id="contact" size="22" /> <label for="contact">Contact name (required)</label><br />
				<input type="text" name="email" id="email" size="22" /> <label for="email">Contact e-mail</label><br />
				<input type="text" name="contactnumber" id="contactnumber" size="22" /> <label for="contactnumber">Contact phone number</label><br />
				<textarea name="message" id="message" cols="60" rows="3">Notes</textarea>
			</p>
			<hr />
			<p><input type="text" name="jobid" id="jobid" value="REF ID# <?php echo $job['id'];?>" size="12" readonly="readonly" /> <input name="send" type="submit" id="send" value="Send Application" /></p>
		</form>
	</div>
<?php
}

function jobbin_template_random_ad($args) {
	extract($args);
	?>
	<div class="center">
		<small>
			<a href="<?php echo jobbin_get_permalink('job_id='.esc_attr($job->id));?>"><?php echo sprintf(__('%1$s is looking for a %2$s', 'jobbin'), esc_attr($job->company_name), esc_attr($job->title));?></a>
			<br/>
			<a href="<?php echo jobbin_get_permalink();?>"><?php _e('Looking for a job? Got a position to fill? Check out the Job Board.', 'jobbin');?></a>
		</small>
	</div>
<?php }?>
