<?php

//-- Dispaly All Master Notifications in Post/Page Editor ------------------------
//-----------------------------------------------------------------------------
add_action("admin_menu", "mnbar_post_meta_box_options");
add_action('save_post', 'mnbar_post_meta_box_save');

function mnbar_post_meta_box_options(){
	if( function_exists( 'add_meta_box' ) ) {
		$post_types=get_post_types(); 
		foreach($post_types as $post_type) {
			add_meta_box("mnbar_post_metas", __("Select Master Notification for this page/post", "mnpro"), "mnbar_post_meta_box_add", $post_type, "normal", "high");
		}
	}
	else{
	}
}

function mnbar_post_meta_box_add(){

	global $post;
	$custom = get_post_custom($post->ID);
	
	$mnbar_disable   = (array_key_exists("mnbar_disable",$custom)) ? $custom["mnbar_disable"][0] : 0;
	$mnbar_check     = (array_key_exists("mnbar_check",$custom)) ? $custom["mnbar_check"][0] : 0;
	$mnbar_selection = (array_key_exists("mnbar_selection",$custom)) ? $custom["mnbar_selection"][0] : 0;

    global $wpdb;
	$table_name = $wpdb->prefix . "masternotification"; 
    $mnbar_data = $wpdb->get_results("SELECT * FROM $table_name where active='1' ORDER BY id DESC");

	?>

	<input type="checkbox" name="mnbar_disable" id="mnbar_disable" <?php if($mnbar_disable){ ?> checked <?php } ?> value="true"/>&nbsp;<label for="mnbar_disable" style="color:red;"><?php _e('Check this, if you want to disable Master Notification for this post/page.','mnpro'); ?> </label><br/>
	
	<input type="hidden" name="nabr_matasubmit" value="1" />
	
	<div class="mnbar_disable">
	
		<div class="mnbar_checkbox">
			<input type="checkbox" name="mnbar_check" id="mnbar_check" <?php if($mnbar_check){ ?> checked <?php } ?> value="true"/>&nbsp;<label for="mnbar_check"><?php _e('Add "Master Notification" to this post/page..','mnpro'); ?> </label>
		</div>
	
		<?php
		if($mnbar_data){
				?><select name="mnbar_selection" class="mnbar_selection">
				<?php
				foreach ($mnbar_data as $data) { 
				   ?><option  value="<?php echo $data->id; ?>" <?php if($mnbar_selection == $data->id ){ echo 'selected="selected"'; }?>><?php echo $data->option_name; ?></option><?php
				}
				?></select><?php
			}
			else{
				?><span style="color:red"><?php _e("Master Notification(s) not activated / created.",'mnpro') ?></span><?php
			}
		?>
	</div><?php
}

//update post custom fields
function mnbar_post_meta_box_save(){
	global $post;
	if(isset($_REQUEST['nabr_matasubmit'])) {
		update_post_meta($post->ID, "mnbar_selection",$_POST['mnbar_selection']);
		update_post_meta($post->ID, "mnbar_disable",$_POST['mnbar_disable']);
		update_post_meta($post->ID, "mnbar_check",$_POST['mnbar_check']);
	}
}
?>