(function ($) {
    $.fn.masternotification = function (options) {
        var defaults = {
            "defaultstate": "true",
            "staytime": "6000",
            "exmsgstate": "close",
			"exmsgopentm":"4000",
			"exmsgclosetm":"4000",
			"disablecmsg" : "no",
			"showextend" : "0"
        };
        var options = $.extend(defaults, options);
        return this.each(function () {
            var opts = options;
            obj = $(this);
            objDwn = $(obj.find(".mnbar_downArr").attr("href"));
            objPush = $(".notification_push");
            var stayTimer;
			var extmsgopen;
			var extmsgcounter;
			var extmsgclose;

			function clearAll(){
			    clearTimeout(stayTimer);
				clearTimeout(extmsgopen);
				clearTimeout(extmsgcounter);
				clearTimeout(extmsgclose);
				obj.find(".mnbar_extendmsg .mnbar_extinfo").remove();
			}
			
            function staytime() {
                stayTimer = setTimeout(function () {
                    obj.slideUp("fast");
                    objDwn.slideDown();
                    pullObj()
                }, opts.staytime)
            }
			
			function exmsgOpenClose(){
				extmsgopen = setTimeout(function(){
					obj.find(".mnbar_extendmsg").slideDown('fast',function(){obj.find("a.mnbar_plusminus").addClass("active");});
		
					if(opts.disablecmsg =="no"){
						obj.find(".mnbar_extendmsg").append('<div class="mnbar_extinfo">This Message will close in <span class="mnbar_ctm"></span> Seconds.</div>');
						var mnbarcounter = opts.exmsgclosetm / 1000;
						obj.find('.mnbar_extinfo .mnbar_ctm').text(mnbarcounter-1);
						extmsgcounter = setInterval(function(){
							mnbarcounter--;
							obj.find('.mnbar_extinfo .mnbar_ctm').text(mnbarcounter);
						},1000);
					}
					
					extmsgclose = setTimeout(function(){
						obj.find(".mnbar_extendmsg").slideUp('fast',function(){obj.find("a.mnbar_plusminus").removeClass("active");});
						obj.find(".mnbar_extendmsg .mnbar_extinfo").remove();
					},opts.exmsgclosetm);
				},opts.exmsgopentm);
			}
			
            function pushObj() {
                var obj_pushHt = 1;
                objPush.css("height", obj_pushHt + 40);
                objPush.slideDown("fast")
            }
            function pullObj() {
                objPush.css("height", "");
                objPush.slideUp("fast")
            }
            if (opts.defaultstate == "true") {
                obj.slideDown("fast");
                pushObj();
                if (opts.exmsgstate == "true") {
					exmsgOpenClose();
                    staytime()
                } else staytime()
            } else if (opts.defaultstate == "false") {
                objDwn.show();
                if (opts.exmsgstate == "false") {
                    exmsgOpenClose();
                } else staytime()
            } else;
            if(opts.showextend !="0"){
	            obj.find("a.mnbar_plusminus,.mnbar_extclick").click(function () {
	                clearAll();
	                	obj.find(".mnbar_extendmsg").stop(true,true).slideToggle('fast',function(){$("a.mnbar_plusminus").toggleClass("active");});
	            });
	        }else{
	        	obj.find(".mnbar_topwrap").click(function () {
	                clearAll();
	                obj.css('cursor', 'pointer');
	                obj.find(".mnbar_extendmsg").stop(true,true).slideToggle('fast',function(){$("a.mnbar_plusminus").toggleClass("active");});
	            });
	        }
			
			$(".mnbar_extclick_shortcode").click(function () {
                clearAll();
				if($('#masternotification:visible').length){
					obj.slideUp("fast");
					obj.find(".mnbar_extendmsg").stop(true,true).slideUp();
					$("a.mnbar_plusminus").removeClass("active");
					objDwn.slideDown();
					pullObj();
				}else{
					objDwn.hide();
					obj.slideDown("fast");
					obj.find(".mnbar_extendmsg").stop(true,true).slideDown();
					$("a.mnbar_plusminus").addClass("active");
					pushObj();
				}
                
                
            });
			
            obj.find("a.mnbar_close").click(function () {
                clearAll();
                obj.slideUp("fast");
                objDwn.slideDown();
                pullObj()
            });
            objDwn.click(function () {
                $(this).hide();
				clearAll();
                obj.slideDown("fast");
                pushObj();
            });
			
			// close extend msg at "esc" button click event
			$(document).keyup(function(e){ 
				if (e.keyCode == 27) {
					obj.find(".mnbar_extendmsg").slideUp('fast',function(){obj.find("a.mnbar_plusminus").removeClass("active");});
				}
			});
        });
    }
})(jQuery);