<?php
/*
Plugin Name: Master Notification Pro
Plugin URI: http://persianscript.ir
Description: Master Notification Pro - Widgetized Notification Bar Plugin for WordPress. This plugin will show notification at top of the header.
Author: PersianScript.ir
Version: 1.0.0
Author URI: http://www.persianscript.ir
*/
//----------------------------------------------------------------------------------
/*---Load Required Files------------------------------
----------------------------------------------------*/
include_once('inc/admin/mnbarups.php');
include_once('scripts.php');
include_once('inc/admin/mn_admin-options.php');
include_once('inc/twitter/twitteroauth.php');
define('MNPROPLUGIN_URL', plugin_dir_url(__FILE__));
//---------------------------------------------------
/****************
	TEXT DOMAIN
****************/ 
function mnbar_textDomain() { 
	load_plugin_textdomain('mnpro', false, dirname( plugin_basename( __FILE__ ) ) . '/lang');
}
add_action('plugins_loaded', 'mnbar_textDomain');
//This function will create new database fields with default values
function mnbar_defaults(){
	    $default = array(
		'defaultposition' => 'top',
		'defaultState' => 'true',
		'stayTime' => '10',
		'colorScheme' => '#2EC1C9',
        'message' => 'Get my Subscription',
		'messageFont' => '12',
    	'messageColor' => '#f3eeee',
    	'mnprostyle' => 'Default',
		'linkUrl'=> 'http://www.persianscript.ir',
    	'linkText' => 'Click here',
		'linkFont' => '12',
		'linkTextColor' => '#fbf8e6',
		'linkBgcolor' => '#57380b',
		'linkTarget' => '_blank',
		'facebookUrl'=> 'http://www.persianscript.ir',
		'twitterUrl'=> 'http://www.persianscript.ir',
		'linkedinUrl'=> 'http://www.persianscript.ir',
		'googleUrl'=> 'http://www.persianscript.ir',
		'rssUrl'=> 'http://www.persianscript.ir',

		'custom' => '',
		'customcss' => '',
		'excustom' => '',
		'excustomcss' => '',

		'counter-message' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry',
		'countermessageColor' => '#fff',
		'counterdate' => '2020/01/01',
		'countertime' => '23:00:00',
		'countertimerColor' => '#fff',
		'daystext' => 'Days',
		'hourstext' => 'Hours',
		'minstext' => 'Minutes',
		'sectext' => 'Seconds',

		'excounter-message' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry',
		'excountermessageColor' => '#fff',
		'excounterdate' => '2020/01/01',
		'excountertime' => '23:00:00',
		'excountertimerColor' => '#fff',
		'exdaystext' => 'Days',
		'exhourstext' => 'Hours',
		'exminstext' => 'Minutes',
		'exsectext' => 'Seconds',

		'exvideomessage' => '<h3 style=color:#fff>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem IpsumLorem Ipsum is simply dummy text of the printing and typesetting industry.<h5 style=color:#fff> Lorem IpsumLorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum</h5><p></p>',

		'exnoofpost' => '5',
		'nabr_exposttitlecolorScheme' => '#ffffff',
		'exposttitlesize' => '30',
		'nabr_expostcontentcolorScheme' => '#ffffff',
		'expostcontentsize' => '15',

		'nabr_extwtcolorScheme' => '#ffffff',
		'exnooftwt' => '5',
		'extwtusername' => '',
		'extwtconsumerkey' => '',
		'extwtconsumersecretkey' => '',
		'extwtaccesstoken' => '',
		'extwtaccesssecrettoken' => '',
		
		'extendMesg' => 'true',
		'extendMesgWrapWt' => '960',

		'notificationmsgshow'=>'default',
		'twtusername' => '',
		'twtconsumerkey' => '',
		'twtconsumersecretkey' => '',
		'twtaccesstoken' => '',
		'twtaccesssecrettoken' => '',
		'nabr_twtcolorScheme' => '#ffffff',
		'noofpost' => '5',
		'noofwords' => '50',
		'nooftwt' => '5',
		'nabr_posttitlecolorScheme' => '#ffffff',
		'posttitlesize' => '20',
		'nabr_postcontentcolorScheme' => '#ffffff',
		'postcontentsize' => '15',
		
		'extendMesgShow'=>'custom',
		'extendMesgState' => 'open',
		'extendMesgCmsg' => 'no',
		'extMesgOpenTime' => '4',
		'extMesgCloseTime' => '4',
		'extMesgHeight' => '200',
		'exvideourl' => ''
    );
return $default;
}

function mnbar_settings(){
	    $defaultSettings = array(
		'mnbar_settingchk' => 'true',
		'mnbar_setDfltmnbar' => '1',
		'mnbar_setPages' => 'true',
		'mnbar_setPosts' => 'true',
		'mnbar_setHomepage' => 'true',
		'mnbar_setBlogpage' => 'true',
		'mnbar_setcats' => 'true',
		'mnbar_setctax' => 'true',
		'mnbar_settags' => 'true',
		'mnbar_setdate' => 'true',
		'mnbar_setauthor' => 'true'
    );
return $defaultSettings;
}

add_action('admin_menu', 'mnbar_plugin_admin_menu');
function mnbar_plugin_admin_menu() {
	add_menu_page('Add Master Notification', __('MNotification', 'mnpro'), 'publish_posts', 'masternotification','add_notification_bar',plugins_url('inc/images/icon.png',__FILE__));
	add_submenu_page('masternotification', 'Edit Master Notification', '', 'publish_posts','mnbar_edit','edit_notification_bar');
	add_submenu_page('masternotification', __('All MNotification', 'mnpro'), __('All MNotification', 'mnpro'), 'publish_posts','mnbar_list','list_notification_bar');
}

// Runs when plugin is activated and creates new database field
register_activation_hook(__FILE__,'masternotification_plugin_install');
function masternotification_plugin_install() {
    add_option('masternotification_options', mnbar_defaults());
    add_option('masternotification_settings', mnbar_settings());
    mnbar_install();
    global $wpdb;
	$table_name = $wpdb->prefix . "masternotification"; 
    $sql = "INSERT INTO " . $table_name . " values ('','masternotification_options','1');";
    $wpdb->query( $sql );
}

//notification bar Table
function mnbar_install(){
    global $wpdb;
	$table_name = $wpdb->prefix . "masternotification"; 
		$sql = "CREATE TABLE " . $table_name . " (
		  id mediumint(9) NOT NULL AUTO_INCREMENT,
		  option_name VARCHAR(255) NOT NULL DEFAULT  'masternotification_options',
		  active tinyint(1) NOT NULL DEFAULT  '0',
		  PRIMARY KEY (`id`),
          UNIQUE (
                    `option_name`
            )
		)";
		require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
		dbDelta($sql);
}

// get masternotification version
function mnbar_get_version(){
	if ( ! function_exists( 'get_plugins' ) )
	require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
	$plugin_folder = get_plugins( '/' . plugin_basename( dirname( __FILE__ ) ) );
	$plugin_file = basename( ( __FILE__ ) );
	return $plugin_folder[$plugin_file]['Version'];
}

add_action('wp_ajax_mnpro_saved' ,'mnpro_edit_saved');
function mnpro_edit_saved(){
	check_ajax_referer('mnpro-options-data', 'security');
	$data = $_POST;
	unset($data['security'], $data['action']);
	$mnbar_itemnameopt = $data['mnbar_itemname'];
	$data_arr = $data[$mnbar_itemnameopt];
	
	if(update_option($mnbar_itemnameopt, $data_arr)){
		die('1');
	} else {
		die('0');
	}
}

// add notification bar on frontend 
function mnbar_addon_front(){
	include_once('inc/front/mn_front.php');
}
add_action('wp_footer','mnbar_addon_front');

// add notification extend click shortcode
function mnbar_extclick_shortcode( $atts, $content="" ) {
     return "<span class='mnbar_extclick_shortcode'>$content</span>";
}
add_shortcode( 'mnbarExtclick', 'mnbar_extclick_shortcode' );

// regsiter notification bar sidebar
function mnbar_widget_init() {
	register_sidebar(array(
		'id' => 'mnpro',
		'name' => __('Master Notification Pro Widget Area', 'mnpro'),
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>'
	));
}
add_action( 'init', 'mnbar_widget_init' );
function parse_youtube($youtube_src1){
	if (preg_match('/youtube\.com\/watch\?v=([^\&\?\/]+)/', $youtube_src1)) {
		preg_match_all('#(http://www.youtube.com)?/(v/([-|~_0-9A-Za-z]+)|watch\?v\=([-|~_0-9A-Za-z]+)&?.*?)#i',$youtube_src1,$output);
		$mnpro_yvideo_id = $output[4][0];
	} else if (preg_match('/youtube\.com\/embed\/([^\&\?\/]+)/', $youtube_src1)) {
		preg_match_all('#(http://www.youtube.com)?/(v/([-|~_0-9A-Za-z]+)|watch\?v\=([-|~_0-9A-Za-z]+)&?.*?)#i',$youtube_src1,$output);
		$mnpro_yvideo_id = $output[4][0];
	} else if (preg_match('/youtube\.com\/v\/([^\&\?\/]+)/',$youtube_src1)) {
		preg_match_all('#(http://www.youtube.com)?/(v/([-|~_0-9A-Za-z]+)|watch\?v\=([-|~_0-9A-Za-z]+)&?.*?)#i',$youtube_src1,$output);
		$mnpro_yvideo_id = $output[4][0];
	} else if (preg_match('/youtu\.be\/([^\&\?\/]+)/', $youtube_src1)) {
		preg_match_all('#(http://www.youtube.com)?/(v/([-|~_0-9A-Za-z]+)|watch\?v\=([-|~_0-9A-Za-z]+)&?.*?)#i',$youtube_src1,$output);
		$mnpro_yvideo_id = $output[4][0];
	} else if(preg_match('/https:\/\/(www\.)*youtube\.com\/.*/',$youtube_src1)){
		preg_match_all('#(http://www.youtube.com)?/(v/([-|~_0-9A-Za-z]+)|watch\?v\=([-|~_0-9A-Za-z]+)&?.*?)#i',$youtube_src1,$output);
		$mnpro_yvideo_id = $output[4][0];
	}

	return $mnpro_yvideo_id;
}
//----------------------------------------------------------------------------------