<?php
/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @since      1.0.0
 * @package    Realtime_Visitor_Stats
 * @author     Weblator <daniel.prior@weblator.com>
 */
class Els_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;

	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/els-admin.css', array(), $this->version, 'all' );
		wp_enqueue_style( $this->plugin_name . "flags", plugin_dir_url( __FILE__ ) . 'css/flag-icon.min.css', array(), $this->version, 'all' );
		wp_enqueue_style( $this->plugin_name . "font-awesome", plugin_dir_url( __FILE__ ) . 'css/font-awesome.min.css', array(), $this->version, 'all' );
		wp_enqueue_style( $this->plugin_name . "data-tables", plugin_dir_url( __FILE__ ) . 'css/jquery.dataTables.min.css', array(), $this->version, 'all' );
	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts( $hook ) {

		wp_enqueue_script( $this->plugin_name . "handlebars", plugin_dir_url( __FILE__ ) . 'js/handlebars-v2.0.0.js', array( 'jquery' ), $this->version, false );
		wp_enqueue_script( $this->plugin_name . "moment", plugin_dir_url( __FILE__ ) . 'js/moment.js', array( 'jquery' ), $this->version, false );
		if ( $hook == "index.php" ){

			wp_register_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/els-admin.js', array( 'jquery' ), $this->version, false );
			wp_localize_script( $this->plugin_name, 'data_array', array(
				"user" => __("User", "easy-live-stats"),
				"current_page" => __("Current Page", "easy-live-stats"),
				"browser" => __("Browser", "easy-live-stats"),
				"time_on_site" => __("Time on Site", "easy-live-stats"),
				"pages_visited" => __("Pages Visited", "easy-live-stats"),
				"page" => __("Page", "easy-live-stats"),
				"start_time" => __("Start Time", "easy-live-stats"),
				"end_time" => __("End Time", "easy-live-stats"),
				"time_on_page" => __("Time on Page", "easy-live-stats"),
			) );
			wp_enqueue_script( $this->plugin_name );
		}

		wp_enqueue_script( $this->plugin_name . "data-tables", plugin_dir_url( __FILE__ ) . 'js/jquery.dataTables.min.js', array( 'jquery' ), $this->version, false );
		wp_enqueue_script( $this->plugin_name . "settings", plugin_dir_url( __FILE__ ) . 'js/els-settings.js', array( 'jquery' ), $this->version, false );

	}


	public function dashboard_widget( $post, $callback_args ) {


		require_once plugin_dir_path( __FILE__ ) . "/partials/els-display.php";

	}

	public function add_dashboard_widgets() {

		add_meta_box( 'easy-live-stats-widget', 'Real-time Visitor Stats', array( $this, 'dashboard_widget'), 'dashboard', 'normal', 'high' );

	}

	public function load_js_templates() {

		$files = glob(plugin_dir_path( __FILE__ ) . "js/templates/*.{html}", GLOB_BRACE);
		foreach ($files as $file)
			require_once($file);
	}

	function screen_layout_columns($columns) {

		$columns['dashboard'] = 2;
		return $columns;
	}

	function screen_layout_dashboard() {
		return 2;
	}

	function add_option_page() {

		add_options_page( 'Real-time Visitor Stats','Real-time Visitor Stats','manage_options','realtime-visitor-stats-settings', array( $this, 'load_options_page' ));

	}

	function load_options_page(){

		global $wpdb;

		$ban_list = $wpdb->get_results("SELECT * FROM {$wpdb->prefix}live_ban_list ORDER BY ban_date DESC", ARRAY_A);
		$ban_log = $wpdb->get_results("SELECT * FROM {$wpdb->prefix}live_ban_log ORDER BY date DESC", ARRAY_A);
		require_once plugin_dir_path( __FILE__ ) . "/partials/els-settings.php";
	}

}