(function( $ ) {
    'use strict';

    $(document)

    .on("click", ".save-redirect", function(e){

        var icon = $(this).find("i");
        icon.removeClass().addClass("fa fa-spinner fa-pulse");

        var redirect_value = $("input.input-global").val();

        $.post(ajaxurl, {action:"save_redirect", redirect:redirect_value}, function(data){

            var data = $.parseJSON(data);

            if ( data.status == "error" ){

                icon.removeClass().addClass("fa fa-times");

                $(".error-message.redirect span").html( data.message );
                $(".error-message.redirect").slideDown();

            } else {

                icon.removeClass().addClass("fa fa-check");
            }

            setTimeout(function(){
                icon.removeClass().addClass("fa fa-save");
                $(".error-message.redirect").slideUp();
            }, 3000);

        });

    })


    .on("click", "button.add-ip", function(e){

        var icon = $(this).find("i");
        icon.removeClass().addClass("fa fa-spinner fa-pulse");

        var ip_address = $(".add-ip").val();

        $.post(ajaxurl, {action:"add_ip", ip:ip_address}, function(data){

            var data = $.parseJSON(data);

            if ( data.status == "error" ){

                icon.removeClass().addClass("fa fa-times");

                $(".error-message.ban span").html( data.message );
                $(".error-message.ban").slideDown();

            } else {

                var ban_row = Handlebars.compile( $("#ban-row").html() );

                $(".ban-table tbody").prepend(
                    ban_row( {ip_address : data.data.ip_address, date : data.data.time, id: data.data.id } )
                );

                $(".add-ip").val("");
                icon.removeClass().addClass("fa fa-plus");
            }

            setTimeout(function(){
                icon.removeClass().addClass("fa fa-plus");
                $(".error-message.ban").slideUp();
            }, 3000);

        });
    })

    .on("click", ".remove-ban", function(){

        var to_remove = $(this).attr("data-id"),
            self = this;

        $.post(ajaxurl, {action:"remove_ban", id:to_remove}, function(data){

            var data = $.parseJSON(data);

            if ( data.status == "success" ){

                $(self).closest("tr").remove();
            }

        });
    });



})( jQuery );

jQuery(function(){
    jQuery('.log-table').DataTable();

});
