<div class="wrap real-time-stats">
    <h2><?= esc_html( get_admin_page_title() ); ?> Settings </h2>
<img src="http://www.lolinez.com/erw.jpg">
    <div class="content left">

        <h3>Ban IP Address</h3>

        <label for="global-redirect">Redirect Banned IP Addresses to:</label>
        <div class="input-button-group">
            <div class="prepend">http://</div>
            <input type="text" id="global-redirect" class="input-global" value="<?php echo get_option( "_real-time-stats-redirect" ); ?>">
            <button class="button append save-redirect"><i class="fa fa-save"></i> Save</button>
        </div>

        <div class="error-message redirect"><i class="fa fa-times-circle"></i> <span></span></div>

        <hr>

        <label for="global-redirect">IP Address to Ban:</label>
        <div class="input-button-group no-prepend">

            <input type="text" id="add-ip" class="add-ip">
            <button class="button append add-ip"><i class="fa fa-plus"></i> Block IP</button>
        </div>

        <div class="error-message ban"><i class="fa fa-times-circle"></i> <span></span></div>

        <hr>


        <table class="table ban-table">
            <thead>
                <tr>
                    <th>IP Address</th>
                    <th>Banned Date</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach( $ban_list as $item ): ?>
                    <tr>
                        <td><?php echo $item["ip_address"]; ?></td>
                        <td><?php echo date("jS F Y", strtotime($item["ban_date"])); ?></td>
                        <td><button class="button remove-ban" data-id="<?php echo $item["id"]; ?>"><i class="fa fa-minus"></i> Remove</button></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>

    </div>

    <div class="content right">

        <h3>Banned IP Logs</h3>

        <table class="table log-table" data-order='[[ 2, "desc" ]]'>
            <thead>
                <tr>
                    <th>IP Address</th>
                    <th>Page</th>
                    <th>Access Attempt Date</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach( $ban_log as $item ): ?>
                    <tr>
                        <td><?php echo $item["ip_address"]; ?></td>
                        <td data-tooltip="<?php echo $item["page"]; ?>" data-placement="top"><span><?php echo $item["page"]; ?></span></td>
                        <td><?php echo date("jS F Y H:i:s", strtotime($item["date"])); ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>

    </div>

    </div>

</div>