<?php

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    Realtime_Visitor_Stats
 * @subpackage Realtime_Visitor_Stats/includes
 * @author     Weblator <daniel.prior@weblator.com>
 */
class Els_Activator {

	public static function activate() {

        global $wpdb;

        $wpdb->query("
            CREATE TABLE IF NOT EXISTS `{$wpdb->prefix}live_visitor_page_view` (
              `live_visitor_page_view_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
              `live_visitor_page_view_random_user` varchar(100) DEFAULT NULL,
              `live_visitor_page_view_page` varchar(255) DEFAULT NULL,
              `live_visitor_page_view_page_url` varchar(255) DEFAULT NULL,
              `live_visitor_page_view_start_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
              `live_visitor_page_view_end_time` timestamp NULL DEFAULT NULL,
              `live_last` tinyint(1) DEFAULT NULL,
              PRIMARY KEY (`live_visitor_page_view_id`)
            ) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;
        ");

        $wpdb->query("
            CREATE TABLE IF NOT EXISTS `{$wpdb->prefix}live_visitor_user` (
              `live_visitor_user_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
              `live_visitor_page_view_random_user` varchar(100) DEFAULT NULL,
              `live_visitor_user_wp_name` varchar(255) DEFAULT NULL,
              `live_visitor_user_ip` varchar(20) DEFAULT NULL,
              `live_visitor_user_os` varchar(20) DEFAULT NULL,
              `live_visitor_user_browser` varchar(20) DEFAULT NULL,
              `live_visitor_user_city` varchar(255) DEFAULT NULL,
              `live_visitor_user_region` varchar(255) DEFAULT NULL,
              `live_visitor_user_country` varchar(255) DEFAULT NULL,
              `live_visitor_last_page_load` varchar(255) DEFAULT NULL,
              PRIMARY KEY (`live_visitor_user_id`)
            ) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;
        ");

        $wpdb->query("
            CREATE TABLE IF NOT EXISTS `{$wpdb->prefix}live_ban_log` (
            `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
            `ip_address` varchar(150) DEFAULT NULL,
            `page` text,
            `date` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
            PRIMARY KEY (`id`)
          ) ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;
        ");

        $wpdb->query("
            CREATE TABLE IF NOT EXISTS `{$wpdb->prefix}live_ban_list` (
            `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
            `ip_address` varchar(250) DEFAULT NULL,
            `ban_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
            PRIMARY KEY (`id`)
          ) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=latin1;
        ");




        //Add Redirect option
        if ( get_option( "_real-time-stats-redirect" ) !== false )
            update_option( "_real-time-stats-redirect", "google.com" );
        else
            add_option( "_real-time-stats-redirect", "google.com" );


	}

}
