<?php

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @since      1.0.0
 * @package    Realtime_Visitor_Stats
 * @subpackage Realtime_Visitor_Stats/includes
 * @author     Weblator <daniel.prior@weblator.com>
 */
class Els_Public {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of the plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;

	}

	/**
	 * Register the stylesheets for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {


		wp_register_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/els-public.js', array( 'jquery' ), $this->version, false );
		wp_localize_script( $this->plugin_name, 'ajaxurl', admin_url("admin-ajax.php") );
		wp_enqueue_script( $this->plugin_name );


	}

	public function check_for_banned_ip(){

		if ( !is_admin() ){

			global $wpdb;

			$current_ip = $_SERVER["REMOTE_ADDR"];

			$count = $wpdb->get_var(
				$wpdb->prepare("SELECT count(id) FROM {$wpdb->prefix}live_ban_list WHERE ip_address = '%s'", $current_ip)
			);

			if ( $count ) {

				$current_url = "http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
				$direct = get_option( "_real-time-stats-redirect" );

				$wpdb->query(
					$wpdb->prepare("INSERT INTO {$wpdb->prefix}live_ban_log (ip_address, page) VALUES('%s', '%s')", $current_ip, $current_url)
				);

				wp_redirect( "http://" . $direct ); exit;
			}
		}

	}

}
