<?php

/**
 * Plugin Name:       Real-time Visitor Stats for WordPress
 * Plugin URI:        http://plugins.weblator.com/realtime-visitor-stats
 * Description:       'Real-time Visitor Stats' is a WordPress dashboard widget that allows you to monitor visitors to your WordPress website in real time. The plugin requires minimal setup, so you can start tracking your visitors instantly.
 * Version:           1.1.1
 * Author:            Weblator
 * Author Email:      daniel.prior@weblator.com
 * Author URI:        http://weblator.com/
 * Text Domain:       realtime-visitor-stats
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

if (!session_id()) {
    session_start();
}

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/els-activator.php
 */
function activate_easy_live_stats() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/els-activator.php';
	Els_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/els-deactivator.php
 */
function deactivate_easy_live_stats() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/els-deactivator.php';
	Els_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_easy_live_stats' );
register_deactivation_hook( __FILE__, 'deactivate_easy_live_stats' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/els.php';

/**
 * Begins execution of the plugin.
 *
 * @since    1.0.0
 */
function run_els() {

	$plugin = new Els();
	$plugin->run();

}
run_els();
