<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * SixthType Reviews Functions
 *
 * @package  SixthType-Reviews/Includes
 * @author   SixthType <hello@sixthtype.com>
 * @version  1.0
 * @since 	 1.0
 */

/**
 * Obtain SixthType Reviews Instance
 *
 * @version  1.0
 * @since    1.0
 * @return   SixthType_Reviews
 */
function st_reviews_instance() {

	return SixthType_Reviews::get_instance();
}

/**
 * Show Post Review
 *
 * @version  1.0
 * @since    1.0
 * @param    integer $post_id
 */
function st_reviews_show_review( $post_id = null ) {

	global $post;

	if( ! isset( $post_id ) ) {
		
		$post_id = $post->ID;
	}

	$st_reviews = st_reviews_instance();
	$st_reviews->display_review( $post_id );
}

/**
 * Find If Post Have Review
 *
 * @version  1.0
 * @since    1.0
 * @param    integer $post_id
 * @return   boolean
 */
function st_reviews_is_review_post( $post_id = null ) {

	global $post;

	if( ! isset( $post_id ) ) {
		
		$post_id = $post->ID;
	}

	$st_reviews = st_reviews_instance();

	return $st_reviews->is_review_post( $post_id );	
}

/**
 * Display Review Post Score
 *
 * @version  1.0
 * @since    1.0
 * @param    integer $post_id
 */
function st_reviews_post_score( $post_id = null ) {

	echo esc_html( st_reviews_get_post_score( $post_id ) );
}

/**
 * Get Review Post Score
 *
 * @version  1.0
 * @since    1.0
 * @param    integer $post_id
 * @return   SixthType_Reviews
 */
function st_reviews_get_post_score( $post_id = null ) {
	
	global $post;

	if( ! isset( $post_id ) ) {
		
		$post_id = $post->ID;
	}

	$st_reviews = st_reviews_instance();

	return $st_reviews->get_review_score( $post_id );
}

/**
 * Get Review Post Score CSS Class
 *
 * Returns a CSS class name depending on post score value.
 * 
 * @version  1.0
 * @since    1.0
 * @param    integer $post_id
 * @return   string
 */
function st_reviews_get_post_score_class( $post_id = null ) {

	$score = st_reviews_get_post_score( $post_id );
	$st_reviews = st_reviews_instance();

	return $st_reviews->get_score_css_class( $score );
}

/**
 * Display Review Post Conclusion Text
 *
 * @version  1.0
 * @since    1.0
 * @param    integer $post_id
 */
function st_reviews_post_conclusion( $post_id = null ) {

	echo st_reviews_get_post_conclusion( $post_id );
}

/**
 * Get Review Post Conclusion Text
 *
 * @version  1.0
 * @since    1.0
 * @param    integer $post_id
 * @return   string
 */
function st_reviews_get_post_conclusion( $post_id = null ) {
	
	global $post;

	if( ! isset( $post_id ) ) {
		
		$post_id = $post->ID;
	}

	$st_reviews = st_reviews_instance();

	return $st_reviews->get_review_conclusion( $post_id );
}

?>