/*--------------------------------------
 * SixthType Framework Admin JS
 *
 * @version  1.0
 --------------------------------------*/

/**
 * Document Ready
 * 
 */
jQuery(document).ready(function($){

	window.STFR = {};

	/**
	 * Defaults
	 * 
	 */
	STFR.defaults = {
		options_view: $('.stfr-options-view'),
		notification_view: $('#stfr_notification_view'),
		nonce: $('#sixthtype_nonce_id').val(),
		media_frame: null
	};

	/**
	 * INIT
	 * 
	 */
	STFR.init = function() {

		var ntf_content = STFR.defaults.notification_view.find('.content'),
			ntf_class = STFR.defaults.notification_view.attr('class');

		// init options
		STFR.defaults.options_view.each( function(){

			STFR.init_options( $(this) );

		});
		
		// if notification text is not empty display notification
		if( $.trim( ntf_content.html() ) ) {
			STFR.show_notification( ntf_content.html(), ntf_class );
		}
	}

	/**
	 * Show Notification
	 *
	 * @param string text - notification text
	 * @param string type - notification type ('success' or 'warning')
	 */
	STFR.show_notification = function( text, type ) {

		if( _.isUndefined( text ) || _.isNull( text ) ) {
			return;
		}

		if( type != 'warning' ) {
			type = 'success';
		}

		STFR.defaults.notification_view.removeAttr('class');
		STFR.defaults.notification_view.addClass( type );
		STFR.defaults.notification_view.find('.content').html( text );

		STFR.defaults.notification_view
						.stop(true, true)
							.animate({top: 0 }, 500, 'easeOutBack')
								.delay(1200).animate({top: -120 }, 550, 'easeInBack');

	};

	/**
	 * Initialize Options
	 *
	 * Initialize all options in given context
	 * 
	 * @param  Object context - jQuery object
	 */
	STFR.init_options = function( context ) {

		STFR.switch_toggle.add_to( context );
		STFR.color_picker.add_to( context );
		STFR.slider_input.add_to( context );
		STFR.select_image_option.add_to( context );
		STFR.file_upload.add_to( context );
		STFR.gallery.add_to( context );
		STFR.font_picker.add_to( context );
		STFR.icon_picker.add_to( context );
	};

	/**
	 * Destroy Options
	 *
	 * Removes all options event listeners from context
	 * 
	 * @param  Object context - jQuery object
	 */
	STFR.destroy_options = function( context ) {

		STFR.switch_toggle.remove_from( context );
		STFR.color_picker.remove_from( context );
		STFR.slider_input.remove_from( context );
		STFR.select_image_option.remove_from( context );
		STFR.file_upload.remove_from( context );
		STFR.gallery.remove_from( context );
		STFR.font_picker.remove_from( context );
		STFR.icon_picker.remove_from( context );
	};

	/**
	 * Switch Toggle
	 * 
	 */
	STFR.switch_toggle = {

		/**
		 * Init each found instance of 
		 * switch toggle option in the given context
		 * 
		 * @param Object context - jQuery object
		 */
		add_to: function( context ) {

			if( _.isUndefined( context ) || _.isNull( context ) ) {
				return;
			}

			context.find('.stfr-switch-toggle').each( function(){

				$(this).click( function(){

					var val_id = $(this).attr('data-val-id'),
						val_el = $(this).find( '#' + val_id );

					// check toggle state
					if( val_el.val() === 'on' ) {

						$(this).removeClass('state-on')
									.addClass('state-off');

						val_el.val('off');

					}else{

						$(this).removeClass('state-off')
									.addClass('state-on');

						val_el.val('on');
					}
				});

			});

		},

		/**
		 * Unbind all occurrences of switch toggle
		 * option inside the given context
		 * 
		 * @param Object context - jQuery object
		 */
		remove_from: function( context ) {

			if( _.isUndefined( context ) || _.isNull( context ) ) {
				return;
			}

			context.find('.stfr-switch-toggle').each( function(){

				$(this).unbind('click');

			});

		}

	};

	/**
	 * Color Picker
	 * 
	 */
	STFR.color_picker = {
			
		/**
		 * Init each found instance of 
		 * color picker option in the given context
		 * 
		 * @param Object context - jQuery object
		 */
		add_to: function( context ) {

			if( _.isUndefined( context ) || _.isNull( context ) ) {
				return;
			}

			context.find('.stfr-color-picker').each( function(){

				$(this).ColorPicker({
					
					onSubmit: function(hsb, hex, rgb, el) {
						
						var c_box = $(el).attr('data-color-box');

						$( '#' + c_box ).css('backgroundColor', '#' + hex );
					
						$(el).val(hex);
						$(el).ColorPickerHide();
					},

					onBeforeShow: function (el) {
						$(this).ColorPickerSetColor( this.value );
					}
				})
				.bind('keyup', function(){
					$(this).ColorPickerSetColor( this.value );
				});

			});

		},

		/**
		 * Unbind all occurrences of color picker
		 * option inside the given context
		 * 
		 * @param Object context - jQuery object
		 */
		remove_from: function( context ) {

			if( _.isUndefined( context ) || _.isNull( context ) ) {
				return;
			}

			context.find('.stfr-color-picker').each( function(){

				$(this).ColorPicker({ onSubmit: null, onBeforeShow: null });
				$(this).unbind();

			});
		}

	};

	/**
	 * Slider Input
	 * 
	 */
	STFR.slider_input = {

		/**
		 * Init each found instance of slider
		 * input option in the given context
		 * 
		 * @param Object context - jQuery object
		 */
		add_to: function( context ) {

			if( _.isUndefined( context ) || _.isNull( context ) ) {
				return;
			}

			context.find('.stfr-ui-slider').each( function(){

				var startVal = $(this).attr('data-value'),
					fieldV = $('#' + $(this).attr('data-field') ),
					min_v = parseFloat( $(this).attr('data-min') ),
					max_v = parseFloat( $(this).attr('data-max') ),
					step_v = parseFloat( $(this).attr('data-step') );

				$(this).slider({
					value: startVal,
					range: 'min',
					min: min_v,
					max: max_v,
					step: step_v,
					slide: function( event, ui ) {
						fieldV.val(ui.value);
					}
				});

			});

		},

		/**
		 * Unbind all occurrences of slider input
		 * option inside the given context
		 * 
		 * @param Object context - jQuery object
		 */
		remove_from: function( context ) {

			if( _.isUndefined( context ) || _.isNull( context ) ) {
				return;
			}

			context.find('.stfr-ui-slider').each( function(){
				
				$(this).slider({ slide: null });
				$(this).unbind();

			});
		}

	};

	/**
	 * Select Image Option
	 * 
	 */
	STFR.select_image_option = {

		/**
		 * Init each found instance of select image
		 * option in the given context
		 * 
		 * @param Object context - jQuery object
		 */
		add_to: function( context ) {

			if( _.isUndefined( context ) || _.isNull( context ) ) {
				return;
			}

			context.find('.stfr-select-image-option').each( function(){

				var target = $( '#'+ $(this).attr('data-target-id') );

				$(this).find('a').click( function(e){
					
					e.preventDefault();

					$(this).parent()
							.parent()
								.find('.selected')
									.removeClass('selected');
					
					$(this).parent()
							.addClass('selected');

					// set new value
					target.val( $(this).attr('data-sel-val') );

				});

			});

		},

		/**
		 * Unbind all occurrences of select image
		 * option inside the given context
		 * 
		 * @param Object context - jQuery object
		 */
		remove_from: function( context ) {

			if( _.isUndefined( context ) || _.isNull( context ) ) {
				return;
			}

			context.find('.stfr-select-image-option').each( function(){

				$(this).find('li').unbind('click');

			});
		}

	};

	/**
	 * File Upload
	 * 
	 */
	STFR.file_upload = {

		/**
		 * Init each found instance of file upload
		 * option in the given context
		 * 
		 * @param Object context - jQuery object
		 */
		add_to: function( context ) {

			if( _.isUndefined( context ) || _.isNull( context ) ) {
				return;
			}

			context.find('.stfr-file-button').each( function(){

				var v_field = $(this).prev(),
					url_field = v_field.prev(),
					url_val = url_field.val(),
					file_type = $(this).attr('data-type'),
					img_preview = $( '#' + v_field.attr('id') + '_preview' ),
					title = $(this).attr('data-title'),
					btn_text = $(this).html();

				// Button click
				$(this).click( function(e){

					e.preventDefault();

					STFR.media_frame = wp.media.frames.stfr_media_frame = wp.media({
						title: title,
				      	button: { text: btn_text, },
				      	frame: 'select',
				      	library: { type: file_type },
				      	multiple: false
					});

					// Frame attachment select
					STFR.media_frame.on('select', function(){

						// get selected attachment
						var selected = STFR.media_frame.state().get('selection').first().toJSON(),
							attachment = {};

						attachment.id = selected.id;
						attachment.url = selected.url;
						
						// if file type is image update image preview
						if( file_type == 'image' ) {
							
							if( _.isUndefined( selected.sizes ) ) {

								attachment.url = selected.url;

							}else if( ! _.isUndefined( selected.sizes.medium ) ) {
								
								attachment.url = selected.sizes.medium.url;
							}

							img_preview.attr( 'src', attachment.url );
						}

						v_field.val( _.escape( JSON.stringify( attachment ) ) );

						// update url field
						url_field.val( attachment.url );
						url_val = attachment.url;

						
						STFR.media_frame = null;

					});

					// open media frame
					STFR.media_frame.open();

				});
				
				// Handle URL input field change
				url_field.focusout( function(){

					if( file_type != 'image' ) {
						return;
					}

					if( url_val != url_field.val() ) {
						url_val = url_field.val();

						// update field JSON value
						// use id:0 for images that are not
						// from media manager
						var ob = { id:0, url: url_val };

						v_field.val( _.escape( JSON.stringify( ob ) ) );

						// update image preview
						if( url_field.val() != '' ) {
							img_preview.attr( 'src', url_val );
						}
					}

				});


			});

		},

		/**
		 * Unbind all occurrences of file upload
		 * option inside the given context
		 * 
		 * @param Object context - jQuery object
		 */
		remove_from: function( context ) {

			if( _.isUndefined( context ) || _.isNull( context ) ) {
				return;
			}

			context.find('.stfr-file-button').each( function(){

				$(this).unbind('click');
				$(this).prev().prev().unbind('focusout');
				
				if( STFR.media_frame ) {
					STFR.media_frame.unbind('select');
					STFR.media_frame = null;
				}

			});
		}

	};

	/**
	 * Gallery
	 * 
	 */
	STFR.gallery = {

		/**
		 * Init each found instance of gallery
		 * option in the given context
		 * 
		 * @param Object context - jQuery object
		 */
		add_to: function( context ) {

			if( _.isUndefined( context ) || _.isNull( context ) ) {
				return;
			}

			context.find('.stfr-gallery-button').each( function(){

				var v_field = $(this).next(),
					slides = $( '#' + v_field.attr('id') + '_slides'),
					t_slide = slides.find('.template').clone().removeAttr('class'),
					state = 'gallery',
					selection = {};

				// Button click
				$(this).click( function(e){

					e.preventDefault();

					// if there are saved attachments set state to gallery-edit
					// and fill gallery selection with those attachments
					var saved_att = JSON.parse( _.unescape( v_field.val() ) );

					if( ! _.isEmpty( saved_att ) ) {

						var ids = [],
							query,
							query_args = {};
						
						// get attachment ids
						_.map( saved_att, function( attachment_id ){
							ids.push( attachment_id );
						});

						query_args.post__in = ids;
						query_args.orderby  = 'post__in';
						state = 'gallery-edit';

						// create query for saved attachments
						query = wp.media.query( query_args );

						// fill selection with query result
						selection = new wp.media.model.Selection( query.models, {
							props: query.props.toJSON(),
							multiple: true
						});
					}

					// Create gallery frame
					STFR.media_frame = wp.media.frames.stfr_media_frame = wp.media({
						frame: 'post',
				      	library: { type: 'image' },
				      	multiple: true,
				      	state: state,
				      	selection: selection
					});

					
					// Frame update
					STFR.media_frame.on('update', function( selected ){

						var ids = [],
							slide;

						selected = selected.toJSON();

						// remove current slides
						slides.empty();

						_.map( selected, function( att ){
							
							// add attachment id to list with ids
							ids.push( att.id );
							
							// create new slide
							slide = t_slide.clone()

							slide.find('img')
									.attr('src', att.sizes.thumbnail.url)
										.attr('alt', att.title);
							
							// add slide to slides container
							slides.append( slide );

						});

						v_field.val( _.escape( JSON.stringify( ids ) ) );

						STFR.media_frame = null;

					});

					// Frame close
					STFR.media_frame.on('close', function(){

						// if gallery contains no
						// attachments clear the slides
						var count = STFR.media_frame.state().get('library').length;
						
						if( ! count ) {

							slides.empty();
							v_field.val('[]');

							// add empty gallery text
							var no_slides = t_slide.clone(),
								no_slides_text = 'No images selected.';

							if( ! _.isUndefined( STFR_l10n.no_gallery_slides ) ) {
								no_slides_text = STFR_l10n.no_gallery_slides;
							}

							no_slides.addClass('no-slides');
							no_slides.html( no_slides_text );
							
							slides.append( no_slides );
						}

					});

					// open media frame
					STFR.media_frame.open();

				});

			});

		},

		/**
		 * Unbind all occurrences of gallery
		 * option inside the given context
		 * 
		 * @param Object context - jQuery object
		 */
		remove_from: function( context ) {

			if( _.isUndefined( context ) || _.isNull( context ) ) {
				return;
			}

			context.find('.stfr-gallery-button').each( function(){
				
				$(this).unbind('click');
				
				if( STFR.media_frame ) {
					STFR.media_frame.unbind('update');
					STFR.media_frame.unbind('close');
					STFR.media_frame = null;
				}

			});

		}

	};

	/**
	 * Font Picker
	 * 
	 */
	STFR.font_picker = {

		/**
		 * Init each found instance of font picker
		 * option in the given context
		 * 
		 * @param Object context - jQuery object
		 */
		add_to: function( context ) {

			if( _.isUndefined( context ) || _.isNull( context ) ) {
				return;
			}

			context.find('.stfr-font-picker').each( function(){

				STFR.font_picker.Views.init();

				var field,
					picker,
					currentFont,
					preview,
					subsets,
					variants,
					fallback,
					variants_list,
					subsets_list;

				field = $(this).find('.font-data');
				picker = $(this).find('.fonts-list');
				preview = $(this).find('.stfr-font-preview');
				variants = $(this).find('.font-variants');
				subsets = $(this).find('.font-subsets');
				fallback = $(this).find('.font-fallback');

				currentFont = JSON.parse( _.unescape( field.val() ) );
 				_.extend(currentFont, Backbone.Events);
 				$(this).data( 'cfont', currentFont );

 				// setup current font checkboxes
 				STFR.font_picker.setup_checkboxes( currentFont, variants, subsets );

 				// listen for font prop update and update field value
 				currentFont.on('update-font', function(){

 					font = {
 						family: currentFont.family,
 						variants: currentFont.variants,
 						subsets: currentFont.subsets,
 						sel_variants: currentFont.sel_variants,
 						sel_subsets: currentFont.sel_subsets,
 						type: currentFont.type,
 						category: currentFont.category,
 						fallback: currentFont.category,
 						file: currentFont.file
 					}

 					if( ! _.isUndefined( currentFont.fallback ) ) {

 						font.fallback = currentFont.fallback;
 					}

 					field.val( _.escape( JSON.stringify( font ) ) );
 				});

 				// listen for font change
				picker.on('change', function(e){

					var selected,
						font;

					selected = $(this).find('option:selected')
					font = JSON.parse( _.unescape( selected.attr('data-font') ) );

					// update font preview
					STFR.font_picker.update_preview( preview, font );

					// set newly selected font
					STFR.font_picker.set_selected_font( currentFont, font, fallback );

					// clear subsets and variants
					STFR.font_picker.remove_checkboxes( variants );
					STFR.font_picker.remove_checkboxes( subsets );

					// setup new font varaints and subsets
					STFR.font_picker.setup_checkboxes( currentFont, variants, subsets );

				});

				// listen for font fallbacks change
				fallback.on('blur', function(){

					if( $(this).val() == currentFont.fallback ) {
						return;
					}

					currentFont.fallback = $(this).val(); 
					currentFont.trigger('update-font');

				});
			});

		},

		/**
		 * Unbind all occurrences of font picker
		 * option inside the given context
		 * 
		 * @param Object context - jQuery object
		 */
		remove_from: function( context ) {

			if( _.isUndefined( context ) || _.isNull( context ) ) {
				return;
			}

			context.find('.stfr-font-picker').each( function(){
				
				$(this).data('cfont').off();
				$(this).find('.font-data').off();
				$(this).find('.font-fallback').off();

				STFR.font_picker.remove_checkboxes( $(this) );

			});

		},

		/**
		 * Setup font variants and subset checkboxes
		 * 
		 */
		setup_checkboxes: function( currentFont, variants_view, subsets_view ) {

			if( currentFont.type != 'google_font' ) {

				variants_view.hide();
				subsets_view.hide();

				return;
			}

			variants_view.show();
			subsets_view.show();

			variants_list = STFR.font_picker.variants_from_font( currentFont );
			subsets_list = STFR.font_picker.subsets_from_font( currentFont );

			// add variants and subsets
			if( ! _.isEmpty( variants_list ) ) {

				STFR.font_picker.add_checkboxes( variants_view, variants_list, currentFont );
			}

			if( ! _.isEmpty( subsets_list ) ) {
				
				STFR.font_picker.add_checkboxes( subsets_view, subsets_list, currentFont );
			}

		},

		/**
		 * Return array with variants objects 
		 * from given font object
		 * 
		 */
		variants_from_font: function( font ) {

			var variants = [],
				variant;

			if( _.isUndefined( font.variants ) ) {
				return variants;
			}

			_.each( font.variants, function(item){
				
				variant = {
					type: 'variant',
					label: item,
					lid: _.uniqueId('fnt-v-'),
					selected: ''
				}

				if( ! _.isUndefined( font.sel_variants ) &&
					$.inArray( item, font.sel_variants ) >= 0 ) {
					
					variant.selected = 'checked="checked"';
				}

				variants.push( variant );
			});

			return variants;
		},

		/**
		 * Return array with subsets objects 
		 * from given font object
		 * 
		 */
		subsets_from_font: function( font ) {

			var subsets = [],
				subset;

			if( _.isUndefined( font.subsets ) ) {
				return subsets;
			}

			_.each( font.subsets, function(item){
				
				subset = {
					type: 'subset',
					label: item,
					lid: _.uniqueId('fnt-s-'),
					selected: ''
				}

				if( ! _.isUndefined( font.sel_subsets ) &&
					$.inArray( item, font.sel_subsets ) >= 0 ) {
					
					subset.selected = 'checked="checked"';
				}

				subsets.push( subset );
			});

			return subsets;
		},

		/**
		 * Remove Checkboxes from given context
		 * 
		 */
		remove_checkboxes: function( context ) {

			context.find('input').each( function(){
				
				$(this).off();
				$(this).parent().remove();
			});
		},

		/**
		 * Append checkboxes to container
		 * 
		 */
		add_checkboxes: function( container, list, currentFont ) {

			var view;

			_.each( list, function( model ){

			 	view = new STFR.font_picker.Views.Checkbox({ model: model });

				container.append( view.render().$el );

				view.$el.find('input').on(
					'change',
					{ model: model, cfont: currentFont },
					STFR.font_picker.checkbox_change
				);

			});

		},

		/**
		 * Checkbox change callback
		 * 
		 */
		checkbox_change: function(e) {

			var isChecked = $(this).is(':checked');

			if( e.data.model.type == 'variant' ){

				// add new variant
				if( isChecked ) {
					
					e.data.cfont.sel_variants.push( e.data.model.label );
				
				} else {

					// remove variant
					var index = $.inArray( e.data.model.label, e.data.cfont.sel_variants );
					e.data.cfont.sel_variants.splice(index, 1);
				}

				e.data.cfont.trigger( 'update-font' );
			}

			if( e.data.model.type == 'subset' ){

				// add new subset
				if( isChecked ) {
				
					e.data.cfont.sel_subsets.push( e.data.model.label );
				
				} else {

					// remove subset
					var index = $.inArray( e.data.model.label, e.data.cfont.sel_subsets );
					e.data.cfont.sel_subsets.splice(index, 1);
				}

				e.data.cfont.trigger( 'update-font' );
			}
		},

		/**
		 * Set Selected Font Data
		 * 
		 */
		set_selected_font: function( currentFont, font, fallback ) {

			currentFont.family = font.family;
			currentFont.type = font.type;
			currentFont.category = font.category;
			currentFont.sel_variants = [];
			currentFont.sel_subsets = [];
			currentFont.fallback = font.category;
			currentFont.file = '';

			if( ! _.isNull( font.variants ) ) {
				currentFont.variants = font.variants;
			}

			if( ! _.isNull( font.subsets ) ) {
				currentFont.subsets = font.subsets;
			}

			if( ! _.isNull( font.file ) ) {

				currentFont.file = font.file;
			}

			fallback.val( currentFont.fallback );

			currentFont.trigger('update-font');
		},

		/**
		 * Update Font Preview
		 * 
		 */
		update_preview: function( preview, font ) {

			preview.css('font-family', font.family );

			if( font.type != 'system' ) {

				preview
					.find('.font-face')
						.attr('href', font.face );
			}
		},

		/*---------------------------*
		 * Views
		 *---------------------------*/
		Views: {

			init: function() {

				if( this.Checkbox != null ) {
					return;
				}

				var t_checkbox = '<input type="checkbox" id="<%= lid %>" <%= selected %>/>';
					t_checkbox += '<label class="stfr-label" for="<%= lid %>"><%= label %></label>';

				this.Checkbox = Backbone.View.extend({
					
					tagName: 'span',
					template: _.template( t_checkbox ),
					
					render: function() {

						this.$el.html( this.template( this.model ) );
						return this;
					}
				});
			},

			Checkbox: null
		}

	};

	/**
	 * Icon Picker
	 * 
	 */
	STFR.icon_picker = {

		/**
		 * Init each found instance of icon picker 
		 * option in the given context
		 * 
		 * @param Object context - jQuery object
		 */
		add_to: function( context ) {

			if( _.isUndefined( context ) || _.isNull( context ) ) {
				return;
			}

			context.find('.stfr-font-icon-picker').each( function(){

				var picker = $(this),
					field = picker.children('input').first(),
					preview = picker.find('.stfr-font-icon-preview > span');

				picker.on('icon-change', function( e ){
					
					preview.removeClass( field.val() );

					picker.find('.stfr-font-icon.is-active')
							.removeClass('is-active');
					
					e.caller.addClass('is-active');
					field.val( e.name );

					preview.addClass( e.name );
				});

				$(this).find('.stfr-font-icon').each( function(){

					$(this).on('click', function(){

						var name = $(this).attr('data-name');
						
						picker.trigger( { type: 'icon-change', caller: $(this), name: name } );
						
					});
				});

			});

		},

		/**
		 * Unbind all occurrences of icon picker
		 * option inside the given context
		 * 
		 * @param Object context - jQuery object
		 */
		remove_from: function( context ) {

			if( _.isUndefined( context ) || _.isNull( context ) ) {
				return;
			}

			context.find('.stfr-font-icon-picker').each( function(){
				
				$(this).off();
				
				$(this).find('.stfr-font-icon').each( function(){

					$(this).off();
				});
			});
		}

	};

	// Initialize
	STFR.init();

});
