/*--------------------------------------
 * SixthType Reviews Admin Page
 *
 * @version  1.0
 --------------------------------------*/

/**
 * Document Ready
 * 
 */
jQuery(document).ready( function($){

	window.STRW_PAGE = {};

	/**
	 * Defaults
	 * 
	 */
	STRW_PAGE.def = {
		form: $('#st-plugin-settings-form'),
		menu: $('.stfr-page-menu'),
		save_button: $('.st-plugin-save-settings'),
		groups: $('.group'),
		current_group: null	
	};

	/**
	 * INIT
	 * 
	 */
	STRW_PAGE.init = function() {

		STRW_PAGE.def.current_group = STRW_PAGE.def.groups.first();
	 	STRW_PAGE.def.current_group.show();
		STRW_PAGE.def.current_group.addClass('current-group');

		// set first menu btn to active
		STRW_PAGE.def.menu.find('li:first').addClass('current');
		
		// handle menu clicks
		STRW_PAGE.def.menu.find('a').click( function(e) {
			
			e.preventDefault();
			
			var new_group = $( '#' + $(this).attr('id') ) ;
			
			if( $(this).parent().hasClass('current') ) {
				return;
			}

			STRW_PAGE.def.menu.find('li.current').removeClass('current');
			
			$(this).parent().addClass('current');
			
			STRW_PAGE.def.current_group.hide();
			STRW_PAGE.def.current_group = new_group;
			STRW_PAGE.def.current_group.removeClass('hidden');
			STRW_PAGE.def.current_group.fadeIn(200);

		});

		STRW_PAGE.def.save_button.click( STRW_PAGE.save_plugin_options );
	};

	/**
	 * Save Plugin Options
	 * 
	 */
	STRW_PAGE.save_plugin_options = function(e) {

		e.preventDefault();

		STRW_PAGE.def.save_button.prop('disabled', true);

		$.ajax({
			type: 'post',
	        url: ajaxurl,
	        data: { 
	        	action: 'st_review_save_settings',
	        	st_reviews_form_data: STRW_PAGE.def.form.serialize(),
	        	nonce: STRW_PAGE_l10n.nonce
	        },
	        success: function(data) {

				STFR.show_notification( data );
				STRW_PAGE.def.save_button.prop('disabled', false);	
	        }
		});
		
	};

	STRW_PAGE.init();

});