<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 *	
 * Plugin Settings Page
 *
 * @version  1.0
 * @since    1.0
 * @author   SixthType <hello@sixthtype.com>
 * @link     http://themeforest.net/user/SixthType
 *
 */

$st_reviews_options_view = SixthType_Options_View::get_instance();
$st_reviews = SixthType_Reviews::get_instance();
$st_reviews_settings = st_reviews_get_plugin_options();

?>

<form method="post" id="st-plugin-settings-form">

	<div class="stfr-page-wrap">
		
		<div class="stfr-page-header">
			
			<h2 class="title"><?php echo esc_html( __( 'SixthType Reviews', 'sixthtype-reviews' ) ); ?></h2>
			<p class="description">
				<?php echo esc_html( __( 'Version:', 'sixthtype-reviews' ) )  . ' ' . ST_REVIEWS_VERSION; ?> 
				/ <a href="http://www.sixthtype.com/knowledge-base/" target="_blank" title="<?php echo esc_attr( __( 'Knowledge Base', 'sixthtype-reviews' ) ); ?>">
					<?php echo esc_html( __( 'Knowledge Base', 'sixthtype-reviews' ) ); ?>
				</a> 
				/ <a href="http://www.sixthtype.com/support/" target="_blank" title="<?php echo esc_attr( __( 'Support', 'sixthtype-reviews' ) ); ?>">
					<?php echo esc_html( __( 'Support', 'sixthtype-reviews' ) ); ?>
				</a>
			</p>

		</div>

		<div class="stfr-page-content-wrap">
			
			<div class="stfr-options-view stfr-page-content theme-options plugin-options">
				<?php $st_reviews_options_view->generate_page_options( $st_reviews_settings, $st_reviews->get_settings() ); ?>
				</div>
			</div>

			<div class="stfr-page-sidebar">
				<ul class="stfr-page-menu">
					<?php echo $st_reviews_options_view->get_menu(); ?>
				</ul>
				<div class="stfr-clear"></div>
			</div>

		</div>

		<div class="stfr-toolbar">
			
			<input type="submit" class="st-plugin-save-settings button button-primary stfr-right" value="<?php echo esc_attr( __( 'Save Changes', 'sixthtype-reviews' ) ); ?>"/>
			
			<div class="stfr-clear"></div>
		</div>

	</div>

</form>
