<?php
	
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>
<!-- # SixthType Reviews Templates -->

<!-- Criteria -->
<script type="text/html" id="st-reviews-tmpl-criteria">
	
	<span class="name"><%= _.escape( name ) %></span>
	<div class="strw-controls">
		<a href="#" title="<?php _e( 'Edit Criteria Settings', 'sixthtype-reviews' ); ?>">
			<span class="strw-control-icon strw-edit-icon stfr-left"></span>
		</a>
		<a href="#" title="<?php _e( 'Delete Criteria', 'sixthtype-reviews' ); ?>">
			<span class="strw-control-icon strw-delete-icon stfr-left"></span>
		</a>
	</div>
	<input type="hidden" name="strw_criteria[]" value="<%= _.escape( JSON.stringify( { "name": name, "options": options } ) ) %>"/>
	

</script>

<!-- No Criteria -->
<script type="text/html" id="st-reviews-tmpl-no-criteria">
	<span><?php echo esc_html( __( 'No review criteria found!', 'sixthtype-reviews' ) ); ?></span>
</script>

<!-- Edit Criteria -->
<script type="text/html" id="st-reviews-tmpl-edit-criteria">
	
	<div class="media-modal wp-core-ui strw-edit-frame">
		
		<a class="media-modal-close" href="#" title="Close">
			<span class="media-modal-icon"></span>
		</a>

		<div class="media-modal-content">
			<div class="media-frame hide-menu">

				<div class="media-frame-title">
					
					<h1><?php _e( 'Edit Criteria Settings', 'sixthtype-reviews' ); ?></h1>
					
					<div class="loader">
						<img src="<?php echo ST_REVIEWS_URI . 'admin/images/ajax-loader.gif'; ?>" alt="Loader"/>
					</div>
					<div class="stfr-clear"></div>

				</div>
				
				<form id="strw-criteria-options-form" method="post" action="post.php">
					<div class="media-frame-content strw-criteria-options"></div>
				</form>

				<div class="media-frame-toolbar">
					<div class="media-toolbar">
						<div class="media-toolbar-primary">
							<a href="#" class="button media-button button-primary button-large button-save">
								<?php _e( 'Save Changes', 'sixthtype-reviews' ); ?>
							</a>
						</div>
					</div>
				</div>

			</div>
		</div>

	</div>
	<div class="media-modal-backdrop"></div>

</script>

<!-- Criteria Field -->
<script type="text/html" id="st-reviews-tmpl-field">
	
	<span class="name"><%= _.escape( name ) %></span>
	<div class="strw-controls">
		<a href="#" title="<?php _e( 'Delete Field', 'sixthtype-reviews' ); ?>">
			<span class="strw-control-icon strw-delete-icon stfr-left"></span>
		</a>
	</div>
	<input type="hidden" name="strw_criteria_field[]" value="<%= _.escape( name ) %>"/>
	
</script>

<!-- No Criteria Fields -->
<script type="text/html" id="st-reviews-tmpl-no-fields">
	<span><?php echo esc_html( __( 'No rating fields found!', 'sixthtype-reviews' ) ); ?></span>
</script>

<!-- Selected Criteria Score Field -->
<script type="text/html" id="st-reviews-tmpl-sc-field">
	
	<span class="name"><%= _.escape( name ) %></span>
	
	<input type="text" id="<%= _.escape( uid ) %>" class="stfr-input small stfr-ui-slider-field" value="<%= _.escape( score ) %>">
	<div data-value="<%= _.escape( score ) %>" data-field="<%= _.escape( uid ) %>" data-min="<%= _.escape( minScore ) %>" data-max="<%= _.escape( maxScore ) %>" data-step="<%= _.escape( scoreStep ) %>" class="stfr-ui-slider">
		<span class="ui-slider-handle"></span>
	</div>
	<div class="stfr-clear"></div>
	
</script>

<!-- Selected Criteria Score Data -->
<script type="text/html" id="st-reviews-tmpl-sc-data">
	<div class="strw-field-data-wrap">
		<input type="hidden" name="strw_criteria_score_field[]" value="<%= _.escape( JSON.stringify( { "name": name, "score": score } ) ) %>"/>
	</div>
</script>

<!-- Selected Criteria No Score Fields -->
<script type="text/html" id="st-reviews-tmpl-sc-no-fields">
	<span><?php echo esc_html( __( 'This review criteria does not have any rating fields.', 'sixthtype-reviews' ) ); ?></span>
</script>