<?php

/**
 * Plugin Name: SixthType Reviews 
 * Plugin URI: http://www.persianscript.ir/
 * Description: دانلود از پرشین اسکریپت.
 * Version: 1.0
 * Author: پرشین اسکریپت
 * Author URI: http://www.persianscript.ir
 * Requires: WordPress 3.5+
 * 
 * Text Domain: sixthtype-reviews
 * Domain Path: languages
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if( ! class_exists( 'SixthType_Reviews_Loader' ) ) :

/**
 *
 * SixthType Reviews Loader
 *
 * @version  1.0
 * @since 	 1.0
 * @package  SixthType-Reviews
 * @author 	 SixthType <hello@sixthtype.com>
 */
class SixthType_Reviews_Loader {

	/**
	 * Constructor
	 *
	 * @access  public
	 * @since  	1.0
	 */
	public function __construct() {
		
		add_action( 'init', array( &$this, 'init_plugin' ) );
		register_activation_hook( __FILE__, array( &$this, 'plugin_activation' ) );
	}

	/**
	 * Plugin Activation
	 *
	 * Called after plugin activation to set default plugin settings
	 *
	 * @access  public
	 * @since   1.0 
	 */
	public function plugin_activation() {

		$this->set_constants();
		
		require_once( ST_REVIEWS_ROOT . 'includes/sixthtype-reviews-settings.php' );
		require_once( ST_REVIEWS_ROOT . 'includes/class-sixthtype-reviews.php' );
		require_once( ST_REVIEWS_ROOT . 'includes/class-sixthtype-plugin-settings.php' );
		
		$settings = get_option( SixthType_Reviews::SETTINGS_KEY );

		if( isset( $settings ) && ! empty( $settings ) ) {
			return;
		}

		$plugin_options = st_reviews_get_plugin_options();

		$plugin_settings = new SixthType_Plugin_Settings();
		$plugin_settings->reset_settings( $plugin_options, SixthType_Reviews::SETTINGS_KEY );
		
		$css = st_reviews_generate_score_css();
		$plugin_settings->add_setting( 'strw_css', $css, SixthType_Reviews::SETTINGS_KEY );
	}

	/**
	 * Plugin Initialization
	 *
	 * @access  public
	 * @since   1.0
	 */
	public function init_plugin() {

		$this->set_constants();
		$this->load_text_domain();
		$this->load_files();
		
		if( is_admin() ) {

			$options = new SixthType_Reviews_Options();
			$admin = new SixthType_Reviews_Admin();
			$meta_box = SixthType_Meta_Box::get_instance();
		}

		$reviews = SixthType_Reviews::get_instance();
	}

	/**
	 * Set Constants
	 *
	 * @access 	private
	 * @since 	1.0
	 */
	private function set_constants() {

		define( 'ST_REVIEWS_VERSION', '1.0' );
		define( 'ST_REVIEWS_ROOT', plugin_dir_path( __FILE__ ) );
		define( 'ST_REVIEWS_URI', plugin_dir_url( __FILE__ ) );
	}

	/**
	 * Load Text Domain
	 * 
	 * @access 	private
	 * @since 	1.0
	 */
	private function load_text_domain() {

		load_plugin_textdomain( 'sixthtype-reviews', false, ST_REVIEWS_ROOT . 'languages/' );
	}

	/**
	 * Load Files
	 *
	 * @access 	private
	 * @since 	1.0
	 */
	private function load_files() {

		require_once( ST_REVIEWS_ROOT . 'templates/sixthtype-reviews-templates.php' );
		require_once( ST_REVIEWS_ROOT . 'includes/sixthtype-reviews-functions.php' );
		require_once( ST_REVIEWS_ROOT . 'includes/class-sixthtype-reviews.php' );
		
		if( is_admin() ) {

			require_once( ST_REVIEWS_ROOT . 'admin/class-sixthtype-reviews-admin.php' );
			require_once( ST_REVIEWS_ROOT . 'includes/sixthtype-reviews-settings.php' );
			require_once( ST_REVIEWS_ROOT . 'includes/class-sixthtype-reviews-options.php' );
			require_once( ST_REVIEWS_ROOT . 'includes/class-sixthtype-meta-box.php' );
			require_once( ST_REVIEWS_ROOT . 'includes/class-sixthtype-options-view.php' );
			require_once( ST_REVIEWS_ROOT . 'includes/class-sixthtype-validator.php' );
			require_once( ST_REVIEWS_ROOT . 'includes/class-sixthtype-plugin-settings.php' );
			require_once( ST_REVIEWS_ROOT . 'includes/class-sixthtype-utilities.php' );
		}
	}
}

$stfr_plugin_reviews = new SixthType_Reviews_Loader();

endif; // end class exists check

?>