<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if( ! class_exists( 'SixthType_Utilities' ) ) :

/**
 * SixthType Utilities
 *
 * Contains static utilities methods for Sennz Framework
 *
 * @static
 * @version 	1.0
 * @since 		1.0
 * @package 	SixthType-Framework/Includes
 * @author 		SixthType <hello@sixthtype.com>
 */
class SixthType_Utilities {

	/**
	 * Get KSES Allowed Tags
	 *
	 * Adds custom allowed tags to wp kses default ones
	 *
	 * @static
	 * @access 	public
	 * @since  	1.0
	 * @return 	array
	 */
	public static function get_kses_allowed_tags() {

		global $allowedposttags;

		$custom_allowed_tags = array();
		
		// iframe
		$custom_allowed_tags['iframe'] = array( 
			'src' => array(),
			'width' => array(),
			'height' => array(),
			'allowfullscreen' => array()
		);

		return array_merge( $custom_allowed_tags, $allowedposttags);
	}

	/**
	 * Get Fonts
	 *
	 * Returns an array with system fonts, Google web fonts and
	 * if available, custom fonts. 
	 *
	 * @static
	 * @access 	public
	 * @since  	1.0
	 * @return 	array
	 */
	public static function get_fonts() {

		$fonts = array();
		$google_fonts_url = 'https://www.googleapis.com/webfonts/v1/webfonts?key=';
		$google_fonts_api_key = 'AIzaSyDnvzLU4Z9ze_Y_e4T9Wd22nNGIvtIvETU';
		$google_fonts = get_transient( 'stfr_tr_google_fonts' );

		// Google Web Fonts
		if( empty( $google_fonts ) ) {

			$google_fonts = array();
			$response = wp_remote_get( $google_fonts_url . $google_fonts_api_key );

			if( ! is_wp_error( $response ) ) {
				
				$fonts_list = json_decode( $response['body'] );

				foreach( $fonts_list->items as $font ) {
					
					$font_item = array(
						'family' => $font->family,
						'category' => $font->category,
						'variants' => $font->variants,
						'subsets' => $font->subsets,
						'type' => 'google_font',
					);

					$font_item['face'] = SixthType_Utilities::get_font_face( $font_item );
					$google_fonts[] = $font_item;
				}

				if( ! empty( $google_fonts ) ) {

					set_transient( 'stfr_tr_google_fonts', $google_fonts, WEEK_IN_SECONDS );
				}
			}
		}

		// System fonts
		$system_fonts = array(
			
			/* Arial */
			array(
				'family' => 'Arial',
				'category' => 'sans-serif',
				'type' => 'system'
			),

			/* Tahoma */
			array(
				'family' => 'Tahoma',
				'category' => 'sans-serif',
				'type' => 'system'
			),

			/* Verdana */
			array(
				'family' => 'Verdana',
				'category' => 'sans-serif',
				'type' => 'system'
			),

			/* Helvetica */
			array(
				'family' => 'Helvetica',
				'category' => 'sans-serif',
				'type' => 'system'
			),

			/* Helvetica Neue */
			array(
				'family' => 'Helvetica Neue',
				'category' => 'sans-serif',
				'type' => 'system'
			),

			/* Helvetica Neue Light */
			array(
				'family' => 'Helvetica Neue Light',
				'category' => 'sans-serif',
				'type' => 'system'
			),

			/* Georgia */
			array(
				'family' => 'Georgia',
				'category' => 'serif',
				'type' => 'system'
			),

			/* Times New Roman */
			array(
				'family' => 'Times New Roman',
				'category' => 'serif',
				'type' => 'system'
			),

			/* "Courier New */
			array(
				'family' => 'Courier New',
				'category' => 'monospace',
				'type' => 'system'
			)
		);
			
		// Custom fonts
		$custom_fonts = apply_filters( 'stfr_custom_fonts', array() );

		$fonts['System-Fonts'] = $system_fonts;
		$fonts['Google-Web-Fonts'] = $google_fonts;
		$fonts['Custom-Fonts'] = $custom_fonts;

		return $fonts;
	}

	/**
	 * Get Font Face
	 *
	 * @static
	 * @access 	public
	 * @since  	1.0
	 * @param   array $font
	 * @return 	string
	 */
	public static function get_font_face( $font ) {

		if( ! is_array( $font ) || ! isset( $font['type'] ) ) {
			return '';
		}

		if( $font['type'] == 'google_font' ) {

			$google_font_url = '//fonts.googleapis.com/css?family=';
			$protocol = is_ssl() ? 'https:' : 'http:';
			$font_family = str_replace( ' ', '+', $font['family'] );

			return $protocol . $google_font_url . $font_family;
		}

		return '';
	}

	/**
	 * Get Icon Font Icons
	 *
	 * @static
	 * @access 	public
	 * @since  	1.0
	 * @param   array $font_css_file
	 * @param   string $icons_prefix (optional)
	 * @return 	array/WP_Error
	 */
	public static function get_font_css_icons( $font_css_file, $icons_prefix = 'fa' ) {

		WP_Filesystem();
		
		global $wp_filesystem;
		
		if( ! $wp_filesystem->exists( $font_css_file ) ) {

			return new WP_Error( 
				'stfr_util',
				__( 'Icon font CSS file does not exists!', 'sixthtype-framework' )
			);
		}

		$content = $wp_filesystem->get_contents( $font_css_file );

		if( ! $content ) {

			return new WP_Error( 
				'stfr_util',
				__( 'There was an error while reading the font CSS file!', 'sixthtype-framework' )
			);
		}

		$icons_list = array();
		$pattern = '/\.(' . $icons_prefix . '-(?:\w+(?:-)?)+):before/';
		
		preg_match_all( $pattern, $content, $icons, PREG_SET_ORDER );

		foreach( $icons as $icon ) {
            
            $icons_list[] = $icon[1];
        }

        return $icons_list;
	}

	/**
	 * Returns An Array With Terms.
	 * Used To Select A Term From Select Option List.
	 * 
	 * @static
	 * @access  public
	 * @since   1.0
	 * @param   string $term_name
	 * @param   array $args (optional)
	 * @return  array
	 */
	public static function get_select_term_list( $term_name, $args = array() ) {

		$terms = get_terms( $term_name, $args );
		$terms_list = array(
			array(
				'value' => 'recent',
				'label' => __( 'Recent Posts', 'sixthtype-framework' )
			)
		);

		if( ! is_wp_error( $terms ) ) {

			foreach( $terms as $term ) {
				
				$terms_list[] = array(
					'value' => $term->term_id,
					'label' => $term->name
				);
			}
		}

		return $terms_list;
	}
}

endif; // end class exists check

?>