<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * SixthType Reviews Settings
 *
 * @package  SixthType-Reviews/Includes
 * @author 	 SixthType <hello@sixthtype.com>
 * @version  1.0
 * @since 	 1.0
 */

/**
 * Get Plugin Options
 *
 * @version  1.0
 * @since 	 1.0
 * @return   array
 */
function st_reviews_get_plugin_options() {

	$post_types_list = array();
	$exclude_post_types = array( 'attachment', 'revision', 'nav_menu_item' );
	$post_types = get_post_types();

	foreach ( $post_types as $post_type ) {
		
		if( ! in_array( $post_type, $exclude_post_types ) ) {

			$post_types_list[] = array( 'value' => $post_type, 'label' => $post_type );
		}
	}

	$maximum_score_list = array(
		array( 'value' => 3, 'label' => '3' ),
		array( 'value' => 5, 'label' => '5' ),
		array( 'value' => 10, 'label' => '10' )
	);

	$reviews_style = array(
		'st-classic' => ST_REVIEWS_URI . 'admin/images/templates/classic.png',
		'st-classic-right' => ST_REVIEWS_URI . 'admin/images/templates/classic-right.png',
		'st-stars' => ST_REVIEWS_URI . 'admin/images/templates/stars.png',
		'st-stars-right' => ST_REVIEWS_URI . 'admin/images/templates/stars-right.png',
		'st-circles' => ST_REVIEWS_URI . 'admin/images/templates/circles.png',
		'st-classic-bold' => ST_REVIEWS_URI . 'admin/images/templates/classic-bold.png',
		'st-classic-clean' => ST_REVIEWS_URI . 'admin/images/templates/classic-clean.png'
	);

	$reviews_style = apply_filters( 'st_reviews_reviews_style_list', $reviews_style );

	$settings = array();

	////////////////////////////
	// Reviews Criteria
	////////////////////////////
	$settings[] = array( 
		'title' => __( 'Reviews Criteria', 'sixthtype-reviews' ),
		'id' => 'strw_heading_criteria',
		'desc' => __( 'Here you can create, edit and delete your reviews criteria.', 'sixthtype-reviews' ),
		'default' => '',
		'type' => 'heading'
	);

	// Add Reviews Criteria
	$settings[] = array(
		'title' => __( 'Manage Review Criteria', 'sixthtype-reviews' ),
		'id' => 'strw_reviews_criteria',
		'desc' => __( 'Use unique name for each review criteria. Each criteria can have its own
					   set of rating fields. After you create one, click on wrench icon to edit
					   criteria options.', 'sixthtype-reviews' ),
		'default' => '',
		'class' => 'strw-create-criteria',
		'options' => array(),
		'type' => 'create_reviews_criteria',
		'validate_hook' => 'st_reviews_validate_create_criteria'
	);

	////////////////////////////
	// Reviews Settings
	////////////////////////////
	$settings[] = array( 
		'title' => __( 'Reviews Settings', 'sixthtype-reviews' ),
		'id' => 'strw_heading_settings',
		'desc' => __( 'Here you can change global reviews settings.', 'sixthtype-reviews' ),
		'default' => '',
		'type' => 'heading'
	);

	// Review Post Types
	$settings[] = array(
		'title' => __( 'Review Post Types', 'sixthtype-reviews' ),
		'id' => 'strw_review_post_types',
		'desc' => __( 'Choose which post types should have reviews.', 'sixthtype-reviews' ),
		'default' => array( 'post' ),
		'class' => 'stfr-checkboxes-label',
		'options' => $post_types_list,
		'type' => 'checkboxes'
	);

	// Select
	$settings[] = array( 
		'title' => __( 'Maximum Score', 'sixthtype-reviews' ),
		'id' => 'strw_max_score',
		'desc' => __( 'Select your reviews maximum score. Please, note that if you change 
					   maximum score when you have review posts, you will have to rate each 
					   review post again to affect  the change.', 'sixthtype-reviews' ),
		'default' => 10,
		'class' => 'stfr-select',
		'options' => $maximum_score_list,
		'type' => 'select'
	);

	// Disable Review Shortcode
	$settings[] = array( 
		'title' => __( 'Disable Review Shortcode', 'sixthtype-reviews' ),
		'id' => 'strw_disable_shortcode',
		'desc' => __( 'Toggle on to disable review shortcode.
					   Handy if you used the shortcode inside posts, but your new theme supports 
					   SixthType Reviews and now it shows up duplicate review scores.', 'sixthtype-reviews' ),
		'default' => 'off',
		'class' => 'stfr-switch-toggle',
		'type' => 'switch_toggle'
	);

	////////////////////////////
	// Reviews Style
	////////////////////////////
	$settings[] = array( 
		'title' => __( 'Reviews Style', 'sixthtype-reviews' ),
		'id' => 'strw_heading_style',
		'desc' => __( 'Here you can change reviews style and look.', 'sixthtype-reviews' ),
		'default' => '',
		'type' => 'heading'
	);

	// Select Reviews Style
	$settings[] = array(
		'title' => __( 'Select Reviews Style', 'sixthtype-reviews' ),
		'id' => 'strw_reviews_style',
		'desc' => __( 'Select your reviews style. To learn how to add your own styles
					   visit our Knowledge Base.', 'sixthtype-reviews' ),
		'default' => 'st-classic',
		'class' => 'stfr-select-image-option',
		'options' => $reviews_style,
		'type' => 'select_image_option'
	);

	// Rating Bar Background Color
	$settings[] = array( 
		'title' => __( 'Rating Bar Color', 'sixthtype-reviews' ),
		'id' => 'strw_bar_color',
		'desc' => __( 'Change rating bar background color, used in some review styles.', 'sixthtype-reviews' ),
		'default' => 'eaeaea',
		'class' => 'stfr-input small stfr-color-picker',
		'type' => 'color_picker'
	);

	// High Score Color
	$settings[] = array( 
		'title' => __( 'High Score Color', 'sixthtype-reviews' ),
		'id' => 'strw_high_color',
		'desc' => __( 'Set background color for high score.', 'sixthtype-reviews' ),
		'default' => '01ad9c',
		'class' => 'stfr-input small stfr-color-picker',
		'type' => 'color_picker'
	);

	// High Score Text Color
	$settings[] = array( 
		'title' => __( 'High Score Text Color', 'sixthtype-reviews' ),
		'id' => 'strw_high_txt_color',
		'desc' => __( 'Set high score review text color.', 'sixthtype-reviews' ),
		'default' => 'ffffff',
		'class' => 'stfr-input small stfr-color-picker',
		'type' => 'color_picker'
	);

	// Semi-High Score Color
	$settings[] = array( 
		'title' => __( 'Semi-High Score Color', 'sixthtype-reviews' ),
		'id' => 'strw_semi_high_color',
		'desc' => __( 'Set background color for semi-high score.', 'sixthtype-reviews' ),
		'default' => '27b9ab',
		'class' => 'stfr-input small stfr-color-picker',
		'type' => 'color_picker'
	);

	// Semi-High Score Text Color
	$settings[] = array( 
		'title' => __( 'Semi-High Score Text Color', 'sixthtype-reviews' ),
		'id' => 'strw_semi_high_txt_color',
		'desc' => __( 'Set semi-high score review text color.', 'sixthtype-reviews' ),
		'default' => 'ffffff',
		'class' => 'stfr-input small stfr-color-picker',
		'type' => 'color_picker'
	);

	// Medium Score Color
	$settings[] = array( 
		'title' => __( 'Medium Score Color', 'sixthtype-reviews' ),
		'id' => 'strw_medium_color',
		'desc' => __( 'Set background color for medium score.', 'sixthtype-reviews' ),
		'default' => '4dc5ba',
		'class' => 'stfr-input small stfr-color-picker',
		'type' => 'color_picker'
	);

	// Medium Score Text Color
	$settings[] = array( 
		'title' => __( 'Medium Score Text Color', 'sixthtype-reviews' ),
		'id' => 'strw_medium_txt_color',
		'desc' => __( 'Set medium score review text color.', 'sixthtype-reviews' ),
		'default' => 'ffffff',
		'class' => 'stfr-input small stfr-color-picker',
		'type' => 'color_picker'
	);

	// Semi Low Score Color
	$settings[] = array( 
		'title' => __( 'Semi-Low Score Color', 'sixthtype-reviews' ),
		'id' => 'strw_semi_low_color',
		'desc' => __( 'Set background color for semi-low score.', 'sixthtype-reviews' ),
		'default' => '74d2c9',
		'class' => 'stfr-input small stfr-color-picker',
		'type' => 'color_picker'
	);

	// Semi Low Score Text Color
	$settings[] = array( 
		'title' => __( 'Semi-Low Score Text Color', 'sixthtype-reviews' ),
		'id' => 'strw_semi_low_txt_color',
		'desc' => __( 'Set semi-low score review text color.', 'sixthtype-reviews' ),
		'default' => 'ffffff',
		'class' => 'stfr-input small stfr-color-picker',
		'type' => 'color_picker'
	);

	// Low Score Color
	$settings[] = array( 
		'title' => __( 'Low Score Color', 'sixthtype-reviews' ),
		'id' => 'strw_low_color',
		'desc' => __( 'Set background color for low score.', 'sixthtype-reviews' ),
		'default' => '99ded7',
		'class' => 'stfr-input small stfr-color-picker',
		'type' => 'color_picker'
	);

	// Low Score Text Color
	$settings[] = array( 
		'title' => __( 'Low Score Text Color', 'sixthtype-reviews' ),
		'id' => 'strw_low_txt_color',
		'desc' => __( 'Set low score review text color.', 'sixthtype-reviews' ),
		'default' => 'ffffff',
		'class' => 'stfr-input small stfr-color-picker',
		'type' => 'color_picker'
	);

	return apply_filters( 'st_reviews_settings', $settings );
}

/**
 * Get Reviews Meta Box Options
 * 
 * @version  1.0
 * @since 	 1.0
 * @return   array
 */
function st_reviews_get_meta_box_options() {

	$st_reviews = SixthType_Reviews::get_instance();
	$criteria = $st_reviews->get_setting( 'strw_reviews_criteria' );

	$options = array();

	// Review Options
	$options[] = array( 
		'title' => __( 'Review', 'sixthtype-reviews' ),
		'id' => 'st_heading_settings',
		'desc' => __( 'Here you can change review options.', 'sixthtype-reviews' ),
		'default' => '',
		'type' => 'heading'
	);

	// Select Review Criteria
	$options[] = array(
		'title' => __( 'Select Review Criteria', 'sixthtype-reviews' ),
		'id' => 'sixthtype_review_selected_criteria',
		'desc' => __( 'Once you select review criteria, the criteria rating fields will show up below.
					   Then you can change each rating field score using the sliders.
					   If you want to remove the review from this post, choose "Select Review Criteria"
					   option and update your post.', 'sixthtype-reviews' ),
		'default' => '',
		'class' => '',
		'options' => $criteria,
		'type' => 'select_review_criteria',
		'validate_hook' => 'st_reviews_validate_select_criteria'
	);

	// Review Conclusion
	$options[] = array( 
		'title' => __( 'Review Conclusion', 'sixthtype-reviews' ),
		'id' => 'sixthtype_review_conclusion',
		'desc' => __( 'Write here your review conclusion text. 
					   It will appear below the review score.', 'sixthtype-reviews' ),
		'default' => '',
		'class' => 'stfr-editor',
		'options' => null,
		'type' => 'editor'
	);

	// Review Shortcode
	$options[] = array(
		'title' => __( 'Review Shortcode', 'sixthtype-reviews' ),
		'id' => 'sixthtype_review_shortcode',
		'desc' => __( 'If your current theme does not support SixthType Reviews,
					  use the following shortcode to display this post review:', 'sixthtype-reviews' ),
		'default' => '',
		'class' => 'stfr-input strw-shortcode-field',
		'type' => 'review_shortcode'
	);

	return apply_filters( 'st_reviews_meta_box_options', $options );
}

/**
 * Get Criteria Options
 * 
 * @version  1.0
 * @since 	 1.0
 * @return   array
 */
function st_reviews_get_criteria_options() {

	$options = array();

	// Add Criteria Fields
	$options[] = array(
		'title' => __( 'Manage Criteria Rating Fields', 'sixthtype-reviews' ),
		'id' => 'strw_criteria_fields',
		'desc' => __( 'Here you can add, delete and rearrange rating fields.
					   Use unique name for each rating field.
					   To rearrange fields use drag and drop.', 'sixthtype-reviews' ),
		'default' => '',
		'class' => 'strw-criteria-fields',
		'options' => array(),
		'type' => 'review_criteria_fields',
		'validate_hook' => 'st_reviews_validate_criteria_fields'
	);

	return apply_filters( 'st_reviews_criteria_options', $options );
}

/**
 * Get Review Criteria Data
 *
 * @version  1.0
 * @since    1.0
 * @return   array
 */
function st_reviews_get_criteria_data() {

	$st_reviews = SixthType_Reviews::get_instance();
	$criteria = $st_reviews->get_criteria();
	$reviews_criteria_data = array();

	foreach ( $criteria as $criteria_data ) {
			
		if( ! isset( $criteria_data['name'] ) ||
			! isset( $criteria_data['options'] ) ||
			! isset( $criteria_data['options']['strw_criteria_fields'] ) ) {
			
			continue;
		}

		$fields = array();
		$criteria_data_fields = $criteria_data['options']['strw_criteria_fields'];
		
		unset( $criteria_data['options']['strw_criteria_fields'] );

		$reviews_criteria_data[] = array(
			'name' => $criteria_data['name'],
			'fields' => $criteria_data_fields,
			'options' => $criteria_data['options']
		);
	}

	return $reviews_criteria_data;
}

/**
 * Generates Score CSS From Plugin Style Settings
 *
 * @version  1.0
 * @since    1.0
 * @return   string - generated CSS
 */
function st_reviews_generate_score_css() {

	$st_reviews = SixthType_Reviews::get_instance();
	$score_css = '';
	$current_class = '';
	
	$css_options = array(
		
		// Bar Background Color
		array(
			'id' => 'strw_bar_color',
			'class' => '.strw-bar',
			'property' => 'background-color: #'
		),

		// Low
		array(
			'id' => 'strw_low_color',
			'class' => '.strw-low',
			'property' => 'background-color: #'
		),
		
		array(
			'id' => 'strw_low_txt_color',
			'class' => '.strw-low',
			'property' => 'color: #'
		),

		// Semi-Low
		array(
			'id' => 'strw_semi_low_color',
			'class' => '.strw-semi-low',
			'property' => 'background-color: #'
		),
		
		array(
			'id' => 'strw_semi_low_txt_color',
			'class' => '.strw-semi-low',
			'property' => 'color: #'
		),

		// Medium
		array(
			'id' => 'strw_medium_color',
			'class' => '.strw-medium',
			'property' => 'background-color: #'
		),
		
		array(
			'id' => 'strw_medium_txt_color',
			'class' => '.strw-medium',
			'property' => 'color: #'
		),

		// Semi-High
		array(
			'id' => 'strw_semi_high_color',
			'class' => '.strw-semi-high',
			'property' => 'background-color: #'
		),
		
		array(
			'id' => 'strw_semi_high_txt_color',
			'class' => '.strw-semi-high',
			'property' => 'color: #'
		),

		// High
		array(
			'id' => 'strw_high_color',
			'class' => '.strw-high',
			'property' => 'background-color: #'
		),
		
		array(
			'id' => 'strw_high_txt_color',
			'class' => '.strw-high',
			'property' => 'color: #'
		)
	);
		
	foreach( $css_options as $option ) {
			
		$value = $st_reviews->get_setting( $option['id'] );

		if( $current_class != $option['class'] ) {
			
			// close current css class
			if( $score_css != '' ) {
				
				$score_css .= '}';
			}

			$current_class = $option['class'];
			$score_css .= $current_class . '{';
		}

		$score_css .= $option['property'] . $value . ';';
	}

	// close last css class
	if( $score_css != '' ) {

		$score_css .= '}';
	}

	return sprintf( '/* SixthType Reviews Score */%s%s', PHP_EOL, $score_css );
}

/**
 * Get Review Shortcode Options
 *
 * @version  1.0
 * @since    1.0
 * @return   array
 */
function st_reviews_shortcode_options() {

	$options = array();
	$post_id = 1;

	if( class_exists( 'SixthType_Framework' ) ) {

		$framework = SixthType_Framework::get_instance(); 
		$current_post_id = $framework->get_var( 'post_id' );

		if( $current_post_id != null ) {

			$post_id = $current_post_id;
		}
	}	

	// Review post ID
	$options[] = array( 
		'title' => __( 'Review Post ID', 'sixthtype-reviews' ),
		'id' => 'post_id',
		'desc' => __( 'Type here the review post ID.
					   Note: Do not mix reviews inside review post as
					   it will result to false microformat data. Use non 
					   review post/page to display multiple reviews.', 'sixthtype-reviews' ),
		'default' => $post_id,
		'class' => 'stfr-input small',
		'type' => 'text'
	);

	return $options;
}
