<?php

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;


/**
 * Admin Class
 *
 * Handles generic Admin functionality and AJAX requests.
 *
 * @package Social Auto Poster
 * @since 1.0.0
 */
class Wpw_Auto_Posting_AdminPages {

	var $scripts, $model, $render, $message,
		$fbposting, $twposting, $liposting;
	
	public function __construct() {		
	
		global $wpw_auto_poster_scripts, $wpw_auto_poster_model, $wpw_auto_poster_render, $wpw_auto_poster_message_stack,
				$wpw_auto_poster_fb_posting, $wpw_auto_poster_tw_posting, $wpw_auto_poster_li_posting;
		
		$this->scripts 	= $wpw_auto_poster_scripts;
		$this->model 	= $wpw_auto_poster_model;
		$this->render 	= $wpw_auto_poster_render;
		$this->message 	= $wpw_auto_poster_message_stack;
		
		//social posting class objects
		$this->fbposting = $wpw_auto_poster_fb_posting;
		$this->twposting = $wpw_auto_poster_tw_posting;
		$this->liposting = $wpw_auto_poster_li_posting;
	}

	/**
	 * Register Settings
	 *
	 * Runs when the admin_init hook fires and registers 
	 * the plugin settings with the WordPress settings API.
	 *
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	function wpw_auto_poster_init() {
	
		register_setting( 'wpw_auto_poster_plugin_options', 'wpw_auto_poster_options', array( $this, 'validate_options' ) );
		register_setting( 'wpw_auto_poster_widget_options', 'wpw_auto_poster_widget_pack' );
	}

	/**
	 * Validation/Sanitization
	 *
	 * Sanitize and validate input fields.
	 *
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	public function validate_options( $input ) {	
		
		global $wpw_auto_poster_options;
		
		//Facebook Settings Options
		$input['fb_app_id']					=	$this->model->wpw_auto_poster_stripslashes_deep( $input['fb_app_id'] );
		$input['fb_app_secret']				=	$this->model->wpw_auto_poster_stripslashes_deep( $input['fb_app_secret'] );
		$input['custom_status_msg']			=	$this->model->wpw_auto_poster_stripslashes_deep( $input['custom_status_msg'] );
		$input['fb_custom_img']				=	$this->model->wpw_auto_poster_stripslashes_deep( $input['fb_custom_img'] );
		
		//facebook application id or secret blank or change then reset session
		if( ( empty( $input['fb_app_id'] ) || empty( $input['fb_app_secret'] ) ) 
				|| ( $wpw_auto_poster_options['fb_app_id'] != $input['fb_app_id'] ) 
				|| ( $wpw_auto_poster_options['fb_app_secret'] != $input['fb_app_secret'] ) ) {
					
			$this->fbposting->wpw_auto_poster_fb_reset_session();
		}
		
		//Twitter Settings Options
		$input['twitter_consumer_key']		=	$this->model->wpw_auto_poster_stripslashes_deep( $input['twitter_consumer_key'] );
		$input['twitter_consumer_secret']	=	$this->model->wpw_auto_poster_stripslashes_deep( $input['twitter_consumer_secret'] );
		$input['twitter_oauth_token']		=	$this->model->wpw_auto_poster_stripslashes_deep( $input['twitter_oauth_token'] );
		$input['twitter_oauth_secret']		=	$this->model->wpw_auto_poster_stripslashes_deep( $input['twitter_oauth_secret'] );
		
		//LinkedIn Settings Options
		$input['linkedin_app_id']			=	$this->model->wpw_auto_poster_stripslashes_deep( $input['linkedin_app_id'] );
		$input['linkedin_app_secret']		=	$this->model->wpw_auto_poster_stripslashes_deep( $input['linkedin_app_secret'] );
		$input['li_post_image']				=	$this->model->wpw_auto_poster_stripslashes_deep( $input['li_post_image'] );
		
		//linkedin application id or secret blank or change then reset session
		if( ( empty( $input['linkedin_app_id'] ) || empty( $input['linkedin_app_secret'] ) ) 
				|| ( $wpw_auto_poster_options['linkedin_app_id'] != $input['linkedin_app_id'] )
				|| ( $wpw_auto_poster_options['linkedin_app_secret'] != $input['linkedin_app_secret'] ) ) {
					
			$this->liposting->wpw_auto_poster_li_reset_session();
		}
		
		//set session to set tab selected in settings page
		$selectedtab = isset( $input['selected_tab'] ) ? $input['selected_tab'] : '';
		$this->message->add_session( 'poster-selected-tab', strtolower( $selectedtab ) );
		
		return $input;
	}
	
	/**
	 * Add Top Level Menu Page
	 *
	 * Runs when the admin_menu hook fires and adds a new
	 * top level admin page and menu item.
	 *
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	function wpw_auto_poster_add_settings_page() {
	
		global $post;
		
		// plugin settings page
		$wpw_auto_poster_admin = add_menu_page( __( 'Social Auto Poster', 'wpwautoposter' ), __( 'Social Auto Poster', 'wpwautoposter' ), wpwautoposterlevel, 'wpw-auto-poster-settings', '', WPW_AUTO_POSTER_IMG_URL . '/wpw-auto-poster-icon.png'); 
		
		$wpw_auto_poster_admin = add_submenu_page( 'wpw-auto-poster-settings', __( 'Social Auto Poster Settings', 'wpwautoposter' ), __( 'Settings', 'wpwautoposter' ), wpwautoposterlevel, 'wpw-auto-poster-settings', array( $this, 'wpw_auto_poster_settings_page' ) );
	    $wpw_auto_poster_widget = add_submenu_page( 'wpw-auto-poster-settings',  __( 'Social Auto Poster Facebook Widget Pack', 'wpwautoposter' ), __( 'Facebook Widget Pack', 'wpwautoposter' ), wpwautoposterlevel, 'wpw-auto-poster-widgetpack', array( $this,'wpw_auto_poster_widget_pack_page' ) );
	    
		// loads the JavaScript and style sheets needed for the plugin settings screen
		add_action( "admin_print_styles-$wpw_auto_poster_admin", array( $this->scripts, 'wpw_auto_poster_settings_page_print_styles' ) );
		add_action( "admin_head-$wpw_auto_poster_admin", array( $this->scripts, 'wpw_auto_poster_settings_page_load_scripts' ));
		
		add_action( "admin_print_styles-$wpw_auto_poster_widget", array( $this->scripts, 'wpw_auto_poster_settings_page_print_styles' ) );
	}

	/**
	 * Settings Page
	 *
	 * Renders the plugin settings page.
	 *
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	function wpw_auto_poster_settings_page() {		
	
		include_once( WPW_AUTO_POSTER_ADMIN . '/forms/wpw-auto-poster-plugin-settings.php' );
	}

	/**
	 * Widget Pack Settings Page
	 *
	 * Renders the widget pack settings page.
	 *
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	function wpw_auto_poster_widget_pack_page() {
		
		include( WPW_AUTO_POSTER_ADMIN . '/forms/wpw-auto-poster-widget-pack-settings.php' );
	}
	
	/**
	 * Post to Social Medias
	 * 
	 * Handles to post to social media
	 *
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	public function wpw_auto_poster_post_to_social_media( $postid, $post ) {
		
		global $wpw_auto_poster_options,$postedstr;
		 
		$post_type_object = get_post_type_object( $post->post_type );
		
		if ( ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE )                // Check Autosave
			|| ( ! isset( $_POST['post_ID'] ) || $postid != $_POST['post_ID'] )
			|| ( ! current_user_can( $post_type_object->cap->edit_post, $postid ) )
			|| ( $post->post_status != 'publish' ) )  {
			return $postid;
		}
		
		$prefix = WPW_AUTO_POSTER_META_PREFIX;
		
		$postedstr = array();
		
		//Facebook Posting
		$facebookarr = !empty($wpw_auto_poster_options['enable_facebook_for']) ? $wpw_auto_poster_options['enable_facebook_for'] : array();
		
		$fb_published = get_post_meta( $postid, $prefix . 'fb_published_on_fb', true );
		
			//Check If post is already published and there is disable from metabox but it has checked in backend
			//then it will post to social site when the post is going to published first time when created new
			if( ( !empty( $wpw_auto_poster_options['enable_facebook'] ) && ( !isset( $fb_published ) || $fb_published == false ) && in_array( $post->post_type, $facebookarr ) ) 
					|| ( isset( $_POST[$prefix.'post_to_facebook'] ) && $_POST[$prefix.'post_to_facebook'] == 'on' ) ) { 
				
						
				$res = $this->fbposting->wpw_auto_poster_fb_post_to_userwall( $post );
				
				if( isset( $res['id'] ) && !empty( $res['id'] ) ) { //check post has been posted on facebook or not
					update_post_meta( $postid, $prefix . 'fb_published_on_fb', '1' );
					$postedstr[] = 'fb';
				}
			}
		//Twitter Posting
		$twitterarr = !empty($wpw_auto_poster_options['enable_twitter_for']) ? $wpw_auto_poster_options['enable_twitter_for'] : array();
			
		$tw_published = get_post_meta( $postid, $prefix . 'tw_status', true );
		
			//Check If post is already published and there is disable from metabox but it has checked in backend
			//then it will post to social site when the post is going to published first time when created new
			if( ( !empty( $wpw_auto_poster_options['enable_twitter'] ) && ( !isset( $tw_published ) || $tw_published == false ) && in_array( $post->post_type,$twitterarr ) ) 
			 	|| ( isset( $_POST[$prefix.'post_to_twitter'] ) && $_POST[$prefix.'post_to_twitter'] == 'on' ) )  { 
					
				$res = $this->twposting->wpw_auto_poster_post_to_twitter( $post );
				if( !isset( $res->error ) && !empty( $res->id ) ) { //check if error should not occured and successfully tweeted
					update_post_meta( $postid, $prefix . 'tw_status', '1' );
					$postedstr[] = 'tw';
				}
			
			
			}
			
		//LinkedIn Posting
		$linkedinarr = !empty($wpw_auto_poster_options['enable_linkedin_for']) ? $wpw_auto_poster_options['enable_linkedin_for'] : array();
		
		$li_published = get_post_meta( $postid, $prefix . 'li_status', true );

			//Check If post is already published and there is disable from metabox but it has checked in backend
			//then it will post to social site when the post is going to published first time when created new
			if( ( !empty( $wpw_auto_poster_options['enable_linkedin'] ) && ( !isset( $li_published ) || $li_published == false ) && in_array( $post->post_type,$linkedinarr ) ) 
					|| ( isset( $_POST[$prefix.'post_to_linkedin'] ) && $_POST[$prefix.'post_to_linkedin'] == 'on' ) ) { 
					
				$res = $this->liposting->wpw_auto_poster_post_to_linkedin( $post );
				
				if( isset( $res['success'] ) && !empty( $res['success'] ) ) { //check if error should not occured and successfully tweeted
					update_post_meta( $postid, $prefix . 'li_status', '1' );
					$postedstr[] = 'li';
				}
			}
		
		//redirect to custom url after saving post
		add_filter('redirect_post_location', array( $this, 'wpw_auto_poster_redirect_save_post') );
	}
	
	public function wpw_auto_poster_redirect_save_post($loc) {
		
		global $postedstr;
		
		if( !empty( $postedstr ) ) {
			return add_query_arg( 'wpwautoposteron', $postedstr, $loc);
		} else {
			return $loc;
		}
		
	}
	
	function wpw_auto_poster_admin_notices() {
		
		if ( !isset( $_GET['wpwautoposteron'] ) ) return false;
		
		$done = isset( $_GET['wpwautoposteron'] ) && !empty( $_GET['wpwautoposteron'] ) ? true : false;
		//$postedon = str_replace( '-', ',', $_GET['wpwautoposteron'] );
		$postedon = $_GET['wpwautoposteron'];
		
		$reparr = array( 'fb', 'tw', 'li' );
		$replcarr = array( 
								__( 'Facebook', 'wpwautoposter' ),
								__( 'Twitter', 'wpwautoposter' ),
								__( 'LinkedIn', 'wpwautoposter' )
							);
		
		$postedon = str_replace( $reparr, $replcarr, $postedon );
		$postedon = implode( $postedon, ',' );
		
		$msg =  sprintf( __( 'Post published on %1$s', 'wpwautoposter' ), $postedon);
		echo "<div class='updated'><p>{$msg}.</p></div>";
	}
	
	/**
	 * Add Schedule posting with social media
	 * 
	 * Handles to work posting on social media when 
	 * someone set schedule for particular post
	 * at that time it will automatic posted on social medias
	 * whichever is selected in settings page
	 * 
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	public function wpw_auto_poster_schedule_posting( $postid ) {
		
		global $wpw_auto_poster_options;
		
		$post = get_post($postid);
		
		if ($post->post_type == 'revision') return; // Imp Line //  if revision dont do anything.
		if ($post->post_status != 'publish') return;
			
		$prefix = WPW_AUTO_POSTER_META_PREFIX;
			
		//Facebook Posting
		$facebookarr = !empty($wpw_auto_poster_options['enable_facebook_for']) ? $wpw_auto_poster_options['enable_facebook_for'] : array();
		
		if( !empty( $wpw_auto_poster_options['enable_facebook'] ) && in_array( $post->post_type,$facebookarr ) ) {
			
			$res = $this->fbposting->wpw_auto_poster_fb_post_to_userwall( $post );
				
			if( isset( $res['id'] ) && !empty( $res['id'] ) ) { //check post has been posted on facebook or not
				update_post_meta( $postid, $prefix . 'fb_published_on_fb', '1' );
			}
			
		}
		
		//Twitter Posting
		$twitterarr = !empty($wpw_auto_poster_options['enable_twitter_for']) ? $wpw_auto_poster_options['enable_twitter_for'] : array();
		
		if( !empty( $wpw_auto_poster_options['enable_twitter'] ) && in_array( $post->post_type,$twitterarr ) ) {
			
			$res = $this->twposting->wpw_auto_poster_post_to_twitter( $post );
			
			if( !isset( $res->error ) && !empty( $res->id ) ) { //check if error should not occured and successfully tweeted
				update_post_meta( $postid, $prefix . 'tw_status', '1' );
				
			}
			
		}
		
		//LinkedIn Posting
		$linkedinarr = !empty($wpw_auto_poster_options['enable_linkedin_for']) ? $wpw_auto_poster_options['enable_linkedin_for'] : array();
		
		if( !empty( $wpw_auto_poster_options['enable_linkedin'] ) && in_array( $post->post_type,$linkedinarr ) ) {
			
			$res = $this->liposting->wpw_auto_poster_post_to_linkedin( $post );
				
			if( isset( $res['success'] ) && !empty( $res['success'] ) ) { //check if error should not occured and successfully tweeted
				update_post_meta( $postid, $prefix . 'li_status', '1' );
			}
			
		}
		
	}
	
	/**
	 * Adding Hooks
	 *
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	public function add_hooks() {
		
		// if the user can edit plugin options, let the fun begin!
		add_action( 'admin_menu', array( $this, 'wpw_auto_poster_add_settings_page' )); //
		add_action( 'admin_init', array( $this, 'wpw_auto_poster_init' )); // registers plugin options	
		add_action( "admin_enqueue_scripts", array( $this->scripts, 'wpw_auto_poster_settings_page_print_scripts' ) ); // enqueus our java scripts		
		
		//post to social media when post or page or custom post type will be published
		add_action('save_post', array( $this, 'wpw_auto_poster_post_to_social_media' ), 10, 2 ); //
		
		//show admin notices
		add_action('admin_notices', array($this, 'wpw_auto_poster_admin_notices'));
		
		//add for schedule posting
		add_action( 'publish_future_post', array( $this, 'wpw_auto_poster_schedule_posting' ) ); // added for schdule post 
		
	}
}
?>