<?php

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

/**
 * Facebook Settings
 *
 * The html markup for the Facebook settings tab.
 *
 * @package Social Auto Poster
 * @since 1.0.0
 */
?>

<!-- beginning of the facebook general settings meta box -->
<div id="wpw-auto-poster-facebook-general" class="post-box-container">
	<div class="metabox-holder">	
		<div class="meta-box-sortables ui-sortable">
			<div id="facebook_general" class="postbox">	
				<div class="handlediv" title="<?php _e( 'Click to toggle', 'wpwautoposter' ); ?>"><br /></div>
									
					<h3 class="hndle">
						<span style='vertical-align: top;'><?php _e( 'Facebook General Settings', 'wpwautoposter' ); ?></span>
					</h3>
									
					<div class="inside">
										
						<table class="form-table">											
							<tbody>				
								<tr valign="top">
									<th scope="row">
										<label for="wpw_auto_poster_options[enable_facebook]"><?php _e( 'Enable Autoposting to Facebook:', 'wpwautoposter' ); ?></label>
									</th>
									<td>
										<input name="wpw_auto_poster_options[enable_facebook]" id="wpw_auto_poster_options[enable_facebook]" type="checkbox" value="1" <?php if( isset( $wpw_auto_poster_options['enable_facebook'] ) ) { checked( '1', $wpw_auto_poster_options['enable_facebook'] ); } ?> />
										<p><small><?php _e( 'Check this box, if you want to automatically post your new content to Facebook.', 'wpwautoposter' ); ?></small></p>
									</td>
								</tr>

								<tr valign="top">
									<th scope="row">
										<label for="wpw_auto_poster_options[enable_facebook_for]"><?php _e( 'Enable Facebook Autoposting for:', 'wpwautoposter' ); ?></label>
									</th>
									<td>
										<ul>
										<?php 
											$all_types = get_post_types( array( 'public' => true ), 'objects');
											$all_types = is_array( $all_types ) ? $all_types : array();
											
											if( !empty( $wpw_auto_poster_options['enable_facebook_for'] ) ) {
												$prevent_meta = $wpw_auto_poster_options['enable_facebook_for'];
											} else {
												$prevent_meta = array();
											}
											
											foreach( $all_types as $type ) {	
												/*if( !empty( $wpw_auto_poster_options['prevent_item_'.$type->name] ) ) {
													$items_count = count( $wpw_auto_poster_options['prevent_item_'.$type->name] );
												} else {
													$wpw_auto_poster_options['prevent_item_'.$type->name] = '';
													$items_count = 0;
												}
												*/
												if( !is_object( $type ) ) continue;															
													$label = @$type->labels->name ? $type->labels->name : $type->name;
													if( $label == 'Media' || $label == 'media' ) continue; // skip media
													$selected = ( in_array( $type->name, $prevent_meta ) ) ? 'checked="checked"' : '';
													
										?>
															
											<li class="wpw-auto-poster-prevent-types">
												<input type="checkbox" id="wpw_auto_posting_facebook_prevent_<?php echo $type->name; ?>" name="wpw_auto_poster_options[enable_facebook_for][]" value="<?php echo $type->name; ?>" <?php echo $selected; ?>/>
																						
												<label for="wpw_auto_posting_facebook_prevent_<?php echo $type->name; ?>"><?php echo $label; ?></label>
											</li>
											
											<?php	} ?>
										</ul>
										<p><small><?php _e( 'Check each of the post types that you want to post automatically to Facebook when they get published.', 'wpwautoposter' ); ?></small></p>  
									</td>
								</tr>
															
								<tr valign="top">
									<td colspan="2">
										<input type="submit" value="<?php _e ( 'Save Changes', 'wpwautoposter' ); ?>" id="wpw_auto_poster_set_submit" name="wpw_auto_poster_set_submit" class="button-primary">
									</td>
								</tr>
								
							</tbody>
						</table>
									
					</div><!-- .inside -->
							
			</div><!-- #facebook_general -->
		</div><!-- .meta-box-sortables ui-sortable -->
	</div><!-- .metabox-holder -->
</div><!-- #wpw-auto-poster-facebook-general -->
<!-- end of the facebook general settings meta box -->

<!-- beginning of the facebook api settings meta box -->
<div id="wpw-auto-poster-facebook-api" class="post-box-container">
	<div class="metabox-holder">	
		<div class="meta-box-sortables ui-sortable">
			<div id="facebook_api" class="postbox">	
				<div class="handlediv" title="<?php _e( 'Click to toggle', 'wpwautoposter' ); ?>"><br /></div>
									
					<h3 class="hndle">
						<span style='vertical-align: top;'><?php _e( 'Facebook API Settings', 'wpwautoposter' ); ?></span>
					</h3>
									
					<div class="inside">
										
						<table class="form-table">											
							<tbody>				
								<tr valign="top">
									<th scope="row">
										<label><?php _e( 'Facebook Application:', 'wpwautoposter' ); ?></label>
									</th>
									<td>
										<p><strong><?php _e( 'It is IMPORTANT that you\'re creating a new Facebook App for the Facebook posting.', 'wpwautoposter' ); ?></strong></p> 
										<p><?php _e( 'To create a new one, follow these steps:', 'wpwautoposter' ); ?></p> 
										<ol>
											<li>
												<a href="https://www.facebook.com/developers/createapp.php" target="_blank"><?php _e( 'Create your Facebook Application.', 'wpwautoposter' ); ?></a>
											</li>
											<li>
												<?php _e( 'Look for the <strong>Site URL</strong> field in the Web Site tab and enter your site URL in this field:', 'wpwautoposter' ); ?> <code><strong><?php echo home_url(); ?></strong></code>
											</li>
											<li>
												<?php _e( 'After this, go to the <a href="https://developers.facebook.com/apps" target="_blank">Facebook Application List page</a> and select your newly created application', 'wpwautoposter' ); ?>
											</li>
											<li>
												<?php _e( 'Copy the values from these fields: <strong>App ID/API Key</strong> and <strong>App Secret</strong> and enter them here:', 'wpwautoposter' ); ?>
											</li>
										</ol>
									</td>
								</tr> 
								
								<tr valign="top">
									<th scope="row">
										<label for="wpw_auto_poster_options[fb_app_id]"><?php _e( 'Facebook App ID/API Key:', 'wpwautoposter' ); ?></label>
									</th>
									<td>
										<input type="text" name="wpw_auto_poster_options[fb_app_id]" id="wpw_auto_poster_options[fb_app_id]" value="<?php echo $model->wpw_auto_poster_escape_attr( $wpw_auto_poster_options['fb_app_id'] ); ?>" class="large-text" />
										<p><small><?php _e( 'Enter Facebook App ID / API Key.', 'wpwautoposter' ); ?></small></p>  
									</td>
								</tr>    
					
								<tr valign="top">
									<th scope="row">
										<label for="wpw_auto_poster_options[fb_app_secret]"><?php _e( 'Facebook App Secret:', 'wpwautoposter' ); ?></label>
									</th>
									<td>
										<input type="text" name="wpw_auto_poster_options[fb_app_secret]" id="wpw_auto_poster_options[fb_app_secret]" value="<?php echo $model->wpw_auto_poster_escape_attr( $wpw_auto_poster_options['fb_app_secret'] ); ?>" class="large-text" />
										<p><small><?php _e( 'EnterFacebook App Secret.', 'wpwautoposter' ); ?></small></p>  
									</td>
								</tr> 
								
								<tr valign="top">
									<th scope="row">
										<label for="wpw_auto_poster_options[prevent_linked_accounts_access]"><?php _e( 'Prevent access to my linked accounts:', 'wpwautoposter' ); ?></label>
									</th>
									
									<td  valign="top">
										<input name="wpw_auto_poster_options[prevent_linked_accounts_access]" id="wpw_auto_poster_options[prevent_linked_accounts_access]" type="checkbox" value="1" <?php if( isset( $wpw_auto_poster_options['prevent_linked_accounts_access'] ) ) { checked( '1', $wpw_auto_poster_options['prevent_linked_accounts_access'] ); } ?> />
										<p><small><?php _e( 'If you check this option, then all your linked Facebook Accounts won\'t be accessible to the plugin. This means that you then will only be able to post to your personal Facebook Account/Profile.','wpwautoposter' ); ?></small></p>
									</td>	
								</tr>
																					
								<tr valign="top">
									<td colspan="2">
										<input type="submit" value="<?php _e ( 'Save Changes', 'wpwautoposter' ); ?>" id="wpw_auto_poster_set_submit" name="wpw_auto_poster_set_submit" class="button-primary">
									</td>
								</tr>  													
							</tbody>
						</table>
									
					</div><!-- .inside -->
							
			</div><!-- #facebook_api -->
		</div><!-- .meta-box-sortables ui-sortable -->
	</div><!-- .metabox-holder -->
</div><!-- #wpw-auto-poster-facebook-api -->
<!-- end of the facebook api settings meta box -->

<?php if( isset($wpw_auto_poster_options['fb_app_id']) && !empty($wpw_auto_poster_options['fb_app_id']) && isset($wpw_auto_poster_options['fb_app_secret']) && !empty($wpw_auto_poster_options['fb_app_secret'])  ) { ?>

<!-- beginning of the grant extended permission meta box -->
<div id="wpw-auto-poster-grant-permission" class="post-box-container">
	<div class="metabox-holder">	
		<div class="meta-box-sortables ui-sortable">
			<div id="grant_permission" class="postbox">	
				<div class="handlediv" title="<?php _e( 'Click to toggle', 'wpwautoposter' ); ?>"><br /></div>
									
					<h3 class="hndle">
						<span style='vertical-align: top;'><?php _e( 'Grant Extended Permissions', 'wpwautoposter' ); ?></span>
					</h3>
									
					<div class="inside">
										
						<table class="form-table">											
							<tbody>				
								<tr valign="top">
									<th scope="row">
										<label><?php _e( 'Allowing permissions:', 'wpwautoposter' ); ?></label>
									</th>
									<td>
										<p><?php _e( 'Posting content to your chosen Facebook Fan Page or personal account requires you to grant extended permissions. If you want to use this feature you should grant the extended permissions now.', 'wpwautoposter' ); ?></p>
										<?php										
											$returnurl = admin_url().'edit.php?post_type=wpw_auto_poster&page=wpw-auto-poster-settings'; 
										
											if( isset( $_SESSION['wpweb_fb_user_id'] ) && !empty( $_SESSION['wpweb_fb_user_id'] ) )  {
												
												echo '<p>' . __( 'You already granted extended permissions.', 'wpwautoposter' ) . '</p>';	
										?>
										
												<a href="<?php echo $returnurl.'&fb_reset_user=1'; ?>"><?php _e( 'Reset User Session', 'wpwautoposter' ); ?></a>
												
										
										<?php
											} else {
											
												echo '<p><a href="' . $fbposting->wpw_auto_poster_get_fb_login_url() . '">' . __( 'Grant extended permissions', 'wpwautoposter' ) . '</a></p>';
											}
										?>	
									</td>
								</tr> 
																					
								<tr valign="top">
									<td colspan="2">
										<input type="submit" value="<?php _e ( 'Save Changes', 'wpwautoposter' ); ?>" id="wpw_auto_poster_set_submit" name="wpw_auto_poster_set_submit" class="button-primary">
									</td>
								</tr>  													
							</tbody>
						</table>
									
					</div><!-- .inside -->
							
			</div><!-- #grant_permissions -->
		</div><!-- .meta-box-sortables ui-sortable -->
	</div><!-- .metabox-holder -->
</div><!-- #wpw-auto-poster-grant-permission -->
<!-- end of the grant extended permissions meta box -->

<?php } ?>

<!-- beginning of the autopost to facebook meta box -->
<div id="wpw-auto-poster-autopost-facebook" class="post-box-container">
	<div class="metabox-holder">	
		<div class="meta-box-sortables ui-sortable">
			<div id="autopost_facebook" class="postbox">	
				<div class="handlediv" title="<?php _e( 'Click to toggle', 'wpwautoposter' ); ?>"><br /></div>
									
					<h3 class="hndle">
						<span style='vertical-align: top;'><?php _e( 'Autopost to Facebook', 'wpwautoposter' ); ?></span>
					</h3>
									
					<div class="inside">
										
						<table class="form-table">											
							<tbody>		
								<?php
									if( isset( $_SESSION['wpweb_fb_user_accounts'] ) && !empty( $_SESSION['wpweb_fb_user_accounts'] ) ) {
										$wpw_auto_poster_fb_user = $fbposting->wpw_auto_poster_get_fb_user_data();
									} else {
										$wpw_auto_poster_fb_user = '';
									}
									
									if( empty( $wpw_auto_poster_fb_user['id'] ) ) {
										$wpw_auto_poster_fb_user['id'] = 0;
									}						
										
									$types = get_post_types( array( 'public'=>true ), 'objects' );
									$types = is_array( $types ) ? $types : array();
								?>
								<tr valign="top">
									<th scope="row">
										<label><?php _e( 'Map WordPress types to Facebook locations:', 'wpwautoposter' ); ?></label>
									</th>
									<td>
										<?php
											
											if( isset( $_SESSION['wpweb_fb_user_accounts'] ) && !empty( $_SESSION['wpweb_fb_user_accounts'] ) ) {
												$fb_accounts = $_SESSION['wpweb_fb_user_accounts'];
												$fb_accounts = isset( $fb_accounts['auth_accounts'] ) ? $fb_accounts['auth_accounts'] : array();
											} else {
												$fb_accounts = '';
											}
											
											$optstr = '';											
											
											foreach( $types as $type ) {											
												if( !is_object( $type ) ) continue;
												
													if( isset( $wpw_auto_poster_options['fb_type_' . $type->name . '_method'] ) ) {
														$wpw_auto_poster_fb_type_method = $wpw_auto_poster_options['fb_type_' . $type->name . '_method'];	
													} else {
														$wpw_auto_poster_fb_type_method = '';
													}
													$label = @$type->labels->name ? $type->labels->name : $type->name;
													
													if( $label == 'Media' || $label == 'media' ) continue; // skip media
												?>
												<p>
												<?php _e( 'Autopost ', 'wpwautoposter' ); ?>
												<?php echo $label; ?>
												<?php _e( ' to Facebook', 'wpwautoposter' ); ?>
												
													<select name="wpw_auto_poster_options[fb_type_<?php echo $type->name; ?>_method]" id="wpw_auto_poster_fb_type_post_method">
														<?php /* <option value="0"><?php _e( 'Don\'t post this type to Facebook', 'wpwautoposter' ); ?></option>*/?>
														<option value="feed" <?php if( $wpw_auto_poster_fb_type_method == 'feed') { echo 'selected="selected"'; } ?>><?php _e( 'As a Wall Post', 'wpwautoposter' ); ?></option>
														<option value="feed_status" <?php if($wpw_auto_poster_fb_type_method == 'feed_status') { echo 'selected="selected"'; } ?>><?php _e( 'As a Status Update', 'wpwautoposter' ); ?></option>
														<option value="notes" <?php if($wpw_auto_poster_fb_type_method == 'notes') { echo 'selected="selected"'; } ?>><?php _e( 'As a Note', 'wpwautoposter' ); ?></option>
														<option value="events" <?php if($wpw_auto_poster_fb_type_method == 'events') { echo 'selected="selected"'; } ?>><?php _e( 'As an Event', 'wpwautoposter' ); ?></option>
													</select>
													
													<?php //if( $fb_accounts != '' ) { ?>
													
														<?php 
															_e( 'of this user', 'wpwautoposter' ); 
															if( isset( $wpw_auto_poster_options['fb_type_'.$type->name.'_user'] ) ) {
																$wpw_auto_poster_fb_type_user = $wpw_auto_poster_options['fb_type_'.$type->name.'_user'];	 
															} else {
																$wpw_auto_poster_fb_type_user = '';
															}
														?>
														
														<select name="wpw_auto_poster_options[fb_type_<?php echo $type->name; ?>_user]">
															<option value=""></option>
															<?php
																foreach( $fb_accounts as $aid => $aval ) { 
															?>
																	<option value="<?php echo $aid; ?>" <?php if( $wpw_auto_poster_fb_type_user == $aid ) { echo 'selected="selected"'; } ?> ><?php echo $aval; ?></option>
															<?php		
																}
															?>
														</select>
													<?php //} ?>
													</p>
												<div style="clear:both"></div>
											<?php }
											?>
									</td>
								</tr> 

								<tr valign="top"> 
									<th scope="row">
										<label for="wpw_auto_poster_options[prevent_post_metabox]"><?php _e( 'Do not allow individual posts to Facebook:', 'wpwautoposter' ); ?></label>
									</th>									
									<td>
										<input name="wpw_auto_poster_options[prevent_post_metabox]" id="wpw_auto_poster_options[prevent_post_metabox]" type="checkbox" value="1" <?php if( isset( $wpw_auto_poster_options['prevent_post_metabox'] ) ) { checked( '1', $wpw_auto_poster_options['prevent_post_metabox'] ); } ?> />
										<p><small><?php _e( 'If you run a multi author blog, then you can prevent your authors to posting to individual Facebook Accounts by checking this box. If checked, then all posts, created by any author, will get posted to your chosen Facebook Account.', 'wpwautoposter' ); ?></small></p>
									</td>	
								</tr>
								
								<tr valign="top">
									<th scope="row">
										<label for="wpw_auto_poster_options[fb_custom_img]"><?php _e( 'Facebook Post Image:', 'wpwautoposter' ); ?></label>
									</th>
									<td>
										<input type="text" value="<?php echo $model->wpw_auto_poster_escape_attr( $wpw_auto_poster_options['fb_custom_img'] ); ?>" name="wpw_auto_poster_options[fb_custom_img]" id="wpw_auto_poster_options_fb_custom_img" class="large-text wpw-auto-poster-img-field">
										<input type="button" class="button-secondary wpw-auto-poster-uploader-button" name="wpw-auto-poster-uploader" value="<?php _e( 'Add Image','wpwautoposter' );?>" />
										<p><small><?php _e( 'Here you can upload a default image which will be used for the Facebook wall post.', 'wpwautoposter' ); ?></small></p>
									</td>	
								</tr>
								
								<tr valign="top">									
									<th scope="row">
										<label for="wpw_auto_poster_options[custom_status_msg]"><?php _e( 'Facebook Status Update Text:', 'wpwautoposter' ); ?></label>
									</th>
									<td>
										<input type="text" value="<?php echo $model->wpw_auto_poster_escape_attr( $wpw_auto_poster_options['custom_status_msg'] ); ?>" name="wpw_auto_poster_options[custom_status_msg]" id="wpw_auto_poster_options[custom_status_msg]" class="large-text">
										<p><small style="line-height: 20px;"><?php _e( 'Here you can enter a default status update text. You can customize this content for your needs. There are also several template tags you can use to customize the content. The template tags will then be replaced with the related information. The available tags are:<br />
											 <code>{first_name}</code> - displays the first name,<br />
											 <code>{last_name}</code> - displays the last name,<br /> 
											 <code>{title}</code> - displays the post title,<br />
											 <code>{link}</code> - displays the post title with link,<br />
											 <code>{site_name}</code> - displays the name of your site.', 'wpwautoposter' ); ?></small></p>
									</td>	
									
								</tr>
								
								<tr valign="top">
									<td colspan="2">
										<input type="submit" value="<?php _e ( 'Save Changes', 'wpwautoposter' ); ?>" id="wpw_auto_poster_set_submit" name="wpw_auto_poster_set_submit" class="button-primary">
									</td>
								</tr>  													
							</tbody>
						</table>
									
					</div><!-- .inside -->
							
			</div><!-- #autopost_facebook -->
		</div><!-- .meta-box-sortables ui-sortable -->
	</div><!-- .metabox-holder -->
</div><!-- #ps-poster-autopost-facebook -->
<!-- end of the autopost to facebook meta box -->