<?php

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

/**
 * General Settings
 *
 * The html markup for the general settings box.
 *
 * @package Social Auto Poster
 * @since 1.0.0
 */
?>

<!-- beginning of the general settings meta box -->
<div id="wpw-auto-poster-general" class="post-box-container">
	<div class="metabox-holder">	
		<div class="meta-box-sortables ui-sortable">
			<div id="general" class="postbox">	
				<div class="handlediv" title="<?php _e( 'Click to toggle', 'wpwautoposter' ); ?>"><br /></div>
								
					<!-- general settings box title -->
					<h3 class="hndle">
						<span style='vertical-align: top;'><?php _e( 'General Settings', 'wpwautoposter' ); ?></span>
					</h3>
									
					<div class="inside">
										
						<table class="form-table">											
							<tbody>															
								<tr valign="top">
									<th scope="row">
										<label for="wpw_auto_poster_options[delete_options]"><?php _e( 'Delete Options:', 'wpwautoposter' ); ?></label>
									</th>
									<td>
										<input id="wpw_auto_poster_options[delete_options]" name="wpw_auto_poster_options[delete_options]" type="checkbox" value="1" <?php if ( isset( $wpw_auto_poster_options['delete_options'] ) ) { checked( '1', $wpw_auto_poster_options['delete_options'] ); } ?> />
										<p><small><?php _e( 'If you don\'t want to use the Social Auto Poster Plugin on your site anymore, you can check that box. This makes sure, that all the settings and tables are being deleted from the database when you deactivate the plugin.', 'wpwautoposter' ); ?></small></p>
									</td>
								</tr>
								
								<tr valign="top">
									<th scope="row">
										<label for="wpw_auto_poster_options[url_shortener]"><?php _e( 'URL Shortener', 'wpwautoposter' ); ?></label> 
									</th>
									<td>
										<select name="wpw_auto_poster_options[url_shortener]" id="wpw_auto_poster_options[url_shortener]" class="url_shortener">
											<?php
												$url_shortener = array( 'wordpress' => __( 'WordPress', 'wpwautoposter' ), 'tinyurl' => __( 'TinyURL', 'wpwautoposter' ), 'bitly' => __( 'bit.ly', 'wpwautoposter' ) );
																
												foreach ( $url_shortener as $key => $option ) {											
													?>
													<option value="<?php echo $model->wpw_auto_poster_escape_attr( $key ); ?>" <?php selected( $wpw_auto_poster_options['url_shortener'], $key ); ?>>
														<?php esc_html_e( $option ); ?>
													</option>
													<?php
												}															
											?> 														
										</select>
										<p><small><?php _e( 'Long URLs will automatically be shortened using the specified URL shortener.', 'wpwautoposter' ); ?></small></p>
									</td>
								</tr>
								
								<?php	        
									if( $wpw_auto_poster_options['url_shortener'] == 'bitly' ) {	        		
										$class = '';	        		
									} else {	        		
										$class = ' style="display:none;"';
									}
								?>
								
								<tr valign="top" class="setting_input_bitly"<?php echo $class; ?>>
									<th scope="row">
										<label for="wpw_auto_poster_options[bitly_username]"><?php _e( 'Bit.ly username', 'wpwautoposter' ); ?> </label>
									</th>
									<td>
										<input type="text" name="wpw_auto_poster_options[bitly_username]" id="wpw_auto_poster_options[bitly_username]" value="<?php echo $model->wpw_auto_poster_escape_attr( $wpw_auto_poster_options['bitly_username'] ); ?>" class="large-text">
									</td>
								</tr>
										
								<tr valign="top" class="setting_input_bitly"<?php echo $class; ?>>
									<th scope="row">
										<label for="wpw_auto_poster_options[bitly_api_key]"><?php _e( 'Bit.ly API key', 'socialfm' ); ?> </label>
									</th>
									<td>
										<input type="text" name="wpw_auto_poster_options[bitly_api_key]" id="wpw_auto_poster_options[bitly_api_key]" value="<?php echo $model->wpw_auto_poster_escape_attr( $wpw_auto_poster_options['bitly_api_key'] ); ?>" class="large-text">
									</td>
								</tr>
													
								<tr valign="top">
									<td colspan="2">
										<!-- submit button to save changes -->
										<input type="submit" value="<?php _e ( 'Save Changes', 'wpwautoposter' ); ?>" id="wpw_auto_seo_booster_set_submit" name="wpw_auto_seo_booster_set_submit" class="button-primary">
									</td>
								</tr>  													
							</tbody>
						</table>
										
					</div><!-- .inside -->
									
			</div><!-- #general -->
		</div><!-- .meta-box-sortables ui-sortable -->
	</div><!-- .metabox-holder -->
</div><!-- #wpw-auto-poster-general -->
<!-- end of the general settings meta box -->