<?php

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

/**
 * LinkedIn Settings
 *
 * The html markup for the LinkedIn settings tab.
 *
 * @package Social Auto Poster
 * @since 1.0.0
 */
?>

<!-- beginning of the linkedin general settings meta box -->
<div id="wpw-auto-poster-linkedin-general" class="post-box-container">
	<div class="metabox-holder">	
		<div class="meta-box-sortables ui-sortable">
			<div id="linkedin_general" class="postbox">	
				<div class="handlediv" title="<?php _e( 'Click to toggle', 'wpwautoposter' ); ?>"><br /></div>
								
					<h3 class="hndle">
						<span style='vertical-align: top;'><?php _e( 'LinkedIn General Settings', 'wpwautoposter' ); ?></span>
					</h3>
									
					<div class="inside">
										
						<table class="form-table">											
							<tbody>
								<tr valign="top">
									<th scope="row">
										<label for="wpw_auto_poster_options[enable_linkedin]"><?php _e( 'Enable Autoposting to LinkedIn:', 'wpwautoposter' ); ?></label>
									</th>
									<td>
										<input name="wpw_auto_poster_options[enable_linkedin]" id="wpw_auto_poster_options[enable_linkedin]" type="checkbox" value="1" <?php if( isset( $wpw_auto_poster_options['enable_linkedin'] ) ) { checked( '1', $wpw_auto_poster_options['enable_linkedin'] ); } ?> />
										<p><small><?php _e( 'Check this box, if you want to automatically post your new content to LinkedIn.', 'wpwautoposter' ); ?></small></p>
									</td>
								</tr>	

								<tr valign="top">
									<th scope="row">
										<label for="wpw_auto_poster_options[enable_linkedin_for]"><?php _e( 'Enable LinkedIn Autoposting for:', 'wpwautoposter' ); ?></label>
									</th>
									<td>
										<ul>
										<?php 
											$all_types = get_post_types( array( 'public' => true ), 'objects');
											$all_types = is_array( $all_types ) ? $all_types : array();
											
											if( !empty( $wpw_auto_poster_options['enable_linkedin_for'] ) ) {
												$prevent_meta = $wpw_auto_poster_options['enable_linkedin_for'];
											} else {
												$prevent_meta = '';
											}
															
											$prevent_meta = is_array( $prevent_meta ) ? $prevent_meta : array();
														
											foreach( $all_types as $type ) {	
												/*if( !empty( $wpw_auto_poster_options['prevent_item_'.$type->name] ) ) {
													$items_count = count( $wpw_auto_poster_options['prevent_item_'.$type->name] );
												} else {
													$wpw_auto_poster_options['prevent_item_'.$type->name] = '';
													$items_count = 0;
												}*/
															
												if( !is_object( $type ) ) continue;															
													$label = @$type->labels->name ? $type->labels->name : $type->name;
													if( $label == 'Media' || $label == 'media' ) continue; // skip media
													$selected = ( in_array( $type->name, $prevent_meta ) ) ? 'checked="checked"' : '';
										?>
															
											<li class="wpw-auto-poster-prevent-types">
												<input type="checkbox" id="wpw_auto_posting_linkedin_prevent_<?php echo $type->name; ?>" name="wpw_auto_poster_options[enable_linkedin_for][]" value="<?php echo $type->name; ?>" <?php echo $selected; ?>/>
																						
												<label for="wpw_auto_posting_linkedin_prevent_<?php echo $type->name; ?>"><?php echo $label; ?></label>
											</li>
											
											<?php	} ?>
										</ul>
										<p><small><?php _e( 'Check each of the post types that you want to post automatically to LinkedIn when they get published.', 'wpwautoposter' ); ?></small></p>  
									</td>
								</tr> 
													
								<tr valign="top">
									<td colspan="2">
										<input type="submit" value="<?php _e ( 'Save Changes', 'wpwautoposter' ); ?>" id="wpw_auto_poster_set_submit" name="wpw_auto_poster_set_submit" class="button-primary">
									</td>
								</tr>  													
							</tbody>
						</table>
										
					</div><!-- .inside -->
									
			</div><!-- #linkedin_general -->
		</div><!-- .meta-box-sortables ui-sortable -->
	</div><!-- .metabox-holder -->
</div><!-- #wpw-auto-poster-linkedin-general -->
<!-- end of the linkedin general settings meta box -->

<!-- beginning of the linkedin api settings meta box -->
<div id="wpw-auto-poster-linkedin-api" class="post-box-container">
	<div class="metabox-holder">	
		<div class="meta-box-sortables ui-sortable">
			<div id="linkedin_api" class="postbox">	
				<div class="handlediv" title="<?php _e( 'Click to toggle', 'wpwautoposter' ); ?>"><br /></div>
									
					<h3 class="hndle">
						<span style='vertical-align: top;'><?php _e( 'LinkedIn API Settings', 'wpwautoposter' ); ?></span>
					</h3>
									
					<div class="inside">
					
						<table class="form-table">
							<tbody>
								<tr valign="top">
									<th scope="row">
										<label><?php _e( 'LinkedIn App Settings:', 'wpwautoposter' ); ?></label>
									</th>
									<td>
										<p><?php _e( 'Before you can start publishing your content to LinkedIn you need to create a LinkedIn Application.', 'wpwautoposter' ); ?></p>
										<ol>
											<li>
												<a href="https://www.linkedin.com/secure/developer" target="_blank"><?php _e( 'Create your LinkedIn application', 'wpwautoposter' );?></a>
											</li>
											<li>
												<?php _e( 'Click on "Add New Application". Then enter the information in to the form. You only need to enter the ones with a star, which are required. Then agree to their terms and click on Add Application.', 'wpwautoposter' );?>
											</li>
											<li>
												<?php _e( 'Copy and paste the <b>API Key</b> and <b>Secret Key</b> in to the fields below:', 'wpwautoposter' ); ?>
											</li>
										</ol>
									</td>
								</tr> 
								
								<tr valign="top">
									<th scope="row">
										<label for="wpw_auto_poster_options[linkedin_app_id]"><?php _e( 'LinkedIn App ID/API Key:', 'wpwautoposter' ); ?></label>
									</th>
									<td>
										<input type="text" name="wpw_auto_poster_options[linkedin_app_id]" id="wpw_auto_poster_options[linkedin_app_id]" value="<?php if (isset($wpw_auto_poster_options['linkedin_app_id'])) { echo $model->wpw_auto_poster_escape_attr( $wpw_auto_poster_options['linkedin_app_id'] ); } ?>" class="large-text" />
										<p><small><?php _e( 'Enter LinkedIn App ID/API Key.', 'wpwautoposter' ); ?></small></p>  
									</td>
								</tr>    
				
								<tr valign="top">
									<th scope="row">
										<label for="wpw_auto_poster_options[linkedin_app_secret]"><?php _e( 'LinkedIn App Secret:', 'wpwautoposter' ); ?></label>
									</th>
									<td>
										<input type="text" name="wpw_auto_poster_options[linkedin_app_secret]" id="wpw_auto_poster_options[linkedin_app_secret]" value="<?php if (isset($wpw_auto_poster_options['linkedin_app_secret'])) { echo $model->wpw_auto_poster_escape_attr( $wpw_auto_poster_options['linkedin_app_secret'] ); } ?>" class="large-text" />
										<p><small><?php _e( 'Enter LinkedIn App Secret.', 'wpwautoposter' ); ?></small></p>  
									</td>
								</tr>
								
								<tr valign="top">
									<td colspan="2">
										<input type="submit" value="<?php _e ( 'Save Changes', 'wpwautoposter' ); ?>" id="wpw_auto_poster_set_submit" name="wpw_auto_poster_set_submit" class="button-primary">
									</td>
								</tr>  	
								
							</tbody>
						</table>
					
					</div><!-- .inside -->
							
			</div><!-- #linkedin_api -->
		</div><!-- .meta-box-sortables ui-sortable -->
	</div><!-- .metabox-holder -->
</div><!-- #wpw-auto-poster-linkedin-api -->
<!-- end of the linkedin api settings meta box -->

<?php if( isset($wpw_auto_poster_options['linkedin_app_id']) && !empty($wpw_auto_poster_options['linkedin_app_id']) && isset($wpw_auto_poster_options['linkedin_app_secret']) && !empty($wpw_auto_poster_options['linkedin_app_secret'])  ) { ?>

<!-- beginning of the grant extended permission meta box -->
<div id="wpw-auto-poster-linkein-grant-permission" class="post-box-container">
	<div class="metabox-holder">	
		<div class="meta-box-sortables ui-sortable">
			<div id="grant_permission" class="postbox">	
				<div class="handlediv" title="<?php _e( 'Click to toggle', 'wpwautoposter' ); ?>"><br /></div>
									
					<h3 class="hndle">
						<span style='vertical-align: top;'><?php _e( 'Grant Extended Permissions', 'wpwautoposter' ); ?></span>
					</h3>
									
					<div class="inside">
										
					<table class="form-table">											
						<tbody>				
							<tr valign="top">
								<th scope="row">
									<label><?php _e( 'Allowing permissions:', 'wpwautoposter' ); ?></label>
								</th>
								<td>
									<p><?php _e( 'Posting content to your chosen LinkedIn personal account requires you to grant extended permissions. If you want to use this feature you should grant the extended permissions now.', 'wpwautoposter' ); ?></p>
									<?php										
										$returnurl = admin_url().'edit.php?post_type=wpw_auto_poster&page=wpw-auto-poster-settings';
										
										if( isset( $_SESSION['wpw_auto_poster_li_user_id'] ) && !empty( $_SESSION['wpw_auto_poster_li_user_id'] ) )  {
											
											echo '<p>' . __( 'You already granted extended permissions', 'wpwautoposter' ) . '</p>';	
									?>
									
											<a href="<?php echo $returnurl.'&li_reset_user=1'; ?>"><?php _e( 'Reset User Session', 'wpwautoposter' ); ?></a>
											
									
									<?php
										} else {
										
											echo '<p><a href="' . $liposting->wpw_auto_poster_get_li_login_url() . '">' . __( 'Grant extended permissions', 'wpwautoposter' ) . '</a></p>';
										}
									?>	
								</td>
							</tr> 
																				
							<tr valign="top">
								<td colspan="2">
									<input type="submit" value="<?php _e ( 'Save Changes', 'wpwautoposter' ); ?>" id="wpw_auto_poster_set_submit" name="wpw_auto_poster_set_submit" class="button-primary">
								</td>
							</tr>  													
						</tbody>
					</table>
				</div><!-- .inside -->
			</div><!-- #grant_permissions -->
		</div><!-- .meta-box-sortables ui-sortable -->
	</div><!-- .metabox-holder -->
</div><!-- #wpw-auto-poster-linkein-grant-permission -->
<!-- end of the grant extended permissions meta box -->

<?php } ?>

<!-- beginning of the grant extended permission meta box -->
<div id="wpw-auto-poster-linkein-grant-permission" class="post-box-container">
	<div class="metabox-holder">	
		<div class="meta-box-sortables ui-sortable">
			<div id="grant_permission" class="postbox">	
				<div class="handlediv" title="<?php _e( 'Click to toggle', 'wpwautoposter' ); ?>"><br /></div>
									
				<h3 class="hndle">
					<span style='vertical-align: top;'><?php _e( 'Autopost to LinkedIn', 'wpwautoposter' ); ?></span>
				</h3>
								
				<div class="inside">
					<table class="form-table">
						<tbody>
							
							<tr valign="top">
								<th scope="row">
									<label for="wpw_auto_poster_options[li_post_image]"><?php _e( 'LinkedIn Post Image:', 'wpwautoposter' ); ?></label>
								</th>
								<td>
									<input type="text" name="wpw_auto_poster_options[li_post_image]" id="wpw_auto_poster_options_li_post_image" class="large-text wpw-auto-poster-img-field" value="<?php echo $model->wpw_auto_poster_escape_attr( $wpw_auto_poster_options['li_post_image'] ); ?>">
									<input type="button" class="button-secondary wpw-auto-poster-uploader-button" name="wpw-auto-poster-uploader" value="<?php _e( 'Add Image','wpwautoposter' );?>" />
									<p><small><?php _e( 'Here you can upload a default image which will be used for the LinkedIn wall post.', 'wpwautoposter' ); ?></small></p>
								</td>	
							</tr>
							
							<tr valign="top">
								<td colspan="2">
									<input type="submit" value="<?php _e ( 'Save Changes', 'wpwautoposter' ); ?>" id="wpw_auto_poster_set_submit" name="wpw_auto_poster_set_submit" class="button-primary">
								</td>
							</tr>
						</tbody>
					</table>
				</div><!-- .inside -->
			</div><!-- #grant_permissions -->
		</div><!-- .meta-box-sortables ui-sortable -->
	</div><!-- .metabox-holder -->
</div><!-- #wpw-auto-poster-linkein-grant-permission -->
<!-- end of the grant extended permissions meta box -->
					