<?php

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

/**
 * Settings Page
 *
 * The code for the plugins main settings page
 *
 * @package Social Auto Poster
 * @since 1.0.0
 */
 
global $wpw_auto_poster_options, $wpw_auto_poster_model, $wpw_auto_poster_message_stack,
		$wpw_auto_poster_fb_posting, $wpw_auto_poster_tw_posting, $wpw_auto_poster_li_posting;

//model class
$model = $wpw_auto_poster_model;

//message stack class
$message = $wpw_auto_poster_message_stack;
 
//facebook posting class
$fbposting = $wpw_auto_poster_fb_posting;

//twitter posting class
$twposting = $wpw_auto_poster_tw_posting;

//linkedin posting class
$liposting = $wpw_auto_poster_li_posting;

 ?>
<div class="wrap">

	<!-- Social Auto Poster logo -->
	<img src="<?php echo WPW_AUTO_POSTER_IMG_URL . '/wpw-auto-poster-logo.png'; ?>" class="wpw-auto-poster-logo" alt="<?php _e( 'Logo', 'wpwautoposter' ) ?>" />
		
	<!-- plugin name -->
	<h2><?php esc_attr_e( 'Social Auto Poster Settings', 'wpwautoposter' ); ?></h2><br />
	
	<!-- settings reset -->
	<?php
		if( isset( $_POST['wpw_auto_posting_reset_settings'] ) && $_POST['wpw_auto_posting_reset_settings'] == __( 'Reset All Settings', 'wpwautoposter' ) ) {
			
			// set default settings
			wpw_auto_posting_default_settings(); 
			
			$fbposting->wpw_auto_poster_fb_reset_session(); //facebook session reset
			$liposting->wpw_auto_poster_li_reset_session(); //linkedin session reset
			
			echo '<div id="message" class="updated fade" style="width:95%"><p><strong>' . __( 'All Settings Reset Successfully.', 'wpwautoposter' ) . '</strong></p></div>'; 
		}
	?>
		
	<!-- settings updated message -->
	<?php 
		if( isset( $_GET['settings-updated'] ) ) {

			echo '<div id="message" class="updated fade"><p><strong>' . __( 'Changes Saved.', 'wpwautoposter' ) . '</strong></p></div>'; 
		}
	?>
	
	<form method="post" action="">
		<div class="wpw-auto-poster-posting-reset-setting">
	        <input type="submit" class="button-primary wpw-auto-poster-reset-button" id="wpw_auto_posting_reset_settings" name="wpw_auto_posting_reset_settings" value="<?php _e( 'Reset All Settings', 'wpwautoposter' )?>" />
	     </div>
	</form>  
		
	<!-- beginning of the plugin options form -->
	<form id="wpw_auto_poster_setting" method="post" action="options.php">
		
		<?php settings_fields( 'wpw_auto_poster_plugin_options' ); ?>
		<?php $wpw_auto_poster_options = get_option( 'wpw_auto_poster_options' ); ?>
			
		<!-- beginning of the left meta box section -->
		<div class="content">
				
			<?php
				
				/**
				 * Settings Boxes
				 *
				 * Including all the different settings boxes for the plugin options.
				 *
				 * @package Social Auto Poster
				 * @since 1.0.0
				 */
				
				$general_tab = $facebook_tab = $twitter_tab = $linkedin_tab = '';
				$general_content = $facebook_content = $twitter_content = $linkedin_content = '';
				$selected_tab = '';
				
				if( $message->size( 'poster-selected-tab' ) > 0 ) { //make tab selected 
					//$selected_tab = $message->output( 'poster-selected-tab' );
					$selected_tab = $message->messages[0]['text'];
					
				}
				
				switch( $selected_tab ) {
					
					case 'facebook' : 
									$facebook_tab = 'nav-tab-active';
									$facebook_content = 'wpw-auto-poster-selected-tab';
									break;
					
					case 'twitter' : 
									$twitter_tab = 'nav-tab-active';
									$twitter_content = 'wpw-auto-poster-selected-tab';
									break;
									
					case 'linkedin' : 
									$linkedin_tab = 'nav-tab-active';
									$linkedin_content = 'wpw-auto-poster-selected-tab';
									break;
									
					default : 
									$general_tab = 'nav-tab-active';
									$general_content = 'wpw-auto-poster-selected-tab';
									break;
				}
				
			?>
			
			<h2 class="nav-tab-wrapper wpw-auto-poster-h2">
			
				<a class="nav-tab <?php echo $general_tab; ?>" href="#wpw-auto-poster-tab-0"><img src="<?php echo WPW_AUTO_POSTER_URL; ?>/includes/images/wpw-auto-poster-icon.png" width="24" height="24" alt="gn" title="<?php $model->wpw_auto_poster_escape_attr( 'General', 'wpwautoposter' ); ?>" /></a>
				<a class="nav-tab <?php echo $facebook_tab; ?>" href="#wpw-auto-poster-tab-1"><img src="<?php echo WPW_AUTO_POSTER_URL; ?>/includes/images/facebook_set.png" width="24" height="24" alt="fb" title="<?php $model->wpw_auto_poster_escape_attr( 'Facebook', 'wpwautoposter' ); ?>" /></a>
				<a class="nav-tab <?php echo $twitter_tab; ?>" href="#wpw-auto-poster-tab-2"><img src="<?php echo WPW_AUTO_POSTER_URL; ?>/includes/images/twitter_set.png" width="24" height="24" alt="tw" title="<?php $model->wpw_auto_poster_escape_attr( 'Twitter', 'wpwautoposter' ); ?>" /></a>
				<a class="nav-tab <?php echo $linkedin_tab; ?>" href="#wpw-auto-poster-tab-3"><img src="<?php echo WPW_AUTO_POSTER_URL; ?>/includes/images/linkedin_set.png" width="24" height="24" alt="li" title="<?php $model->wpw_auto_poster_escape_attr( 'LinkedIn', 'wpwautoposter' ); ?>" /></a>
				
			</h2><!--nav-tab-wrapper-->
			<input type="hidden" id="wpw_auto_poster_selected_tab" name="wpw_auto_poster_options[selected_tab]" value="<?php echo $selected_tab;?>"/>
			<div class="wpw-auto-poster-content">
			
				<div class="wpw-auto-poster-tab-content <?php echo $general_content; ?>" id="wpw-auto-poster-tab-0"> 
				
					<?php
				
					// General Settings
					include( WPW_AUTO_POSTER_ADMIN . '/forms/wpw-auto-poster-general-settings.php' );
				
					?>
				
				</div>
		 	
				<div class="wpw-auto-poster-tab-content <?php echo $facebook_content; ?>" id="wpw-auto-poster-tab-1">
				
					<?php
				
					// Facebook Settings
					include( WPW_AUTO_POSTER_ADMIN . '/forms/wpw-auto-poster-facebook.php' );
				
					?>
				
				</div>
		 	
				<div class="wpw-auto-poster-tab-content <?php echo $twitter_content; ?>" id="wpw-auto-poster-tab-2">
				
					<?php
				
					// Twitter Settings
					include( WPW_AUTO_POSTER_ADMIN . '/forms/wpw-auto-poster-twitter.php' );
				
					?>
				
				</div>
				
				<div class="wpw-auto-poster-tab-content <?php echo $linkedin_content; ?>" id="wpw-auto-poster-tab-3">
				
					<?php
				
					// LinkedIn Settings
					include( WPW_AUTO_POSTER_ADMIN . '/forms/wpw-auto-poster-linkedin.php' );
				
					?>
				
				</div>
				
			</div>
			
		</div><!-- .content -->
			
	</form><!-- end of plugin options form -->

</div><!-- .wrap -->