<?php

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

/**
 * Twitter Settings
 *
 * The html markup for the Twitter settings tab.
 *
 * @package Social Auto Poster
 * @since 1.0.0
 */
?>

<!-- beginning of the twitter general settings meta box -->
<div id="wpw-auto-poster-twitter-general" class="post-box-container">
	<div class="metabox-holder">	
		<div class="meta-box-sortables ui-sortable">
			<div id="twitter_general" class="postbox">	
				<div class="handlediv" title="<?php _e( 'Click to toggle', 'wpwautoposter' ); ?>"><br /></div>
								
					<h3 class="hndle">
						<span style='vertical-align: top;'><?php _e( 'Twitter General Settings', 'wpwautoposter' ); ?></span>
					</h3>
									
					<div class="inside">
										
						<table class="form-table">											
							<tbody>										
								<tr valign="top">
									<th scope="row">
										<label for="wpw_auto_poster_options[enable_twitter]"><?php _e( 'Enable Autoposting to Twitter:', 'wpwautoposter' ); ?></label>
									</th>
									<td>
										<input name="wpw_auto_poster_options[enable_twitter]" id="wpw_auto_poster_options[enable_twitter]" type="checkbox" value="1" <?php if( isset( $wpw_auto_poster_options['enable_twitter'] ) ) { checked( '1', $wpw_auto_poster_options['enable_twitter'] ); } ?> />
										<p><small><?php _e( 'Check this box, if you want to automatically post your new content to Twitter.', 'wpwautoposter' ); ?></small></p>
									</td>
								</tr>	

								<tr valign="top">
									<th scope="row">
										<label for="wpw_auto_poster_options[enable_twitter_for]"><?php _e( 'Enable Twitter Autoposting for:', 'wpwautoposter' ); ?></label>
									</th>
									<td>
										<ul>
										<?php 
											$all_types = get_post_types( array( 'public' => true ), 'objects');
											$all_types = is_array( $all_types ) ? $all_types : array();
											
											if( !empty( $wpw_auto_poster_options['enable_twitter_for'] ) ) {
												$prevent_meta = $wpw_auto_poster_options['enable_twitter_for'];
											} else {
												$prevent_meta = '';
											}
															
											$prevent_meta = is_array( $prevent_meta ) ? $prevent_meta : array();
														
											foreach ( $all_types as $type ) {	
												/*if( !empty( $wpw_auto_poster_options['prevent_item_'.$type->name] ) ) {
													$items_count = count( $wpw_auto_poster_options['prevent_item_'.$type->name] );
												} else {
													$wpw_auto_poster_options['prevent_item_'.$type->name] = '';
													$items_count = 0;
												}*/
															
												if ( !is_object( $type ) ) continue;															
													$label = @$type->labels->name ? $type->labels->name : $type->name;
													if( $label == 'Media' || $label == 'media' ) continue; // skip media
													$selected = ( in_array( $type->name, $prevent_meta ) ) ? 'checked="checked"' : '';
										?>
															
											<li class="wpw-auto-poster-prevent-types">
												<input type="checkbox" id="wpw_auto_posting_twitter_prevent_<?php echo $type->name; ?>" name="wpw_auto_poster_options[enable_twitter_for][]" value="<?php echo $type->name; ?>" <?php echo $selected; ?>/>
																						
												<label for="wpw_auto_posting_twitter_prevent_<?php echo $type->name; ?>"><?php echo $label; ?></label>
											</li>
											
											<?php	} ?>
										</ul>
										<p><small><?php _e( 'Check each of the post types that you want to post automatically to Twitter when they get published.', 'wpwautoposter' ); ?></small></p>  
									</td>
								</tr>
								
								<tr valign="top">
									<td colspan="2">
										<input type="submit" value="<?php _e ( 'Save Changes', 'wpwautoposter' ); ?>" id="wpw_auto_poster_set_submit" name="wpw_auto_poster_set_submit" class="button-primary">
									</td>
								</tr> 
							</tbody>
						</table>
										
					</div><!-- .inside -->
									
			</div><!-- #twitter_general -->
		</div><!-- .meta-box-sortables ui-sortable -->
	</div><!-- .metabox-holder -->
</div><!-- #wpw-auto-poster-twitter-general -->
<!-- end of the twitter general settings meta box -->

<!-- beginning of the twitter api settings meta box -->
<div id="wpw-auto-poster-twitter-api" class="post-box-container">
	<div class="metabox-holder">	
		<div class="meta-box-sortables ui-sortable">
			<div id="twitter_api" class="postbox">	
				<div class="handlediv" title="<?php _e( 'Click to toggle', 'wpwautoposter' ); ?>"><br /></div>
								
					<h3 class="hndle">
						<span style='vertical-align: top;'><?php _e( 'Twitter API Settings', 'wpwautoposter' ); ?></span>
					</h3>
									
					<div class="inside">
										
						<table class="form-table">											
							<tbody>			
								<tr valign="top">
								
									<th scope="row">
										<label><?php _e( 'Twitter Application:', 'wpwautoposter' ); ?></label>
									</th>
									<td>
										<p><?php _e( 'Before you can start publishing your content to Twitter you need to create a Twitter Application.', 'wpwautoposter' ); ?></p>
										<p><strong><?php _e( '1. Create an Application for this site on the <a href="https://dev.twitter.com/apps/new" target="_blank">Twitter application registration page.</a>', 'wpwautoposter' ); ?></strong>
											<ul class="twtlist">
												<li><?php _e( 'If you\'re not currently logged in, log-in with the Twitter username and password which you want associated with this site.', 'wpwautoposter' ); ?></li>
												<li><?php _e( 'The name of your application can not include the word "Twitter". Use the name of your web site.', 'wpwautoposter' ); ?></li>
												<li><?php _e( 'You can use whatever you want for your Application Description.', 'wpwautoposter' ); ?></li>
												<li><?php _e( 'The WebSite and Callback URL should be:', 'wpwautoposter' ); ?><strong><?php echo home_url(); ?></strong></li>
											</ul>
										</p>
										<p><strong><?php _e( '2. Go to the "Settings" tab on your Twitter application page.</a>', 'wpwautoposter' ); ?></strong>
											<ul class="twtlist">
												<li><?php _e( '<trong>Important:</strong> You NEED to select "Read and Write" for the Application Type. Make sure, that Twitter saved the settings, especially "Read and Write" correctly.', 'wpwautoposter' ); ?></li>
												<li><?php _e( 'Update the application settings.', 'wpwautoposter' ); ?></li>
											</ul>
										</p>
										<p><strong><?php _e( '3. Copy and paste your consumer key and consumer secret into the fields below.</a>', 'wpwautoposter' ); ?></strong></p>
									</td>
								</tr>	
								
								<tr valign="top">
									<th scope="row">
										<label for="wpw_auto_poster_options[twitter_consumer_key]"><?php _e( 'Consumer Key:', 'wpwautoposter' ); ?></label>
									</th>
									<td>
										<input type="text" name="wpw_auto_poster_options[twitter_consumer_key]" id="wpw_auto_poster_options[twitter_consumer_key]" value="<?php echo $model->wpw_auto_poster_escape_attr( $wpw_auto_poster_options['twitter_consumer_key'] ); ?>" class="large-text">
										<p><small><?php _e( 'Enter Twitter Consumer Key.', 'wpwautoposter' ); ?></small></p>  
									</td>
								</tr>
								
								<tr valign="top">
									<th scope="row">
										<label for="wpw_auto_poster_options[twitter_consumer_secret]"><?php _e( 'Consumer Secret:', 'wpwautoposter' ); ?></label>
									</th>
									<td>
										<input type="text" name="wpw_auto_poster_options[twitter_consumer_secret]" id="wpw_auto_poster_options[twitter_consumer_secret]" value="<?php echo $model->wpw_auto_poster_escape_attr( $wpw_auto_poster_options['twitter_consumer_secret'] ); ?>" class="large-text">
										<p><small><?php _e( 'Enter Twitter Consumer Secret.', 'wpwautoposter' ); ?></small></p>  
									</td>
								</tr>
								
								<tr valign="top">
									<th scope="row">
										<label for="wpw_auto_poster_options[twitter_oauth_token]"><?php _e( 'Access Token:', 'wpwautoposter' ); ?></label>
									</th>
									<td>
										<input type="text" name="wpw_auto_poster_options[twitter_oauth_token]" id="wpw_auto_poster_options[twitter_oauth_token]" value="<?php echo $model->wpw_auto_poster_escape_attr( $wpw_auto_poster_options['twitter_oauth_token'] ); ?>" class="large-text">
										<p><small><?php _e( 'Enter Twitter Access Token.', 'wpwautoposter' ); ?></small></p>  
									</td>
								</tr>
								
								<tr valign="top">
									<th scope="row">
										<label for="wpw_auto_poster_options[twitter_oauth_secret]"><?php _e( 'Access Token Secret:', 'wpwautoposter' ); ?></label>
									</th>
									<td>
										<input type="text" name="wpw_auto_poster_options[twitter_oauth_secret]" id="wpw_auto_poster_options[twitter_oauth_secret]" value="<?php echo $model->wpw_auto_poster_escape_attr( $wpw_auto_poster_options['twitter_oauth_secret'] ); ?>" class="large-text">
										<p><small><?php _e( 'Enter Twitter Access Token Secret.', 'wpwautoposter' ); ?></small></p>  
									</td>
								</tr>
								
								<tr valign="top">
									<td colspan="2">
										<input type="submit" value="<?php _e ( 'Save Changes', 'wpwautoposter' ); ?>" id="wpw_auto_poster_set_submit" name="wpw_auto_poster_set_submit" class="button-primary">
									</td>
								</tr> 
							</tbody>
						</table>
										
					</div><!-- .inside -->
									
			</div><!-- #twitter_api -->
		</div><!-- .meta-box-sortables ui-sortable -->
	</div><!-- .metabox-holder -->
</div><!-- #wpw-auto-poster-twitter-api -->
<!-- end of the twitter api settings meta box -->

<!-- beginning of the twitter template settings meta box -->
<div id="wpw-auto-poster-twitter-template" class="post-box-container">
	<div class="metabox-holder">	
		<div class="meta-box-sortables ui-sortable">
			<div id="twitter_template" class="postbox">	
				<div class="handlediv" title="<?php _e( 'Click to toggle', 'wpwautoposter' ); ?>"><br /></div>
								
					<h3 class="hndle">
						<span style='vertical-align: top;'><?php _e( 'Twitter Template Settings', 'wpwautoposter' ); ?></span>
					</h3>
									
					<div class="inside">
										
						<table class="form-table">											
							<tbody>				
								<tr valign="top">
									<th scope="row">
										<label for="wpw_auto_poster_options[tw_tweet_template]"><?php _e( 'Individual Tweet Template', 'wpwautoposter' ); ?></label>
									</th>
									<td>
										<select name="wpw_auto_poster_options[tw_tweet_template]" id="wpw_auto_poster_options[tw_tweet_template]" class="tw_tweet_template">
											<?php   												
												$select_template = array( "title_link" => __( "[title] - [link]", "wpwautoposter" ), "title_fullauthor_link" => __( "[title] by [full_author] - [link]", "wpwautoposter" ), "title_nickname_link" => __( "[title] by @[nickname_author] - [link]", "wpwautoposter" ), "post_type_title_link" => __( "New [post_type]: [title] - [link]", "wpwautoposter" ), "post_type_title_fullauthor_link" => __( "New [post_type]: [title] by [full_author] - [link]", "wpwautoposter" ), "post_type_title_nickname_link" => __( "New [post_type]: [title] by [nickname_author] - [link]", "wpwautoposter" ), "custom" => __( "Custom", "wpwautoposter" ) );
																
												foreach ( $select_template as $key => $option ) {											
													?>
													<option value="<?php echo $model->wpw_auto_poster_escape_attr( $key ); ?>" <?php selected( $wpw_auto_poster_options['tw_tweet_template'], $key ); ?>>
														<?php esc_html_e( $option ); ?>
													</option>
													<?php
												}															
											?> 														
										</select>
										<p><small style="line-height: 20px;"><?php _e( 'Choose the template you want to use to get your content published on twitter. You can customize this content for your needs. There are also several template tags you can use to customize the content. The template tags will then be replaced with the related information. The available tags are:<br />
											 <code>{title}</code> - displays the post title,<br /> 
											 <code>{link}</code> - displays the post link,<br />
											 <code>{full_author}</code> - displays the full author name,<br />
											 <code>{nickname_author}</code> - displays the nickname of author,<br /> 
											 <code>{post_type}</code> - displays the post type.', 'wpwautoposter' ); ?></small></p>
									</td>
								</tr>
								
								<?php	        
									if( $wpw_auto_poster_options['tw_tweet_template'] == 'custom' ) {	        		
										$showing = '';	        		
									} else {	        		
										$showing = ' style="display:none;"';
									}
								?>
								
								<tr valign="top" id="custom_template"<?php echo $showing; ?>>
									<th scope="row">
										<label for="wpw_auto_poster_options[tw_custom_tweet_template]"><?php _e( 'Custom Tweet Template', 'wpwautoposter' ); ?></label>
									</th>
									<td>
										<input type="text" name="wpw_auto_poster_options[tw_custom_tweet_template]" id="wpw_auto_poster_options[tw_custom_tweet_template]" value="<?php echo $model->wpw_auto_poster_escape_attr( $wpw_auto_poster_options['tw_custom_tweet_template'] ); ?>" class="large-text">
										<p><small><?php _e( 'You can enter a custom tweet template to be used here. Valid tags are [link], [title], [full_author] and [nickname_author].', 'wpwautoposter' ); ?></small></p>
									</td>
								</tr>
								
								<tr valign="top">
									<td colspan="2">
										<input type="submit" value="<?php _e ( 'Save Changes', 'wpwautoposter' ); ?>" id="wpw_auto_poster_set_submit" name="wpw_auto_poster_set_submit" class="button-primary">
									</td>
								</tr> 
							</tbody>
						</table>
										
					</div><!-- .inside -->
									
			</div><!-- #twitter_api -->
		</div><!-- .meta-box-sortables ui-sortable -->
	</div><!-- .metabox-holder -->
</div><!-- #wpw-auto-poster-twitter-template -->
<!-- end of the twitter template settings meta box -->