<?php

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

/**
 * Widget Pack Settings Page
 *
 * The code for the plugins widget pack settings page
 *
 * @package Facebook Autopost
 * @since 1.0.0
 */
echo '<div class="wrap">';

	global $wpdb, $wpweb_fb_model, $wpw_auto_poster_widget_pack;
	
	//modal class
	$model = $wpweb_fb_model;
	
	echo '<img src="' . WPW_AUTO_POSTER_IMG_URL . '/wpw-auto-poster-logo.png' . '" class="wpw-auto-poster-logo" alt="'. __( 'Logo', 'wpwautoposter') .'" />';
	echo '<h2>'. __( "Facebook Widget Pack", 'wpwautoposter') .'</h2>';
	echo '<div class="message important">'.__('Turning a widget on here will make it available in your widget settings.', 'wpwautoposter').'</div>';
	if( isset( $_GET['settings-updated'] ) ) {
		echo '<div id="message" class="updated fade"><p><strong>' . __( 'Changes Saved.', 'wpwautoposter' ) . '</strong></p></div>'; 
	}
	echo '<form method="post" action="options.php">';
	//echo '<h3>'.__('Widget pack','wpwautoposter').'</h3>';
	
	settings_fields( 'wpw_auto_poster_widget_options' );
	
	?>
	
		<table class="form-table"> 
				<tbody>
					<tr>
						<th scope="row" width="15%" valign="top">
							<strong><label for="albums_allowed"><?php _e('Use Facebook Albums widget:', 'wpwautoposter'); ?> </strong></div>
						</th>
						
						<td valign="top">
							<input type="checkbox" value="1"  id="albums_allowed" name="wpw_auto_poster_widget_pack[albums_allowed]" <?php checked( isset( $wpw_auto_poster_widget_pack['albums_allowed']) ? $wpw_auto_poster_widget_pack['albums_allowed'] : '', '1' );  ?>>	
							<div class="wpw_auto_poster_widget_description">
							<?php _e('Easily display Facebook Albums.', 'wpwautoposter'); ?>
							<table>
								 <tbody>
									 <tr>
									 	<th><?php _e('Widget settings preview', 'wpwautoposter'); ?></th>
									 	<th><?php _e('Widget preview', 'wpwautoposter'); ?></th>
									 </tr> 
								 	<tr>
								 		<td valign="top"><img src="<?php echo WPW_AUTO_POSTER_IMG_URL . '/widget/albums_allowed.jpg'; ?>"></td>
								 		<td valign="top"><img src="<?php echo WPW_AUTO_POSTER_IMG_URL . '/widget/albums_allowed_result.jpg'; ?>"></td>
								 	</tr>
								  </tbody>
							</table>
							</div>
						</td>	
					</tr>
					
					<tr>
						<th scope="row" width="15%" valign="top">
							<strong><label for="events_allowed"><?php _e('Use Facebook Events widget:', 'wpwautoposter'); ?> </strong></div>
						</th>
						
						<td valign="top">
							<input type="checkbox" value="1" id="events_allowed" name="wpw_auto_poster_widget_pack[events_allowed]" <?php checked( isset( $wpw_auto_poster_widget_pack['events_allowed']) ? $wpw_auto_poster_widget_pack['events_allowed'] : '', '1' ); ?>>	
							<div class="wpw_auto_poster_widget_description">
							<?php _e('Easily display Facebook Events.', 'wpwautoposter'); ?>
							<table>
								 <tbody>
									 <tr>
									 	<th><?php _e('Widget settings preview', 'wpwautoposter'); ?></th>
									 	<th><?php _e('Widget preview', 'wpwautoposter'); ?></th>
									 </tr> 
								 	<tr>
								 		<td valign="top"><img src="<?php echo WPW_AUTO_POSTER_IMG_URL . '/widget/events_allowed.jpg'; ?>"></td>
								 		<td valign="top"><img src="<?php echo WPW_AUTO_POSTER_IMG_URL . '/widget/events_allowed_result.jpg'; ?>"></td>
								 	</tr>
								  </tbody>
							</table>
							</div>
						</td>	
					</tr>
					
					<tr>
						<th scope="row" width="15%" valign="top">
							<strong><label for="facepile_allowed"><?php _e('Use Facebook Facepile widget:', 'wpwautoposter'); ?> </strong></div>
						</th>
						
						<td valign="top">
							<input type="checkbox" value="1" id="facepile_allowed" name="wpw_auto_poster_widget_pack[facepile_allowed]" <?php checked( isset( $wpw_auto_poster_widget_pack['facepile_allowed']) ? $wpw_auto_poster_widget_pack['facepile_allowed'] : '', '1' ); ?>>	
							<div class="wpw_auto_poster_widget_description">
							<?php _e('Easily display Facebook Facepile.', 'wpwautoposter'); ?>
							<table>
								 <tbody>
									 <tr>
									 	<th><?php _e('Widget settings preview', 'wpwautoposter'); ?></th>
									 	<th><?php _e('Widget preview', 'wpwautoposter'); ?></th>
									 </tr> 
								 	<tr>
								 		<td valign="top"><img src="<?php echo WPW_AUTO_POSTER_IMG_URL . '/widget/facepile_allowed.jpg'; ?>"></td>
								 		<td valign="top"><img src="<?php echo WPW_AUTO_POSTER_IMG_URL . '/widget/facepile_allowed_result.jpg'; ?>"></td>
								 	</tr>
								  </tbody>
							</table>
							</div>
						</td>	
					</tr>
					
					<tr>
						<th scope="row" width="15%" valign="top">
							<strong><label for="likebox_allowed"><?php _e('Use Facebook Like Box widget:', 'wpwautoposter'); ?> </strong></div>
						</th>
						
						<td valign="top">
							<input type="checkbox" value="1" id="likebox_allowed" name="wpw_auto_poster_widget_pack[likebox_allowed]" <?php checked( isset( $wpw_auto_poster_widget_pack['likebox_allowed']) ? $wpw_auto_poster_widget_pack['likebox_allowed'] : '', '1' ); ?>>	
							<div class="wpw_auto_poster_widget_description">
							<?php _e('Easily display Facebook Like Box.', 'wpwautoposter'); ?>
							<table>
								 <tbody>
									 <tr>
									 	<th><?php _e('Widget settings preview', 'wpwautoposter'); ?></th>
									 	<th><?php _e('Widget preview', 'wpwautoposter'); ?></th>
									 </tr> 
								 	<tr>
								 		<td valign="top"><img src="<?php echo WPW_AUTO_POSTER_IMG_URL . '/widget/likebox_allowed.jpg'; ?>"></td>
								 		<td valign="top"><img src="<?php echo WPW_AUTO_POSTER_IMG_URL . '/widget/likebox_allowed_result.jpg'; ?>"></td>
								 	</tr>
								  </tbody>
							</table>
							</div>
						</td>	
					</tr>
					
					<tr>
						<th scope="row" width="15%" valign="top">
							<strong><label for="recommendations_allowed"><?php _e('Use Facebook Recommendations widget:', 'wpwautoposter'); ?> </strong></div>
						</th>
						
						<td valign="top">
							<input type="checkbox" value="1" id="recommendations_allowed" name="wpw_auto_poster_widget_pack[recommendations_allowed]" <?php checked( isset( $wpw_auto_poster_widget_pack['recommendations_allowed']) ? $wpw_auto_poster_widget_pack['recommendations_allowed'] : '', '1' ); ?>>	
							<div class="wpw_auto_poster_widget_description">
							<?php _e('Easily display Facebook Recommendations', 'wpwautoposter'); ?>
							<table>
								 <tbody>
									 <tr>
									 	<th><?php _e('Widget settings preview', 'wpwautoposter'); ?></th>
									 	<th><?php _e('Widget preview', 'wpwautoposter'); ?></th>
									 </tr> 
								 	<tr>
								 		<td valign="top"><img src="<?php echo WPW_AUTO_POSTER_IMG_URL . '/widget/recommendations_allowed.jpg'; ?>"></td>
								 		<td valign="top"><img src="<?php echo WPW_AUTO_POSTER_IMG_URL . '/widget/recommendations_allowed_result.jpg'; ?>"></td>
								 	</tr>
								  </tbody>
							</table>
							</div>
						</td>	
					</tr>
					
					<tr>
						<th scope="row" width="15%" valign="top">
							<strong><label for="activityfeed_allowed"><?php _e('Use Facebook Activity Feed widget:', 'wpwautoposter'); ?> </strong></div>
						</th>
						
						<td valign="top">
							<input type="checkbox" value="1" id="activityfeed_allowed" name="wpw_auto_poster_widget_pack[activityfeed_allowed]" <?php checked( isset( $wpw_auto_poster_widget_pack['activityfeed_allowed']) ? $wpw_auto_poster_widget_pack['activityfeed_allowed'] : '', '1' ); ?>>	
							<div class="wpw_auto_poster_widget_description">
							<?php _e('Easily display Facebook Activity Feed.', 'wpwautoposter'); ?>
							<table>
								 <tbody>
									 <tr>
									 	<th><?php _e('Widget settings preview', 'wpwautoposter'); ?></th>
									 	<th><?php _e('Widget preview', 'wpwautoposter'); ?></th>
									 </tr> 
								 	<tr>
								 		<td valign="top"><img src="<?php echo WPW_AUTO_POSTER_IMG_URL . '/widget/activityfeed_allowed.jpg'; ?>"></td>
								 		<td valign="top"><img src="<?php echo WPW_AUTO_POSTER_IMG_URL . '/widget/activityfeed_allowed_result.jpg'; ?>"></td>
								 	</tr>
								  </tbody>
							</table>
							</div>
						</td>	
					</tr>
					
					<tr>
						<th scope="row" width="15%" valign="top">
							<strong><label for="dashboard_permissions_allowed"><?php _e('Use Facebook Dashboard widgets:', 'wpwautoposter'); ?> </strong></div>
						</th>
						
						<td valign="top">
							<input type="checkbox" value="1" id="dashboard_permissions_allowed" name="wpw_auto_poster_widget_pack[dashboard_permissions_allowed]" <?php checked( isset( $wpw_auto_poster_widget_pack['dashboard_permissions_allowed']) ? $wpw_auto_poster_widget_pack['dashboard_permissions_allowed'] : '', '1' ); ?>>	
							<div class="wpw_auto_poster_widget_description">
							<?php _e('Display extended permissions granting box for your users in the Dashboard.', 'wpwautoposter'); ?>
							<table>
								 <tbody>
									 <tr>
									 	<th><?php _e('Widget settings preview', 'wpwautoposter'); ?></th>
									 	<th></th>
									 </tr> 
								 	<tr>
								 		<td valign="top"><img src="<?php echo WPW_AUTO_POSTER_IMG_URL . '/widget/dashboard_permissions_allowed.jpg'; ?>"></td>
								 		<td valign="top"></td>
								 	</tr>
								  </tbody>
							</table>
							</div>
						</td>	
					</tr>
					
				</tbody>
		</table>		
			
		<?php
			echo apply_filters ( 
								 'wpweb_fb_settings_submit_button', 
								 '<p class="submit"><input class="button-primary" type="submit" name="wpw_auto_poster-widget-set-submit" value="'. __( 'Save Changes', 'wpwautoposter' ).'" /></p>'
								);
		
	echo '</form>';
	echo '</div>';
?>