<?php 

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

/**
 * Renderer Class
 *
 * To handles some small HTML content for front end
 * 
 * @package Social Auto Poster
 * @since 1.0.0
 */
class Wpw_Auto_Poster_Renderer {

	
	public function __construct() {
		
	}
	
	/**
	 * Add Metabox Content
	 * 
	 * Handles to add Metabox content posts
	 * 
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	public function wpw_auto_post_metabox_content( $post ) {
		
		global $wpw_auto_poster_options;
		
		$html = '';
		
		$html .= '<div class="wpw-auto-poster-metabox">';
		
		$html .= '<table>
					<tbody>';
		
		$html .= '	<tr>
						<td colspan="3">
							<input type="checkbox" id="wpw_auto_poster_select_meta_medias" name="wpw_auto_poster_select_meta_medias" value="1" />
							<label for="wpw_auto_poster_select_meta_medias"><strong>'.__( 'Select All Social Medias', 'wpwautoposter' ).'</strong></label>
						</td>
					</tr>';
		
		$html .= '	<tr>';

		$html .= '		<td>';
		
		//Facebook Option
		$html .= 	$this->wpw_auto_poster_show_fb_meta_option( $post );
						
		$html .= ' 		</td>';
		
		$html .= '		<td>';
		
		//Twitter Option
		$html .= 	$this->wpw_auto_poster_show_tw_meta_option( $post );
						
		$html .= ' 		</td>';
		
		$html .= '		<td>';
		
		//LinkedIn Option
		$html .= 	$this->wpw_auto_poster_show_li_meta_option( $post );
						
		$html .= ' 		</td>';
		
		
		$html .= '	</tr>';
		
		$html .= '	</tbody>
				</table>';
		
		$html .= '</div>';
		
		echo $html;
	}
	
	/**
	 * Add Facebook Option to Metabox
	 * 
	 * Handles to return facebook option HTML to metabox
	 * 
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	public function wpw_auto_poster_show_fb_meta_option( $post ) {
		
		global $wpw_auto_poster_options;
		
		$html = '';
		
		$html .= '	<img src="'.WPW_AUTO_POSTER_URL.'includes/images/facebook.png" alt="'.__( 'Facebook','wpwautoposter' ).'" title="'.__( 'Post to Facebook','wpwautoposter' ).'"/>';
		
		if( !empty($wpw_auto_poster_options['enable_facebook']) && in_array( $post->post_type, $wpw_auto_poster_options['enable_facebook_for'] ) ) {
			
			if( WPW_AUTO_POSTER_FB_APP_ID != '' && WPW_AUTO_POSTER_FB_APP_SECRET != '' ) {
			
				$facebook_on_meta = get_post_meta( $post->ID, 'wpw_auto_poster_enable_facebook', true );
				
				$html .= '<div class="wpw-auto-poster-meta-options">';
				$html .= '	<input type="checkbox" name="wpw_auto_poster_post_to_facebook" id="wpw_auto_poster_post_to_facebook" value="1" '.checked('1',$facebook_on_meta, false).'/>';
				$html .= '	<label for="wpw_auto_poster_post_to_facebook">'.__( 'Publish this Post to FaceBook', 'wpwautoposter' ).'</label>';
				$html .= '</div>';
				
			} else {
				
				$html .= '<div class="wpw-auto-poster-meta-desc">'.__('Setup and Authorize your Facebook Account to AutoPost to Facebook','wpwautoposter' ).'</div>';
			}
			
		} else {
			
			$html .= '<div class="wpw-auto-poster-meta-desc">'.__('Enable Facebook Autoposting to Autopost to Facebook.','wpwautoposter' ).'</div>';
			
		}
		
		return $html;
	}
	
	/**
	 * Add Twitter Option to Metabox
	 * 
	 * Handles to return twitter option HTML to metabox
	 * 
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	public function wpw_auto_poster_show_tw_meta_option( $post ) {
		
		global $wpw_auto_poster_options;
		
		$html = '';
		
		$html .= '	<img src="'.WPW_AUTO_POSTER_URL.'includes/images/twitter.png" alt="'.__( 'Twitter','wpwautoposter' ).'" title="'.__( 'Post to Twitter','wpwautoposter' ).'"/>';
			
		if( !empty($wpw_auto_poster_options['enable_twitter']) && in_array( $post->post_type, $wpw_auto_poster_options['enable_twitter_for'] ) ) {
			
			if( WPW_AUTO_POSTER_TW_CONS_KEY != '' && WPW_AUTO_POSTER_TW_CONS_KEY != '' ) {
			
				$twitter_on_meta = get_post_meta( $post->ID, 'wpw_auto_poster_post_to_twitter', true );
				
				$html .= '<div class="wpw-auto-poster-meta-options">';
				$html .= '	<input type="checkbox" name="wpw_auto_poster_post_to_twitter" id="wpw_auto_poster_post_to_twitter" value="1" '.checked('1',$twitter_on_meta, false).'/>';
				$html .= '	<label for="wpw_auto_poster_post_to_twitter">'.__( 'Publish this Post to Twitter', 'wpwautoposter' ).'</label>';
				$html .= '</div>';
				
			} else {
				
				$html .= '<div class="wpw-auto-poster-meta-desc">'.__('Setup and Authorize your Twitter Account to AutoPost to Twitter','wpwautoposter' ).'</div>';
			}
			
		} else {
			
			$html .= '<div class="wpw-auto-poster-meta-desc">'.__('Enable Twitter Autoposting to Autopost to Twitter.','wpwautoposter' ).'</div>';
			
		}
		
		return $html;
	}
	
	/**
	 * Add LinkedIn Option to Metabox
	 * 
	 * Handles to return LinkedIn option HTML to metabox
	 * 
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	public function wpw_auto_poster_show_li_meta_option( $post ) {
		
		global $wpw_auto_poster_options;
		
		$html = '';
		
		$html .= '	<img src="'.WPW_AUTO_POSTER_URL.'includes/images/linkedin.png" alt="'.__( 'LinkedIn','wpwautoposter' ).'" title="'.__( 'Post to LinkedIn','wpwautoposter' ).'"/>';
			
		if( !empty($wpw_auto_poster_options['enable_linkedin']) && in_array( $post->post_type, $wpw_auto_poster_options['enable_linkedin_for'] ) ) {
			
			if( WPW_AUTO_POSTER_LI_APP_ID != '' && WPW_AUTO_POSTER_LI_APP_SECRET != '' ) {
			
				$linkedin_on_meta = get_post_meta( $post->ID, 'wpw_auto_poster_post_to_linkedin', true );
				
				$html .= '<div class="wpw-auto-poster-meta-options">';
				$html .= '	<input type="checkbox" name="wpw_auto_poster_post_to_linkedin" id="wpw_auto_poster_post_to_linkedin" value="1" '.checked('1',$linkedin_on_meta, false).'/>';
				$html .= '	<label for="wpw_auto_poster_post_to_linkedin">'.__( 'Publish this Post to LinkedIn', 'wpwautoposter' ).'</label>';
				$html .= '</div>';
				
			} else {
				
				$html .= '<div class="wpw-auto-poster-meta-desc">'.__('Setup and Authorize your LinkedIn Account to AutoPost to LinkedIn','wpwautoposter' ).'</div>';
			}
			
		} else {
			
			$html .= '<div class="wpw-auto-poster-meta-desc">'.__('Enable LinkedIn Autoposting to Autopost to LinkedIn.','wpwautoposter' ).'</div>';
			
		}
		
		return $html;
	}
	
}
?>