<?php

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

/**
 * Scripts Class
 *
 * Handles adding scripts functionality to the admin pages
 * as well as the front pages.
 *
 * @package Social Auto Poster
 * @since 1.0.0
 */
class Wpw_Auto_Posting_Scripts {
	
	public function __construct() {
		
	}
	
	/**
	 * Enqueuing Styles
	 *
	 * Loads the required stylesheets for displaying the theme settings page in the WordPress admin section.
	 *
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	public function wpw_auto_poster_settings_page_print_styles() {
	
		// loads the required styles for the plugin settings page
		wp_register_style( 'wpw-auto-poster-admin', WPW_AUTO_POSTER_URL . 'includes/css/wpw-auto-poster-admin.css', array(), null );
		wp_enqueue_style( 'wpw-auto-poster-admin' );
			
		// load the required styles for the meta boxes
		wp_enqueue_style( array( 'thickbox' ) );
	}
	
	/**
	 * Enqueuing Scripts
	 *
	 * Loads the JavaScript files required for managing the meta boxes on the theme settings
	 * page, which allows users to arrange the boxes to their liking plus all the other java
	 * script files needed for the settings page.
	 *
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	public function wpw_auto_poster_settings_page_print_scripts( $hook_suffix ) {
		
		if ( $hook_suffix == 'toplevel_page_wpw-auto-poster-settings' ) {
				
			// loads the required scripts for the meta boxes
			wp_enqueue_script( 'common' );
			wp_enqueue_script( 'wp-lists' );
			wp_enqueue_script( 'postbox' );
			wp_enqueue_script( 'jquery' );
			wp_enqueue_script( 'media-upload' );
			wp_enqueue_media(); //imp to work with new media uploader wordpress > 3.5
			wp_enqueue_script( 'thickbox' );
			
		}
	}
	
	/**
	 * Loading Additional Java Script
	 *
	 * Loads the JavaScript required for toggling the meta boxes on the theme settings page.
	 *
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	public function wpw_auto_poster_settings_page_load_scripts() { 
		
		global $wp_version;
		
		$newui = $wp_version >= '3.5' ? '1' : '0'; //check wp version for showing media uploader
		
		wp_register_script( 'wpw-auto-poster-settings', WPW_AUTO_POSTER_URL . 'includes/js/wpw-auto-poster-settings.js', array( 'jquery' ), null );
		wp_enqueue_script( 'wpw-auto-poster-settings' );
		//localize script
		wp_localize_script( 'wpw-auto-poster-settings','WpwAutoPosterSettings',array( 
																						'new_media_ui'	=>	$newui,
																						'confirmmsg' 	=> __( 'Click OK to reset all options. All settings will be lost!', 'wpwautoposter' )
																					) );
		
		?>				
			<script type="text/javascript">
				//<![CDATA[
				jQuery(document).ready( function($) {
					$('.if-js-closed').removeClass('if-js-closed').addClass('closed');
					postboxes.add_postbox_toggles( 'toplevel_page_wpw-auto-poster-settings' );
				});
				//]]>
			</script>
		<?php
	}
	
	/**
	 * Adding Hooks
	 *
	 * Adding proper hoocks for the scripts.
	 *
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	public function add_hooks() {
	
		// adding the admin css to posts for the shortcode popup
		add_action( 'admin_print_scripts-post.php', array( $this, 'wpw_auto_poster_settings_page_print_styles' ));
		add_action( 'admin_print_scripts-post-new.php', array( $this, 'wpw_auto_poster_settings_page_print_styles' ));
		add_action( 'admin_print_scripts-post-edit.php', array( $this, 'wpw_auto_poster_settings_page_print_styles' ));
		
	}
}
?>