<?php

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;


//include the main class file for metabox
//require_once( WPW_AUTO_POSTER_META_DIR . '/meta-box-class.php' );

//include extended metabox class to user in poster plugin
require_once( WPW_AUTO_POSTER_META_DIR . '/class-wpw-auto-poster-meta.php' );

if ( is_admin() ) {
	
	global $wpw_auto_poster_model, $wpw_auto_poster_options,
			$wpw_auto_poster_fb_posting, $wpw_auto_poster_li_posting;
	
	//model class
	$model = $wpw_auto_poster_model;
	
	//posting class
	$fbposting = $wpw_auto_poster_fb_posting;
	$liposting = $wpw_auto_poster_li_posting;
	
	/* 
	 * prefix of meta keys, optional
	 * use underscore (_) at the beginning to make keys hidden, for example $prefix = '_ba_';
	 *  you also can make prefix empty to disable it
	 * 
	 */
	$prefix = WPW_AUTO_POSTER_META_PREFIX;
	
	/* 
	 * configure your meta box
	 */
	$config1 = array(
		'id' => 'wpw_auto_poster_meta',					// meta box id, unique per meta box
		'title' => __( 'Social Auto Poster Settings', 'wpwautoposter'),		// meta box title
		'pages' => 'all',					//insert meta in custom post type
		'context' => 'normal',							// where the meta box appear: normal (default), advanced, side; optional
		'priority' => 'high',							// order of meta box: high (default), low; optional
		'fields' => array(),							// list of meta fields (can be added by field arrays)
		'local_images' => false,						// Use local or hosted images (meta box images for add/remove)
	);
	
	$poster_meta =  new Wpw_Auto_Poster_Social_Meta_Box( $config1 );
	
	/************************************* Facebook Tab Starts ******************************************************/
	
	$twtabon = true; //when facebook tab is off then on twitter tab on by default
	
	if( !isset( $wpw_auto_poster_options['prevent_post_metabox'] ) || empty( $wpw_auto_poster_options['prevent_post_metabox'] )) { //check if not allowed for individual post in settings page
	
		$twtabon = false; //when facebook is on then off twitter tab by default
		
		$fbmetatab = array(
							'class'		=>	'facebook',				//unique class name of each tabs
							'title' 	=>	__('Facebook','wpwautoposter'), //  title of tab
							'active' 	=>	true	//it will by default make tab active on page load
					  );
	
		//initiate tabs in metabox
		$poster_meta->addTabs($fbmetatab);
		
		//get all facebook account authenticated
		$fb_users = $fb_accounts = array();
		$fb_users['']	= __( 'Default', 'wpwautoposter' ); //default value
		
		if( isset( $_SESSION['wpweb_fb_user_accounts'] ) && !empty( $_SESSION['wpweb_fb_user_accounts'] ) ) {
			$fb_accounts = $_SESSION['wpweb_fb_user_accounts'];
			$fb_accounts = isset( $fb_accounts['auth_accounts'] ) ? $fb_accounts['auth_accounts'] : array();
		}
		foreach ($fb_accounts as $key => $value) {
			$fb_users[$key] = $value;
		}
		
		//check facebook application id and secret must entered in settings page or not
		if( WPW_AUTO_POSTER_FB_APP_ID == '' || WPW_AUTO_POSTER_FB_APP_SECRET == '' ) { 
			
			$poster_meta->addGrantPermission( $prefix . 'fb_warning', array( 'desc' => __( 'Enter your Facebook APP ID / Secret within the Settings Page, otherwise the Facebook posting won\'t work.', 'wpwautoposter'), 'url' => admin_url( 'edit.php?post_type=wpw_auto_poster&page=wpw-auto-poster-settings' ), 'urltext' => __( 'Go to the Settings Page', 'wpwautoposter' ),'tab' => 'facebook' ) );
			
		} else {
		
			//check facebook user id is set or not
			if( !isset( $_SESSION['wpweb_fb_user_id'] ) || empty( $_SESSION['wpweb_fb_user_id'] ) )  {
			
				$poster_meta->addGrantPermission( $prefix . 'fb_grant', array( 'desc' => __( 'Your App doesn\'t have enough permissions to publish on Facebook.', 'wpwautoposter'), 'url' => $fbposting->wpw_auto_poster_get_fb_login_url(), 'urltext' => __( 'Grant extended permissions now.', 'wpwautoposter' ),'tab' => 'facebook' ) );
			}
		}
		
		//add label to show status
		$poster_meta->addTweetStatus( $prefix . 'fb_published_on_fb',  array( 'name'=> __( 'Status:', 'wpwautoposter' ), 'desc' => __( 'Status of Facebook wall post like published/unpublished.', 'wpwautoposter' ),'tab' => 'facebook' ) );
		
		//post to facebook
		$poster_meta->addPublishBox( $prefix . 'post_to_facebook', array( 'name'=> __( 'Publish Post On Facebook:', 'wpwautoposter' ), 'desc' => __( 'Publish this Post to FaceBook Userwall.', 'wpwautoposter' ) ,'tab' => 'facebook' ) );
		
		//publish with diffrent post title
		$poster_meta->addText( $prefix . 'fb_custom_title', array( 'validate_func' => 'escape_html', 'name'=> __( 'Custom Title:', 'wpwautoposter' ), 'desc' => __( 'Here you can enter a custom title which will be used for the wall post. Leave it empty to use the post title.', 'wpwautoposter' ), 'tab' => 'facebook' ));
		
		//post to this account
		$poster_meta->addSelect( $prefix . 'fb_user_id', $fb_users, array( 'name'	=> __( 'Post To This Facebook Account:', 'wpwautoposter' ), 'std'=> array( '' ), 'desc' => __( 'Select an account to which you want to post. Leave it empty to use the default one from the settings page.', 'wpwautoposter' ),'tab' => 'facebook') );
		
		$wall_post_types = array(
									'' 				=> __( 'Default', 'wpwautoposter' ),
									'feed'			=> __( 'As a Wall Post', 'wpwautoposter' ),
									'feed_status'	=> __( 'As a Status Update', 'wpwautoposter' ),
									'notes'			=> __( 'As a Note', 'wpwautoposter' ),
									'events'		=> __( 'As an Event', 'wpwautoposter' ),
								);
		
		//post on wall as a type
		$poster_meta->addSelect( $prefix . 'fb_posting_method', $wall_post_types ,array( 'name'	=> __( 'Post As:', 'wpwautoposter' ), 'std'=> array( '' ), 'desc' => __( 'Select a Facebook post type. Leave it empty to use the default one from the settings page.', 'wpwautoposter' ),'tab' => 'facebook') );
	
		//post image url
		$poster_meta->addImage( $prefix . 'fb_post_image', array( 'name'=> __( 'Post Image:', 'wpwautoposter' ), 'desc' => __( 'Here you can upload a default image which will be used for the Facebook wall post. Leave it empty to  use the default one from the settings page.', 'wpwautoposter' ), 'tab' => 'facebook' ) );
		
		//publish with diffrent post title
		$poster_meta->addText( $prefix . 'fb_custom_status_msg', array( 'default' => __( 'New blog post :  {title} - {link}', 'wpwautoposter' ), 'validate_func' => 'escape_html', 'name'=> __( 'Facebook Status Update Text:', 'wpwautoposter' ), 'desc' => __( 'Here you can enter a custom  status update text. Leave it empty to  use the default one from the settings page. You can use following template tags within the status text:<br />
											 <code>{first_name}</code> - displays the first name,<br />
											 <code>{last_name}</code> - displays the last name,<br /> 
											 <code>{title}</code> - displays the post title,<br />
											 <code>{link}</code> - displays the post title with link,<br />
											 <code>{site_name}</code> - displays the name of your site.', 'wpwautoposter' ), 'tab' => 'facebook' ));
		
		//custom link to post to facebook
		$poster_meta->addText( $prefix . 'fb_custom_post_link', array( 'validate_func' => 'escape_html', 'name'=> __( 'Custom Link:', 'wpwautoposter' ), 'desc' => __( 'Here you can enter a custom link which will be used for  the wall post. Leave it empty to use the link of the current post. The link must start with http://', 'wpwautoposter' ), 'tab' => 'facebook' ));
		
		//custom caption to post on facebook
		$poster_meta->addText( $prefix . 'fb_custom_caption', array( 'validate_func' => 'escape_html', 'name'=> __( 'Custom Caption:', 'wpwautoposter' ), 'desc' => __( 'Here you can enter a custom caption of the link (appears beneath the link name). If you leave it empty, Facebook will use the  post URL as caption.', 'wpwautoposter' ), 'tab' => 'facebook' ) );
		
		//publish status descriptin to facebook
		$poster_meta->addTextarea( $prefix . 'fb_custom_post_desc', array( 'validate_func' => 'escape_html', 'name'=> __( 'Custom Description:', 'wpwautoposter' ), 'desc' => __( 'Here you can customize the content which will be used by Facebook for the link description on the wall post. Leave it empty to use description of the current post.', 'wpwautoposter' ), 'tab' => 'facebook' ) );	
		
	}
	/************************************* Facebook Tab Ends ******************************************************/
	
	/************************************* Twitter Tab Starts ******************************************************/
	
	$opttemplate = isset( $wpw_auto_poster_options['tw_tweet_template'] ) ? $wpw_auto_poster_options['tw_tweet_template'] : 'title_link';
	
	//tweet default tempalte 
	$defaulttemplate = $model->wpw_auto_poster_get_tweet_template($opttemplate);
	
	$twmetatab = array(
							'class'		=>	'twitter',				//unique class name of each tabs
							'title' 	=>	__('Twitter','wpwautoposter'), //  title of tab
							'active' 	=>	$twtabon	//it will by default make tab active on page load
					  );
	
	//initiate tabs in metabox
	$poster_meta->addTabs($twmetatab);
	
	if( WPW_AUTO_POSTER_TW_CONS_KEY == '' || WPW_AUTO_POSTER_TW_CONS_SECRET == '' || WPW_AUTO_POSTER_TW_AUTH_TOKEN == '' || WPW_AUTO_POSTER_TW_AUTH_SECRET == '' ) { 
			
		$poster_meta->addGrantPermission( $prefix . 'tw_warning', array( 'desc' => __( 'Enter your Twitter Application Details within the Settings Page, otherwise posting to Twitter won\'t work.', 'wpwautoposter'), 'url' => admin_url( 'edit.php?post_type=wpw_auto_poster&page=wpw-auto-poster-settings' ), 'urltext' => __( 'Go to the Settings Page', 'wpwautoposter' ),'tab' => 'twitter' ) );
		
	}
	
	//add label to show status
	$poster_meta->addTweetStatus( $prefix . 'tw_status',  array( 'name'=> __( 'Status:', 'wpwautoposter' ), 'desc' => __( 'Status of Twitter wall post like published/unpublished.', 'wpwautoposter' ),'tab' => 'twitter' ) );

	//post to twitter
	$poster_meta->addPublishBox( $prefix . 'post_to_twitter', array( 'name'=> __( 'Publish Post On Twitter:', 'wpwautoposter' ), 'desc' => __( 'Publish this Post to Twitter.', 'wpwautoposter' ) , 'tab' => 'twitter' ) );
	
	//twitter status
	//$poster_meta->addSelect( $prefix . 'post_to_twitter', array( '' => __('--Select--','wpwautoposter'), '1' => __('Will be tweeted','wpwautoposter'), '2' => __('Do not tweet','wpwautoposter') ) ,array( 'name'	=> __( 'Post:', 'wpwautoposter' ), 'std'=> array( '' ), 'desc' => __( 'Select wheather this post will be tweeted on twiter or not.', 'wpwautoposter' ),'tab' => 'twitter') );
	
	//tweet mode
	$poster_meta->addTweetMode( $prefix . 'tw_tweet_mode', array( 'name'=> __( 'Mode:', 'wpwautoposter' ), 'desc' => __( 'Tweet Template Mode.', 'wpwautoposter' ),'tab' => 'twitter' ) );
	
	//tweet template, do not change the order for tweet template and tweet preview field
	$poster_meta->addTweetTemplate( $prefix . 'tw_template', array( 'default' => $defaulttemplate, 'validate_func' => 'escape_html', 'name'=> __( 'Tweet Template:', 'wpwautoposter' ), 'desc' => __( 'Here you can enter a custom Tweeter template. Leave it empty to use the default one from the settings page. You can use following template tags within the status text:<br />
											 <code>{title}</code> - displays the post title,<br /> 
											 <code>{link}</code> - displays the post link,<br />
											 <code>{full_author}</code> - displays the full author name,<br />
											 <code>{nickname_author}</code> - displays the nickname of author,<br /> 
											 <code>{post_type}</code> - displays the post type.', 'wpwautoposter' ),'tab' => 'twitter' ) );
	
	//add label to show preview, do not change the order for tweet template and tweet preview field
	$poster_meta->addTweetPreview( $prefix . 'tw_template',  array( 'default' => $defaulttemplate, 'validate_func' => 'escape_html', 'name'=> __( 'Preview:', 'wpwautoposter' ), 'tab' => 'twitter' ) );
	
	/************************************* Twitter Tab Ends ******************************************************/
	
	/************************************* LinkedIn Tab Starts ******************************************************/
	
	$limetatab = array(
							'class'		=>	'linkedin',				//unique class name of each tabs
							'title' 	=>	__('LinkedIn','wpwautoposter'), //  title of tab
							'active' 	=>	false	//it will by default make tab active on page load
					  );
	
	//initiate tabs in metabox
	$poster_meta->addTabs($limetatab);
	
	if( WPW_AUTO_POSTER_LI_APP_ID == '' || WPW_AUTO_POSTER_LI_APP_SECRET == '' ) { 
			
		$poster_meta->addGrantPermission( $prefix . 'li_warning', array( 'desc' => __( 'Enter your LinkedIn Application Details within the Settings Page, otherwise posting to LinkedIn won\'t work.', 'wpwautoposter'), 'url' => admin_url( 'edit.php?post_type=wpw_auto_poster&page=wpw-auto-poster-settings' ), 'urltext' => __( 'Go to the Settings Page', 'wpwautoposter' ),'tab' => 'linkedin' ) );
		
	} else {
	
		if( !isset( $_SESSION['wpw_auto_poster_li_user_id'] ) || empty( $_SESSION['wpw_auto_poster_li_user_id'] ) )  {
			
			$poster_meta->addGrantPermission( $prefix . 'li_grant', array( 'desc' => __( 'Your App doesn\'t have enough permissions to publish on LinkedIn.', 'wpwautoposter'), 'url' => $liposting->wpw_auto_poster_get_li_login_url(), 'urltext' => __( 'Grant extended permissionsnow.', 'wpwautoposter' ),'tab' => 'linkedin' ) );
		}
	}
	
	//add label to show status
	$poster_meta->addTweetStatus( $prefix . 'li_status',  array( 'name'=> __( 'Status:', 'wpwautoposter' ), 'desc' => __( 'Status of LinkedIn wall post like published/unpublished.', 'wpwautoposter' ),'tab' => 'linkedin' ) );
	
	//post to linkedin
	$poster_meta->addPublishBox( $prefix . 'post_to_linkedin', array( 'name'=> __( 'Publish Post On LinkedIn:', 'wpwautoposter' ), 'desc' => __( 'Publish this post to your LinkedIn userwall.', 'wpwautoposter' ) ,'tab' => 'linkedin' ) );
	
	//publish status to linkedin
	$poster_meta->addText( $prefix . 'li_post_title', array( 'validate_func' => 'escape_html', 'name'=> __( 'Custom Title:', 'wpwautoposter' ), 'desc' => __( 'Here you can enter a custom title which will be used for the wall post. Leave it empty to use the post title.', 'wpwautoposter' ), 'tab' => 'linkedin' ));

	//publish status to linkedin image
	$poster_meta->addImage( $prefix . 'li_post_image', array( 'name'=> __( 'Post Image:', 'wpwautoposter' ), 'desc' => __( 'Here you can upload a default image which will be used for the wall post. Leave it empty to use the default one from the settings page.', 'wpwautoposter' ), 'tab' => 'linkedin' ) );
	
	//custom link to post to facebook
	$poster_meta->addText( $prefix . 'li_post_link', array( 'validate_func' => 'escape_html', 'name'=> __( 'Custom Link:', 'wpwautoposter' ), 'desc' => __( 'Here you can enter a custom link which will be used for the wall post. Leave it empty to use the link of the current post. The link must start with http://', 'wpwautoposter' ), 'tab' => 'linkedin' ));
	
	//comment to linkedin
	$poster_meta->addText( $prefix . 'li_post_comment', array( 'validate_func' => 'escape_html', 'name'=> __( 'Comments:', 'wpwautoposter' ), 'desc' => __( 'Here you can customize the content which will be used by LinkedIn for the wall post. Leave it empty to  use the default one from the settings page. You can use following template tags within the status text:<br />
											 <code>{first_name}</code> - displays the first name,<br />
											 <code>{last_name}</code> - displays the last name,<br /> 
											 <code>{title}</code> - displays the post title,<br />
											 <code>{link}</code> - displays the post title with link,<br />
											 <code>{site_name}</code> - displays the name of your site.', 'wpwautoposter' ), 'tab' => 'linkedin' ));
	
	//publish status descriptin to linkedin
	$poster_meta->addTextarea( $prefix . 'li_post_desc', array( 'validate_func' => 'escape_html', 'name'=> __( 'Custom Description:', 'wpwautoposter' ), 'desc' => __( 'Here you can customize the content which will be used by LinkedIn for the link description on the wall post. Leave it empty to use description of the current post.', 'wpwautoposter' ), 'tab' => 'linkedin' ) );
	
	
	/************************************* LinkedIn Tab Ends   ******************************************************/
	
	/*
	 * Don't Forget to Close up the meta box decleration
	 */
	//Finish Meta Box Decleration
	$poster_meta->Finish();
}
?>