<?php

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

/**
 * Fan Page Posting Class
 *
 * Handles all the functions to post the submitted and approved
 * reviews to a chosen Fan Page / Facebook Account.
 *
 * @package Social Auto Poster
 * @since 1.0.0
 */
class Wpw_Auto_Poster_FB_Posting {

	var $facebook,$message,$model;
	var $_user_cache;
	
	public function __construct() {
	
		global $wpw_auto_poster_message_stack,$wpw_auto_poster_model;
		
		$this->message = $wpw_auto_poster_message_stack;
		$this->model = $wpw_auto_poster_model;
		
		//initialize the session value when data is saved in database
		$this->wpw_auto_poster_fb_initialize();
	}
	
	/**
	 * Include Facebook Class
	 * 
	 * Handles to load facebook class
	 * 
	 * @package Social Auto Poster
 	 * @since 1.0.0
	 */
	public function wpw_auto_poster_load_facebook() {
		
		global $wpw_auto_poster_options;
		
		//check facebook application id and application secret is not empty or not
		if( !empty( $wpw_auto_poster_options['fb_app_id'] ) && !empty( $wpw_auto_poster_options['fb_app_secret'] ) ) {
			
			if( !class_exists( 'Facebook' ) ) {
				require_once( WPW_AUTO_POSTER_SOCIAL_DIR . '/facebook/facebook.php' );
			}
			
			$this->facebook = new Facebook( array(
													'appId' => WPW_AUTO_POSTER_FB_APP_ID,
													'secret' => WPW_AUTO_POSTER_FB_APP_SECRET,
													'cookie' => true
												));
			return true;
		} else {
			
			return false;
		}
	}
	
	/**
	 * Initializes external API handlers
	 *
	 * @access private
	 */
	public function wpw_auto_poster_fb_initialize() {
	
		//load facebook class
		$facebook = $this->wpw_auto_poster_load_facebook();
		
		//check facebook class is exis or not
		if( !$facebook ) return false;
		
			// Facebook
			//echo $user = $this->facebook->getUser();
			$user = $this->facebook->getUser();
			
			//check user is logged in facebook or not
			if( $user ) {
				
			 	try {
					
			        // Proceed knowing you have a logged in user who's authenticated.
					$_SESSION['wpweb_fb_user_cache'] = isset( $_SESSION['wpweb_fb_user_cache'] )
						? $_SESSION['wpweb_fb_user_cache'] : $this->facebook->api('/me');
			        $this->_user_cache =  $_SESSION['wpweb_fb_user_cache'];		       
			      
			        $_SESSION['wpweb_fb_user_id'] = isset( $_SESSION['wpweb_fb_user_id'] )
						? $_SESSION['wpweb_fb_user_id'] : $user;
									
					$_SESSION['wpweb_fb_user_accounts'] = $this->wpw_auto_poster_fb_fetch_accounts();
					
					// start code to manage session from database 			
					$wpw_auto_poster_fb_sess_data = get_option( 'wpw_auto_poster_fb_sess_data' );
					
					if( empty( $wpw_auto_poster_fb_sess_data ) ) {
						
						$sess_data = array(
												'wpw_auto_poster_fb_user_cache'		=>	$_SESSION['wpweb_fb_user_cache'],
												'wpw_auto_poster_fb_user_id'		=>	$_SESSION['wpweb_fb_user_id'],
												'wpw_auto_poster_fb_user_accounts'	=>	$_SESSION['wpweb_fb_user_accounts'],
												WPW_AUTO_POSTER_FB_SESS1 			=>	$_SESSION[WPW_AUTO_POSTER_FB_SESS1],
												WPW_AUTO_POSTER_FB_SESS2 			=>	$_SESSION[WPW_AUTO_POSTER_FB_SESS2],
												WPW_AUTO_POSTER_FB_SESS3 			=>	$_SESSION[WPW_AUTO_POSTER_FB_SESS3],
												WPW_AUTO_POSTER_FB_SESS4 			=>	@$_SESSION[WPW_AUTO_POSTER_FB_SESS4],
											);
						
				      	update_option( 'wpw_auto_poster_fb_sess_data', $sess_data );
				    } 	
					
			      	// end code to manage session from database 	
			      	 
				} catch( FacebookApiException $e ) {
	
			 	  	$user = null;
				}
			}
			
			//set session to set tab selected in settings page
			if( isset($_GET['page']) && $_GET['page'] == 'wpw-auto-poster-settings' &&  isset($_GET['code']) && isset($_REQUEST['state']) ) {
			  $this->message->add( 'poster-selected-tab', 'facebook' );
			}
	}
	
	/**
	 * Facebook Login URL
	 *
	 * Getting the login URL from Facebook.
	 *
	 * @@package Social Auto Poster
	 * @since 1.0.0
	 */
	public function wpw_auto_poster_get_fb_login_url() {
		
		//load facebook class
		$facebook = $this->wpw_auto_poster_load_facebook();
		
		//check facebook class is exis or not
		if( !$facebook ) return false;
		
		$portvalue = is_ssl() ? 'https://' : 'http://';
		$redirect_URL = $portvalue.$_SERVER['SERVER_NAME'].$_SERVER['REQUEST_URI'];
		$loginUrl = $this->facebook->getLoginUrl(	array(
														'scope'	=> 'email,offline_access,publish_stream,manage_pages,create_note,create_event',
														'redirect_uri'  => $redirect_URL
													) );
		return $loginUrl;
    }
	
    /**
	 * User Data
	 *
	 * Getting the cached user data from the connected
	 * Facebook user (back end).
	 *
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	public function wpw_auto_poster_get_fb_user_data() {

		if( !empty( $this->_user_cache ) ) {
			return $this->_user_cache;
		}
	}
	
	/**
	 * Pages Tokens
	 *
	 * Getting the the tokens from all pages/accounts which
	 * are associated with the connected Facebook account
	 * so that the admin chan choose to which page/account 
	 * he wants to post the submitted and approved reviews to.
	 *
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	public function wpw_auto_poster_fb_get_pages_tokens() {
		
		//load facebook class
		$facebook = $this->wpw_auto_poster_load_facebook();
		
		//check facebook class is exis or not
		if( !$facebook ) return false;
		
		try {
			$ret = $this->facebook->api( '/' . $_SESSION['wpweb_fb_user_id'] . '/accounts/' );
		} catch ( Exception $e ) {
			return false;
		}
		return $ret;
	}
	
	/**
	 * Fetching Accounts
	 *
	 * Fetching all the associated accounts from the connected
	 * Facebook user (site admin).
	 *
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	public function wpw_auto_poster_fb_fetch_accounts() {
	
		global $wpw_auto_poster_options;
		
		if( !isset( $wpw_auto_poster_options[ 'prevent_linked_accounts_access' ] ) ) {
				
			$page_tokens = $this->wpw_auto_poster_fb_get_pages_tokens();
			$page_tokens = isset( $page_tokens['data'] ) ? $page_tokens['data'] : array();
			
		} else {        	
        	$page_tokens = array();
        }
		
		$api = array();
		$api['auth_accounts'][$_SESSION['wpweb_fb_user_id']] = $this->_user_cache['name']." (".$_SESSION['wpweb_fb_user_id'].")"; 
		$api['auth_tokens'][$_SESSION['wpweb_fb_user_id']] = isset( $_SESSION['fb_'.WPW_AUTO_POSTER_FB_APP_ID.'_access_token'] ) ? $_SESSION['fb_'.WPW_AUTO_POSTER_FB_APP_ID.'_access_token'] : ''; 
			
		if( !isset( $wpw_auto_poster_options[ 'prevent_linked_accounts_access' ] ) ) {
			foreach( $page_tokens as $ptk ) {
				if( !isset( $ptk['id'] ) || !isset( $ptk['access_token'] ) ) continue;
				$api['auth_tokens'][$ptk['id']] = $ptk['access_token'];
				$api['auth_accounts'][$ptk['id']] = $ptk['name'];
			}
		}
			
		return $api;
	}
	
	/**
	 * Facebook Fan Page Posting
	 *
	 * Does handle the function for posting on the Facebook Fan Page
	 * of admin's choice after the review has been submitted and
	 * got approved.
	 *
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	public function wpw_auto_poster_fb_post_to_fanpage( $post_method, $send, $post_to  ) {
	
		global $wpdb, $wpw_auto_poster_options,$post;
		
		//metabox field prefix
		$prefix = WPW_AUTO_POSTER_META_PREFIX;
		
		$wpw_auto_poster_fb_sess_data = get_option( 'wpw_auto_poster_fb_sess_data' );

		$fb_access_token = ( isset( $wpw_auto_poster_fb_sess_data['wpw_auto_poster_fb_user_accounts'] ) && isset( $wpw_auto_poster_fb_sess_data['wpw_auto_poster_fb_user_accounts']['auth_tokens'] ) ) ? $wpw_auto_poster_fb_sess_data['wpw_auto_poster_fb_user_accounts']['auth_tokens'] : array();
		
		// get the value for the fan page from the post meta box
		$fb_user_meta = get_post_meta( $post_id, $prefix . 'fb_user', true );
		
		$post_to = '';	
		// check if we have some value for the fan page from the post meta box
		if( !empty( $fb_user_meta ) ) {
			$post_to = $fb_user_meta;
		} else {
			// if we don't we will use the one from the settings page
			if( isset( $wpw_auto_poster_options['fb_user'] ) && !empty( $wpw_auto_poster_options['fb_user'] ) ) {				
				$post_to = $wpw_auto_poster_options['fb_user'];
			} 
		}
		
		if( isset( $fb_access_token[$post_to] ) ) {
			$send['access_token'] = $fb_access_token[$post_to]; // most imp line 
		} else {
			$send['access_token'] = '';
		}		
	
		if( !empty( $post_to ) && !empty( $send['access_token'] ) ) {	// if Post Reviews to this Fan Page/Account option is set 			
		
			//load facebook class
			$facebook = $this->wpw_auto_poster_load_facebook();
			
			//check facebook class is exis or not
			if( !$facebook ) return false;
				
			try {				
				$ret = $this->facebook->api( '/'.$post_to.'/'.$post_method.'/', 'POST', $send );										
				//return $ret;
			} catch ( Exception $e ) {
				//return false;
			}
		}
	}
	
	/**
	 * Post to User Wall on Facebook
	 * 
	 * Handles to post user wall on facebook
	 * 
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	public function wpw_auto_poster_fb_post_to_userwall( $post ) {
		
		global $wpw_auto_poster_options;
		
		//metabox field prefix
		$prefix = WPW_AUTO_POSTER_META_PREFIX;
		
		$post_type 	= $post->post_type; //post type
		$unique = 'false';
		$userdata = get_userdata( $post->post_author );
		$first_name = $userdata->first_name; //user first name
		$last_name = $userdata->last_name; //user last name
		
		//published status
		$ispublished = get_post_meta( $post->ID, $prefix . 'fb_published_on_fb', true );
		
		if ( !isset( $wpw_auto_poster_options['prevent_post_metabox'] ) ) { //check if prevent metabox is not enable
			
			$wpw_auto_poster_fb_custom_title= get_post_meta( $post->ID, $prefix . 'fb_custom_title', true );
			$wpw_auto_poster_fb_user_id 	= get_post_meta( $post->ID, $prefix . 'fb_user_id', true );
			$wpw_auto_fb_posting_method 	= get_post_meta( $post->ID, $prefix . 'fb_posting_method', true );
			$wpw_auto_fb_custom_status_msg 	= get_post_meta( $post->ID, $prefix . 'fb_custom_status_msg', true );
			$wpw_auto_poster_published 		= get_post_meta( $post->ID, $prefix . 'fb_publish', true );
			$wpw_auto_poster_custom_link 	= get_post_meta( $post->ID, $prefix . 'fb_custom_post_link', true );
			$wpw_auto_poster_custom_desc 	= get_post_meta( $post->ID, $prefix . 'fb_custom_post_desc', true );
			$wpw_auto_poster_custom_caption = get_post_meta( $post->ID, $prefix . 'fb_custom_caption', true );
			$wpw_auto_poster_custom_img 	= get_post_meta( $post->ID, $prefix . 'fb_post_image', true );
			
		}
		
		//get facebook user data
		$wpw_auto_poster_fb_sess_data 	= get_option( 'wpw_auto_poster_fb_sess_data' );

		//facebook access token
		$fb_access_token 			= ( isset( $wpw_auto_poster_fb_sess_data['wpw_auto_poster_fb_user_accounts'] ) 
										&& isset( $wpw_auto_poster_fb_sess_data['wpw_auto_poster_fb_user_accounts']['auth_tokens'] ) ) 
										? $wpw_auto_poster_fb_sess_data['wpw_auto_poster_fb_user_accounts']['auth_tokens'] : array();
		
		//check facebook posting is enable or not
		if( empty( $wpw_auto_poster_options['enable_facebook'] ) && !$wpw_auto_poster_published ) {
			return false;
		}
		
		//post custom title for posting on facebook userwall
		if( isset( $wpw_auto_poster_fb_custom_title ) && !empty( $wpw_auto_poster_fb_custom_title ) ) {
			$title = $wpw_auto_poster_fb_custom_title;
		} else {
			$title = $post->post_title;
		}
		
		//posting method
		$post_as 	= isset( $wpw_auto_fb_posting_method ) && !empty( $wpw_auto_fb_posting_method ) ? $wpw_auto_fb_posting_method :  $wpw_auto_poster_options[ 'fb_type_'.$post_type.'_method' ];
		
		//facebook user id on whose wall the post will be posted
		$fb_user_id = isset( $wpw_auto_poster_fb_user_id ) && !empty( $wpw_auto_poster_fb_user_id ) ? $wpw_auto_poster_fb_user_id : $wpw_auto_poster_options[ 'fb_type_'.$post_type.'_user' ];
		$post_to 	= $fb_user_id;
		
		//post link for posting to facebook user wall
		$postlink = isset( $wpw_auto_poster_custom_link ) && !empty( $wpw_auto_poster_custom_link ) ? $wpw_auto_poster_custom_link : '';
		//if custom link is set or not
		$customlink = !empty( $postlink ) ? 'true' : 'false';
		//do url shortner
		$postlink = $this->model->wpw_auto_poster_get_short_post_link( $postlink, $unique, $post->ID, $customlink );

		//if post is published on facebook once then change url to prevent duplication
		if( isset( $ispublished ) && !empty( $ispublished ) ) { 
			$unique = 'true';
		}
		
		//check facebook user id is selected for posting or not
		if( !$post_to ) {
			return false;
		}
		
		//custom status message to post on facebook
		$custom_msg 	= isset( $wpw_auto_fb_custom_status_msg ) && $wpw_auto_fb_custom_status_msg ? $wpw_auto_fb_custom_status_msg : $wpw_auto_poster_options[ "custom_status_msg" ];
		
		//post content to post
		$post_content = isset( $wpw_auto_poster_custom_desc ) && !empty( $wpw_auto_poster_custom_desc ) ? $wpw_auto_poster_custom_desc
							: strip_shortcodes( $post->post_content );
		
		//strip html kses and tags
		$post_content = $this->model->wpw_auto_poster_stripslashes_deep( $post_content );
		
		//post custom caption to post on facebook
		$post_caption = isset( $wpw_auto_poster_custom_caption ) && !empty( $wpw_auto_poster_custom_caption ) ? $wpw_auto_poster_custom_caption : '';
							
		//post custom image to post on facebook
		$post_img = isset( $wpw_auto_poster_custom_img ) && !empty( $wpw_auto_poster_custom_img ) ? $wpw_auto_poster_custom_img['src']
						: $wpw_auto_poster_options['fb_custom_img'];
						
		switch( $post_as ) {
			
			case "notes":
				$post_method = 'notes';
				$send = array (
					'subject' => $title,
					'message' => $post_content
				);
				break;
				
			case "events":				
				$post_method = 'events';				
				$date = new DateTime( date( 'Y-m-d H:i:s' ) );
				$date->modify( '+1 day' );
				$start_date = $date->format( 'Y-m-d' );
				$send = array(
					'name' => $title,
					'description' => $post_content,
					'start_time' =>  $start_date, // '2012-03-14T14:00:00'
					'location' => 'someplace' 
				);
				break;
				
			case "feed_status":				
				$post_method = 'feed';				
				$search_arr = array( '{title}', '{link}', '{first_name}' , '{last_name}', '{site_name}', '%title%', '%link%' );
				$replace_arr = array( $title, $postlink,$first_name, $last_name, get_option( 'blogname' ), $title, $postlink  );
				$final_msg = str_replace( $search_arr, $replace_arr, $custom_msg ); 				
				$send = array(
					'message' => $final_msg
				 );
				break;	
				
			case "feed":
			default:				
				$post_method = 'feed';
				$send = array();
				
				if( !empty( $post_img ) ) {	$send['picture'] = $post_img; }
				if( !empty( $post_caption ) ) { $send['caption'] = substr($post_caption, 0, 999); }
				
				$send['message'] = substr( $title, 0, 999 );
				$send['link'] = $postlink;
				$send['name'] = $post->post_title;
				$send['description'] = $post_content;
				
				break;
		}
		
		if( isset( $fb_access_token[$post_to] ) ) {
			$send['access_token'] = $fb_access_token[$post_to]; // most imp line 
		} else {
			$send['access_token'] = '';
		}		
	
		if( !empty( $post_to ) && !empty( $send['access_token'] ) ) {	// if Post Reviews to this Fan Page/Account option is set 			
			
			//load facebook class
			$facebook = $this->wpw_auto_poster_load_facebook();
			
			//check facebook class is exis or not
			if( !$facebook ) return false;
			
				try {
					$ret = $this->facebook->api( '/'.$post_to.'/'.$post_method.'/', 'POST', $send );
					return $ret;
				} catch ( Exception $e ) {
					//return $e;
					return false;
				}
		}
	}
	
	/**
	 * Reset Sessions
	 *
	 * Resetting the Facebook sessions when the admin clicks on
	 * its link within the settings page.
	 *
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	function wpw_auto_poster_fb_reset_session() {
		
		unset( $_SESSION['wpweb_fb_user_id'] );
		unset( $_SESSION['wpweb_fb_user_cache'] );
		unset( $_SESSION['wpweb_fb_user_accounts'] );
		update_option( 'wpw_auto_poster_fb_sess_data', '' );
		
		unset( $_SESSION[WPW_AUTO_POSTER_FB_SESS1] );
		unset( $_SESSION[WPW_AUTO_POSTER_FB_SESS2] );
		unset( $_SESSION[WPW_AUTO_POSTER_FB_SESS3] );
		unset( $_SESSION[WPW_AUTO_POSTER_FB_SESS4] );
	}
	
	/**
	 * Get album photos from facebook
	 *
	 * Handle to get album photos for particular id from facebook
	 *
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	function wpw_auto_poster_fb_get_album_photos($aid, $limit=false) {
		
		//load facebook class
		$facebook = $this->wpw_auto_poster_load_facebook();
		
		//check facebook class is exis or not
		if( !$facebook ) return false;
		
		if (!$aid) return false;
		$limit = $limit ? '?limit=' . $limit : '';
		
		$fb_access_token = isset($_SESSION['wpweb_fb_user_accounts']['auth_tokens']) ? $_SESSION['wpweb_fb_user_accounts']['auth_tokens'] : array();
		$token = $fb_access_token[$_SESSION['wpweb_fb_user_id']]; 
		$send['access_token'] = $token; // most imp line 
		
		try {
			$res = $this->facebook->api('/' . $aid . '/photos/' . $limit,'GET',$send); 
			
		} catch (Exception $e) {
			
			return false;
		}
		return $res;
	}
	
	/**
	 * Get all events from facebook
	 *
	 * Handle to get all events for particular id from facebook
	 *
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	function wpw_auto_poster_fb_get_events_for($for) {
		
		//load facebook class
		$facebook = $this->wpw_auto_poster_load_facebook();
		
		//check facebook class is exis or not
		if( !$facebook ) return false;
		
		if (!$for) return false;
		
		$fb_access_token = isset($_SESSION['wpweb_fb_user_accounts']['auth_tokens']) ? $_SESSION['wpweb_fb_user_accounts']['auth_tokens'] : array();
		//$token = $fb_access_token[$for]; 
		
		if(isset($fb_access_token[$for])) {
			
			$token = $fb_access_token[$for]; 
			
		} else {
			//echo "HERE";
			return false;
		}
		$send['access_token'] = $token; // most imp line 
		
		try {
			$res = $this->facebook->api('/' . $for . '/events/','GET',$send);
		} catch (Exception $e) {
			echo $e;
			return false;
		}
		return $res;
	}
	
	/**
	 * Get all albums from facebook
	 *
	 * Handle to get all albums for particular id from facebook
	 *
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	function wpw_auto_poster_fb_get_albums_for($for) {

		//load facebook class
		$facebook = $this->wpw_auto_poster_load_facebook();
		
		//check facebook class is exis or not
		if( !$facebook ) return false;
		
		if (!$for) return false;

		$fb_access_token = isset($_SESSION['wpweb_fb_user_accounts']['auth_tokens']) ? $_SESSION['wpweb_fb_user_accounts']['auth_tokens'] : array();
		$token = $fb_access_token[$for]; 
		$send['access_token'] = $token; // most imp line 
		try {
			
			$res = $this->facebook->api('/' . $for . '/albums/?auth_token=' . $send);
		
			
		} catch (Exception $e) {
			
			return false;
		}
		
		return $res;
	}
	
	/**
	 * Display html in dashboard widget for grant permission
	 *
	 * Handle to display html in dashboard widget for grant permission facebook
	 *
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	function wpw_auto_poster_dashboard_permissions_widget() {
							
		$returnurl = admin_url().'edit.php?post_type=wpw_auto_poster&page=wpw-auto-poster-settings'; 
										
		if( isset( $_SESSION['wpweb_fb_user_id'] ) && !empty( $_SESSION['wpweb_fb_user_id'] ) )  {
			
			echo '<p>' . __( 'You already granted extended permissions.', 'wpwautoposter' ) . '</p>';	
	
			echo '<a href="' . $returnurl . '&fb_reset_user=1">' . __( 'Reset User Session', 'wpwautoposter' ) . '</a>';
	
		} else {
		
			echo '<p><a href="' . $this->wpw_auto_poster_get_fb_login_url() . '">' . __( 'Grant extended permissions', 'wpwautoposter' ) . '</a></p>';
		}
	}
										
}