<?php

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

/**
 * LinkedIn Posting Class
 *
 * Handles all the functions to post the submitted and approved
 * reviews to a chosen application owner account
 *
 * @package Social Auto Poster
 * @since 1.0.0
 */
class Wpw_Auto_Poster_Li_Posting {
	
	var $linkedinconfig,$linkedin,$message,$model;
	
	public function __construct() {
	
		global $wpw_auto_poster_message_stack,$wpw_auto_poster_model;
		
		$this->message = $wpw_auto_poster_message_stack;
		$this->model = $wpw_auto_poster_model;
		
		//intialize some data
		$this->wpw_auto_poster_li_initialize();
	}
	
	/**
	 * Include LinkedIn Class
	 * 
	 * Handles to load Linkedin class
	 * 
	 * @package Social Auto Poster
 	 * @since 1.0.0
	 */
	public function wpw_auto_poster_load_linkedin() {
		
		global $wpw_auto_poster_options;
	
		//linkedin declaration
		if( !empty( $wpw_auto_poster_options['linkedin_app_id'] ) && !empty( $wpw_auto_poster_options['linkedin_app_secret'] ) ) {

			if( !class_exists( 'LinkedIn' ) ) {
				require_once( WPW_AUTO_POSTER_SOCIAL_DIR . '/linkedin/class-linkedin.php' );
			}
			
			//linkedin api configuration
			$this->linkedinconfig = array(
									    	'appKey'       => WPW_AUTO_POSTER_LI_APP_ID,
										  	'appSecret'    => WPW_AUTO_POSTER_LI_APP_SECRET,
										  	'callbackUrl'  => NULL 
									  	 );
									  	 
			$this->linkedin = new LinkedIn( $this->linkedinconfig );
			
			return true;
			
		} else {
			
			return false;
		}
	}
	
	/**
	 * Make Logged In User to LinekedIn
	 * 
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	public function wpw_auto_poster_li_user_logged_in() {
		
		global $wpw_auto_poster_options;
		
		if( !empty( $wpw_auto_poster_options['linkedin_app_id'] ) && !empty( $wpw_auto_poster_options['linkedin_app_secret'] ) ) {
			
			//check $_GET['wpwautoposter'] equals to linkedin
			if( isset( $_GET['wpwautoposter'] ) && $_GET['wpwautoposter'] == 'linkedin' ) {
				
				//load linkedin class
				$linkedin = $this->wpw_auto_poster_load_linkedin();
				
				//check linkedin loaded or not
				if( !$linkedin ) return false;
				
				// code will excute when user does connect with linked in
				if( isset( $_REQUEST[LINKEDIN::_GET_TYPE] ) && $_REQUEST[LINKEDIN::_GET_TYPE] == 'initiate' ) { // if user allows access to linkedin
				
					$this->linkedinconfig['callbackUrl'] = add_query_arg( array( 'wpwautoposter' => 'linkedin', LINKEDIN::_GET_TYPE => 'initiate', LINKEDIN::_GET_RESPONSE => '1' ), $this->model->wpw_auto_poster_self_url() );
					$this->linkedin = new LinkedIn( $this->linkedinconfig );
				   
					// check for response from LinkedIn
					$_GET[LINKEDIN::_GET_RESPONSE] = ( isset( $_GET[LINKEDIN::_GET_RESPONSE] ) ) ? $_GET[LINKEDIN::_GET_RESPONSE] : '';
			     
					if( !$_GET[LINKEDIN::_GET_RESPONSE] ) { // this code get executed when the user clicks on the button and linkedin does ask for permission 
				      	
						// LinkedIn hasn't sent us a response, the user is initiating the connection
						// send a request for a LinkedIn access token
						$response = $this->linkedin->retrieveTokenRequest();
					    
						if( $response['success'] === TRUE ) {
							
							// store the request token
							$_SESSION['wpw_auto_poster_linkedin_oauth']['linkedin']['request'] = $response['linkedin'];
				         
							// redirect the user to the LinkedIn authentication/authorisation page to initiate validation.
							wp_redirect( LINKEDIN::_URL_AUTH . $response['linkedin']['oauth_token']);
							exit;
							
			          	} else {
							// bad token request
							echo __( 'Request token retrieval failed', 'wpwautoposter' );
				        }		        
				      } else { //this code will execute when the user clicks on the allow access button on linkedin
				      
					        // LinkedIn has sent a response, user has granted permission, take the temp access token, the user's secret and the verifier to request the user's real secret key
					        $response = $this->linkedin->retrieveTokenAccess( $_SESSION['wpw_auto_poster_linkedin_oauth']['linkedin']['request']['oauth_token'], $_SESSION['wpw_auto_poster_linkedin_oauth']['linkedin']['request']['oauth_token_secret'], $_GET['oauth_verifier'] );
					       
					        if( $response['success'] === TRUE ) {
								// the request went through without an error, gather user's 'access' tokens
								$_SESSION['wpw_auto_poster_linkedin_oauth']['linkedin']['access'] = $response['linkedin'];
					          
								// set the user as authorized for future quick reference
								$_SESSION['wpw_auto_poster_linkedin_oauth']['linkedin']['authorized'] = TRUE;
								
								//get profile data
								$this->linkedin = new LinkedIn( $this->linkedinconfig );
								$this->linkedin->setTokenAccess( $_SESSION['wpw_auto_poster_linkedin_oauth']['linkedin']['access'] );
								$this->linkedin->setResponseFormat( LINKEDIN::_RESPONSE_XML );
								
								//add user data to session for further user
								$resultdata = array();
								$response = $this->linkedin->profile( '~:(id,first-name,last-name,picture-url,email-address,date-of-birth,public-profile-url)' );
								//convert xml object to simple array
						        $resultdata = json_decode( json_encode( ( array ) simplexml_load_string( $response['linkedin'] ) ), 1 );
						        
						        //set user data to sesssion for further use
						        $_SESSION['wpw_auto_poster_linkedin_user_cache'] = $resultdata;
					           	
								// redirect the user back to the demo page
								$this->message->add_session( 'poster-selected-tab', 'linkedin' );
								
								//wp_redirect(admin_url('edit.php?post_type=wpw_auto_poster&page=wpw-auto-poster-settings'));
								$redirectselfurl = add_query_arg( array( 
																			LINKEDIN::_GET_TYPE 	=> 	false, 
																			LINKEDIN::_GET_RESPONSE => 	false,
																			'oauth_token'			=>	false,
																			'oauth_verifier'		=> 	false,
																			'wpwautoposter'		=>	false
																	 	), 
																		$this->model->wpw_auto_poster_self_url()
																	);
								//set user data  to session
								$this->wpw_auto_poster_set_li_data_to_session();
				
								wp_redirect( $redirectselfurl );
								exit;
								
					        } else {
								// bad token access
								echo __( 'Access token retrieval failed', 'wpwautoposter' );
					        }
					        
				      } //end else
			      
			  	} //end if $_REQUEST[LINKEDIN::_GET_TYPE] == 'initiate'
				
			} //end if to check $_GET['wpwautoposter'] equals to linkedin
			
		} //end if to check linkedin app id and secret are not empty
		
	}
		
	/**
	 * Initializes Some Data to session
	 * 
	 * @package Social Auto Poster
	 * @since 1.0.0
	 * 
	 */
	public function wpw_auto_poster_li_initialize() {
		
		global $wpw_auto_poster_options;
		
		//check user data is not empty and linkedin app id and secret are not empty
		if( !empty( $wpw_auto_poster_options['linkedin_app_id'] ) && !empty( $wpw_auto_poster_options['linkedin_app_secret'] ) ) {
			
			//Set Session From Options Value
			$wpw_auto_poster_li_sess_data = get_option( 'wpw_auto_poster_li_sess_data' );
			
			if( !empty( $wpw_auto_poster_li_sess_data ) && !isset( $_SESSION['wpw_auto_poster_li_user_id'] ) ) { //check user data is not empty
				
				$_SESSION['wpw_auto_poster_li_user_id'] = $wpw_auto_poster_li_sess_data['wpw_auto_poster_li_user_id'];
				$_SESSION['wpw_auto_poster_li_cache'] = $wpw_auto_poster_li_sess_data['wpw_auto_poster_li_cache'];
				$_SESSION['wpw_auto_poster_li_oauth'] = $wpw_auto_poster_li_sess_data['wpw_auto_poster_li_oauth'];
				$_SESSION['wpw_auto_poster_linkedin_oauth'] = $wpw_auto_poster_li_sess_data['wpw_auto_poster_li_oauth']; //assign stored oauth token to database
			}
		} 
	}
	
	/**
	 * Get LinkedIn Login URL
	 * 
	 * Handles to Return LinkedIn URL
	 * 
	 * @package Social Auto Poster
	 * @since 1.0.0
	 * 
	 */
	public function wpw_auto_poster_get_li_login_url() {
		
		//load linkedin class
		$linkedin = $this->wpw_auto_poster_load_linkedin();
		
		//check linkedin loaded or not
		if( !$linkedin ) return false;
		
		//'wpwautoposter' => 'linkedin',
		$preparedurl = add_query_arg( array( 'wpwautoposter' => 'linkedin', LINKEDIN::_GET_TYPE => 'initiate', 'code' => false, 'state' => false ) ); 
		return $preparedurl;
		
	}
	
	
	/**
	 * Post To LinkedIn
	 * 
	 * Handles to Posting to Linkedin
	 *
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	public function wpw_auto_poster_post_to_linkedin( $post ) {
		
		global $wpw_auto_poster_options;
		
		//load linkedin class
		$linkedin = $this->wpw_auto_poster_load_linkedin();
		
		//meta prefix
		$prefix = WPW_AUTO_POSTER_META_PREFIX;
		
		//check linkedin loaded or not
		if( !$linkedin ) return false;
		
		//check linkedin authorized session is true or not
		//need to do for linkedin posting code
		if( $_SESSION['wpw_auto_poster_linkedin_oauth']['linkedin']['authorized'] === TRUE ) {
			$this->linkedin = new LinkedIn( $this->linkedinconfig );
			$this->linkedin->setTokenAccess( $_SESSION['wpw_auto_poster_linkedin_oauth']['linkedin']['access'] );
			$this->linkedin->setResponseFormat(LinkedIn::_RESPONSE_XML);
		}
		
		$unique = 'false';
				
		//user data
		$userdata = get_userdata( $post->post_author );
		$first_name = $userdata->first_name; //user first name
		$last_name = $userdata->last_name; //user last name
		
		//published status
		$ispublished = get_post_meta( $post->ID, $prefix . 'li_status', true );
		
		//post title
		$posttitle = $post->post_title;
		$customtitle = get_post_meta( $post->ID, $prefix . 'li_post_title', true );
		$title = !empty( $customtitle ) ? $customtitle : $posttitle;
		
		//post image
		$postimage = get_post_meta( $post->ID, $prefix . 'li_post_image', true );
		$postimage = isset( $postimage['src'] ) && !empty( $postimage['src'] ) ? $postimage['src'] : $wpw_auto_poster_options['li_post_image'];
		
		//post link
		$postlink = get_post_meta( $post->ID, $prefix . 'li_post_link', true );
		$postlink = isset( $postlink ) && !empty( $postlink ) ? $postlink : '';
		//if custom link is set or not
		$customlink = !empty( $postlink ) ? 'true' : 'false';
		//do url shortner
		$postlink = $this->model->wpw_auto_poster_get_short_post_link( $postlink, $unique, $post->ID, $customlink );
		
		//if post is published on facebook once then change url to prevent duplication
		if( isset( $ispublished ) && $ispublished == '1' ) {
			$unique = 'true';
		}
		
		//comments
		$comments = get_post_meta( $post->ID, $prefix . 'li_post_comment', true );
		$comments = !empty( $comments ) ? $comments : '';
		
		//description
		$description = get_post_meta( $post->ID, $prefix . 'li_post_desc', true );
		$description = !empty( $description ) ? $description : strip_shortcodes( $post->post_content );
		$description = $this->model->wpw_auto_poster_stripslashes_deep( $description );
		
		$search_arr = array( '{title}', '{link}', '{first_name}' , '{last_name}', '{sitename}' );
		$replace_arr = array( $title, $postlink, $first_name, $last_name, get_option( 'blogname') );
		$comments = str_replace( $search_arr, $replace_arr, $comments ); 				
		
		$content = array( 
							'title' 				=> $title,
							'submitted-url'			=> $postlink,
							'comment'				=> $comments,
							'submitted-image-url'	=> $postimage,
							'description'			=> $description
						);
		
		try {	
				
			$ret = $this->linkedin->share( 'new', $content );
			return $ret;
				
		} catch ( Exception $e ) {
			//return $e;
			return false;
		}
		
	}
	
	/**
	 * Get LinkedIn User Data
	 *
	 * Function to get LinkedIn User Data
	 *
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	public function wpw_auto_poster_get_li_user_data() {
	
		$user_profile_data = '';
		
		if ( isset( $_SESSION['wpw_auto_poster_linkedin_user_cache'] ) && !empty( $_SESSION['wpw_auto_poster_linkedin_user_cache'] ) ) {
		
			$user_profile_data = $_SESSION['wpw_auto_poster_linkedin_user_cache'];
		}
		return $user_profile_data;
	}
	
	/**
	 * Set Session Data of linkedin to session
	 * 
	 * Handles to set user data to session
	 * 
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	public function wpw_auto_poster_set_li_data_to_session() {
		
		//fetch user data who is grant the premission
		$liuserdata = $this->wpw_auto_poster_get_li_user_data();
		
		if( isset( $liuserdata['id'] ) && !empty( $liuserdata['id'] ) ) {

			try {
		        
		        $_SESSION['wpw_auto_poster_li_user_id'] = isset( $_SESSION['wpw_auto_poster_li_user_id'] )
					? $_SESSION['wpw_auto_poster_li_user_id'] : $liuserdata['id'];

				$_SESSION['wpw_auto_poster_li_cache']	= isset( $_SESSION['wpw_auto_poster_li_cache'] ) 
					? $_SESSION['wpw_auto_poster_li_cache'] : $liuserdata;
					
				$_SESSION['wpw_auto_poster_li_oauth'] = isset( $_SESSION['wpw_auto_poster_li_oauth'] ) 
					? $_SESSION['wpw_auto_poster_li_oauth'] : $_SESSION['wpw_auto_poster_linkedin_oauth'];
				
				// start code to manage session from database 			
				$wpw_auto_poster_li_sess_data = get_option( 'wpw_auto_poster_li_sess_data' );
				
				if( empty( $wpw_auto_poster_li_sess_data ) ) {				
					
					$sess_data = array(
											'wpw_auto_poster_li_user_id'	=> $_SESSION['wpw_auto_poster_li_user_id'],
											'wpw_auto_poster_li_cache'	=> $liuserdata,
											'wpw_auto_poster_li_oauth'	=> $_SESSION['wpw_auto_poster_linkedin_oauth']
										);
					
			      	update_option( 'wpw_auto_poster_li_sess_data', $sess_data );
				} 					
		      	// end code to manage session from database 	
		      	 
			} catch( Exception $e ) {

		 	  	$liuserdata = null;
			}
		} 
	}
	
	/**
	 * Reset Sessions
	 *
	 * Resetting the Linkedin sessions when the admin clicks on
	 * its link within the settings page.
	 *
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	public function wpw_auto_poster_li_reset_session() {
		
		update_option( 'wpw_auto_poster_li_sess_data', '' );
		unset( $_SESSION['wpw_auto_poster_li_user_id'] );
		unset( $_SESSION['wpw_auto_poster_li_cache'] );
		unset( $_SESSION['wpw_auto_poster_li_oauth'] );
		if(isset($_SESSION['wpw_auto_poster_linkedin_oauth']) && !empty($_SESSION['wpw_auto_poster_linkedin_oauth'])) {//destroy linkedin session
			unset( $_SESSION['wpw_auto_poster_linkedin_oauth'] );
		}
	}
}
?>