<?php

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

/**
 * Twitter Posting Class
 *
 * Handles all the functions to tweet on twitter
 *
 * @package Social Auto Poster
 * @since 1.0.0
 */
class Wpw_Auto_Poster_TW_Posting {

	var $twitter,$model;
	
	public function __construct() {
	
		global $wpw_auto_poster_model;
		
		$this->model = $wpw_auto_poster_model;
	}
	
	/**
	 * Include Twitter Class
	 * 
	 * Handles to load twitter class
	 * 
	 * @package Social Auto Poster
 	 * @since 1.0.0
	 */
	public function wpw_auto_poster_load_twitter() {
		
		global $wpw_auto_poster_options;
		
		//check twitter application id and application secret is not empty or not
		if( !empty( $wpw_auto_poster_options['twitter_consumer_key'] ) && !empty( $wpw_auto_poster_options['twitter_consumer_secret'] )
			&& !empty( $wpw_auto_poster_options['twitter_oauth_token'] ) && !empty( $wpw_auto_poster_options['twitter_oauth_secret']) ) {
			
				if( !class_exists( 'TwitterOAuth' ) ) {
					require_once( WPW_AUTO_POSTER_SOCIAL_DIR . '/twitter/twitteroauth.php' );
				}
			
				// Twitter Object
				$this->twitter = new TwitterOAuth( WPW_AUTO_POSTER_TW_CONS_KEY, WPW_AUTO_POSTER_TW_CONS_SECRET, 
													WPW_AUTO_POSTER_TW_AUTH_TOKEN, WPW_AUTO_POSTER_TW_AUTH_SECRET );
			return true;
		} else {
			return false;
		}
		
	}

	/**
	 * Post To Twitter
	 * 
	 * Handles to Post on Twitter account
	 * 
	 * @package Social Auto Poster
	 * @since 1.0.0
	 */
	public function wpw_auto_poster_post_to_twitter( $post ) {
		
		global $wpw_auto_poster_options;
		
		//metabox field prefix
		$prefix = WPW_AUTO_POSTER_META_PREFIX;
		
		//load twitter class
		$twitter = $this->wpw_auto_poster_load_twitter();
	
		//check twitter class is loaded or not
		if( !$twitter ) return false;
		
			if( !empty( $post ) ) { 
			
				$status = get_post_meta( $post->ID, $prefix . 'tw_template',true);
				
				if( empty($status) ) {
					$status = $this->model->wpw_auto_poster_get_tweet_template( $wpw_auto_poster_options['tw_tweet_template'] );
				}
				 
				if( strlen( $status ) > 139 ) { //check status should not greater then 140 character
					$status = substr( $status, 0, 139 );
				}
			
				$status = $this->model->wpw_auto_poster_tweet_status ( $post, $status );
				
				try {	
					
					$result = $this->twitter->post( 'statuses/update', array( 'status' => $status ) );
					return $result;
					
				} catch ( Exception $e ) {
					//return $e;
					return false;
				}
				
			}
	}
}
?>