<?php

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

/**
 * Wpw_Auto_Poster_Fb_WidgetActivityFeed Widget Class.
 *
 * This class handles everything that needs to be handled with the widget:
 * the settings, form, display, and update for displaying submitted reviews.
 *
 * @package Social Auto Poster
 * @since 1.0.0
 */
class Wpw_Auto_Poster_Fb_WidgetActivityFeed extends WP_Widget {

	/**
	 * Widget setup.
	 */
	function Wpw_Auto_Poster_Fb_WidgetActivityFeed () {
		$widget_ops = array('classname' => __CLASS__, 'description' => __('Shows Facebook Activity Feed.', 'wpwautoposter'));
		parent::WP_Widget(__CLASS__, sprintf( __( '%s Facebook Activity Feed', 'wpwautoposter' ), WPW_AUTO_POSTER_TITLE_PREFIX ), $widget_ops);
	}

	/*
	 * Displays the widget form in the admin panel
	 */
	function form($instance) {
		
		// Set defaults
		// ...

		$defaults = array( 
							'title' 			=> '',
							'url' 				=> '',
							'width' 			=> '',
							'height' 			=> '',
							'show_header' 		=> '',
							'recommendations' 	=> '',
							'filter' 			=> '',
							'color_scheme' 		=> '',
							'links' 			=> ''
						 );
		
        $instance = wp_parse_args( (array) $instance, $defaults );
		
		$title = esc_attr($instance['title']);
		$url = esc_attr($instance['url']);
		$width = esc_attr($instance['width']);
		$height = esc_attr($instance['height']);
		$show_header = esc_attr($instance['show_header']);
		$recommendations = esc_attr($instance['recommendations']);
		$filter = esc_attr($instance['filter']);
		$color_scheme = esc_attr($instance['color_scheme']);
		$links = esc_attr($instance['links']);

		$html = '';
		
		$html .= '<p>';
		$html .= '<label for="' . $this->get_field_id('title') . '">' . __('Title:', 'wpwautoposter') . '</label>';
		$html .= '<input type="text" name="' . $this->get_field_name('title') . '" id="' . $this->get_field_id('title') . '" class="widefat" value="' . $title . '"/>';
		$html .= '</p>';

		$html .= '<p>';
		$html .= '<label for="' . $this->get_field_id('url') . '">' . __('Site:', 'wpwautoposter') . '</label> ';
		$html .= '<input type="text" name="' . $this->get_field_name('url') . '" id="' . $this->get_field_id('url') . '" class="widefat" value="' . $url . '"/>';
		$html .= '<div><small>' . __('Enter a comma separated list of domains to show activity for, or leave blank to use current domain.', 'wpwautoposter') . '</small></div>';
		$html .= '</p>';

		$html .= '<p>';
		$html .= '<label for="' . $this->get_field_id('filter') . '">' . __('Filter:', 'wpwautoposter') . '</label> ';
		$html .= '<input type="text" name="' . $this->get_field_name('filter') . '" id="' . $this->get_field_id('filter') . '" class="widefat" value="' . $filter . '"/>';
		$html .= '<div><small>' . __('Only URLs which contain the filter string in the first two path parameters of the URL will be shown. Leave this field empty to prevent filtering.', 'wpwautoposter') . '</small></div>';
		$html .= '</p>';

		$html .= '<p>';
		$html .= '<label for="' . $this->get_field_id('width') . '">' . __('Width:', 'wpwautoposter') . '</label> ';
		$html .= '<input type="text" name="' . $this->get_field_name('width') . '" id="' . $this->get_field_id('width') . '" size="3" value="' . $width . '"/>px';
		$html .= '</p>';

		$html .= '<p>';
		$html .= '<label for="' . $this->get_field_id('height') . '">' . __('Height:', 'wpwautoposter') . '</label> ';
		$html .= '<input type="text" name="' . $this->get_field_name('height') . '" id="' . $this->get_field_id('height') . '" size="3" value="' . $height . '"/>px';
		$html .= '</p>';

		$html .= '<p>';
		$html .= '<label for="' . $this->get_field_id('show_header') . '">' . __('Show header:', 'wpwautoposter') . '</label> ';
		$html .= '<input type="checkbox" name="' . $this->get_field_name('show_header') . '" id="' . $this->get_field_id('show_header') . '" value="1" ' . checked( $show_header, '1', false ) . ' />';
		$html .= '</p>';

		$html .= '<p>';
		$html .= '<label for="' . $this->get_field_id('recommendations') . '">' . __('Show recommendations:', 'wpwautoposter') . '</label> ';
		$html .= '<input type="checkbox" name="' . $this->get_field_name('recommendations') . '" id="' . $this->get_field_id('recommendations') . '" value="1" ' . checked( $recommendations, '1', false ) . ' />';
		$html .= '</p>';

		$html .= '<p>';
		$html .= '<label for="' . $this->get_field_id('color_scheme') . '">' . __('Color scheme:', 'wpwautoposter') . '</label> ';
		$html .= '<select name="' . $this->get_field_name('color_scheme') . '" id="' . $this->get_field_id('color_scheme') . '">';
		$html .= '<option value="light" ' . selected( 'light', $color_scheme, false ) . '>' . __('Light', 'wpwautoposter') . '</option>';
		$html .= '<option value="dark" ' . selected( 'dark', $color_scheme, false ) . '>' . __('Dark', 'wpwautoposter') . '</option>';
		$html .= '</select>';
		$html .= '</p>';

		$html .= '<p>';
		$html .= '<label for="' . $this->get_field_id('links') . '">' . __('Link target:', 'wpwautoposter') . '</label> ';
		$html .= '<select name="' . $this->get_field_name('links') . '" id="' . $this->get_field_id('links') . '">';
		$html .= '<option value="_top" ' . selected( '_top', $links, false ) . '>' . __('_top', 'wpwautoposter') . '</option>';
		$html .= '<option value="_parent" ' . selected( '_parent', $links, false ) . '>' . __('_parent', 'wpwautoposter') . '</option>';
		$html .= '<option value="_blank" ' . selected( '_blank', $links, false ) . '>' . __('_blank', 'wpwautoposter') . '</option>';
		$html .= '</select>';
		$html .= '</p>';

		echo $html;
	}

	/**
	 * Updates the widget control options for the particular instance of the widget
	 */
	function update($new_instance, $old_instance) {
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['width'] = strip_tags($new_instance['width']);
		$instance['height'] = strip_tags($new_instance['height']);
		$instance['url'] = strip_tags($new_instance['url']);
		$instance['show_header'] = strip_tags($new_instance['show_header']);
		$instance['recommendations'] = strip_tags($new_instance['recommendations']);
		$instance['filter'] = strip_tags($new_instance['filter']);
		$instance['color_scheme'] = strip_tags($new_instance['color_scheme']);
		$instance['links'] = strip_tags($new_instance['links']);

		return $instance;
	}

	/**
	 * Outputs the content of the widget
	 */
	function widget($args, $instance) {
		extract($args);
		$title = apply_filters('widget_title', $instance['title']);
		$width = (int)$instance['width'];
		$width = $width ? $width : 250;
		$height = (int)$instance['height'];
		$height = $height ? $height : 300;
		$url = $instance['url'];
		$url = $url ? $url : parse_url(site_url(), PHP_URL_HOST);
		$show_header = (int)@$instance['show_header'];
		$show_header = $show_header ? 'true' : 'false';
		$recommendations = (int)@$instance['recommendations'];
		$recommendations = $recommendations ? 'true' : 'false';
		$filter = @$instance['filter'];
		$color_scheme = $instance['color_scheme'];
		$color_scheme = $color_scheme ? $color_scheme : 'light';
		$links = $instance['links'];
		$links = $links ? $links : '_blank';

		echo $before_widget;
		if ($title) echo $before_title . $title . $after_title;

		echo '<iframe src="http://www.facebook.com/plugins/activity.php?site=' . $url . '&amp;width=' . $width . '&amp;height=' . $height . '&amp;header=' . $show_header . '&amp;colorscheme=' . $color_scheme . '&amp;linktarget='. $links . '&amp;font&amp;border_color&amp;recommendations='.$recommendations.'" scrolling="no" frameborder="0" style="border:none; overflow:hidden; width:' . $width . 'px; height:' . $height . 'px;" allowTransparency="true"></iframe>';

		//echo "<fb:activity site='{$url}' width='{$width}' height='{$height}' header='{$show_header}' recommendations='{$recommendations}' linktarget='{$links}'></fb:activity>";

		echo $after_widget;
	}
}