<?php

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

/**
 * Wpw_Auto_Poster_Fb_WidgetAlbums Widget Class.
 *
 * This class handles everything that needs to be handled with the widget:
 * the settings, form, display, and update for displaying submitted reviews.
 *
 * @package Social Auto Poster
 * @since 1.0.0
 */
class Wpw_Auto_Poster_Fb_WidgetAlbums extends WP_Widget {
	var $fbposting;

	/**
	 * Widget setup.
	 */
	function Wpw_Auto_Poster_Fb_WidgetAlbums () {
		
		global $wpw_auto_poster_fb_posting;
		$this->fbposting = $wpw_auto_poster_fb_posting;
		$widget_ops = array('classname' => __CLASS__, 'description' => __('Shows photos from a Facebook Album', 'wpwautoposter'));

		add_action('admin_print_scripts', array($this, 'js_load_scripts'));
		add_action('admin_print_styles', array($this, 'css_load_styles'));
		add_action('wp_print_styles', array($this, 'front_load_styles'));
		add_action('admin_head', array($this, 'wpw_auto_poster_pretty_head'));

		parent::WP_Widget(__CLASS__, sprintf( __( '%s Facebook Albums', 'wpwautoposter' ), WPW_AUTO_POSTER_TITLE_PREFIX ), $widget_ops);
	}

	/**
	 * Enqueue styles.
	 */
	function css_load_styles () {
		
		wp_enqueue_style('wpw_auto_poster_pretty_photo', WPW_AUTO_POSTER_URL . 'includes/css/wpw-auto-poster-prettyphoto.css');
	}
	
	/**
	 * Enqueue front styles.
	 */
	function front_load_styles () {
		
		wp_enqueue_style('wpw_auto_poster_front_albums', WPW_AUTO_POSTER_URL . 'includes/css/wpw-auto-poster-widget-albums.css');
	}
	
	/**
	 * Enqueue scripts.
	 */
	function js_load_scripts () {
		
		wp_enqueue_script('jquery');
		wp_enqueue_script('wpw_auto_poster_pretty_photo', WPW_AUTO_POSTER_URL . 'includes/js/wpw-auto-poster-prettyPhoto.js');
		
	}
	
	/**
	 * Enqueue head script.
	 */
	function wpw_auto_poster_pretty_head() {
		
?>		
		<script type="text/javascript" charset="utf-8">
		
					
			jQuery(document).ready(function(){
				 
			   	jQuery("a[rel^='prettyPhoto']").prettyPhoto({
			   		
			   		animationSpeed: 'normal', /* fast/slow/normal */
					padding: 40, /* padding for each side of the picture */
				  	showTitle: true, /* true/false */	
					show_title: true, /* true/false */
					social_tools: '',
					theme: 'pp_default', /* light_rounded / dark_rounded / light_square / dark_square / facebook */
						
			   	});
			});
						

			function wpw_auto_poster_set_album_id(album_id) {
				
				jQuery('.album_id_textbox').val(album_id);
				jQuery.prettyPhoto.close();
			}
		
		</script> 	
<?php		
	}
	
	/*
	 * Displays the widget form in the admin panel
	 */
	function form($instance) {
		
		// Set defaults
		$defaults = array( 
							'title' 	=> '',
							'album_id' 	=> '',
							'limit' 	=> '',
							'per_row' 	=> '',
							'img_h' 	=> '',
							'img_w' 	=> '',
							'img_crop' 	=> ''
						 );
		
        $instance = wp_parse_args( (array) $instance, $defaults );
		
		$title = esc_attr($instance['title']);
		$album_id = esc_attr($instance['album_id']);
		$limit = esc_attr($instance['limit']);
		$per_row = esc_attr($instance['per_row']);
		$img_h = esc_attr($instance['img_h']);
		$img_w = esc_attr($instance['img_w']);

		$img_w = isset($instance['img_h']) ? $img_w : '75';
		$img_h = isset($instance['img_w']) ? $img_h : '75';
		$img_crop = $instance['img_crop'];

		$html = '';

		$fb_user = isset( $_SESSION['wpweb_fb_user_id'] ) ? $_SESSION['wpweb_fb_user_id'] : '';
		
		// album code added 
		$albums = $this->fbposting->wpw_auto_poster_fb_get_albums_for($fb_user);
		$albums = $albums['data'];
		
	
		// album code end
		
		if ( !$fb_user ) {
			
			$html .= '<div class="wpw_auto_poster_admin_message message">';
			$html .= sprintf(__('Your app doesn\'t have enough permissions. <a href="%s">Grant needed permissions now</a>'), $this->fbposting->wpw_auto_poster_get_fb_login_url());
			$html .= '</div>';
			
		} else {
			
			$html .= '<div class="wpw_auto_poster_admin_message message">Facebook user ID: ' . $fb_user . '</div>';
		}

		$html .= '<p>';
		$html .= '<label for="' . $this->get_field_id('title') . '">' . __('Title:', 'wpwautoposter') . '</label>';
		$html .= '<input type="text" name="' . $this->get_field_name('title') . '" id="' . $this->get_field_id('title') . '" class="widefat" value="' . $title . '"/>';
		$html .= '</p>';

		$html .= '<p class="wpw_auto_poster_album_widget_select_album">';
		$html .= '<label for="' . $this->get_field_id('album_id') . '">' . __('Album ID:', 'wpwautoposter') . '</label>';
		$html .= '<input type="text" name="' . $this->get_field_name('album_id') . '" class="album_id_textbox" id="' . $this->get_field_id('album_id') . '" value="' . $album_id . '"/>';
		$html .= '<a href="#wpw_auto_poster_inline" class="open_popup" rel="prettyPhoto" title="">' . __('Select album','wpwautoposter') . '</a>';
		$html .= '<div class="log"></div><div id="wpw_auto_poster_inline" style="display:none;">';
		
		if (is_array($albums)) {
			
			$html .= '<div class="wpw_auto_poster_popup">'.__('Add FB Photo','wpwautoposter').'</div><ul>'; 
			
			foreach ($albums as $album_data) {
				
				$html .= '<li class="wpw_auto_poster_popup_li_text">'.$album_data['name'].'</li>';
				$html .= '<li><a href="javascript:void(0);" class="wpw_auto_poster_popup_a" onClick="return wpw_auto_poster_set_album_id(\''.$album_data['id'].'\')"> Insert Album</a></li><br />';
				
			}
			
			$html .= '</ul>';
			
		}
		$html .= '</div>';
		$html .= '</p>';

		$html .= '<p>';
		$html .= '<label for="' . $this->get_field_id('limit') . '">' . __('Display only this many photos:', 'wpwautoposter') . '</label>';
		$html .= '<select name="' . $this->get_field_name('limit') . '" id="' . $this->get_field_id('limit') . '">';
		for ($i=1; $i<51; $i++) {
			$html .= '<option value="' . $i . '" ' . selected( $i, $limit, false ) . '>' . $i . '</option>';
		}
		
		$html .= '</select>';
		$html .= '</p>';

		$html .= '<p>';
		$html .= '<label for="' . $this->get_field_id('per_row') . '">' . __('Photos per row:', 'wpwautoposter') . '</label>';
		$html .= '<select name="' . $this->get_field_name('per_row') . '" id="' . $this->get_field_id('per_row') . '">';
		for ($i=1; $i<10; $i++) {
			$html .= '<option value="' . $i . '" ' . selected( $i, $per_row, false ) . '>' . $i . '</option>';
		}
		$html .= '</select>';
		$html .= '</p>';

		$html .= '<p>';
		$html .= '<label for="' . $this->get_field_id('img_w') . '">' . __('Image size:', 'wpwautoposter') . '</label>';
		$html .= '<input type="text" name="' . $this->get_field_name('img_w') . '" size="2" maxsize="3" id="' . $this->get_field_id('img_w') . '" value="' . $img_w . '"/>';
		$html .= 'x';
		$html .= '<input type="text" name="' . $this->get_field_name('img_h') . '" size="2" maxsize="3" id="' . $this->get_field_id('img_h') . '" value="' . $img_h . '"/>';
		$html .= '<br /><small>' . __('Format: width x height. <br />Omitting one of dimensions will show your images in scale.', 'wpwautoposter')  . '</small>';
		$html .= '</p>';

		$html .= '<p>';
		$html .= '<label for="' . $this->get_field_id('img_crop') . '">' . __('Crop image height:', 'wpwautoposter') . '</label> ';
		$html .= '<input type="checkbox" name="' . $this->get_field_name('img_crop') . '" id="' . $this->get_field_id('img_crop') . '" value="1" ' . checked( $img_crop, '1', false ) . ' />';
		$html .= '<br /><small>' . __('Selecting this option will crop your oversized images vertically.', 'wpwautoposter')  . '</small>';
		$html .= '</p>';

		echo $html;
	}

	/**
	 * Updates the widget control options for the particular instance of the widget
	 */
	function update($new_instance, $old_instance) {
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['album_id'] = strip_tags($new_instance['album_id']);
		$instance['limit'] = strip_tags($new_instance['limit']);
		$instance['per_row'] = strip_tags($new_instance['per_row']);
		$instance['img_w'] = strip_tags($new_instance['img_w']);
		$instance['img_h'] = strip_tags($new_instance['img_h']);
		$instance['img_crop'] = isset($new_instance['img_crop']) ? 1 : 0;

		$instance['photos'] = empty($instance['photos']) ? $this->fbposting->wpw_auto_poster_fb_get_album_photos($instance['album_id']) : $instance['photos'];

		return $instance;
	}

	/**
	 * Outputs the content of the widget
	 */
	function widget($args, $instance) {
		
		extract($args);
		$title = apply_filters('widget_title', $instance['title']);
		$limit = (int)$instance['limit'];
		$per_row = (int)$instance['per_row'];
		$img_w = (int)$instance['img_w'];
		$img_h = (int)$instance['img_h'];
		$img_crop = (int)$instance['img_crop'];
		$album_id = $instance['album_id'];

		
		
		$photos = $this->fbposting->wpw_auto_poster_fb_get_album_photos($album_id); // , $limit
		/*if (!empty($photos['data'])) {
			// We have a valid FB connection.
			// Use that to refresh data:
			// Update the instance with fresh photos
		
		} else {
			$photos = $instance['photos'];
		}*/
		$photos = $photos['data'];
		
		echo $before_widget;
		if ($title) echo $before_title . $title . $after_title;

		if (is_array($photos)) {
			echo '<table cellspacing="0" cellpadding="0" border="0" class="wpw_auto_poster_album_photos">';
			$count = 0;
			echo '<tr>';
			foreach ($photos as $photo) {
				$style = $img_crop ? "display:block;float:left;height:{$img_h}px;overflow:hidden" : '';
				echo '<td valign="top" class="wpw-auto-poster-widget-album">' .
					'<a href="' . $photo['images'][0]['source'] . '" style="' . $style . '" target="_blank">' .
						'<img src="' . $photo['images'][count($photo['images'])-1]['source'] . '" ' .
						($img_w ? "width='{$img_w}'" : '') .
						($img_h && !$img_crop ? "height='{$img_h}'" : '') .
						' />' .
					'</a>' .
				'</td>';
				++$count;
				if ($count == $per_row) {
					echo '</tr><tr>';
					$count = 0;
				}
			}
			if ($count < $per_row) {
				echo '<td colspan="' . ($per_row-$count) . '"></td>';
			}
			echo '<tr>';
			echo '</table>';
		}

		echo $after_widget;
	}
}