<?php

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

/**
 * Wpw_Auto_Poster_Fb_WidgetEvents Widget Class.
 *
 * This class handles everything that needs to be handled with the widget:
 * the settings, form, display, and update for displaying submitted reviews.
 *
 * @package Social Auto Poster
 * @since 1.0.0
 */
class Wpw_Auto_Poster_Fb_WidgetEvents extends WP_Widget {
	var $fbposting;

	/**
	 * Widget setup.
	 */
	function Wpw_Auto_Poster_Fb_WidgetEvents () {
		
		global $wpw_auto_poster_fb_posting;
		$this->fbposting = $wpw_auto_poster_fb_posting;
		$widget_ops = array('classname' => __CLASS__, 'description' => __('Shows Facebook Events', 'wpwautoposter'));

		add_action('wp_print_styles', array($this, 'css_load_styles'));
		add_action('admin_print_scripts-widgets.php', array($this, 'js_load_scripts'));
		add_action('admin_print_styles-widgets.php', array($this, 'css_load_admin_styles'));

		parent::WP_Widget(__CLASS__, sprintf( __( '%s Facebook Events', 'wpwautoposter' ), WPW_AUTO_POSTER_TITLE_PREFIX ), $widget_ops);
	}

	/**
	 * Enqueue styles.
	 */
	function css_load_styles () {
		wp_enqueue_style('wpw_auto_poster_widget_events', WPW_AUTO_POSTER_URL . 'includes/css/wpw-auto-poster-widget-events.css');
	}
	
	/**
	 * Enqueue datepicker style.
	 */
	function css_load_admin_styles () {
		wp_enqueue_style('wpw_auto_poster_datepicker', WPW_AUTO_POSTER_URL . 'includes/css/datepicker/wpw-auto-poster-datepicker.css');
	}
	
	/**
	 * Enqueue scripts.
	 */
	function js_load_scripts () {
		wp_enqueue_script('jquery-ui-datepicker');
		wp_enqueue_script('wpw_auto_poster_widget_events', WPW_AUTO_POSTER_URL . 'includes/js/wpw-auto-poster-widget-events.js', array('jquery', 'jquery-ui-datepicker'));
	}

	/*
	 * Displays the widget form in the admin panel
	 */
	function form($instance) {
		
		// Set defaults
		$defaults = array( 
							'title' 			=> '',
							'for' 				=> '',
							'show_image' 		=> '',
							'show_location' 	=> '',
							'show_start_date' 	=> '',
							'show_end_date' 	=> '',
							'date_threshold' 	=> '',
							'only_future' 		=> ''
						 );
		
        $instance = wp_parse_args( (array) $instance, $defaults );
		
		$title = esc_attr($instance['title']);
		$for1 = esc_attr($instance['for']);
		
		if(!empty($for1)) {
			$for = $for1;
		} else {
			$for = isset( $_SESSION['wpweb_fb_user_id'] ) ? $_SESSION['wpweb_fb_user_id'] : '';
		}
		//$for = $for ? $for : $_SESSION['wpweb_fb_user_id'];
		$show_image = esc_attr($instance['show_image']);
		$show_location = esc_attr($instance['show_location']);
		$show_start_date = esc_attr($instance['show_start_date']);
		$show_end_date = esc_attr($instance['show_end_date']);
		$date_threshold = esc_attr($instance['date_threshold']);
		$only_future = esc_attr($instance['only_future']);

		$only_future = (isset($instance['only_future'])) ? $instance['only_future'] : true;

		$html = '';

		$fb_user = isset( $_SESSION['wpweb_fb_user_id'] ) ? $_SESSION['wpweb_fb_user_id'] : '';
		if (!$fb_user) {
				$html .= '<div class="wpw_auto_poster_admin_message message">';
			$html .= sprintf(__('Your app doesn\'t have enough permissions. <a href="%s">Grant needed permissions now</a>'), $this->fbposting->wpw_auto_poster_get_fb_login_url());
			$html .= '</div>';
		} else {
			$html .= '<div class="wpw_auto_poster_admin_message message">' . __('Facebook user ID: ', 'wpwautoposter') . $fb_user . '</div>';
		}

		$html .= '<div class="wpw_auto_poster_widget_events_home">';

		$html .= '<p>';
		$html .= '<label for="' . $this->get_field_id('title') . '">' . __('Title:', 'wpwautoposter') . '</label>';
		$html .= '<input type="text" name="' . $this->get_field_name('title') . '" id="' . $this->get_field_id('title') . '" class="widefat" value="' . $title . '"/>';
		$html .= '</p>';

		$html .= '<p>';
		$html .= '<label for="' . $this->get_field_id('for') . '">' . __('Show events for:', 'wpwautoposter') . '</label>';
		$html .= '<input type="text" name="' . $this->get_field_name('for') . '" id="' . $this->get_field_id('for') . '" value="' . $for . '"/>';
		$html .= '<div>Leave this box empty to display your own events.</div>';
		$html .= '</p>';

		$html .= '<p>';
		$html .= '<label for="' . $this->get_field_id('show_image') . '">' . __('Show image:', 'wpwautoposter') . '</label>';
		$html .= ' <input type="checkbox" name="' . $this->get_field_name('show_image') . '" id="' . $this->get_field_id('show_image') . '" value="1" ' . checked( $show_image, '1', false ) . '/>';
		$html .= '</p>';

		$html .= '<p>';
		$html .= '<label for="' . $this->get_field_id('show_location') . '">' . __('Show location:', 'wpwautoposter') . '</label>';
		$html .= ' <input type="checkbox" name="' . $this->get_field_name('show_location') . '" id="' . $this->get_field_id('show_location') . '" value="1" ' . checked( $show_location, '1', false ) . '/>';
		$html .= '</p>';

		$html .= '<p>';
		$html .= '<label for="' . $this->get_field_id('show_start_date') . '">' . __('Show event start:', 'wpwautoposter') . '</label>';
		$html .= ' <input type="checkbox" name="' . $this->get_field_name('show_start_date') . '" id="' . $this->get_field_id('show_start_date') . '" value="1" ' . checked( $show_start_date, '1', false ) . '/>';
		$html .= '</p>';

		$html .= '<p>';
		$html .= '<label for="' . $this->get_field_id('show_end_date') . '">' . __('Show event end:', 'wpwautoposter') . '</label>';
		$html .= ' <input type="checkbox" name="' . $this->get_field_name('show_end_date') . '" id="' . $this->get_field_id('show_end_date') . '" value="1" ' . checked( $show_end_date, '1', false ) . '/>';
		$html .= '</p>';

		$html .= '<p>';
		$html .= '<label for="' . $this->get_field_id('only_future') . '">' . __('Show only future events:', 'wpwautoposter') . '</label>';
		$html .= ' <input type="checkbox" name="' . $this->get_field_name('only_future') . '" id="' . $this->get_field_id('only_future') . '" value="1" ' . checked( $only_future, '1', false ) . '/>';
		$html .= '</p>';

		$html .= '<p>';
		$html .= '<label for="' . $this->get_field_id('date_threshold') . '">' . __('Show events starting from this date:', 'wpwautoposter') . '</label>';
		$html .= ' <input type="text" class="widefat wpw_auto_poster_date_threshold" name="' . $this->get_field_name('date_threshold') . '" id="' . $this->get_field_id('date_threshold') . '" value="' . $date_threshold . '"/>';
		$html .= '<br /><small>(YYYY-mm-dd, e.g. 2011-06-09)</small>';
		$html .= '</p>';

		$html .= '</div>';

		echo $html;
	}

	/**
	 * Updates the widget control options for the particular instance of the widget
	 */
	function update($new_instance, $old_instance) {
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$for = strip_tags($new_instance['for']);
		
		if(!empty($for)) {
			$instance['for'] = $for;
		} else {
			$instance['for'] = isset( $_SESSION['wpweb_fb_user_id'] ) ? $_SESSION['wpweb_fb_user_id'] : '';
		}
		
		
		$instance['show_image'] = strip_tags($new_instance['show_image']);
		$instance['show_location'] = strip_tags($new_instance['show_location']);
		$instance['show_start_date'] = strip_tags($new_instance['show_start_date']);
		$instance['show_end_date'] = strip_tags($new_instance['show_end_date']);
		$instance['date_threshold'] = strip_tags($new_instance['date_threshold']);
		$instance['only_future'] = strip_tags($new_instance['only_future']);

		//$instance['events'] = empty($instance['events']) ? $this->fbposting->get_events_for($instance['for']) : $instance['events'];

		return $instance;
	}

	/**
	 * Outputs the content of the widget
	 */
	function widget($args, $instance) {
		extract($args);
		$title = apply_filters('widget_title', $instance['title']);
		$for = $instance['for'];
		$show_image = (int)$instance['show_image'];
		$show_location = (int)$instance['show_location'];
		$show_start_date = (int)$instance['show_start_date'];
		$show_end_date = (int)$instance['show_end_date'];
		$date_threshold = $instance['date_threshold'];
		$only_future = $instance['only_future'];

		$date_threshold = $date_threshold ? strtotime($date_threshold) : false;
		if ($only_future) {
			$now = time();
			$date_threshold = ($date_threshold && $date_threshold > $now) ? $date_threshold : $now;
		}

		$events = $this->fbposting->wpw_auto_poster_fb_get_events_for($for);
		/*if (!empty($events['data'])) {
			// We have a valid FB connection.
			// Use that to refresh data:
			// Update the instance with fresh events
			
		} else {
			$events = $instance['events'];
		}*/
		$events = $events['data'];
		
		$timestamp_format = get_option('date_format') . ' ' . get_option('time_format');

		echo $before_widget;
		if ($title) echo $before_title . $title . $after_title;

		if (is_array($events)) {
			echo '<ul class="wpw_auto_poster_widget_events">';
			foreach ($events as $event) {
				if ($date_threshold > strtotime($event['start_time'])) continue;
				include ( WPW_AUTO_POSTER_DIR . '/includes/widgets/wpw-auto-poster-event-item.php');
			}
			echo '</ul>';
		}

		echo $after_widget;
	}
}