<?php

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

/**
 * Wpw_Auto_Poster_Fb_WidgetFacepile Widget Class.
 *
 * This class handles everything that needs to be handled with the widget:
 * the settings, form, display, and update for displaying submitted reviews.
 *
 * @package Social Auto Poster
 * @since 1.0.0
 */
class Wpw_Auto_Poster_Fb_WidgetFacepile extends WP_Widget {

	/**
	 * Widget setup.
	 */
	function Wpw_Auto_Poster_Fb_WidgetFacepile () {
		$widget_ops = array('classname' => __CLASS__, 'description' => __('Shows Facebook Facepile box', 'wpwautoposter'));
		parent::WP_Widget(__CLASS__, sprintf( __( '%s Facebook Facepile', 'wpwautoposter' ), WPW_AUTO_POSTER_TITLE_PREFIX ), $widget_ops);
	}

	/*
	 * Displays the widget form in the admin panel
	 */
	function form($instance) {
		
		// Set defaults
		$defaults = array( 
							'title' => '',
							'url' 	=> '',
							'width' => '',
							'rows' 	=> ''
						 );
		
        $instance = wp_parse_args( (array) $instance, $defaults );
		
		$title = esc_attr($instance['title']);
		$url = esc_attr($instance['url']);
		$width = esc_attr($instance['width']);
		$rows = esc_attr($instance['rows']);

		$html = '';
		
		$html = '<p>';
		$html .= '<label for="' . $this->get_field_id('title') . '">' . __('Title:', 'wpwautoposter') . '</label>';
		$html .= '<input type="text" name="' . $this->get_field_name('title') . '" id="' . $this->get_field_id('title') . '" class="widefat" value="' . $title . '"/>';
		$html .= '</p>';

		$html .= '<p>';
		$html .= '<label for="' . $this->get_field_id('url') . '">' . __('URL <small>(optional)</small>:', 'wpwautoposter') . '</label>';
		$html .= '<input type="text" name="' . $this->get_field_name('url') . '" id="' . $this->get_field_id('url') . '" class="widefat" value="' . $url . '"/>';
		$html .= '<div>' . __('By default, the widget will show the Facepile box for your page. You can override that by providing a custom URL here.', 'wpwautoposter') . '</div>';
		$html .= '</p>';

		$html .= '<p>';
		$html .= '<label for="' . $this->get_field_id('width') . '">' . __('Width:', 'wpwautoposter') . '</label>';
		$html .= '<input type="text" name="' . $this->get_field_name('width') . '" id="' . $this->get_field_id('width') . '" size="3" value="' . $width . '"/>';
		$html .= '</p>';

		$html .= '<p>';
		$html .= '<label for="' . $this->get_field_id('rows') . '">' . __('Rows:', 'wpwautoposter') . '</label>';
		$html .= '<select name="' . $this->get_field_name('rows') . '" id="' . $this->get_field_id('rows') . '">';
		for ($i=1; $i<11; $i++) { 
			$html .= '<option value="' . $i . '" ' . selected( $i, $rows, false ) . '>' . $i . '</option>';
		}
		$html .= '</select>';
		$html .= '</p>';

		echo $html;
	}

	/**
	 * Updates the widget control options for the particular instance of the widget
	 */
	function update($new_instance, $old_instance) {
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['url'] = strip_tags($new_instance['url']);
		$instance['width'] = strip_tags($new_instance['width']);
		$instance['rows'] = strip_tags($new_instance['rows']);

		return $instance;
	}

	/**
	 * Outputs the content of the widget
	 */
	function widget($args, $instance) {
		extract($args);
		$title = apply_filters('widget_title', $instance['title']);
		$url = $instance['url'];
		$width = $instance['width'];
		$width = $width ? $width : 250;
		$rows = $instance['rows'];
		$rows = $rows ? $rows : 4;

		$url = ($url) ? rawurlencode($url) : rawurlencode('http://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']);

		echo $before_widget;
		if ($title) echo $before_title . $title . $after_title;

		echo '<iframe src="http://www.facebook.com/plugins/facepile.php?href=' . $url . '&amp;width=' . $width . '&amp;max_rows=' . $rows . '" scrolling="no" frameborder="0" style="border:none; overflow:hidden; width:' . $width . 'px;" allowTransparency="true"></iframe>';

		echo $after_widget;
	}
}