<?php

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

/**
 * Wpw_Auto_Poster_Fb_WidgetRecommendations Widget Class.
 *
 * This class handles everything that needs to be handled with the widget:
 * the settings, form, display, and update for displaying submitted reviews.
 *
 * @package Facebook Autopost
 * @since 1.0.0
 */
class Wpw_Auto_Poster_Fb_WidgetRecommendations extends WP_Widget {

	/**
	 * Widget setup.
	 */
	function Wpw_Auto_Poster_Fb_WidgetRecommendations () {
		$widget_ops = array('classname' => __CLASS__, 'description' => __('Shows Facebook Recommendations box.', 'wpwautoposter'));
		parent::WP_Widget(__CLASS__, sprintf( __( '%s Facebook Recommendations', 'wpwautoposter' ), WPW_AUTO_POSTER_TITLE_PREFIX ), $widget_ops);
	}

	/*
	 * Displays the widget form in the admin panel
	 */
	function form($instance) {
		
		// Set defaults
		$defaults = array( 
							'title' 		=> '',
							'width' 		=> '',
							'height' 		=> '',
							'show_header' 	=> '',
							'color_scheme' 	=> ''
						 );
		
        $instance = wp_parse_args( (array) $instance, $defaults );
		
		$title = esc_attr($instance['title']);
		$width = esc_attr($instance['width']);
		$height = esc_attr($instance['height']);
		$show_header = esc_attr($instance['show_header']);
		$color_scheme = esc_attr($instance['color_scheme']);

		$html = ' <p>';
		$html .= '<label for="' . $this->get_field_id('title') . '">' . __('Title:', 'wpwautoposter') . '</label>';
		$html .= '<input type="text" name="' . $this->get_field_name('title') . '" id="' . $this->get_field_id('title') . '" class="widefat" value="' . $title . '"/>';
		$html .= '</p>';

		$html .= '<p>';
		$html .= '<label for="' . $this->get_field_id('width') . '">' . __('Width:', 'wpwautoposter') . '</label>';
		$html .= '<input type="text" name="' . $this->get_field_name('width') . '" id="' . $this->get_field_id('width') . '" size="3" value="' . $width . '"/>';
		$html .= '</p>';

		$html .= '<p>';
		$html .= '<label for="' . $this->get_field_id('height') . '">' . __('Height:', 'wpwautoposter') . '</label>';
		$html .= '<input type="text" name="' . $this->get_field_name('height') . '" id="' . $this->get_field_id('height') . '" size="3" value="' . $height . '"/>';
		$html .= '</p>';

		$html .= '<p>';
		$html .= '<label for="' . $this->get_field_id('show_header') . '">' . __('Show header:', 'wpwautoposter') . '</label>';
		$html .= '<input type="checkbox" name="' . $this->get_field_name('show_header') . '" id="' . $this->get_field_id('show_header') . '" value="1" ' . checked( $show_header, '1', false ) . ' />';
		$html .= '</p>';

		$html .= '<p>';
		$html .= '<label for="' . $this->get_field_id('color_scheme') . '">' . __('Color scheme:', 'wpwautoposter') . '</label>';
		$html .= '<select name="' . $this->get_field_name('color_scheme') . '" id="' . $this->get_field_id('color_scheme') . '">';
		$html .= '<option value="light" ' . selected( 'light', $color_scheme, false ) . '>' . __('Light', 'wpwautoposter') . '</option>';
		$html .= '<option value="dark" ' . selected( 'dark', $color_scheme, false ) . '>' . __('Dark', 'wpwautoposter') . '</option>';
		$html .= '</select>';
		$html .= '</p>';

		echo $html;
	}

	/**
	 * Updates the widget control options for the particular instance of the widget
	 */
	function update($new_instance, $old_instance) {
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['width'] = strip_tags($new_instance['width']);
		$instance['height'] = strip_tags($new_instance['height']);
		$instance['show_header'] = strip_tags($new_instance['show_header']);
		$instance['color_scheme'] = strip_tags($new_instance['color_scheme']);

		return $instance;
	}

	/**
	 * Outputs the content of the widget
	 */
	function widget($args, $instance) {
		extract($args);
		$title = apply_filters('widget_title', $instance['title']);
		$width = $instance['width'];
		$width = $width ? $width : 250;
		$height = $instance['height'];
		$height = $height ? $height : 250;
		$show_header = (int)@$instance['show_header'];
		$show_header = $show_header ? 'true' : 'false';
		$color_scheme = $instance['color_scheme'];
		$color_scheme = $color_scheme ? $color_scheme : 'light';

		$url = get_option('siteurl');

		echo $before_widget;
		if ($title) echo $before_title . $title . $after_title;

		echo '<iframe src="http://www.facebook.com/plugins/recommendations.php?site=' . $url . '&amp;width=' . $width . '&amp;height=' . $height . '&amp;header=' . $show_header . '&amp;colorscheme=' . $color_scheme . '&amp;font&amp;border_color" scrolling="no" frameborder="0" style="border:none; overflow:hidden; width:' . $width . 'px; height:' . $height . 'px;" allowTransparency="true"></iframe>';

		echo $after_widget;
	}
}