<?php

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

/**
 * Outputs the content of the events widget
 *
 * @package Social Auto Poster
 * @since 1.0.0
 */
?>
<li>
<div class="wpw_auto_poster_event_title"><?php echo $event['name'];?></div>
<?php if ( $show_image ) { ?>
	<img src="https://graph.facebook.com/<?php echo $event['id']; ?>/picture" />
<?php  } ?>
<?php if ( $show_location && isset( $event['location'] ) ) { ?>
	<div class="wpw_auto_poster_event_location"><?php echo $event['location'];?></div>
<?php } ?>
<div class="wpw_auto_poster_fb_event_time">
<?php if ( $show_start_date && isset( $event['start_time'] ) ) { ?>
	<div class="wpw_auto_poster_event_start_time"><?php echo __('Starts at :','wpwautoposter') . ' ' . date($timestamp_format, strtotime($event['start_time']));?></div>
<?php } ?>
<?php if ( $show_end_date && isset( $event['end_time'] ) ) { ?>
	<div class="wpw_auto_poster_event_end_time"><?php echo __('Ends at :','wpwautoposter') . ' ' . date($timestamp_format, strtotime($event['end_time']));?></div>
<?php } ?>
</div>
</li>